/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.utils;

import android.text.TextUtils;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.livebase.models.LPHorseLamp;
import com.baijiayun.playback.PBRoom;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.ui.bean.VideoPlayerConfig;

public class PBUIUtils {
    public static LPHorseLamp checkHorseLampConfig(LPHorseLamp horseLamp, VideoPlayerConfig videoPlayerConfig) {
        if (videoPlayerConfig.horseLamp != null && !TextUtils.isEmpty((CharSequence)videoPlayerConfig.horseLamp.value)) {
            horseLamp = videoPlayerConfig.horseLamp;
        }
        if (horseLamp == null) {
            return null;
        }
        switch (horseLamp.type) {
            case 2: {
                horseLamp.value = videoPlayerConfig.userName;
                break;
            }
            case 3: {
                horseLamp.value = horseLamp.value + "-" + videoPlayerConfig.userName;
                break;
            }
            case 4: {
                horseLamp.value = TextUtils.isEmpty((CharSequence)videoPlayerConfig.userId) ? videoPlayerConfig.userName : videoPlayerConfig.userId;
                break;
            }
            case 5: {
                String userId = TextUtils.isEmpty((CharSequence)videoPlayerConfig.userId) ? videoPlayerConfig.userName : videoPlayerConfig.userId;
                horseLamp.value = userId + "-" + horseLamp.value;
                break;
            }
        }
        if (PBUIUtils.isHorseLampDisable(horseLamp)) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)horseLamp.color)) {
            horseLamp.color = "#000000";
        }
        if (TextUtils.isEmpty((CharSequence)horseLamp.backgroundColor)) {
            horseLamp.backgroundColor = "#090300";
        }
        return horseLamp;
    }

    private static boolean isHorseLampDisable(LPHorseLamp horseLamp) {
        return horseLamp == null || TextUtils.isEmpty((CharSequence)horseLamp.value) || horseLamp.type == 0;
    }

    public static final boolean disableScreenRecording(IBJYVideoPlayer videoPlayer) {
        if (BJYPlayerSDK.enableScreenRecording == null) {
            return videoPlayer.isEnablePreventScreenCapture();
        }
        return BJYPlayerSDK.enableScreenRecording == false;
    }

    public static final boolean isChatFloatRight(PBRoom pbRoom) {
        if (pbRoom == null) {
            return false;
        }
        if (pbRoom.getPartnerConfig() == null) {
            return false;
        }
        return pbRoom.getPartnerConfig().getIntConfig("chat_float_position") == 1;
    }
}

