/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.toolbox.answersheet;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livebase.base.BaseFragment;
import com.baijiayun.playback.bean.models.LPAnswerModel;
import com.baijiayun.playback.bean.models.LPAnswerSheetOptionModel;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.playback.toolbox.answersheet.QuestionShowContract;
import java.util.ArrayList;
import java.util.List;

public class QuestionShowFragment
extends BaseFragment
implements QuestionShowContract.View {
    private Context context;
    private LinearLayout newLayout;
    private QuestionShowContract.Presenter presenter;

    public int getLayoutId() {
        return R.layout.bjy_pb_dialog_question_show;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.context = context;
    }

    protected void init(Bundle savedInstanceState) {
        super.init(savedInstanceState);
    }

    @Override
    public void setPresenter(QuestionShowContract.Presenter presenter) {
        this.setBasePresenter(presenter);
        this.presenter = presenter;
    }

    @Override
    public void onShowAnswer(LPAnswerModel lpAnswerModel) {
        this.$.id(R.id.dialog_close).clicked(v -> this.presenter.removeQuestionShow());
        LinearLayout answerContainer = (LinearLayout)this.$.id(R.id.ll_show_container).view();
        List options = lpAnswerModel.options;
        ArrayList<String> myAnswers = new ArrayList<String>();
        ArrayList<String> standardAnswers = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int size = options.size();
        for (int i = 0; i < size; ++i) {
            LPAnswerSheetOptionModel optionModel = (LPAnswerSheetOptionModel)options.get(i);
            if (optionModel.isCorrect || optionModel.isRight) {
                standardAnswers.add(optionModel.text);
                sb.append(optionModel.text);
                sb.append(" ");
            }
            if (!optionModel.isActive) continue;
            myAnswers.add(optionModel.text);
        }
        this.showAnswerOption(answerContainer, myAnswers, standardAnswers);
        String text = this.context.getString(R.string.string_standard_answer, new Object[]{sb.toString()});
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)text);
        ForegroundColorSpan whiteSpan = new ForegroundColorSpan(ContextCompat.getColor((Context)this.context, (int)17170444));
        int index = text.indexOf("\uff1a");
        if (index != -1) {
            builder.setSpan((Object)whiteSpan, index + 1, text.length(), 33);
        }
        this.$.id(R.id.tv_standard_answer).text((CharSequence)builder);
    }

    private void showAnswerOption(LinearLayout optionsLayout, List<String> myAnswers, List<String> standardAnswers) {
        int size = myAnswers.size();
        this.$.id(R.id.tv_no_answer).visibility(size == 0 ? 0 : 8);
        optionsLayout.setVisibility(size == 0 ? 8 : 0);
        for (int i = 0; i < size; ++i) {
            String text = myAnswers.get(i);
            CheckedTextView buttonOption = new CheckedTextView(this.getContext());
            buttonOption.setTextColor(this.getResources().getColor(R.color.live_white));
            buttonOption.setBackgroundResource(R.drawable.sel_show_answer);
            buttonOption.setGravity(17);
            if (Build.VERSION.SDK_INT >= 17) {
                buttonOption.setTextAlignment(4);
            }
            int padding = UtilsKt.getDp((int)6);
            buttonOption.setPadding(padding, padding, padding, padding);
            buttonOption.setMinWidth(UtilsKt.getDp((int)32));
            buttonOption.setText((CharSequence)text);
            buttonOption.setChecked(!standardAnswers.contains(text));
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, UtilsKt.getDp((int)32));
            if (i % 4 == 0) {
                this.newLayout = new LinearLayout(this.getContext());
                this.newLayout.setOrientation(0);
                this.newLayout.setGravity(1);
                LinearLayout.LayoutParams newLayoutParams = new LinearLayout.LayoutParams(-1, -2);
                newLayoutParams.setMargins(UtilsKt.getDp((int)8), UtilsKt.getDp((int)8), UtilsKt.getDp((int)8), UtilsKt.getDp((int)8));
                optionsLayout.setOrientation(1);
                optionsLayout.addView((View)this.newLayout, (ViewGroup.LayoutParams)newLayoutParams);
            }
            layoutParams.setMargins(UtilsKt.getDp((int)8), 0, UtilsKt.getDp((int)8), 0);
            if (this.newLayout == null) continue;
            layoutParams.gravity = 1;
            this.newLayout.addView((View)buttonOption, (ViewGroup.LayoutParams)layoutParams);
        }
    }
}

