/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.constant.VideoType;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.bean.keyframe.KeyFrameBean;
import com.baijiayun.videoplayer.bean.keyframe.KeyFrameModel;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.widget.adapter.BaseAdapter;
import com.baijiayun.videoplayer.ui.widget.adapter.KeyFrameAdapter;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class KeyFrameComponent
extends BaseComponent {
    private ImageView bookmarkIv;
    private FrameLayout recyclerContainer;
    private RecyclerView keyframeRecycler;
    private Drawable leftIcon;
    private Drawable rightIcon;
    private boolean isOpened = true;
    private boolean isAnimating;
    private AnimatorSet openAnimatorSet;
    private AnimatorSet closeAnimatorSet;
    private BaseAdapter<?> adapter;
    private VideoType videoType;
    private int visibility = 8;
    private int mSeekProgress = -1;
    private Runnable mSeekEventRunnable = () -> {
        if (this.mSeekProgress < 0) {
            return;
        }
        Bundle bundle = BundlePool.obtain();
        bundle.putInt("int_data", this.mSeekProgress);
        this.requestSeek(bundle);
    };

    public KeyFrameComponent(Context context, boolean isLandscape) {
        super(context);
        this.isLandscape = isLandscape;
        this.initBookMarkDrawable(context);
        this.initView(context);
    }

    private void initBookMarkDrawable(Context context) {
        this.leftIcon = ContextCompat.getDrawable((Context)context, (int)R.drawable.bjy_pb_icon_player_back);
        Matrix matrix = new Matrix();
        matrix.postRotate(180.0f);
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.bjy_pb_icon_player_back);
        this.rightIcon = new BitmapDrawable(context.getResources(), Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)this.leftIcon.getIntrinsicWidth(), (int)this.leftIcon.getIntrinsicHeight(), (Matrix)matrix, (boolean)true));
    }

    private void initView(Context context) {
        this.bookmarkIv = (ImageView)this.findViewById(R.id.keyframe_bookmark);
        this.recyclerContainer = (FrameLayout)this.findViewById(R.id.keyframe_recycler_container);
        this.keyframeRecycler = (RecyclerView)this.findViewById(R.id.keyframe_recycler);
        this.keyframeRecycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        int dp4 = UtilsKt.getDp((int)4);
        this.bookmarkIv.setBackground(new DrawableBuilder().solidColor(Color.parseColor((String)"#cc313847")).cornerRadii(dp4, 0, 0, dp4).build());
        if (this.isOpened) {
            this.bookmarkIv.setImageDrawable(this.rightIcon);
        } else {
            this.bookmarkIv.setImageDrawable(this.leftIcon);
        }
        this.recyclerContainer.setBackgroundColor(Color.parseColor((String)"#cc313847"));
        this.bookmarkIv.setOnClickListener(v -> {
            if (this.isAnimating) {
                return;
            }
            if (this.isOpened) {
                this.openAnimatorSet.cancel();
                this.getView().setTranslationX(0.0f);
                this.closeAnimatorSet.start();
            } else {
                this.closeAnimatorSet.cancel();
                this.getView().setTranslationX((float)this.recyclerContainer.getWidth());
                this.openAnimatorSet.start();
            }
        });
        this.updateShowState(true);
    }

    private void updateShowState(boolean isShow) {
        if (this.isLandscape && isShow) {
            this.setComponentVisibility(0);
            if (this.openAnimatorSet == null || this.closeAnimatorSet == null) {
                this.recyclerContainer.post(this::initAnimation);
            }
        } else {
            this.setComponentVisibility(8);
        }
    }

    private void initAnimation() {
        this.isAnimating = false;
        this.closeAnimatorSet = new AnimatorSet();
        int width = this.recyclerContainer.getMeasuredWidth();
        ObjectAnimator translate1 = ObjectAnimator.ofFloat((Object)this.getView(), (String)"translationX", (float[])new float[]{0.0f, width});
        this.closeAnimatorSet.setDuration(300L).play((Animator)translate1);
        this.closeAnimatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.closeAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                KeyFrameComponent.this.isAnimating = true;
                KeyFrameComponent.this.recyclerContainer.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                KeyFrameComponent.this.recyclerContainer.setVisibility(4);
                KeyFrameComponent.this.bookmarkIv.setImageDrawable(KeyFrameComponent.this.leftIcon);
                KeyFrameComponent.this.isAnimating = false;
                KeyFrameComponent.this.isOpened = false;
            }
        });
        this.openAnimatorSet = new AnimatorSet();
        ObjectAnimator translate2 = ObjectAnimator.ofFloat((Object)this.getView(), (String)"translationX", (float[])new float[]{width, 0.0f});
        this.openAnimatorSet.setDuration(300L).play((Animator)translate2);
        this.openAnimatorSet.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.openAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                KeyFrameComponent.this.isAnimating = true;
                KeyFrameComponent.this.recyclerContainer.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                KeyFrameComponent.this.bookmarkIv.setImageDrawable(KeyFrameComponent.this.rightIcon);
                KeyFrameComponent.this.isAnimating = false;
                KeyFrameComponent.this.isOpened = true;
            }
        });
    }

    @Override
    public void bindVideoPlayer(IBJYVideoPlayer videoPlayer) {
        super.bindVideoPlayer(videoPlayer);
        videoPlayer.addOnVideoTypeChangeListener(videoType -> {
            this.videoType = videoType;
            if (videoType != VideoType.ContentVideo) {
                this.setComponentVisibility(8);
            } else {
                this.setComponentVisibility(this.visibility);
            }
        });
        this.videoType = videoPlayer.getVideoType();
        if (videoPlayer.getVideoType() != VideoType.ContentVideo) {
            this.setComponentVisibility(8);
        } else {
            this.setComponentVisibility(this.visibility);
        }
    }

    @Override
    public void setComponentVisibility(int visibility) {
        this.visibility = visibility;
        super.setComponentVisibility(this.videoType == VideoType.StartVideo || this.videoType == VideoType.EndVideo ? 8 : visibility);
    }

    @Override
    public void onPlayerEvent(int eventCode, Bundle bundle) {
        super.onPlayerEvent(eventCode, bundle);
        switch (eventCode) {
            case -99019: {
                if (this.adapter == null) break;
                this.adapter.update(bundle.getInt("int_data"));
                break;
            }
        }
    }

    @Override
    public void onComponentEvent(int eventCode, Bundle bundle) {
        super.onComponentEvent(eventCode, bundle);
        switch (eventCode) {
            case -80034: {
                boolean show = bundle.getBoolean("bool_data");
                this.updateShowState(show);
                break;
            }
            case -80002: {
                if (this.adapter == null) break;
                this.adapter.update(bundle.getInt("int_data"));
                break;
            }
        }
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        switch (eventCode) {
            case -80006: {
                this.updateShowState(true);
                break;
            }
            case -80040: {
                this.updateAdapter(eventCode);
                List<? extends KeyFrameBean> keyFrames = this.getList(eventCode, bundle);
                if (this.keyframeRecycler.getAdapter() == null || keyFrames == null) {
                    this.setComponentVisibility(8);
                    break;
                }
                this.adapter.setData(keyFrames);
                break;
            }
        }
    }

    private void updateAdapter(int customEventCode) {
        switch (customEventCode) {
            case -80040: {
                BaseAdapter oldAdapter = (BaseAdapter)this.keyframeRecycler.getAdapter();
                if (oldAdapter != null && ((Object)((Object)oldAdapter)).getClass() == KeyFrameAdapter.class) break;
                oldAdapter = new KeyFrameAdapter(this.getContext(), this.getVideoPlayer().getDuration(), (Function1<? super KeyFrameModel.KeyFrameInfo, Unit>)((Function1)keyFrameInfo -> {
                    this.mSeekProgress = (int)Math.ceil((double)this.timeToMillis(keyFrameInfo.timeOffset) / 1000.0);
                    this.keyframeRecycler.removeCallbacks(this.mSeekEventRunnable);
                    this.keyframeRecycler.postDelayed(this.mSeekEventRunnable, 300L);
                    return null;
                }));
                this.keyframeRecycler.setAdapter((RecyclerView.Adapter)oldAdapter);
                ((KeyFrameAdapter)oldAdapter).bindRecycler(this.keyframeRecycler);
                this.adapter = oldAdapter;
                break;
            }
        }
    }

    public long timeToMillis(String time) {
        String[] parts = time.split(":");
        int hours = Integer.parseInt(parts[0]);
        int minutes = Integer.parseInt(parts[1]);
        int seconds = Integer.parseInt(parts[2]);
        return (long)hours * 3600000L + (long)minutes * 60000L + (long)seconds * 1000L;
    }

    private List<? extends KeyFrameBean> getList(int customEventCode, Bundle bundle) {
        switch (customEventCode) {
            case -80040: {
                KeyFrameModel model = (KeyFrameModel)bundle.getSerializable("key_frame_model");
                return model.list;
            }
        }
        return null;
    }

    @Override
    protected View onCreateComponentView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjy_pb_layout_keyframe_component, null);
    }

    @Override
    protected void setKey() {
        this.key = "keyframe_sign_component";
    }
}

