/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.widget.adapter;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.Transformation;
import com.baijiayun.glide.load.resource.bitmap.RoundedCorners;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.videoplayer.bean.keyframe.KeyFrameBean;
import com.baijiayun.videoplayer.bean.keyframe.KeyFrameModel;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.databinding.BjyPbPlayerItemKeyFrameBinding;
import com.baijiayun.videoplayer.ui.widget.adapter.BaseAdapter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B<\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012%\b\u0002\u0010\u0007\u001a\u001f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r\u0018\u00010\b\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0015J\b\u0010\u0018\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\u0006H\u0002J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u0006H\u0016J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0016J\u001a\u0010\"\u001a\u00020\r2\u0010\u0010#\u001a\f\u0012\u0006\b\u0001\u0012\u00020%\u0018\u00010$H\u0016J\u0010\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0006H\u0016R+\u0010\u0007\u001a\u001f\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0012j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/baijiayun/videoplayer/ui/widget/adapter/KeyFrameAdapter;", "Lcom/baijiayun/videoplayer/ui/widget/adapter/BaseAdapter;", "Lcom/baijiayun/videoplayer/ui/widget/adapter/KeyFrameAdapter$KeyFrameViewHolder;", "context", "Landroid/content/Context;", "currentOffset", "", "action", "Lkotlin/Function1;", "Lcom/baijiayun/videoplayer/bean/keyframe/KeyFrameModel$KeyFrameInfo;", "Lkotlin/ParameterName;", "name", "keyFrameInfo", "", "(Landroid/content/Context;ILkotlin/jvm/functions/Function1;)V", "firstLineCount", "lastPosition", "map", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "recycler", "Landroidx/recyclerview/widget/RecyclerView;", "bindRecycler", "recyclerView", "convertOffset2PositionMap", "findRangePosition", "getItemCount", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "setData", "data", "", "Lcom/baijiayun/videoplayer/bean/keyframe/KeyFrameBean;", "timeToSecond", "time", "", "update", "offset", "KeyFrameViewHolder", "videoplayer-ui_release"})
public final class KeyFrameAdapter
extends BaseAdapter<KeyFrameViewHolder> {
    @NotNull
    private final Context context;
    private int currentOffset;
    @Nullable
    private final Function1<KeyFrameModel.KeyFrameInfo, Unit> action;
    @NotNull
    private final LinkedHashMap<Integer, Integer> map;
    private int lastPosition;
    @Nullable
    private RecyclerView recycler;
    private int firstLineCount;

    public KeyFrameAdapter(@NotNull Context context, int currentOffset, @Nullable Function1<? super KeyFrameModel.KeyFrameInfo, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.currentOffset = currentOffset;
        this.action = action;
        this.map = new LinkedHashMap();
        this.lastPosition = -1;
        this.firstLineCount = 6;
    }

    public /* synthetic */ KeyFrameAdapter(Context context, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        this(context, n, (Function1<? super KeyFrameModel.KeyFrameInfo, Unit>)function1);
    }

    @Override
    public void setData(@Nullable List<? extends KeyFrameBean> data) {
        this.list = data;
        this.convertOffset2PositionMap();
        this.notifyDataSetChanged();
    }

    private final void convertOffset2PositionMap() {
        this.map.clear();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Object obj = this.list.get(i);
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.baijiayun.videoplayer.bean.keyframe.KeyFrameModel.KeyFrameInfo");
            KeyFrameModel.KeyFrameInfo keyFrameInfo = (KeyFrameModel.KeyFrameInfo)obj;
            String string2 = keyFrameInfo.timeOffset;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"keyFrameInfo.timeOffset");
            int key = this.timeToSecond(string2);
            Integer n2 = key;
            Integer n3 = i;
            ((Map)this.map).put(n2, n3);
            if (key > this.currentOffset) continue;
            this.lastPosition = i;
        }
    }

    private final int timeToSecond(String time) {
        String[] stringArray = new String[]{":"};
        List parts = StringsKt.split$default((CharSequence)time, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        int hours = Integer.parseInt((String)parts.get(0));
        int minutes = Integer.parseInt((String)parts.get(1));
        int seconds = Integer.parseInt((String)parts.get(2));
        return hours * 3600 + minutes * 60 + seconds;
    }

    private final int findRangePosition() {
        int currentPosition = -1;
        for (Integer offset : this.map.keySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)offset, (String)"offset");
            if (offset > this.currentOffset) break;
            Integer n = this.map.get(offset);
            Intrinsics.checkNotNull((Object)n);
            currentPosition = ((Number)n).intValue();
        }
        return currentPosition;
    }

    @NotNull
    public KeyFrameViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        BjyPbPlayerItemKeyFrameBinding bjyPbPlayerItemKeyFrameBinding = BjyPbPlayerItemKeyFrameBinding.bind(LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_pb_player_item_key_frame, parent, false));
        Intrinsics.checkNotNullExpressionValue((Object)bjyPbPlayerItemKeyFrameBinding, (String)"bind(\n            Layout\u2026 parent, false)\n        )");
        BjyPbPlayerItemKeyFrameBinding binding = bjyPbPlayerItemKeyFrameBinding;
        return new KeyFrameViewHolder(binding);
    }

    public int getItemCount() {
        return this.list.size();
    }

    public void onBindViewHolder(@NotNull KeyFrameViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        Object obj = this.list.get(position);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.baijiayun.videoplayer.bean.keyframe.KeyFrameModel.KeyFrameInfo");
        KeyFrameModel.KeyFrameInfo keyFrameInfo = (KeyFrameModel.KeyFrameInfo)obj;
        BjyPbPlayerItemKeyFrameBinding $this$onBindViewHolder_u24lambda_u244 = holder.getBinding();
        boolean bl = false;
        $this$onBindViewHolder_u24lambda_u244.getRoot().setSelected(this.lastPosition == position);
        $this$onBindViewHolder_u24lambda_u244.keyframeTimeTv.setText((CharSequence)keyFrameInfo.timeOffset);
        $this$onBindViewHolder_u24lambda_u244.keyFrameNameTv.setText((CharSequence)keyFrameInfo.description);
        $this$onBindViewHolder_u24lambda_u244.keyFrameNameTv.post(() -> KeyFrameAdapter.onBindViewHolder$lambda$4$lambda$2($this$onBindViewHolder_u24lambda_u244, this, keyFrameInfo));
        Glide.with((Context)this.context).load(keyFrameInfo.imageUrl).apply(RequestOptions.bitmapTransform((Transformation)((Transformation)new RoundedCorners(UtilsKt.getDp((int)4))))).into($this$onBindViewHolder_u24lambda_u244.keyFrameImageIv);
        $this$onBindViewHolder_u24lambda_u244.getRoot().setOnClickListener(arg_0 -> KeyFrameAdapter.onBindViewHolder$lambda$4$lambda$3(this, keyFrameInfo, arg_0));
    }

    @Override
    public void update(int offset) {
        block1: {
            this.currentOffset = offset;
            int newPosition = this.findRangePosition();
            if (newPosition == this.lastPosition) break block1;
            this.notifyItemChanged(this.lastPosition);
            this.lastPosition = newPosition;
            this.notifyItemChanged(this.lastPosition);
            RecyclerView recyclerView = this.recycler;
            if (recyclerView != null && (recyclerView = recyclerView.getLayoutManager()) != null) {
                recyclerView.scrollToPosition(this.lastPosition);
            }
        }
    }

    public final void bindRecycler(@NotNull RecyclerView recyclerView) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        this.recycler = recyclerView;
    }

    private static final void onBindViewHolder$lambda$4$lambda$2$lambda$1$lambda$0(BjyPbPlayerItemKeyFrameBinding $this_run, KeyFrameModel.KeyFrameInfo $keyFrameInfo, KeyFrameAdapter this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        Intrinsics.checkNotNullParameter((Object)$keyFrameInfo, (String)"$keyFrameInfo");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if ($this_run.openName.isSelected()) {
            TextView textView = $this_run.keyFrameNameTv;
            String string2 = $keyFrameInfo.description;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"keyFrameInfo.description");
            String string3 = string2;
            int n = 0;
            int n2 = this$0.firstLineCount * 2 - 1;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            textView.setText((CharSequence)string4);
            $this_run.openName.setRotation(-90.0f);
            $this_run.openName.setSelected(false);
        } else {
            TextView textView = $this_run.keyFrameNameTv;
            String string5 = $keyFrameInfo.description;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"keyFrameInfo.description");
            String string6 = string5;
            int n = 0;
            int n3 = $keyFrameInfo.description.length();
            String string7 = string6.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            textView.setText((CharSequence)string7);
            $this_run.openName.setRotation(90.0f);
            $this_run.openName.setSelected(true);
        }
    }

    private static final void onBindViewHolder$lambda$4$lambda$2(BjyPbPlayerItemKeyFrameBinding $this_run, KeyFrameAdapter this$0, KeyFrameModel.KeyFrameInfo $keyFrameInfo) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$keyFrameInfo, (String)"$keyFrameInfo");
            Layout layout2 = $this_run.keyFrameNameTv.getLayout();
            if (layout2 == null) break block3;
            Layout $this$onBindViewHolder_u24lambda_u244_u24lambda_u242_u24lambda_u241 = layout2;
            boolean bl = false;
            int lines = $this$onBindViewHolder_u24lambda_u244_u24lambda_u242_u24lambda_u241.getLineCount();
            if (lines > 2) {
                int start = $this$onBindViewHolder_u24lambda_u244_u24lambda_u242_u24lambda_u241.getLineStart(0);
                int end = $this$onBindViewHolder_u24lambda_u244_u24lambda_u242_u24lambda_u241.getLineEnd(0);
                this$0.firstLineCount = end - start;
                if (this$0.firstLineCount > $keyFrameInfo.description.length()) {
                    this$0.firstLineCount = $keyFrameInfo.description.length();
                }
                String string2 = $keyFrameInfo.description;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"keyFrameInfo.description");
                String string3 = string2;
                int n = 0;
                int n2 = this$0.firstLineCount * 2 - 1;
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String text = string4;
                $this_run.keyFrameNameTv.setText((CharSequence)text);
                $this_run.openName.setVisibility(0);
                $this_run.openName.setRotation(-90.0f);
                $this_run.openName.setSelected(false);
                $this_run.keyFrameNameTv.setOnClickListener(arg_0 -> KeyFrameAdapter.onBindViewHolder$lambda$4$lambda$2$lambda$1$lambda$0($this_run, $keyFrameInfo, this$0, arg_0));
            } else {
                $this_run.openName.setVisibility(8);
            }
        }
    }

    private static final void onBindViewHolder$lambda$4$lambda$3(KeyFrameAdapter this$0, KeyFrameModel.KeyFrameInfo $keyFrameInfo, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$keyFrameInfo, (String)"$keyFrameInfo");
            Function1<KeyFrameModel.KeyFrameInfo, Unit> function1 = this$0.action;
            if (function1 == null) break block0;
            function1.invoke((Object)$keyFrameInfo);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/baijiayun/videoplayer/ui/widget/adapter/KeyFrameAdapter$KeyFrameViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/baijiayun/videoplayer/ui/databinding/BjyPbPlayerItemKeyFrameBinding;", "(Lcom/baijiayun/videoplayer/ui/databinding/BjyPbPlayerItemKeyFrameBinding;)V", "getBinding", "()Lcom/baijiayun/videoplayer/ui/databinding/BjyPbPlayerItemKeyFrameBinding;", "videoplayer-ui_release"})
    public static final class KeyFrameViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final BjyPbPlayerItemKeyFrameBinding binding;

        public KeyFrameViewHolder(@NotNull BjyPbPlayerItemKeyFrameBinding binding) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            super((View)binding.getRoot());
            this.binding = binding;
            this.binding.getRoot().setBackground((Drawable)new StateListDrawableBuilder().normal(new DrawableBuilder().solidColor(Color.parseColor((String)"#1AC7D0E6")).cornerRadius(UtilsKt.getDp((int)4)).build()).selected(new DrawableBuilder().solidColor(Color.parseColor((String)"#FF1E5EFF")).cornerRadius(UtilsKt.getDp((int)4)).build()).build());
        }

        @NotNull
        public final BjyPbPlayerItemKeyFrameBinding getBinding() {
            return this.binding;
        }
    }
}

