/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.toolbox.redpacket;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.baijiayun.bjyutils.TimeUtilsKt;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.R;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.playback.dataloader.PlayerDataLoader;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.databinding.BjyPbFragmentRedpacketBinding;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class RedPacketDialog
extends BaseDialogFragment {
    public static final String ROOM_ID = "room_id";
    public static final String TOKEN = "token";
    public static final String USER_NUMBER = "user_number";
    public static final String PLAYBACK_ID = "playback_id";
    public static final String USER_NAME = "user_name";
    public static final String TIME_OFFSET = "time_offset";
    private static final int DURATION = 15;
    private BjyPbFragmentRedpacketBinding binding;
    private Disposable disposableOfTimer;
    private Disposable disposableOfResult;
    private long roomId;
    private String token;
    private String userNumber;
    private long playbackId;
    private String userName;
    private long timeOffset;
    private boolean showResult;
    private int prize;

    protected int getLayoutId() {
        return R.layout.bjy_pb_fragment_redpacket;
    }

    protected void init(@Nullable Bundle savedInstanceState, @Nullable Bundle arguments) {
        this.hideTitleBar();
        if (arguments != null) {
            this.roomId = arguments.getLong(ROOM_ID);
            this.token = arguments.getString(TOKEN);
            this.timeOffset = arguments.getLong(TIME_OFFSET);
            this.userNumber = arguments.getString(USER_NUMBER);
            this.userName = arguments.getString(USER_NAME);
            this.playbackId = arguments.getLong(PLAYBACK_ID);
        }
        this.initView();
        this.binding.countdownTv.setText((CharSequence)this.getString(R.string.bjy_pb_countdown, new Object[]{15}));
        this.disposableOfTimer = Observable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).take(15L).observeOn(AndroidSchedulers.mainThread()).filter(b -> this.isAdded()).subscribe(aLong -> {
            this.binding.countdownTv.setText((CharSequence)this.getString(R.string.bjy_pb_countdown, new Object[]{15L - aLong - 1L}));
            if (aLong + 1L == 15L) {
                this.dismissAllowingStateLoss();
            }
        });
    }

    private void initView() {
        this.binding = BjyPbFragmentRedpacketBinding.bind(this.contentView);
        this.binding.countdownTv.setBackground(new DrawableBuilder().solidColor(0x33000000).cornerRadius(UtilsKt.getDp((int)14)).build());
        this.binding.assistantTv.setBackground(new DrawableBuilder().solidColor(0x1AFFFFFF).cornerRadius(UtilsKt.getDp((int)25)).build());
        this.binding.scoreBtn.setBackground(new DrawableBuilder().solidColor(0x4DFFFFFF).cornerRadius(UtilsKt.getDp((int)22)).build());
        this.binding.scoreBtn.setOnClickListener(v -> this.dismissAllowingStateLoss());
        this.binding.openIv.setOnClickListener(v -> {
            RxUtils.dispose((Disposable)this.disposableOfTimer);
            this.showResultView();
        });
        if (this.showResult) {
            this.binding.containerRedpacket.setVisibility(8);
            this.binding.containerRedpacketDetail.setVisibility(0);
            this.binding.scoreTv.setText((CharSequence)String.valueOf(this.prize));
        } else {
            this.binding.containerRedpacket.setVisibility(0);
            this.binding.containerRedpacketDetail.setVisibility(8);
        }
    }

    private void showResultView() {
        this.showResult = true;
        this.disposableOfResult = PlayerDataLoader.getInstance((Context)this.contentView.getContext()).receiveRedPackage(this.playbackId, this.userNumber, this.userName, TimeUtilsKt.getDateFromSecond((String)"HH:mm:ss", (long)this.timeOffset), this.roomId, this.token).observeOn(AndroidSchedulers.mainThread()).subscribe(redPacketBean -> {
            this.binding.containerRedpacket.setVisibility(8);
            this.binding.containerRedpacketDetail.setVisibility(0);
            this.prize = redPacketBean.prize;
            this.binding.scoreTv.setText((CharSequence)String.valueOf(redPacketBean.prize));
        });
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.baseContent.removeAllViews();
        this.contentView = View.inflate((Context)this.baseContent.getContext(), (int)this.getLayoutId(), null);
        this.baseContent.addView(this.contentView);
        this.initView();
    }

    protected boolean isCanceledOnTouchOutside() {
        return false;
    }

    public void onStart() {
        super.onStart();
        this.getDialog().getWindow().setBackgroundDrawable(new DrawableBuilder().solidColor(0).build());
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.dimAmount = 0.5f;
        windowParams.flags |= 2;
        if (this.hasWindowAnim()) {
            windowParams.windowAnimations = R.style.LiveBaseDialogAnim;
        }
        int shortEdge = Math.min(DisplayUtils.getScreenHeightPixels((Context)this.contextReference), DisplayUtils.getScreenWidthPixels((Context)this.contextReference));
        if (this.getResources().getConfiguration().orientation == 1) {
            windowParams.width = Math.min(shortEdge - UtilsKt.getDp((int)70), UtilsKt.getDp((int)320));
            windowParams.height = UtilsKt.getDp((int)450);
        } else {
            windowParams.width = UtilsKt.getDp((int)250);
            windowParams.height = Math.min(shortEdge - UtilsKt.getDp((int)40), UtilsKt.getDp((int)332));
        }
        windowParams.gravity = 17;
    }

    public void onDestroyView() {
        super.onDestroyView();
        RxUtils.dispose((Disposable)this.disposableOfTimer);
        RxUtils.dispose((Disposable)this.disposableOfResult);
    }
}

