/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.toolbox.questionanswer;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.playback.bean.models.LPQuestionPullListItem;
import com.baijiayun.playback.bean.models.LPQuestionPullResItem;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.playback.toolbox.questionanswer.QuestionAnswerContract;
import com.baijiayun.videoplayer.ui.playback.viewsupport.LinearLayoutWrapManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class QuestionAnswerFragment
extends BaseDialogFragment
implements QuestionAnswerContract.View {
    protected RecyclerView mRecyclerView;
    private QuestionAnswerContract.Presenter presenter;
    private QuestionAdapter adapter;
    private final SimpleDateFormat format = new SimpleDateFormat("HH:mm", Locale.getDefault());

    protected RecyclerView.LayoutManager getLayoutManager() {
        return new LinearLayoutWrapManager(this.getContext());
    }

    public int getLayoutId() {
        return R.layout.bjy_pb_fragment_question_answer;
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        this.contentView.setClickable(true);
        this.title(this.getResources().getString(R.string.live_room_question_answer_text));
        this.editable(false);
        this.mRecyclerView = (RecyclerView)this.contentView.findViewById(R.id.fragment_question_answer_list);
        this.adapter = new QuestionAdapter();
        this.mRecyclerView.setLayoutManager(this.getLayoutManager());
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.presenter.subscribe();
    }

    @Override
    public void notifyDataChange() {
        this.adapter.notifyDataSetChanged();
    }

    @Override
    public void showEmpty(boolean isEmpty) {
        if (isEmpty) {
            this.mRecyclerView.setVisibility(8);
            this.contentView.findViewById(R.id.fragment_question_answer_empty).setVisibility(0);
            this.contentView.findViewById(R.id.fragment_question_answer_empty_tips).setVisibility(0);
        } else {
            this.contentView.findViewById(R.id.fragment_question_answer_empty).setVisibility(8);
            this.contentView.findViewById(R.id.fragment_question_answer_empty_tips).setVisibility(8);
            this.mRecyclerView.setVisibility(0);
        }
    }

    @Override
    public void setPresenter(QuestionAnswerContract.Presenter presenter) {
        this.presenter = presenter;
    }

    private String getTime(long time) {
        Date date = new Date(time * 1000L);
        return this.format.format(date);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.presenter != null) {
            this.presenter.destroy();
            this.presenter = null;
        }
    }

    private class QuestionAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private static final int VIEW_TYPE_QUESTION = 1;
        private static final int VIEW_TYPE_LOADING = 2;

        private QuestionAdapter() {
        }

        @NonNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            if (viewType == 1) {
                View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_pb_item_question_answer, parent, false);
                return new QuestionItem(view);
            }
            if (viewType == 2) {
                View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_pb_item_online_user_loadmore, parent, false);
                return new LoadingViewHolder(view);
            }
            return null;
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            LPQuestionPullResItem item = QuestionAnswerFragment.this.presenter.getQuestion(position);
            if (holder instanceof QuestionItem) {
                QuestionItem questionHolder = (QuestionItem)holder;
                if (item.itemList.isEmpty()) {
                    return;
                }
                questionHolder.questionSymbol.setText((CharSequence)"\u95ee");
                questionHolder.questionSymbol.setBackground(QuestionAnswerFragment.this.getContext().getResources().getDrawable(R.drawable.ic_item_question_symbol));
                questionHolder.questionSymbol.setTextColor(QuestionAnswerFragment.this.getContext().getResources().getColor(R.color.live_red_question_symbol));
                questionHolder.questionName.setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)((LPQuestionPullListItem)item.itemList.get((int)0)).from.getName()));
                questionHolder.questionTime.setText((CharSequence)QuestionAnswerFragment.this.getTime(((LPQuestionPullListItem)item.itemList.get((int)0)).time));
                questionHolder.questionContent.setText((CharSequence)((LPQuestionPullListItem)item.itemList.get((int)0)).content);
                if (item.itemList.size() > 1) {
                    questionHolder.questionReply.setVisibility(0);
                    questionHolder.questionReply.removeAllViews();
                    for (int i = 1; i < item.itemList.size(); ++i) {
                        LinearLayout questionReply = (LinearLayout)LayoutInflater.from((Context)QuestionAnswerFragment.this.getContext()).inflate(R.layout.bjy_pb_item_question_answer, null, false);
                        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
                        layoutParams.bottomMargin = UtilsKt.getDp((int)10);
                        questionReply.setBackground(QuestionAnswerFragment.this.getContext().getResources().getDrawable(R.drawable.bg_item_question_answer_reply));
                        TextView questionSymbol = (TextView)questionReply.findViewById(R.id.fragment_question_answer_symbol);
                        questionSymbol.setText((CharSequence)"\u7b54");
                        questionSymbol.setTextColor(QuestionAnswerFragment.this.getContext().getResources().getColor(R.color.live_blue_question_symbol));
                        questionSymbol.setBackground(QuestionAnswerFragment.this.getContext().getResources().getDrawable(R.drawable.ic_item_answer_symbol));
                        ((TextView)questionReply.findViewById(R.id.fragment_question_answer_name)).setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)((LPQuestionPullListItem)item.itemList.get((int)i)).from.getName()));
                        ((TextView)questionReply.findViewById(R.id.fragment_question_answer_time)).setText((CharSequence)QuestionAnswerFragment.this.getTime(((LPQuestionPullListItem)item.itemList.get((int)i)).time));
                        ((TextView)questionReply.findViewById(R.id.fragment_question_answer_content)).setText((CharSequence)((LPQuestionPullListItem)item.itemList.get((int)i)).content);
                        questionHolder.questionReply.addView((View)questionReply, (ViewGroup.LayoutParams)layoutParams);
                    }
                } else {
                    questionHolder.questionReply.setVisibility(8);
                }
            } else if (holder instanceof LoadingViewHolder) {
                LoadingViewHolder loadingViewHolder = (LoadingViewHolder)holder;
                loadingViewHolder.progressBar.setIndeterminate(true);
            }
        }

        public int getItemCount() {
            return QuestionAnswerFragment.this.presenter.getCount();
        }

        public int getItemViewType(int position) {
            return QuestionAnswerFragment.this.presenter.getQuestion(position) == null ? 2 : 1;
        }
    }

    private static class LoadingViewHolder
    extends RecyclerView.ViewHolder {
        ProgressBar progressBar;

        LoadingViewHolder(View itemView) {
            super(itemView);
            this.progressBar = (ProgressBar)itemView.findViewById(R.id.item_online_user_progress);
        }
    }

    private static class QuestionItem
    extends RecyclerView.ViewHolder {
        TextView questionSymbol;
        TextView questionName;
        TextView questionTime;
        TextView questionContent;
        LinearLayout questionReply;

        public QuestionItem(View itemView) {
            super(itemView);
            this.questionSymbol = (TextView)itemView.findViewById(R.id.fragment_question_answer_symbol);
            this.questionName = (TextView)itemView.findViewById(R.id.fragment_question_answer_name);
            this.questionContent = (TextView)itemView.findViewById(R.id.fragment_question_answer_content);
            this.questionTime = (TextView)itemView.findViewById(R.id.fragment_question_answer_time);
            this.questionReply = (LinearLayout)itemView.findViewById(R.id.fragment_question_answer_reply);
        }
    }
}

