/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.chat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.text.style.LineHeightSpan;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.core.view.GestureDetectorCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.imodels.IMessageModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.widgets.chat.ControlClickSpanTextView;
import com.baijiayun.liveuibase.widgets.chat.TextLineHeightSpan;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class ChatMessageView
extends LinearLayout {
    private final String TAG = ChatMessageView.class.getCanonicalName();
    public static final String MARK = "-@translate@-";
    private TextView tvMsg;
    private TextView tvMsgWall;
    private TextView tvTranslateResult;
    private TextView tvReference;
    private LinearLayout messageContainer;
    private LinearLayout msgWallContainer;
    private LinearLayout btnTranslate;
    private GradientDrawable divideLineDrawable;
    private OnProgressListener onProgressListener;
    private IMessageModel messageModel;
    private boolean isTranslate;
    private boolean isFailed;
    private Disposable subscribeTimer;
    private static int low = 3;
    private GestureDetectorCompat gestureDetectorCompat;
    private TextLineHeightSpan lineHeightSpan;
    public static final int NONE = 0;
    public static final int RECALL = 1;
    public static final int DELETE = 2;
    private static final int[] STATE_CHECKED = new int[]{R.attr.state_checked};
    private boolean stateChecked;
    private IChatMessageListener chatMessageListener;

    public ChatMessageView(Context context2) {
        this(context2, null);
    }

    public ChatMessageView(Context context2, @Nullable AttributeSet attrs) {
        this(context2, attrs, 0);
    }

    public ChatMessageView(Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init(context2, attrs);
        this.initListener();
    }

    @RequiresApi(api=21)
    public ChatMessageView(Context context2, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context2, attrs, defStyleAttr, defStyleRes);
        this.init(context2, attrs);
        this.initListener();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void init(Context context2, AttributeSet attrs) {
        this.setOrientation(0);
        this.messageContainer = new LinearLayout(context2);
        this.messageContainer.setOrientation(1);
        this.divideLineDrawable = new GradientDrawable();
        this.divideLineDrawable.setSize(100, UtilsKt.getDp((int)1));
        this.messageContainer.setDividerDrawable((Drawable)this.divideLineDrawable);
        this.messageContainer.setShowDividers(2);
        LinearLayout.LayoutParams messageContainerParams = new LinearLayout.LayoutParams(-1, -2);
        messageContainerParams.weight = 1.0f;
        this.addView((View)this.messageContainer, (ViewGroup.LayoutParams)messageContainerParams);
        this.tvMsg = new ControlClickSpanTextView(this.getContext());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.setMargins(UtilsKt.getDp((int)3), UtilsKt.getDp((int)2), UtilsKt.getDp((int)3), UtilsKt.getDp((int)2));
        this.messageContainer.addView((View)this.tvMsg, (ViewGroup.LayoutParams)params);
        Paint.FontMetricsInt fontMetricsInt = this.tvMsg.getPaint().getFontMetricsInt();
        this.lineHeightSpan = new TextLineHeightSpan(fontMetricsInt, 20);
        this.tvMsg.setOnTouchListener((v, event) -> {
            this.gestureDetectorCompat.onTouchEvent(event);
            return false;
        });
        this.btnTranslate = new LinearLayout(context2);
        this.btnTranslate.setBackground(ContextCompat.getDrawable((Context)context2, (int)R.drawable.bjy_ic_message_translate));
        LinearLayout.LayoutParams btnTranslateParams = new LinearLayout.LayoutParams(UtilsKt.getDp((int)16), UtilsKt.getDp((int)16));
        btnTranslateParams.setMargins(5, 5, 0, 0);
        this.addView((View)this.btnTranslate, (ViewGroup.LayoutParams)btnTranslateParams);
        this.btnTranslate.setOnClickListener(v -> {
            if (this.onProgressListener == null) {
                return;
            }
            this.btnTranslate.setClickable(false);
            this.isFailed = false;
            this.countDown();
            this.onProgressListener.onProgress();
        });
        this.tvTranslateResult = new TextView(this.getContext());
        this.tvReference = new TextView(this.getContext());
        this.tvReference.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_window_assistant_text_color));
        this.tvReference.setMaxLines(low);
        this.tvReference.setEllipsize(TextUtils.TruncateAt.END);
        this.tvReference.setOnClickListener(v -> {
            low = low == 3 ? Integer.MAX_VALUE : 3;
            this.tvReference.setMaxLines(low);
        });
    }

    private void initMsgWall(Context context2) {
        if (this.getChildAt(0) != null && this.msgWallContainer != null && this.messageContainer.getChildAt(0) == this.msgWallContainer) {
            this.msgWallContainer.setVisibility(0);
            return;
        }
        this.msgWallContainer = new LinearLayout(context2);
        this.msgWallContainer.setOrientation(0);
        LinearLayout.LayoutParams msgWllContainerParams = new LinearLayout.LayoutParams(-2, UtilsKt.getDp((int)24));
        this.messageContainer.addView((View)this.msgWallContainer, 0, (ViewGroup.LayoutParams)msgWllContainerParams);
        this.msgWallContainer.setPadding(UtilsKt.getDp((int)2), 0, UtilsKt.getDp((int)2), 0);
        ImageView imageView = new ImageView(context2);
        imageView.setImageResource(R.drawable.bjy_base_ic_msg_wall);
        LinearLayout.LayoutParams ivMsgWallParams = new LinearLayout.LayoutParams(UtilsKt.getDp((int)12), UtilsKt.getDp((int)12));
        ivMsgWallParams.leftMargin = UtilsKt.getDp((int)2);
        ivMsgWallParams.gravity = 16;
        this.msgWallContainer.addView((View)imageView, (ViewGroup.LayoutParams)ivMsgWallParams);
        this.tvMsgWall = new TextView(context2);
        this.tvMsgWall.setText((CharSequence)context2.getString(R.string.bjy_base_msg_update_wall_chat_tip));
        this.tvMsgWall.setTextColor(-1);
        this.tvMsgWall.setTextSize(0, (float)context2.getResources().getDimensionPixelSize(R.dimen.bjy_base_msg_wall_chat_text_size));
        this.tvMsgWall.setSingleLine(true);
        this.tvMsgWall.setEllipsize(TextUtils.TruncateAt.END);
        LinearLayout.LayoutParams tvMsgWallParams = new LinearLayout.LayoutParams(-2, -2);
        tvMsgWallParams.gravity = 16;
        tvMsgWallParams.leftMargin = UtilsKt.getDp((int)2);
        this.msgWallContainer.addView((View)this.tvMsgWall, (ViewGroup.LayoutParams)tvMsgWallParams);
        this.msgWallContainer.setBackground(new DrawableBuilder().cornerRadii(UtilsKt.getDp((int)8), UtilsKt.getDp((int)8), 0, 0).solidColor(0x33FFFFFF).build());
        this.messageContainer.post(() -> {
            if (context2 == null) {
                return;
            }
            if (this.msgWallContainer.getMeasuredWidth() < this.messageContainer.getMeasuredWidth()) {
                ViewGroup.LayoutParams layoutParams = this.msgWallContainer.getLayoutParams();
                layoutParams.width = this.messageContainer.getMeasuredWidth();
                this.msgWallContainer.setLayoutParams(layoutParams);
            }
        });
    }

    public void setStateChecked(boolean stateChecked) {
        if (this.stateChecked != stateChecked) {
            this.stateChecked = stateChecked;
            this.refreshDrawableState();
        }
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        if (this.stateChecked) {
            int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
            ChatMessageView.mergeDrawableStates((int[])drawableState, (int[])STATE_CHECKED);
            return drawableState;
        }
        return super.onCreateDrawableState(extraSpace);
    }

    public void setTextColor(int textColor) {
        this.tvMsg.setTextColor(textColor);
        this.tvMsg.setLinkTextColor(textColor);
        this.tvTranslateResult.setTextColor(textColor);
    }

    public void setMessageColor(@ColorInt int color2) {
        this.tvMsg.setTextColor(color2);
    }

    public void setLinkTextColor(@ColorInt int color2) {
        this.tvMsg.setLinkTextColor(color2);
    }

    public void setDividerLineColor(@ColorInt int color2) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setSize(100, UtilsKt.getDp((int)1));
        drawable2.setColor(color2);
        this.setDividerDrawable((Drawable)drawable2);
        this.setShowDividers(2);
        this.tvReference.setTextColor(color2);
        this.tvTranslateResult.setTextColor(color2);
    }

    private void initListener() {
        this.gestureDetectorCompat = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)new LongPressListener());
    }

    public void enableTranslation(boolean isEnable) {
        if (isEnable) {
            if (this.btnTranslate.getParent() == null) {
                LinearLayout.LayoutParams btnTranslateParams = new LinearLayout.LayoutParams(UtilsKt.getDp((int)16), UtilsKt.getDp((int)16));
                btnTranslateParams.setMargins(5, 5, 0, 0);
                this.addView((View)this.btnTranslate, (ViewGroup.LayoutParams)btnTranslateParams);
            }
        } else {
            this.removeView((View)this.btnTranslate);
        }
    }

    public void removeTranslate() {
        if (this.tvTranslateResult != null) {
            this.messageContainer.removeView((View)this.tvTranslateResult);
            this.tvTranslateResult = null;
            this.tvTranslateResult = new TextView(this.getContext());
            this.tvTranslateResult.setTextColor(this.tvMsg.getCurrentTextColor());
            this.isTranslate = false;
        }
        if (this.subscribeTimer != null && !this.subscribeTimer.isDisposed()) {
            this.subscribeTimer.dispose();
        }
        this.btnTranslate.setClickable(true);
    }

    public void removeReference() {
        if (this.tvReference != null) {
            this.messageContainer.removeView((View)this.tvReference);
            this.tvReference = null;
            this.tvReference = new TextView(this.getContext());
            this.tvReference.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            this.tvReference.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_assistant_text_color));
            this.tvReference.setMaxLines(low);
            this.tvReference.setEllipsize(TextUtils.TruncateAt.END);
            this.tvReference.setOnClickListener(v -> {
                low = low == 3 ? Integer.MAX_VALUE : 3;
                this.tvReference.setMaxLines(low);
            });
        }
    }

    public void setMessageModel(IMessageModel messageModel) {
        this.messageModel = messageModel;
    }

    public void setMessage(String message) {
        if (message.contains(MARK)) {
            String[] split = message.split(MARK);
            this.addTranslateMessage(split[1]);
        }
    }

    public void setTranslateButtonVisibility(boolean isVisible) {
        this.btnTranslate.setVisibility(isVisible ? 0 : 8);
    }

    public void addTranslateMessage(String translateMessage) {
        if (this.isFailed || this.isTranslate || translateMessage.equals("")) {
            return;
        }
        if (this.subscribeTimer != null && !this.subscribeTimer.isDisposed()) {
            this.subscribeTimer.dispose();
        }
        if (translateMessage.endsWith("\n")) {
            translateMessage = translateMessage.substring(0, translateMessage.length() - 1);
        }
        this.tvTranslateResult.setText((CharSequence)translateMessage);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.setMargins(UtilsKt.getDp((int)3), UtilsKt.getDp((int)2), UtilsKt.getDp((int)3), UtilsKt.getDp((int)2));
        this.messageContainer.addView((View)this.tvTranslateResult, (ViewGroup.LayoutParams)params);
        this.isTranslate = true;
        this.btnTranslate.setClickable(true);
    }

    public void addReferenceMessage() {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.setMargins(UtilsKt.getDp((int)3), UtilsKt.getDp((int)2), UtilsKt.getDp((int)3), UtilsKt.getDp((int)2));
        this.messageContainer.addView((View)this.tvReference, 0, (ViewGroup.LayoutParams)params);
    }

    public TextView getTextView() {
        return this.tvMsg;
    }

    public TextView getTvReference() {
        return this.tvReference;
    }

    public LineHeightSpan getLineHeightSpan() {
        return this.lineHeightSpan;
    }

    public void translateMessage() {
        this.isFailed = false;
        this.countDown();
    }

    @SuppressLint(value={"CheckResult"})
    private void countDown() {
        this.subscribeTimer = Observable.timer((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            String translateFail = Locale.getDefault().getCountry().equalsIgnoreCase("cn") ? "\u7ffb\u8bd1\u5931\u8d25" : "Translate Fail!";
            this.tvTranslateResult.setText((CharSequence)translateFail);
            if (!this.isTranslate) {
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
                params.setMargins(0, 5, 0, 5);
                this.addView((View)this.tvTranslateResult, (ViewGroup.LayoutParams)params);
            }
            this.isFailed = true;
            this.btnTranslate.setClickable(true);
        });
    }

    public void setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
    }

    public void setDivideLineColor(int color2) {
        this.divideLineDrawable.setColor(color2);
    }

    public void setMessageContainerBackground(Drawable drawable2, boolean showMsgWall) {
        this.messageContainer.setBackground(drawable2);
        if (showMsgWall) {
            this.initMsgWall(this.messageContainer.getContext());
        } else if (this.msgWallContainer != null) {
            this.msgWallContainer.setVisibility(8);
        }
    }

    public boolean isTranslate() {
        return this.isTranslate;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        this.gestureDetectorCompat.onTouchEvent(event);
        return true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        RxUtils.dispose((Disposable)this.subscribeTimer);
        this.subscribeTimer = null;
    }

    public void setChatMessageListener(IChatMessageListener chatMessageListener) {
        this.chatMessageListener = chatMessageListener;
    }

    public static interface IChatMessageListener {
        public void showMenu(int var1, int var2, View var3, IMessageModel var4, boolean var5);
    }

    class LongPressListener
    extends GestureDetector.SimpleOnGestureListener {
        LongPressListener() {
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
            if (ChatMessageView.this.chatMessageListener != null) {
                ChatMessageView.this.chatMessageListener.showMenu((int)e.getRawX(), (int)e.getRawY(), (View)ChatMessageView.this, ChatMessageView.this.messageModel, ChatMessageView.this.messageModel.getMessageType() == LPConstants.MessageType.Image);
            }
        }
    }

    public static interface OnProgressListener {
        public void onProgress();
    }
}

