/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.enums.ResStateType;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;

public class StateButton
extends AppCompatButton {
    private int stateColor;
    private int unStateColor;
    private int stateType;
    private int bgType;

    public StateButton(Context context2) {
        this(context2, null);
    }

    public StateButton(Context context2, @Nullable AttributeSet attrs) {
        super(context2, attrs);
        this.init(context2, attrs);
    }

    public StateButton(Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init(context2, attrs);
    }

    private void init(Context context2, AttributeSet attrs) {
        TypedArray typedArray = context2.obtainStyledAttributes(attrs, R.styleable.BJYStateButton);
        this.stateColor = typedArray.getResourceId(R.styleable.BJYStateButton_btnStateColor, 0);
        this.unStateColor = typedArray.getResourceId(R.styleable.BJYStateButton_btnUnStateColor, 0);
        this.stateType = typedArray.getInt(R.styleable.BJYStateButton_btnStateType, 0);
        this.bgType = typedArray.getInt(R.styleable.BJYStateButton_btnBgType, 0);
        typedArray.recycle();
        if (this.stateType == 0) {
            if (this.stateColor != 0) {
                this.setTextColor(ThemeDataUtil.getColorFromThemConfigByColorId((Context)context2, (int)this.stateColor));
            }
            if (this.unStateColor != 0) {
                this.setTextColor(ThemeDataUtil.getColorFromThemConfigByColorId((Context)context2, (int)this.unStateColor));
            }
        } else {
            this.setTextColor(DisplayUtils.getColorStateList((int)ThemeDataUtil.getColorFromThemConfigByColorId((Context)context2, (int)this.stateColor), (int)ThemeDataUtil.getColorFromThemConfigByColorId((Context)context2, (int)this.unStateColor), (ResStateType)(this.stateType == 1 ? ResStateType.enable : ResStateType.selected)));
        }
        if (this.bgType == 1) {
            this.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_live_product_color)).cornerRadius(context2.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        } else if (this.bgType == 2) {
            this.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_dialog_negative_bg_color)).cornerRadius(context2.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        } else if (this.bgType == 3) {
            Drawable selectDrawable2 = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_live_product_color)).cornerRadius(context2.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
            Drawable drawable2 = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_dialog_negative_bg_color)).cornerRadius(context2.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
            this.setBackground((Drawable)new StateListDrawableBuilder().normal(drawable2).selected(selectDrawable2).build());
        } else if (this.bgType == 4) {
            Drawable drawable3 = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_live_product_color)).cornerRadius(context2.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
            Drawable disableDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_dialog_negative_bg_color)).cornerRadius(context2.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
            this.setBackground((Drawable)new StateListDrawableBuilder().normal(drawable3).disabled(disableDrawable).build());
        }
    }
}

