/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.responder;

import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.res.ResourcesCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.liveuibase.R;
import java.util.Random;

public class ResponderRobButton
extends AppCompatImageView {
    private int widthAndHeight;

    public ResponderRobButton(Context context2) {
        super(context2);
    }

    public void setDefaultSize(int defaultSizeInDp) {
        this.widthAndHeight = UtilsKt.getDp((int)defaultSizeInDp);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.widthAndHeight, this.widthAndHeight);
    }

    public void changeRobButtonStatus(RobButtonState state) {
        switch (state) {
            case ROBED: {
                this.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.base_ic_responder_rob_win, null));
                break;
            }
            case NORMAL: {
                this.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.base_ic_responder_rob_normal, null));
                break;
            }
            case ROB_FAIL: {
                this.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.base_ic_responder_rob_lose, null));
                break;
            }
            case READY_TO_SUBMIT: {
                this.setImageDrawable(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.base_ic_responder_rob_submit, null));
                break;
            }
        }
    }

    public void changePositionRandom(View parent) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.getLayoutParams();
        if (parent.getWidth() <= this.widthAndHeight || parent.getHeight() <= this.widthAndHeight) {
            return;
        }
        Random random = new Random();
        layoutParams.leftMargin = random.nextInt(parent.getWidth() - this.widthAndHeight);
        layoutParams.topMargin = random.nextInt(parent.getHeight() - this.widthAndHeight);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public static enum RobButtonState {
        NORMAL,
        ROBED,
        READY_TO_SUBMIT,
        ROB_FAIL;

    }
}

