/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.answerer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPAnswerModel;
import com.baijiayun.livecore.models.LPAnswerSheetOptionModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseWindow;
import com.baijiayun.liveuibase.toolbox.answerer.AnswererContract;
import com.baijiayun.liveuibase.toolbox.answerer.AnswererPresenter;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.android.schedulers.AndroidSchedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AnswererWindow
extends BaseWindow
implements AnswererContract.View {
    private final AnswererContract.Presenter presenter;
    private boolean canSubmit = true;
    private QueryPlus c$;
    private QueryPlus s$;
    private TextView tvSubmit;
    private TextView tvEndTimeTip;
    private TextView tvRemark;
    private ObservableEmitter<List<LPAnswerSheetOptionModel>> emitter;
    private ImageView singleCheckedImageView;
    private TextView singleCheckedTextView;
    private final int commonMargin = UtilsKt.getDp((int)4);
    private final int LINE_COUNT = 6;
    private AnswerResultListener answerResultListener;
    private ClickListener clickListener;

    public AnswererWindow(Context context2, LPAnswerModel lpAnswerModel) {
        super(context2);
        this.presenter = new AnswererPresenter(this, this.routerListener);
        this.presenter.setAnswererDatas(lpAnswerModel);
        this.allowTouch = true;
    }

    @Override
    protected View onCreateView(Context context2) {
        View view = View.inflate((Context)context2, (int)R.layout.uibase_answerer_window, null);
        if (DisplayUtils.isPortrait((Context)context2)) {
            view.setBackground(new DrawableBuilder().rectangle().solidColor(this.add50PercentAlpha(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_window_bg_color))).cornerRadii(UtilsKt.getDp((int)12), UtilsKt.getDp((int)12), 0, 0).build());
        } else {
            view.setBackground(this.getCommonFocusableDrawable(this.add50PercentAlpha(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_window_bg_color))));
        }
        this.allowTouch = false;
        LinearLayout ll = (LinearLayout)view.findViewById(R.id.ll_container);
        ViewGroup.LayoutParams lp = ll.getLayoutParams();
        lp.height = -2;
        ll.setLayoutParams(lp);
        return view;
    }

    public int add50PercentAlpha(int originalColor) {
        int rgb = originalColor & 0xFFFFFF;
        int alpha = Integer.MIN_VALUE;
        return alpha | rgb;
    }

    @Override
    public void initView(LPAnswerModel lpAnswerModel) {
        LPLogger.d((String)"\u7b54\u9898\u5668");
        this.canSubmit = true;
        this.tvEndTimeTip = (TextView)this.$.id(R.id.tv_time).view();
        this.$.id(R.id.iv_close).invisible();
        this.$.id(R.id.iv_close).clicked(v -> this.$.contentView().setVisibility(8));
        TextView tvName = (TextView)this.$.id(R.id.tv_name).view();
        tvName.setTextSize(12.0f);
        LinearLayout llContainer = (LinearLayout)this.$.id(R.id.ll_container).view();
        llContainer.removeAllViews();
        View contentView = View.inflate((Context)this.context, (int)R.layout.uibase_answerer_window_student, null);
        this.c$ = QueryPlus.with((View)contentView);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        llContainer.addView(contentView, (ViewGroup.LayoutParams)layoutParams);
        RelativeLayout llOptionsContainer = (RelativeLayout)this.c$.id(R.id.ll_options_container).view();
        this.tvSubmit = (TextView)this.c$.id(R.id.tv_submit).view();
        this.tvSubmit.setBackground(this.getSubmitDrawable(this.context));
        if (this.isTvMode()) {
            this.tvSubmit.setFocusable(true);
            this.tvSubmit.setFocusableInTouchMode(false);
            this.tvSubmit.setNextFocusRightId(this.$.contentView().getId());
            this.tvSubmit.setOnKeyListener((View.OnKeyListener)new KeyEventListener(null));
        }
        this.compositeDisposable.add(this.c$.id(R.id.tv_submit).clicks().throttleFirst(500L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(o -> {
            if (this.canSubmit) {
                if (this.presenter.submitAnswers()) {
                    if (lpAnswerModel.isVote) {
                        this.endAnswer();
                    } else {
                        this.showToastMessage(this.getString(R.string.base_answerer_submit_success));
                        this.tvSubmit.setText((CharSequence)this.getString(R.string.base_answerer_modify));
                        this.canSubmit = false;
                        this.setClickable((View)llOptionsContainer, false);
                        this.tvSubmit.setNextFocusUpId(this.$.contentView().getId());
                        this.$.id(R.id.iv_close).visible();
                    }
                } else {
                    this.showToastMessage(this.getString(R.string.base_answerer_submit_fail));
                    LPLogger.w((String)"submit onError");
                }
            } else {
                this.canSubmit = true;
                this.presenter.reset();
                this.setClickable((View)llOptionsContainer, true);
                this.tvSubmit.setNextFocusUpId(-1);
                this.tvSubmit.setText((CharSequence)(lpAnswerModel.isVote ? this.getString(R.string.base_tool_box_answerer_vote) : this.getString(R.string.base_answerer_submit)));
            }
            if (this.isTvMode()) {
                this.$.contentView().requestFocus();
            }
        }));
        this.compositeDisposable.add(Observable.create(emitter -> {
            this.emitter = emitter;
            emitter.onNext((Object)lpAnswerModel.options);
        }).observeOn(AndroidSchedulers.mainThread()).filter(optionModelList -> {
            for (LPAnswerSheetOptionModel lpAnswerSheetOptionModel : optionModelList) {
                if (!lpAnswerSheetOptionModel.isActive) continue;
                return !this.tvSubmit.isEnabled();
            }
            this.setClickable((View)this.tvSubmit, !this.canSubmit);
            return false;
        }).subscribe(lpAnswerSheetOptionModel -> this.setClickable((View)this.tvSubmit, true)));
        this.tvRemark = (TextView)contentView.findViewById(R.id.tv_remark);
        this.tvRemark.setVisibility(TextUtils.isEmpty((CharSequence)lpAnswerModel.getDescription()) ? 8 : 0);
        this.tvRemark.setText((CharSequence)lpAnswerModel.getDescription());
        this.timeDown(lpAnswerModel.duration);
        if (lpAnswerModel.isVote) {
            tvName.setText((CharSequence)this.getString(R.string.base_tool_box_answerer_vote));
            this.tvSubmit.setText((CharSequence)this.getString(R.string.base_tool_box_answerer_vote));
            this.tvRemark.setVisibility(8);
        }
        List options = lpAnswerModel.options;
        if (lpAnswerModel.isJudgement()) {
            this.generateJudgementViews(llOptionsContainer, options);
        } else {
            this.generateViews(llOptionsContainer, options, position -> this.generateOptionsView(options, position), 0);
        }
    }

    public void changeOrientation() {
        if (DisplayUtils.isPortrait((Context)this.context)) {
            this.view.setBackground(new DrawableBuilder().rectangle().solidColor(this.add50PercentAlpha(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_bg_color))).cornerRadii(UtilsKt.getDp((int)12), UtilsKt.getDp((int)12), 0, 0).build());
            if (this.s$ != null) {
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.s$.id(R.id.tv_standard_answer).view().getLayoutParams();
                layoutParams.leftMargin = UtilsKt.getDp((int)56);
                LinearLayout.LayoutParams layoutParams1 = (LinearLayout.LayoutParams)this.s$.id(R.id.tv_answer_countdown_close).view().getLayoutParams();
                layoutParams1.leftMargin = UtilsKt.getDp((int)56);
                layoutParams1.rightMargin = UtilsKt.getDp((int)56);
            }
        } else {
            this.view.setBackground(this.getCommonFocusableDrawable(this.add50PercentAlpha(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_bg_color))));
            if (this.s$ != null) {
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.s$.id(R.id.tv_standard_answer).view().getLayoutParams();
                layoutParams.leftMargin = UtilsKt.getDp((int)0);
                LinearLayout.LayoutParams layoutParams1 = (LinearLayout.LayoutParams)this.s$.id(R.id.tv_answer_countdown_close).view().getLayoutParams();
                layoutParams1.leftMargin = UtilsKt.getDp((int)0);
                layoutParams1.rightMargin = UtilsKt.getDp((int)0);
            }
        }
    }

    @Override
    public void onAnswerEnd() {
        this.tvEndTimeTip.setVisibility(8);
    }

    private void setClickable(View view, boolean isEnable) {
        if (this.routerListener.getLiveRoom().isAudition()) {
            isEnable = false;
        }
        view.setEnabled(isEnable);
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = parent.getChildAt(i);
                this.setClickable(child, isEnable);
            }
        }
    }

    private Drawable getSubmitDrawable(Context context2) {
        Drawable disableDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_dialog_negative_bg_color)).cornerRadius(context2.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build();
        return new StateListDrawableBuilder().normal(this.getCommonFocusableDrawable(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_live_product_color))).disabled(disableDrawable).build();
    }

    private Drawable getAnswerSelectedDrawable(Context context2, boolean isSingle) {
        Drawable selectedDrawable = this.getOvalOrRectangleBuilder(isSingle).solidColor(ContextCompat.getColor((Context)context2, (int)R.color.base_theme_live_product)).build();
        Drawable drawable2 = this.getOvalOrRectangleBuilder(isSingle).strokeColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_live_product_color)).strokeWidth(UtilsKt.getDp((int)2)).build();
        return new StateListDrawableBuilder().normal(drawable2).selected(selectedDrawable).build();
    }

    private DrawableBuilder getOvalOrRectangleBuilder(boolean isSingle) {
        return isSingle ? new DrawableBuilder().oval() : new DrawableBuilder().rectangle().cornerRadius(UtilsKt.getDp((int)45));
    }

    private Drawable getShowDrawable(Context context2, boolean isSingle, AnswerStatus state) {
        DrawableBuilder builder = this.getOvalOrRectangleBuilder(isSingle);
        switch (state) {
            case NORMAL: {
                builder.strokeColor(ContextCompat.getColor((Context)context2, (int)R.color.base_theme_live_product)).strokeWidth(UtilsKt.getDp((int)2));
                break;
            }
            case WRONG: {
                builder.solidColor(ContextCompat.getColor((Context)context2, (int)R.color.base_toolbar_red));
                break;
            }
            case RIGHT: {
                builder.solidColor(ContextCompat.getColor((Context)context2, (int)R.color.base_theme_live_product));
            }
        }
        return builder.build();
    }

    private void generateViews(RelativeLayout relativeLayout, List<LPAnswerSheetOptionModel> options, Callback callback, int gravity) {
        int size = options.size();
        RelativeLayout container2 = new RelativeLayout(this.context);
        LinearLayout newLayout = null;
        int previousLineId = -1;
        int lines = (size - 1) / 6 + 1;
        int lastLineColumns = size % 6 == 0 ? 6 : size % 6;
        for (int line = 0; line < lines - 1; ++line) {
            int startByLine = line * 6;
            int startByNextLine = (line + 1) * 6;
            for (int position = startByLine; position < startByNextLine; ++position) {
                View itemView = callback.generateView(position);
                if (line == 0) {
                    itemView.setNextFocusUpId(this.$.contentView().getId());
                }
                if (position == startByNextLine - 1) {
                    itemView.setNextFocusRightId(this.$.contentView().getId());
                }
                if (position == startByLine) {
                    newLayout = this.addOptionsLineLayout(container2, previousLineId);
                    previousLineId = newLayout.getId();
                    itemView.setNextFocusLeftId(this.$.contentView().getId());
                }
                this.addOptionsView(newLayout, itemView);
            }
        }
        for (int lastColumn = 0; lastColumn < lastLineColumns; ++lastColumn) {
            int realPosition = (lines - 1) * 6 + lastColumn;
            View itemView = callback.generateView(realPosition);
            itemView.setNextFocusDownId(this.tvSubmit.getId());
            if (lines == 1) {
                itemView.setNextFocusUpId(this.$.contentView().getId());
            }
            if (lastColumn == 0) {
                newLayout = this.addOptionsLineLayout(container2, previousLineId);
                previousLineId = newLayout.getId();
                itemView.setNextFocusLeftId(this.$.contentView().getId());
            }
            if (lastColumn == lastLineColumns - 1) {
                itemView.setNextFocusRightId(this.$.contentView().getId());
            }
            this.addOptionsView(newLayout, itemView);
        }
        RelativeLayout.LayoutParams relativeLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        switch (gravity) {
            case 1: {
                relativeLayoutParams.addRule(13);
                break;
            }
            default: {
                relativeLayoutParams.addRule(20);
            }
        }
        relativeLayout.addView((View)container2, (ViewGroup.LayoutParams)relativeLayoutParams);
    }

    private LinearLayout addOptionsLineLayout(RelativeLayout container2, int previousLineId) {
        LinearLayout newLayout = new LinearLayout(this.context);
        newLayout.setOrientation(0);
        newLayout.setGravity(0x800003);
        newLayout.setId(View.generateViewId());
        RelativeLayout.LayoutParams containerParams = new RelativeLayout.LayoutParams(-2, -2);
        if (previousLineId == -1) {
            containerParams.addRule(14);
        } else {
            containerParams.addRule(3, previousLineId);
            containerParams.addRule(18, previousLineId);
        }
        container2.addView((View)newLayout, (ViewGroup.LayoutParams)containerParams);
        return newLayout;
    }

    private void addOptionsView(LinearLayout layout2, View view) {
        LinearLayout.LayoutParams itemLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        itemLayoutParams.leftMargin = this.commonMargin;
        itemLayoutParams.rightMargin = this.commonMargin;
        itemLayoutParams.topMargin = this.commonMargin;
        itemLayoutParams.bottomMargin = this.commonMargin;
        layout2.addView(view, (ViewGroup.LayoutParams)itemLayoutParams);
    }

    private void generateJudgementViews(RelativeLayout relativeLayout, List<LPAnswerSheetOptionModel> options) {
        if (options.size() != 2) {
            LPLogger.w((String)"judgement size more than 2 ,onError");
            this.showToastMessage(this.getString(R.string.base_answerer_judgement_error));
            return;
        }
        this.generateViews(relativeLayout, options, position -> this.generateJudgementView(options, position), 0);
    }

    private View generateJudgementView(List<LPAnswerSheetOptionModel> options, int position) {
        LPAnswerSheetOptionModel lpAnswerSheetOptionModel = options.get(position);
        View itemView = View.inflate((Context)this.context, (int)R.layout.uibase_answerer_item_check_option, null);
        TextView tvOption = (TextView)itemView.findViewById(R.id.tv_option);
        tvOption.setText((CharSequence)lpAnswerSheetOptionModel.text);
        tvOption.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_theme_live_product));
        if (lpAnswerSheetOptionModel.text.length() <= 1) {
            tvOption.setBackground(this.getAnswerSelectedDrawable(this.context, true));
            tvOption.setPadding(0, 0, 0, 0);
        } else {
            tvOption.setBackground(this.getAnswerSelectedDrawable(this.context, false));
            tvOption.setPadding(UtilsKt.getDp((int)12), 0, UtilsKt.getDp((int)12), 0);
        }
        ImageView ivCheck = (ImageView)itemView.findViewById(R.id.iv_check);
        ivCheck.setSelected(true);
        ivCheck.setVisibility(lpAnswerSheetOptionModel.isActive && !this.presenter.isVote() ? 0 : 4);
        if (this.isTvMode()) {
            itemView.setFocusable(true);
            itemView.setFocusableInTouchMode(false);
            ivCheck.setFocusable(false);
            FocusChangeListener focusChangeListener = new FocusChangeListener(tvOption);
            itemView.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
            this.clickListener = new ClickListener(lpAnswerSheetOptionModel, ivCheck, tvOption);
            this.clickListener.options = options;
            itemView.setOnKeyListener((View.OnKeyListener)new KeyEventListener(this.clickListener));
            itemView.setNextFocusUpId(this.$.contentView().getId());
            itemView.setNextFocusDownId(this.tvSubmit.getId());
            if (position == 0) {
                itemView.setNextFocusLeftId(this.$.contentView().getId());
            } else {
                itemView.setNextFocusRightId(this.$.contentView().getId());
            }
        } else {
            this.clickListener = new ClickListener(lpAnswerSheetOptionModel, ivCheck, tvOption);
            this.clickListener.options = options;
            tvOption.setOnClickListener((View.OnClickListener)this.clickListener);
            ivCheck.setOnClickListener((View.OnClickListener)this.clickListener);
        }
        return itemView;
    }

    private View generateOptionsView(List<LPAnswerSheetOptionModel> options, int position) {
        LPAnswerSheetOptionModel optionModel = options.get(position);
        View itemView = View.inflate((Context)this.context, (int)R.layout.uibase_answerer_item_check_option, null);
        TextView tvOption = (TextView)itemView.findViewById(R.id.tv_option);
        tvOption.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_theme_live_product));
        tvOption.setBackground(this.getAnswerSelectedDrawable(this.context, true));
        ImageView ivCheck = (ImageView)itemView.findViewById(R.id.iv_check);
        ivCheck.setSelected(true);
        if (this.isTvMode()) {
            itemView.setFocusable(true);
            itemView.setFocusableInTouchMode(false);
            ivCheck.setFocusable(false);
            FocusChangeListener focusChangeListener = new FocusChangeListener(tvOption);
            itemView.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
            this.clickListener = new ClickListener(optionModel, ivCheck, tvOption);
            this.clickListener.options = options;
            itemView.setOnKeyListener((View.OnKeyListener)new KeyEventListener(this.clickListener));
        } else {
            this.clickListener = new ClickListener(optionModel, ivCheck, tvOption);
            this.clickListener.options = options;
            tvOption.setOnClickListener((View.OnClickListener)this.clickListener);
            ivCheck.setOnClickListener((View.OnClickListener)this.clickListener);
        }
        ivCheck.setVisibility(optionModel.isActive && !this.presenter.isVote() ? 0 : 4);
        tvOption.setText((CharSequence)optionModel.text);
        return itemView;
    }

    private View generateShowView(List<String> myAnswers, List<String> standardAnswers, LPAnswerSheetOptionModel model) {
        View itemView = View.inflate((Context)this.context, (int)R.layout.uibase_answerer_item_check_option, null);
        TextView tvOption = (TextView)itemView.findViewById(R.id.tv_option);
        ImageView ivCheck = (ImageView)itemView.findViewById(R.id.iv_check);
        tvOption.setText((CharSequence)model.text);
        boolean isSingle = model.text.length() <= 1;
        tvOption.setPadding(isSingle ? 0 : UtilsKt.getDp((int)12), 0, isSingle ? 0 : UtilsKt.getDp((int)12), 0);
        if (standardAnswers.contains(model.text) && myAnswers.contains(model.text)) {
            tvOption.setBackground(this.getShowDrawable(this.context, isSingle, AnswerStatus.RIGHT));
            tvOption.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_white));
            ivCheck.setVisibility(0);
            ivCheck.setSelected(true);
        } else if (!standardAnswers.contains(model.text) && myAnswers.contains(model.text)) {
            tvOption.setBackground(this.getShowDrawable(this.context, isSingle, AnswerStatus.WRONG));
            tvOption.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_white));
            ivCheck.setVisibility(0);
            ivCheck.setSelected(false);
        } else {
            tvOption.setBackground(this.getShowDrawable(this.context, isSingle, AnswerStatus.NORMAL));
            tvOption.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_theme_live_product));
            ivCheck.setVisibility(8);
        }
        return itemView;
    }

    @Override
    public void timeDown(long down) {
        this.tvEndTimeTip.setText((CharSequence)this.getTimeString(down));
    }

    private String getTimeString(long seconds) {
        long minute = seconds / 60L;
        long second = seconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (minute < 10L) {
            sb.append("0");
        }
        sb.append(minute);
        sb.append(":");
        if (second < 10L) {
            sb.append("0");
        }
        sb.append(second);
        return sb.toString();
    }

    @Override
    public void timeDownClose(long timeDown) {
        if (this.presenter.hasShowAnswer()) {
            this.s$.id(R.id.tv_answer_countdown_close).text((CharSequence)(this.context.getString(R.string.base_live_close) + "\uff08" + timeDown + "s\uff09"));
        }
    }

    @Override
    public void doOnClose() {
        if (this.presenter.hasShowAnswer()) {
            this.s$.id(R.id.tv_answer_countdown_close).visibility(0);
        } else {
            this.$.id(R.id.iv_close).visible();
            this.setClickable(this.c$.id(R.id.ll_options_container).view(), false);
            this.setClickable((View)this.tvSubmit, false);
        }
        if (this.isTvMode()) {
            this.requestFocus();
        }
    }

    @Override
    public void endAnswer() {
        this.presenter.closeWindow();
    }

    @Override
    public void handleBackKey() {
        this.presenter.closeWindow();
    }

    @Override
    public void onDestroy() {
        this.presenter.destroy();
        super.onDestroy();
    }

    @Override
    public void onReset(LPAnswerModel lpAnswerModel) {
        this.tvEndTimeTip.setVisibility(0);
        this.$.contentView().setVisibility(0);
        this.$.id(R.id.iv_close).invisible();
        RelativeLayout llOptionsContainer = (RelativeLayout)this.c$.id(R.id.ll_options_container).view();
        this.setClickable((View)this.tvSubmit, false);
        this.setClickable((View)llOptionsContainer, true);
        this.tvRemark.setVisibility(TextUtils.isEmpty((CharSequence)lpAnswerModel.getDescription()) ? 8 : 0);
        this.tvRemark.setText((CharSequence)lpAnswerModel.getDescription());
        llOptionsContainer.removeAllViews();
        if (lpAnswerModel.isJudgement()) {
            this.generateJudgementViews(llOptionsContainer, lpAnswerModel.options);
        } else {
            this.generateViews(llOptionsContainer, lpAnswerModel.options, position -> this.generateOptionsView(lpAnswerModel.options, position), 0);
        }
        llOptionsContainer.requestLayout();
        if (this.isTvMode()) {
            this.requestFocus();
        }
    }

    @Override
    public void onShowAnswer(LPAnswerModel lpAnswerModel) {
        this.tvEndTimeTip.setVisibility(8);
        this.$.contentView().setVisibility(0);
        this.$.id(R.id.iv_close).visible();
        this.$.id(R.id.iv_close).clicked(v -> this.presenter.closeWindow());
        TextView tvName = (TextView)this.$.id(R.id.tv_name).view();
        tvName.setTextSize(12.0f);
        tvName.setText((CharSequence)this.context.getString(R.string.base_tool_box_answerer_stu));
        LinearLayout llContainer = (LinearLayout)this.$.id(R.id.ll_container).view();
        llContainer.removeAllViews();
        View answerView = View.inflate((Context)this.context, (int)R.layout.uibase_answer_show, null);
        this.s$ = QueryPlus.with((View)answerView);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        llContainer.addView(answerView, (ViewGroup.LayoutParams)layoutParams);
        RelativeLayout answerContainer = (RelativeLayout)this.s$.id(R.id.ll_answer_container).view();
        List options = lpAnswerModel.options;
        ArrayList<String> myAnswers = new ArrayList<String>();
        ArrayList<String> standardAnswers = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int size = options.size();
        for (int i = 0; i < size; ++i) {
            LPAnswerSheetOptionModel optionModel = (LPAnswerSheetOptionModel)options.get(i);
            if (optionModel.isRight) {
                standardAnswers.add(optionModel.text);
                sb.append(optionModel.text);
                sb.append(" ");
            }
            if (!optionModel.isActive) continue;
            myAnswers.add(optionModel.text);
        }
        if (UtilsKt.areListsEqual(myAnswers, standardAnswers)) {
            if (this.answerResultListener != null) {
                this.answerResultListener.onAnswerResult(true);
            }
        } else if (!myAnswers.isEmpty() && !standardAnswers.isEmpty() && this.answerResultListener != null) {
            this.answerResultListener.onAnswerResult(false);
        }
        SpannableString ss = new SpannableString((CharSequence)(this.context.getString(R.string.base_answerer_right) + sb));
        ss.setSpan((Object)new ForegroundColorSpan(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)), ss.length() - sb.length(), ss.length(), 33);
        this.s$.id(R.id.tv_standard_answer).text((CharSequence)ss);
        if (myAnswers.size() == 0) {
            this.s$.id(R.id.tv_no_answer).visibility(0);
            this.s$.id(R.id.ll_answer_container).visibility(8);
        } else {
            this.s$.id(R.id.tv_no_answer).visibility(8);
            this.s$.id(R.id.ll_answer_container).visibility(0);
            this.generateViews(answerContainer, options, position -> this.generateShowView(myAnswers, standardAnswers, (LPAnswerSheetOptionModel)options.get(position)), 1);
        }
        this.s$.id(R.id.tv_answer_countdown_close).clicked(v -> this.presenter.closeWindow());
        if (this.isTvMode()) {
            this.requestFocus();
        }
        this.changeOrientation();
    }

    private boolean checkSingleOption(List<LPAnswerSheetOptionModel> options) {
        int rightCount = 0;
        for (LPAnswerSheetOptionModel optionModel : options) {
            if (optionModel.isCorrect || optionModel.isRight) {
                ++rightCount;
            }
            if (rightCount < 2) continue;
            return false;
        }
        return true;
    }

    public void setAnswerResultListener(AnswerResultListener answerResultListener) {
        this.answerResultListener = answerResultListener;
    }

    public static interface AnswerResultListener {
        public void onAnswerResult(boolean var1);
    }

    static interface Callback {
        public View generateView(int var1);
    }

    static enum AnswerStatus {
        NORMAL,
        RIGHT,
        WRONG;

    }

    class FocusChangeListener
    implements View.OnFocusChangeListener {
        private TextView textView;
        private ImageView imageView;

        public FocusChangeListener(TextView textView) {
            this.textView = textView;
        }

        public FocusChangeListener(ImageView imageView) {
            this.imageView = imageView;
        }

        public void onFocusChange(View v, boolean hasFocus) {
            ImageView currentView;
            if (this.textView != null) {
                this.textView.setTextColor(ContextCompat.getColor((Context)AnswererWindow.this.context, (int)(hasFocus ? R.color.base_white : R.color.base_theme_live_product)));
            }
            if (this.imageView != null) {
                this.imageView.setColorFilter(ContextCompat.getColor((Context)AnswererWindow.this.context, (int)(hasFocus ? R.color.base_white : R.color.base_theme_live_product)));
            }
            Object object = currentView = this.textView == null ? this.imageView : this.textView;
            if (currentView != null) {
                currentView.setBackground(hasFocus ? new DrawableBuilder().oval().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)AnswererWindow.this.context, (int)R.attr.base_theme_live_product_color)).build() : new DrawableBuilder().oval().strokeColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)AnswererWindow.this.context, (int)R.attr.base_theme_live_product_color)).strokeWidth(UtilsKt.getDp((int)2)).build());
            }
        }
    }

    class KeyEventListener
    implements View.OnKeyListener {
        private final ClickListener clickListener;

        public KeyEventListener(ClickListener clickListener) {
            this.clickListener = clickListener;
        }

        public boolean onKey(View v, int keyCode, KeyEvent event) {
            if (event.getAction() == 0) {
                BaseWindow.KeyEventSymbolize action = BaseWindow.KEY_EVENT_ACTIONS.get(keyCode);
                if (this.clickListener != null && action == BaseWindow.KeyEventSymbolize.SELECT) {
                    this.clickListener.onClick(v);
                    return true;
                }
                if (action == BaseWindow.KeyEventSymbolize.BACK) {
                    return AnswererWindow.this.handleChildBackKey();
                }
            }
            return false;
        }
    }

    class ClickListener
    implements View.OnClickListener {
        private List<LPAnswerSheetOptionModel> options;
        private LPAnswerSheetOptionModel optionModel;
        private ImageView imageView;
        private TextView textView;

        public ClickListener(LPAnswerSheetOptionModel optionModel, ImageView imageView, TextView textView) {
            this.optionModel = optionModel;
            this.imageView = imageView;
            this.textView = textView;
        }

        public void onClick(View v) {
            if (AnswererWindow.this.routerListener.getLiveRoom().isAudition()) {
                return;
            }
            boolean singleOption = AnswererWindow.this.checkSingleOption(this.options);
            if (singleOption) {
                if (AnswererWindow.this.singleCheckedImageView != null) {
                    AnswererWindow.this.singleCheckedImageView.setVisibility(4);
                    Object tag = AnswererWindow.this.singleCheckedImageView.getTag();
                    if (tag instanceof LPAnswerSheetOptionModel) {
                        LPAnswerSheetOptionModel optionModel = (LPAnswerSheetOptionModel)tag;
                        optionModel.isActive = false;
                    }
                }
                if (AnswererWindow.this.singleCheckedTextView != null) {
                    AnswererWindow.this.singleCheckedTextView.setTextColor(ContextCompat.getColor((Context)AnswererWindow.this.context, (int)R.color.base_theme_live_product));
                    AnswererWindow.this.singleCheckedTextView.setSelected(false);
                }
                AnswererWindow.this.singleCheckedImageView = this.imageView;
                AnswererWindow.this.singleCheckedTextView = this.textView;
                AnswererWindow.this.singleCheckedImageView.setTag((Object)this.optionModel);
                this.optionModel.isActive = true;
            } else {
                this.optionModel.isActive = !this.optionModel.isActive;
            }
            this.imageView.setVisibility(this.optionModel.isActive && !AnswererWindow.this.presenter.isVote() ? 0 : 4);
            this.textView.setTextColor(ContextCompat.getColor((Context)AnswererWindow.this.context, (int)(this.optionModel.isActive ? R.color.base_white : R.color.base_theme_live_product)));
            this.textView.setSelected(this.optionModel.isActive);
            if (AnswererWindow.this.emitter != null) {
                AnswererWindow.this.emitter.onNext(this.options);
            }
        }
    }
}

