/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.widgets.switchCompat.MultiSwitchCompat;

public class SettingSwitch
extends MultiSwitchCompat {
    private Drawable trackDrawable;

    public SettingSwitch(@NonNull Context context2) {
        super(context2);
        this.initDrawable();
    }

    public SettingSwitch(@NonNull Context context2, @Nullable AttributeSet attrs) {
        super(context2, attrs);
        this.initDrawable();
    }

    public SettingSwitch(@NonNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.initDrawable();
    }

    private void initDrawable() {
        this.setThumbDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.bjy_base_shape_common_switch_thumb));
        this.trackDrawable = new DrawableBuilder().solidColor(this.getContext().getResources().getColor(R.color.bjy_base_setting_switch_background)).build();
        this.setTrackDrawable(this.trackDrawable);
        this.setShowText(true);
        this.setTextColors(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_dialog_positive_text_color), ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_main_text_color));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.trackDrawable.setAlpha(enabled ? 255 : 128);
        this.getThumbDrawable().setAlpha(enabled ? 255 : 128);
    }
}

