/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

public class DragFrameLayout
extends FrameLayout {
    private int lastX = 0;
    private int lastY = 0;
    private int x1 = 0;
    private int x2 = 0;
    private int screenWidth = 10;
    private int screenHeight = 10;
    private Context context;
    private int dx;
    private int dy;
    private ViewGroup mParent;
    private boolean useParentRect = false;
    RelativeLayout.LayoutParams lpFeedback = new RelativeLayout.LayoutParams(-2, -2);
    private int threshold = 0;

    public DragFrameLayout(Context context2) {
        this(context2, null);
    }

    public DragFrameLayout(Context context2, AttributeSet attrs) {
        super(context2, attrs);
        this.initScreenParam(context2);
        this.context = context2;
        this.mParent = (ViewGroup)this.getParent();
    }

    private void initScreenParam(Context context2) {
        DisplayMetrics metric = new DisplayMetrics();
        WindowManager wm = (WindowManager)context2.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metric);
        this.screenWidth = metric.widthPixels;
        this.screenHeight = metric.heightPixels;
        int statusBarHeight = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = this.getResources().getDimensionPixelSize(resourceId);
        }
        if (context2.getResources().getConfiguration().orientation == 1) {
            this.screenHeight -= statusBarHeight;
        }
    }

    public void configurationChanged() {
        this.initScreenParam(this.context);
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.lastX = (int)event.getRawX();
                this.lastY = (int)event.getRawY();
                if (!this.useParentRect) break;
                this.screenWidth = this.mParent.getWidth();
                this.screenHeight = this.mParent.getHeight();
                break;
            }
            case 2: {
                this.dx = (int)event.getRawX() - this.lastX;
                this.dy = (int)event.getRawY() - this.lastY;
                int left = this.getLeft() + this.dx;
                int top = this.getTop() + this.dy;
                int right = this.getRight() + this.dx;
                int bottom = this.getBottom() + this.dy;
                if (left < 0) {
                    left = 0;
                    right = left + this.getWidth();
                }
                if (right > this.screenWidth) {
                    right = this.screenWidth;
                    left = this.screenWidth - this.getWidth();
                }
                if (top < 0) {
                    top = 0;
                    bottom = top + this.getHeight();
                }
                if (bottom > this.screenHeight) {
                    bottom = this.screenHeight;
                    top = this.screenHeight - this.getHeight();
                }
                this.layout(left, top, right, bottom);
                this.lpFeedback.setMargins(left, top, 0, 0);
                this.setLayoutParams((ViewGroup.LayoutParams)this.lpFeedback);
                this.lastX = (int)event.getRawX();
                this.lastY = (int)event.getRawY();
                this.threshold = Math.max(this.threshold, Math.abs(this.dx) + Math.abs(this.dy));
                break;
            }
            case 1: {
                if (this.threshold <= 10) break;
                this.threshold = 0;
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    public void assignParent(ViewGroup parent) {
        if (this.mParent == null) {
            this.mParent = parent;
            this.useParentRect = true;
        } else if (parent == null) {
            this.mParent = null;
        }
    }
}

