/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.chat.messagesend;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.LifecycleOwner;
import com.baijiahulian.common.cropperv2.BJCommonImageCropHelper;
import com.baijiahulian.common.cropperv2.ThemeConfig;
import com.baijiahulian.common.cropperv2.model.PhotoInfo;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.bjyutils.widgets.SimpleTextWatcher;
import com.baijiayun.livebase.base.BasePresenter;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPExpressionModel;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livebase.widgets.BaseMessageSendFragment;
import com.baijiayun.livebase.widgets.emoji.EmojiFragment;
import com.baijiayun.livecore.models.LPMessageAtUserModel;
import com.baijiayun.livecore.models.LPMessageReferenceModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.chat.ChooseAtUserDialog;
import com.baijiayun.liveuibase.chat.LengthFilter;
import com.baijiayun.liveuibase.chat.messagesend.MessageSendContract;
import com.baijiayun.liveuibase.chat.privatechat.ChatUsersDialogFragment;
import com.baijiayun.liveuibase.widgets.chat.MsgEditText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Pair;

public class MessageSendFragment
extends BaseMessageSendFragment
implements MessageSendContract.View {
    private static final String QUICK_REPLY_FILE_NAME = "live_ui_quick_reply";
    private static final String AT = "@";
    private static final int MAX_TEXT_LENGTH = 400;
    private int maxTextLength;
    private MessageSendContract.Presenter presenter;
    private EmojiFragment emojiFragment;
    private ChatUsersDialogFragment chatUsersDialogFragment;
    private boolean autoChoosePrivateChatUser = false;
    private String autoEnterMessage = "";
    private Map<String, Integer> mChatQuickReplyMap;

    public static MessageSendFragment newInstance() {
        return new MessageSendFragment();
    }

    public int getLayoutId() {
        return R.layout.bjy_dialog_message_send;
    }

    protected void setWindowParams(@NonNull WindowManager.LayoutParams windowParams) {
        super.setWindowParams(windowParams);
        windowParams.windowAnimations = R.style.BJYBaseSendMsgDialogAnim;
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        SharedPreferences sharedPreferences;
        super.hideTitleBar();
        this.tvSend = (TextView)this.$.id(R.id.dialog_message_send_btn).view();
        this.etMsgSend = (EditText)this.$.id(R.id.dialog_message_send_et).view();
        this.ivChatEmoji = (ImageView)this.$.id(R.id.dialog_message_emoji).view();
        this.setEmojiContainer((FrameLayout)this.$.id(R.id.dialog_message_send_emoji).view());
        if (this.presenter.isLiveCanWhisper()) {
            this.showPrivateChatChange();
        } else {
            this.$.id(R.id.dialog_private_chat_btn).gone();
            this.$.id(R.id.dialog_interval_line).gone();
        }
        this.$.id(R.id.dialog_message_send_pic).clicked(v -> {
            ThemeConfig.Builder builder = new ThemeConfig.Builder();
            builder.setScreenOrientation(0).setMainElementsColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_live_product_color));
            BJCommonImageCropHelper.openImageSingleAblum((Context)this.contextReference, (BJCommonImageCropHelper.PhotoCropType)BJCommonImageCropHelper.PhotoCropType.None, (ThemeConfig)builder.build(), (BJCommonImageCropHelper.OnHandlerResultCallback)new BJCommonImageCropHelper.OnHandlerResultCallback(){

                public void onHandlerSuccess(List<PhotoInfo> list) {
                    if (list.size() == 1) {
                        MessageSendFragment.this.presenter.sendPicture(list.get(0).getPhotoPath());
                    }
                }

                public void onHandlerFailure(String s) {
                    MessageSendFragment.this.showToast(s);
                }
            });
        });
        if (this.presenter.canSendPicture()) {
            this.$.id(R.id.dialog_message_send_pic).visible();
        } else {
            this.$.id(R.id.dialog_message_send_pic).gone();
        }
        this.$.id(R.id.dialog_message_send_container).background(this.getInputBG());
        this.$.id(R.id.dialog_private_chat_btn).clicked(v -> this.presenter.choosePrivateChatUser());
        this.$.id(R.id.dialog_message_send_btn).enable(false);
        if (this.autoChoosePrivateChatUser) {
            this.presenter.choosePrivateChatUser();
            this.autoChoosePrivateChatUser = false;
        } else {
            this.$.id(R.id.dialog_message_send_et).view().requestFocus();
        }
        if (!TextUtils.isEmpty((CharSequence)this.autoEnterMessage)) {
            EditText editText = (EditText)this.$.id(R.id.dialog_message_send_et).view();
            editText.post(() -> {
                editText.setText((CharSequence)this.autoEnterMessage);
                editText.setSelection(this.autoEnterMessage.length());
            });
        }
        this.mChatQuickReplyMap = (sharedPreferences = this.contextReference.getSharedPreferences(QUICK_REPLY_FILE_NAME, 0)) == null ? new HashMap() : sharedPreferences.getAll();
        this.presenter.getChatQuickReplyList();
        this.initReference();
    }

    protected void initSendTextView() {
        this.$.id(R.id.dialog_message_send_btn).clicked(v -> this.sendMessage());
        this.$.id(R.id.dialog_message_send_btn).text((CharSequence)"");
        this.$.id(R.id.dialog_message_send_btn).background(ContextCompat.getDrawable((Context)this.contextReference, (int)R.drawable.send_btn));
    }

    protected void initEditText() {
        super.initEditText();
        this.$.id(R.id.dialog_message_send_et).view().postDelayed(() -> {
            if (this.getActivity() == null || this.getActivity().isFinishing()) {
                return;
            }
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (imm == null) {
                return;
            }
            imm.showSoftInput(this.$.id(R.id.dialog_message_send_et).view(), 1);
        }, 100L);
        this.$.id(R.id.dialog_message_send_et).clicked(v -> {
            InputMethodManager imm;
            if (this.chatUsersDialogFragment != null) {
                this.$.id(R.id.dialog_private_chat_users).gone();
                FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
                transaction.remove((Fragment)this.chatUsersDialogFragment);
                if (Build.VERSION.SDK_INT >= 24) {
                    transaction.commitNowAllowingStateLoss();
                } else {
                    transaction.commitAllowingStateLoss();
                }
                this.chatUsersDialogFragment = null;
            } else if (this.emojiFragment != null) {
                this.hideEmojiFragment();
            }
            InputMethodManager inputMethodManager = imm = this.getActivity() == null ? null : (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (imm != null && !imm.isActive()) {
                imm.showSoftInput(this.$.id(R.id.dialog_message_send_et).view(), 1);
            }
        });
        this.maxTextLength = this.presenter.getRouter().liveRoom.getCurrentUser().getType() == LPConstants.LPUserType.Student ? Math.max(1, this.presenter.getRouter().liveRoom.getPartnerConfig().messageStudentSendMax) : 400;
        this.etMsgSend.setFilters(new InputFilter[]{new LengthFilter(this.getContext(), this.maxTextLength), (source, start2, end, dest, dstart, dend) -> {
            if (TextUtils.equals((CharSequence)source, (CharSequence)AT) && this.presenter.getRouter().getPrivateChatUser().getValue() == null && this.presenter.getRouter().getLiveRoom().getChatVM().enableUserAtUser()) {
                this.chooseAtUser();
            }
            return source;
        }});
        this.etMsgSend.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == 4 && this.$.id(R.id.dialog_message_send_btn).view().isEnabled()) {
                this.sendMessage();
            }
            return true;
        });
        this.etMsgSend.setHint((CharSequence)(!TextUtils.isEmpty((CharSequence)this.presenter.getRouter().getLiveRoom().getPartnerConfig().messageTabTitle) ? this.getString(R.string.live_input_chat_1, new Object[]{this.presenter.getRouter().getLiveRoom().getPartnerConfig().messageTabTitle}) : this.getString(R.string.live_input_chat)));
    }

    protected void initEmojiView() {
        this.$.id(R.id.dialog_message_emoji).clicked(v -> this.presenter.chooseEmoji());
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void initReference() {
        View view = this.$.id(R.id.layout_reference).view();
        QueryPlus query = QueryPlus.with((View)view);
        view.setBackground(new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_bg_color)).build());
        view.setOnTouchListener((v, event) -> true);
        query.id(R.id.close_iv).clicked(v -> this.presenter.getRouter().getReferenceModel().setValue(null));
        ((TextView)query.id(R.id.content_tv).view()).setMaxLines(this.presenter.getRouter().isLiveEE() ? 2 : 1);
        ((TextView)query.id(R.id.content_tv).view()).setEllipsize(TextUtils.TruncateAt.END);
        this.presenter.getRouter().getReferenceModel().observe((LifecycleOwner)this, it -> {
            if (it == null || it.getFirst() == null) {
                this.$.id(R.id.dialog_private_chat_btn).enable(true);
                this.$.id(R.id.layout_reference).visibility(8);
            } else {
                this.$.id(R.id.dialog_private_chat_btn).enable(false);
                this.$.id(R.id.layout_reference).visibility(0);
                query.id(R.id.name_tv).text((CharSequence)((LPMessageReferenceModel)it.getFirst()).from.name);
                query.id(R.id.content_tv).text(it.getSecond() == null ? "" : (CharSequence)it.getSecond());
            }
        });
        if (this.presenter.getRouter().getLiveRoom().getChatVM().enableUserAtUser()) {
            this.initAtUser();
        }
    }

    private void initAtUser() {
        this.presenter.getRouter().getAtUser().observe((LifecycleOwner)this, iUserModel -> {
            if (iUserModel != null) {
                LPMessageAtUserModel atUser = new LPMessageAtUserModel(iUserModel.getName(), iUserModel.getNumber());
                ((MsgEditText)this.etMsgSend).addAtSpan(AT, iUserModel.getName() + "\t", atUser);
                this.presenter.getRouter().getAtUser().setValue(null);
            }
        });
        this.presenter.getRouter().getChooseAtUser().observe((LifecycleOwner)this, iUserModel -> {
            if (iUserModel != null) {
                LPMessageAtUserModel atUser = new LPMessageAtUserModel(iUserModel.getName(), iUserModel.getNumber());
                UtilsKt.deleteLastChar((EditText)this.etMsgSend);
                ((MsgEditText)this.etMsgSend).addAtSpan(AT, iUserModel.getName() + "\t", atUser);
                this.presenter.getRouter().getChooseAtUser().setValue(null);
                this.etMsgSend.postDelayed(() -> {
                    if (this.getActivity() == null || this.getActivity().isFinishing()) {
                        return;
                    }
                    InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
                    if (imm != null) {
                        imm.showSoftInput((View)this.etMsgSend, 1);
                    }
                }, 500L);
            }
        });
    }

    private void chooseAtUser() {
        if (this.presenter.getRouter().getLiveRoom().getOnlineUserVM().getPrivateUser().isEmpty()) {
            return;
        }
        ChooseAtUserDialog chooseAtUserDialog = new ChooseAtUserDialog();
        chooseAtUserDialog.show(this.getChildFragmentManager(), "ChooseAtUserDialog");
    }

    private Drawable getInputBG() {
        StateListDrawable rstDrawable = new StateListDrawable();
        if (this.getContext() == null) {
            return rstDrawable;
        }
        rstDrawable.addState(new int[]{16842910}, new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_bg_color)).cornerRadius(this.getContext().getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).strokeColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.base_bg_stroke)).strokeWidth(1).build());
        rstDrawable.addState(new int[]{-16842910}, new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_bg_color)).cornerRadius(this.getContext().getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).strokeColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.base_bg_stroke)).strokeWidth(1).build());
        return rstDrawable;
    }

    public void onResume() {
        super.onResume();
        this.updateChatQuickReplyArea();
    }

    public void setAutoChoosePrivateChatUser(boolean autoChoosePrivateChatUser) {
        this.autoChoosePrivateChatUser = autoChoosePrivateChatUser;
    }

    public void setEnterMessage(String autoEnterMessage) {
        this.autoEnterMessage = autoEnterMessage;
    }

    private void sendMessage() {
        if (this.presenter.isAllForbidden() && !this.presenter.canWisperTeacherInForbidAllMode() && !this.presenter.useSecretMsgSendForbid()) {
            this.showToast(this.getString(R.string.live_forbid_send_message));
            this.dismissAllowingStateLoss();
            return;
        }
        Set<LPMessageAtUserModel> atUserList = ((MsgEditText)this.etMsgSend).getAtUserList();
        LPExpressionModel singleEmoji = this.presenter.getSingleEmoji(this.etMsgSend.getText().toString().trim());
        if (singleEmoji == null) {
            if (this.presenter.isPrivateChat()) {
                this.presenter.sendMessageToUser(((EditText)this.$.id(R.id.dialog_message_send_et).view()).getEditableText().toString());
            } else {
                if (this.presenter.isAllForbidden() && !this.presenter.useSecretMsgSendForbid()) {
                    this.showToast(this.getString(R.string.live_forbid_send_message));
                    this.dismissAllowingStateLoss();
                    return;
                }
                LPMessageReferenceModel referenceModel = null;
                if (this.presenter.getRouter().getReferenceModel().getValue() != null) {
                    referenceModel = (LPMessageReferenceModel)((Pair)this.presenter.getRouter().getReferenceModel().getValue()).getFirst();
                }
                this.presenter.sendMessage(this.etMsgSend.getEditableText().toString(), referenceModel, atUserList);
            }
            this.dismissAllowingStateLoss();
        } else {
            Object tag = this.etMsgSend.getTag();
            if (tag instanceof LPExpressionModel && tag != singleEmoji) {
                LPExpressionModel expressionModel = (LPExpressionModel)tag;
                if (TextUtils.equals((CharSequence)expressionModel.name, (CharSequence)singleEmoji.name) || TextUtils.equals((CharSequence)expressionModel.key, (CharSequence)singleEmoji.key)) {
                    singleEmoji = expressionModel;
                }
            }
            if (this.presenter.isPrivateChat()) {
                this.presenter.sendEmojiToUser("[" + singleEmoji.getKey() + "]");
            } else {
                if (this.presenter.isAllForbidden() && !this.presenter.useSecretMsgSendForbid()) {
                    this.showToast(this.getString(R.string.live_forbid_send_message));
                    this.dismissAllowingStateLoss();
                    return;
                }
                LPMessageReferenceModel referenceModel = null;
                if (this.presenter.getRouter().getReferenceModel().getValue() != null) {
                    referenceModel = (LPMessageReferenceModel)((Pair)this.presenter.getRouter().getReferenceModel().getValue()).getFirst();
                }
                this.presenter.sendEmoji("[" + singleEmoji.getKey() + "]", referenceModel, atUserList);
            }
        }
        this.presenter.getRouter().getReferenceModel().setValue(null);
        this.etMsgSend.setTag(null);
    }

    public void setPresenter(MessageSendContract.Presenter presenter2) {
        super.setBasePresenter((BasePresenter)presenter2);
        this.presenter = presenter2;
    }

    @Override
    public void showPrivateChatChange() {
        if (!this.presenter.isLiveCanWhisper()) {
            return;
        }
        if (this.presenter.isPrivateChat()) {
            ((EditText)this.$.id(R.id.dialog_message_send_et).view()).setHint((CharSequence)(this.getString(R.string.private_chat) + UtilsKt.getEncodePhoneNumber((String)this.presenter.getPrivateChatUser().getName())));
            this.$.id(R.id.dialog_private_chat_btn).view().setSelected(true);
            ((TextView)this.$.id(R.id.dialog_private_chat_btn).view()).setTextColor(this.getResources().getColor(R.color.base_white));
        } else {
            ((EditText)this.$.id(R.id.dialog_message_send_et).view()).setHint((CharSequence)(!TextUtils.isEmpty((CharSequence)this.presenter.getRouter().getLiveRoom().getPartnerConfig().messageTabTitle) ? this.getString(R.string.live_input_chat_1, new Object[]{this.presenter.getRouter().getLiveRoom().getPartnerConfig().messageTabTitle}) : this.getString(R.string.live_input_chat)));
            this.$.id(R.id.dialog_private_chat_btn).view().setSelected(false);
            ((TextView)this.$.id(R.id.dialog_private_chat_btn).view()).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.getContext(), (int)R.attr.base_theme_window_assistant_text_color));
        }
    }

    @Override
    public void showMessageSuccess() {
        this.$.id(R.id.dialog_message_send_et).text((CharSequence)"");
        this.dismissAllowingStateLoss();
    }

    @Override
    public void showPrivateChatUserPanel() {
        if (!this.presenter.isLiveCanWhisper()) {
            return;
        }
        if (this.chatUsersDialogFragment == null && this.emojiFragment == null) {
            InputMethodManager imm;
            InputMethodManager inputMethodManager = imm = this.getActivity() == null ? null : (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (imm != null && imm.isActive()) {
                imm.hideSoftInputFromWindow(this.$.id(R.id.dialog_message_send_et).view().getWindowToken(), 0);
            }
            this.contentView.postDelayed(() -> {
                if (this.$ == null) {
                    return;
                }
                this.$.id(R.id.dialog_private_chat_users).visible();
                this.chatUsersDialogFragment = new ChatUsersDialogFragment();
                if (this.presenter.isPrivateChat()) {
                    this.chatUsersDialogFragment.initPrivateChatLabel(this.presenter.getPrivateChatUser());
                }
                FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
                transaction.add(R.id.dialog_private_chat_users, (Fragment)this.chatUsersDialogFragment);
                if (Build.VERSION.SDK_INT >= 24) {
                    transaction.commitNowAllowingStateLoss();
                } else {
                    transaction.commitAllowingStateLoss();
                }
            }, 100L);
        } else if (this.emojiFragment != null) {
            InputMethodManager imm;
            InputMethodManager inputMethodManager = imm = this.getActivity() == null ? null : (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (imm != null && imm.isActive()) {
                imm.hideSoftInputFromWindow(this.$.id(R.id.dialog_message_send_et).view().getWindowToken(), 0);
            }
            this.hideEmojiFragment();
            this.$.id(R.id.dialog_private_chat_users).visible();
            this.chatUsersDialogFragment = new ChatUsersDialogFragment();
            if (this.presenter.isPrivateChat()) {
                this.chatUsersDialogFragment.initPrivateChatLabel(this.presenter.getPrivateChatUser());
            }
            FragmentTransaction _transaction = this.getChildFragmentManager().beginTransaction();
            _transaction.add(R.id.dialog_private_chat_users, (Fragment)this.chatUsersDialogFragment);
            if (Build.VERSION.SDK_INT >= 24) {
                _transaction.commitNowAllowingStateLoss();
            } else {
                _transaction.commitAllowingStateLoss();
            }
        } else {
            InputMethodManager imm;
            this.$.id(R.id.dialog_private_chat_users).gone();
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.remove((Fragment)this.chatUsersDialogFragment);
            if (Build.VERSION.SDK_INT >= 24) {
                transaction.commitNowAllowingStateLoss();
            } else {
                transaction.commitAllowingStateLoss();
            }
            this.chatUsersDialogFragment = null;
            InputMethodManager inputMethodManager = imm = this.getActivity() == null ? null : (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (imm != null && !imm.isActive()) {
                imm.showSoftInput(this.$.id(R.id.dialog_message_send_et).view(), 1);
            }
        }
    }

    @Override
    public void showEmojiPanel() {
        if (this.emojiFragment == null && this.chatUsersDialogFragment == null) {
            InputMethodManager imm;
            InputMethodManager inputMethodManager = imm = this.getActivity() == null ? null : (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (imm != null && imm.isActive()) {
                imm.hideSoftInputFromWindow(this.$.id(R.id.dialog_message_send_et).view().getWindowToken(), 0);
            }
            this.contentView.postDelayed(() -> ((MessageSendFragment)this).showEmojiFragment(), 100L);
        } else if (this.chatUsersDialogFragment != null) {
            InputMethodManager imm;
            InputMethodManager inputMethodManager = imm = this.getActivity() == null ? null : (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (imm != null && imm.isActive()) {
                imm.hideSoftInputFromWindow(this.$.id(R.id.dialog_message_send_et).view().getWindowToken(), 0);
            }
            this.$.id(R.id.dialog_private_chat_users).gone();
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.remove((Fragment)this.chatUsersDialogFragment);
            if (Build.VERSION.SDK_INT >= 24) {
                transaction.commitNowAllowingStateLoss();
            } else {
                transaction.commitAllowingStateLoss();
            }
            this.chatUsersDialogFragment = null;
            this.showEmojiFragment();
        } else {
            InputMethodManager imm;
            this.$.id(R.id.dialog_message_send_emoji).gone();
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.remove((Fragment)this.emojiFragment);
            if (Build.VERSION.SDK_INT >= 24) {
                transaction.commitNowAllowingStateLoss();
            } else {
                transaction.commitAllowingStateLoss();
            }
            this.emojiFragment = null;
            InputMethodManager inputMethodManager = imm = this.getActivity() == null ? null : (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (imm != null) {
                imm.showSoftInput(this.$.id(R.id.dialog_message_send_et).view(), 1);
            }
        }
    }

    @Override
    public void onPictureSend() {
        this.dismissAllowingStateLoss();
    }

    @Override
    public void setChatQuickReplyList(List<String> chatQuickReplyList) {
        for (String quickReply : chatQuickReplyList) {
            if (this.mChatQuickReplyMap.containsKey(quickReply)) continue;
            this.mChatQuickReplyMap.put(quickReply, 0);
        }
        ArrayList<String> deleteQuickReplyList = new ArrayList<String>();
        for (String quickReply : this.mChatQuickReplyMap.keySet()) {
            if (chatQuickReplyList.contains(quickReply)) continue;
            deleteQuickReplyList.add(quickReply);
        }
        for (String quickReply : deleteQuickReplyList) {
            this.mChatQuickReplyMap.remove(quickReply);
        }
        if (this.mChatQuickReplyMap.isEmpty()) {
            this.$.id(R.id.dialog_quick_reply_sclv).gone();
            this.$.id(R.id.dialog_divider_line).gone();
        } else {
            this.$.id(R.id.dialog_quick_reply_sclv).visible();
            this.$.id(R.id.dialog_divider_line).visible();
            this.updateChatQuickReplyArea();
        }
    }

    private void updateChatQuickReplyArea() {
        if (this.mChatQuickReplyMap.isEmpty()) {
            return;
        }
        ArrayList<Map.Entry<String, Integer>> chatQuickReplyList = new ArrayList<Map.Entry<String, Integer>>(this.mChatQuickReplyMap.entrySet());
        Collections.sort(chatQuickReplyList, (o1, o2) -> ((Integer)o2.getValue()).compareTo((Integer)o1.getValue()));
        ((LinearLayout)this.$.id(R.id.dialog_quick_reply_container).view()).removeAllViews();
        for (Map.Entry entry : chatQuickReplyList) {
            TextView textView = new TextView(this.getContext());
            textView.setMaxLines(1);
            textView.setMaxEms(20);
            textView.setEllipsize(TextUtils.TruncateAt.END);
            textView.setTextColor(Color.parseColor((String)"#FF999999"));
            textView.setText((CharSequence)entry.getKey());
            textView.setBackground(ContextCompat.getDrawable((Context)this.contextReference, (int)R.drawable.bjy_bg_chat_quick_reply));
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(20, 0, 20, 0);
            textView.setPadding(11, 4, 11, 4);
            textView.setOnClickListener(v -> {
                EditText editText = (EditText)this.$.id(R.id.dialog_message_send_et).view();
                editText.post(() -> {
                    editText.setText(textView.getText());
                    editText.setSelection(Math.min(this.maxTextLength, textView.getText().length()));
                });
                int count = this.mChatQuickReplyMap.get(textView.getText()) + 1;
                this.mChatQuickReplyMap.put((String)textView.getText(), count);
            });
            ((LinearLayout)this.$.id(R.id.dialog_quick_reply_container).view()).addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    @Nullable
    public Drawable getKeyboardIcon() {
        return ContextCompat.getDrawable((Context)this.contextReference, (int)R.drawable.live_ic_emotion);
    }

    @Nullable
    public Drawable getEmojiIcon() {
        return ContextCompat.getDrawable((Context)this.contextReference, (int)R.drawable.live_ic_emotion);
    }

    @Nullable
    public List<LPExpressionModel> getEmojiList() {
        return this.presenter.getRouter().liveRoom.getExpressions();
    }

    @NonNull
    public SimpleTextWatcher getTextWatcher() {
        return new SimpleTextWatcher(){

            public void onTextChanged(CharSequence s, int start2, int before, int count) {
                MessageSendFragment.this.$.id(R.id.dialog_message_send_btn).enable(!TextUtils.isEmpty((CharSequence)s));
            }
        };
    }

    public void onDestroy() {
        super.onDestroy();
        this.presenter = null;
        SharedPreferences sharedPreferences = this.getContext().getSharedPreferences(QUICK_REPLY_FILE_NAME, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        for (Map.Entry<String, Integer> quickReply : this.mChatQuickReplyMap.entrySet()) {
            editor.putInt(quickReply.getKey(), quickReply.getValue().intValue());
        }
        editor.apply();
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.chatUsersDialogFragment != null) {
            this.chatUsersDialogFragment = null;
        }
    }
}

