/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.toolbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.bjyutils.widgets.SimpleTextWatcher;
import com.baijiayun.liveuibase.R;
import java.util.HashMap;

public class TextEditFrameLayout {
    private final View view;
    private final EditText editText;
    private String beforeText = "";
    private final TextWatcher textWatcher;

    @SuppressLint(value={"InflateParams"})
    public TextEditFrameLayout(final Context context2, final IOnTextChangeListener onTextChangeListener) {
        this.view = LayoutInflater.from((Context)context2).inflate(R.layout.uibase_text_edit_layout, null);
        this.editText = (EditText)this.view.findViewById(R.id.base_message_send_et);
        LinearLayout send = (LinearLayout)this.view.findViewById(R.id.base_message_send_btn);
        send.setOnClickListener(v -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("beforeText", this.beforeText);
            map.put("afterText", this.editText.getEditableText().toString());
            map.put("end", "true");
            if (onTextChangeListener != null) {
                onTextChangeListener.OnTextChange(map);
            }
            this.setEditText("");
            DisplayUtils.hideKeyboard((View)v);
        });
        this.view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                TextEditFrameLayout.this.editText.setFocusable(true);
                TextEditFrameLayout.this.editText.setFocusableInTouchMode(true);
                TextEditFrameLayout.this.editText.requestFocus();
                TextEditFrameLayout.this.editText.removeTextChangedListener(TextEditFrameLayout.this.textWatcher);
                TextEditFrameLayout.this.editText.setText((CharSequence)TextEditFrameLayout.this.beforeText);
                TextEditFrameLayout.this.editText.setSelection(TextEditFrameLayout.this.editText.getText().length());
                TextEditFrameLayout.this.editText.addTextChangedListener(TextEditFrameLayout.this.textWatcher);
                TextEditFrameLayout.this.editText.setSelection(TextEditFrameLayout.this.editText.getText().length());
                v.postDelayed(() -> {
                    InputMethodManager imm = (InputMethodManager)context2.getSystemService("input_method");
                    if (imm == null) {
                        return;
                    }
                    imm.showSoftInput((View)TextEditFrameLayout.this.editText, 0);
                }, 100L);
            }

            public void onViewDetachedFromWindow(View v) {
                if (context2 == null) {
                    return;
                }
                DisplayUtils.hideKeyboard((View)v);
            }
        });
        this.textWatcher = new SimpleTextWatcher(){

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
                TextEditFrameLayout.this.beforeText = s.toString();
            }

            public void afterTextChanged(Editable s) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("beforeText", TextEditFrameLayout.this.beforeText);
                map.put("afterText", TextEditFrameLayout.this.editText.getEditableText().toString());
                if (onTextChangeListener != null) {
                    onTextChangeListener.OnTextChange(map);
                }
            }
        };
        this.editText.addTextChangedListener(this.textWatcher);
    }

    public void setEditText(String text) {
        if (this.editText.isAttachedToWindow()) {
            this.editText.removeTextChangedListener(this.textWatcher);
            this.editText.setText((CharSequence)text);
            this.editText.setSelection(this.editText.getText().length());
            this.editText.addTextChangedListener(this.textWatcher);
        }
        this.beforeText = text;
    }

    public View getView() {
        return this.view;
    }

    public static interface IOnTextChangeListener {
        public void OnTextChange(HashMap<String, String> var1);
    }
}

