/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.setting;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatSeekBar;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.models.LPBleDevice;
import com.baijiayun.livecore.models.LPMirrorModeModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseTitleWindow;
import com.baijiayun.liveuibase.widgets.SettingSwitch;
import com.baijiayun.liveuibase.widgets.setting.BaseSettingContract;
import com.baijiayun.liveuibase.widgets.setting.BaseSettingPresenter;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseSettingWindow
extends BaseTitleWindow
implements BaseSettingContract.BaseSettingView {
    protected Context context;
    private ClipboardManager clipboardManager;
    protected BaseSettingContract.BaseSettingPresenter presenter;
    private ViewGroup settingContainer;
    private TextView lastSelectedView;
    private LPMirrorModeModel lastMirrorModeModel = new LPMirrorModeModel();
    private final Map<String, AtomicBoolean> clickableWithKey = new ConcurrentHashMap<String, AtomicBoolean>();
    private QueryPlus $navigation;
    protected QueryPlus $camera;
    protected QueryPlus $mic;
    protected QueryPlus $roomControl;
    protected QueryPlus $ppt;
    protected QueryPlus $beauty;
    protected QueryPlus $other;
    private Disposable disposableOfTimer;
    public static float lastBeautyLevel = 0.5f;
    public static float lastWhitenessLevel = 0.5f;
    private MusicModeChangeListener musicModeChangeListener;
    AppCompatImageView beautyIcon;
    AppCompatImageView whitenessIcon;
    AppCompatSeekBar beautySeekbar;
    AppCompatSeekBar whitenessSeekbar;
    protected SettingSwitch beautySwitch;

    public BaseSettingWindow(Context context2) {
        super(context2);
        this.allowTouch = true;
        this.context = context2;
        this.setTitle(this.getString(R.string.bjy_base_setting_title));
        this.initChildData();
        this.initView();
    }

    @Override
    protected void onCreateContentView(Context context2) {
        LayoutInflater.from((Context)context2).inflate(R.layout.uibase_setting_fragment, (ViewGroup)this.clContentContainer);
        this.allowTouch = false;
        this.clipboardManager = (ClipboardManager)context2.getSystemService("clipboard");
        this.presenter = this.initPresenter();
    }

    public void setPresenter(BaseSettingContract.BaseSettingPresenter presenter2) {
        this.presenter = presenter2;
    }

    private void initView() {
        this.settingContainer = (ViewGroup)this.$.id(R.id.fl_setting_container).view();
        ViewGroup navigationContainer = (ViewGroup)this.$.id(R.id.fl_navigation_container).view();
        navigationContainer.removeAllViews();
        this.$navigation = QueryPlus.with((View)LayoutInflater.from((Context)this.context).inflate(R.layout.fragment_setting_navigation, navigationContainer));
        TextView roomIdTv = (TextView)this.$.id(R.id.bjy_base_setting_room_id_textview).view();
        roomIdTv.setText((CharSequence)this.context.getResources().getString(R.string.bjy_base_setting_class_id, new Object[]{this.presenter.getRoomId()}));
        TextView copyRoomIdTv = (TextView)this.$.id(R.id.bjy_base_setting_copy_room_id).view();
        copyRoomIdTv.setOnClickListener(v -> {
            ClipData clipData = ClipData.newPlainText((CharSequence)"roomId", (CharSequence)roomIdTv.getText().toString());
            this.clipboardManager.setPrimaryClip(clipData);
            this.showToastMessage(this.context.getResources().getString(R.string.bjy_base_setting_copy_class_id));
        });
        this.showCameraContainer(this.$navigation.id(R.id.bjy_base_setting_type_camera).view());
        this.lastSelectedView = (TextView)this.$navigation.id(R.id.bjy_base_setting_type_camera).view();
        if (!this.presenter.getPartnerConfig().liveEnableUseHandWritingBoard) {
            this.$navigation.id(R.id.bjy_base_setting_type_other).visibility(8);
        }
        this.$navigation.id(R.id.bjy_base_setting_type_camera).clicked(v -> {
            this.showCameraContainer(v);
            this.lastSelectedView = (TextView)this.$navigation.id(R.id.bjy_base_setting_type_camera).view();
        });
        this.$navigation.id(R.id.bjy_base_setting_type_mic).clicked(v -> {
            this.showMicContainer(v);
            this.lastSelectedView = (TextView)this.$navigation.id(R.id.bjy_base_setting_type_mic).view();
        });
        this.$navigation.id(R.id.bjy_base_setting_type_room_control).clicked(v -> {
            this.showRoomControlContainer(v);
            this.lastSelectedView = (TextView)this.$navigation.id(R.id.bjy_base_setting_type_room_control).view();
        });
        this.$navigation.id(R.id.bjy_base_setting_type_ppt).clicked(v -> {
            this.showPPTContainer(v);
            this.lastSelectedView = (TextView)this.$navigation.id(R.id.bjy_base_setting_type_ppt).view();
        });
        this.$navigation.id(R.id.bjy_base_setting_type_beauty).clicked(v -> {
            this.showBeautyContainer(v);
            this.lastSelectedView = (TextView)this.$navigation.id(R.id.bjy_base_setting_type_beauty).view();
        });
        this.$navigation.id(R.id.bjy_base_setting_type_other).clicked(v -> {
            this.showOtherContainer(v);
            this.lastSelectedView = (TextView)this.$navigation.id(R.id.bjy_base_setting_type_other).view();
        });
        this.updateBeautyVisible();
        LPConstants.LPRoomType roomType = this.presenter.getLiveRoom().getRoomInfo().roomType;
        if (roomType == LPConstants.LPRoomType.NewSmallGroup) {
            this.$navigation.id(R.id.bjy_base_setting_type_mic).visibility(8);
            if (!this.presenter.getLiveRoom().isTeacherOrAssistant() && !this.presenter.getLiveRoom().getPartnerConfig().enableHideOtherStudentVideo) {
                this.$navigation.id(R.id.bjy_base_setting_type_room_control).visibility(8);
            }
        }
    }

    public void setMusicModeChangeListener(MusicModeChangeListener listener2) {
        this.musicModeChangeListener = listener2;
    }

    private void showCameraContainer(View view) {
        ((TextView)this.$navigation.id(R.id.bjy_base_setting_type_camera).view()).setTextColor(-1);
        if (this.lastSelectedView != null && this.lastSelectedView != view) {
            this.lastSelectedView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
            this.lastSelectedView.setSelected(false);
        }
        this.$navigation.id(R.id.bjy_base_setting_type_camera).view().setSelected(true);
        this.settingContainer.removeAllViews();
        this.$camera = QueryPlus.with((View)LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_base_layout_setting_camera, this.settingContainer));
        this.initCameraContainer();
    }

    protected abstract void initCameraContainer();

    private void showMicContainer(View v) {
        ((TextView)this.$navigation.id(R.id.bjy_base_setting_type_mic).view()).setTextColor(-1);
        if (this.lastSelectedView != null && this.lastSelectedView != v) {
            this.lastSelectedView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
            this.lastSelectedView.setSelected(false);
        }
        this.$navigation.id(R.id.bjy_base_setting_type_mic).view().setSelected(true);
        this.settingContainer.removeAllViews();
        this.$mic = QueryPlus.with((View)LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_base_layout_setting_mic, this.settingContainer));
        this.initMicContainer();
    }

    protected abstract void initMicContainer();

    private void showRoomControlContainer(View v) {
        ((TextView)this.$navigation.id(R.id.bjy_base_setting_type_room_control).view()).setTextColor(-1);
        if (this.lastSelectedView != null && this.lastSelectedView != v) {
            this.lastSelectedView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
            this.lastSelectedView.setSelected(false);
        }
        this.$navigation.id(R.id.bjy_base_setting_type_room_control).view().setSelected(true);
        this.settingContainer.removeAllViews();
        this.$roomControl = QueryPlus.with((View)LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_base_layout_setting_room_control, this.settingContainer));
        this.initRoomControlContainer();
    }

    protected abstract void initRoomControlContainer();

    public void hideMirrorMenu() {
        this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_text).visibility(8);
        this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_open).visibility(8);
        this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_close).visibility(8);
        this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_text).visibility(8);
        this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_open).visibility(8);
        this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_close).visibility(8);
    }

    private void showPPTContainer(View v) {
        ((TextView)this.$navigation.id(R.id.bjy_base_setting_type_ppt).view()).setTextColor(-1);
        if (this.lastSelectedView != null && this.lastSelectedView != v) {
            this.lastSelectedView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
            this.lastSelectedView.setSelected(false);
        }
        this.$navigation.id(R.id.bjy_base_setting_type_ppt).view().setSelected(true);
        this.settingContainer.removeAllViews();
        this.$ppt = QueryPlus.with((View)LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_base_layout_setting_ppt, this.settingContainer));
        this.initPPTContainer();
    }

    protected abstract void initPPTContainer();

    private void showBeautyContainer(View v) {
        ((TextView)this.$navigation.id(R.id.bjy_base_setting_type_beauty).view()).setTextColor(-1);
        if (this.lastSelectedView != null && this.lastSelectedView != v) {
            this.lastSelectedView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
            this.lastSelectedView.setSelected(false);
        }
        this.$navigation.id(R.id.bjy_base_setting_type_beauty).view().setSelected(true);
        this.settingContainer.removeAllViews();
        this.$beauty = QueryPlus.with((View)LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_base_layout_setting_beauty, this.settingContainer));
        this.initBeautyContainer();
    }

    protected void initBeautyContainer() {
        this.$beauty.clearRefCache();
        this.beautySwitch = (SettingSwitch)this.$beauty.id(R.id.bjy_base_setting_beauty_switch).view();
        this.beautyIcon = (AppCompatImageView)this.$beauty.id(R.id.bjy_base_setting_beauty_icon).view();
        StateListDrawable beautyDrawable = new StateListDrawableBuilder().normal(AppCompatResources.getDrawable((Context)this.context, (int)R.drawable.bjy_base_vector_beauty_off)).selected(AppCompatResources.getDrawable((Context)this.context, (int)R.drawable.bjy_base_vector_beauty_on)).build();
        this.beautyIcon.setImageDrawable((Drawable)beautyDrawable);
        this.whitenessIcon = (AppCompatImageView)this.$beauty.id(R.id.bjy_base_setting_whiteness_icon).view();
        StateListDrawable whitenessDrawable = new StateListDrawableBuilder().normal(AppCompatResources.getDrawable((Context)this.context, (int)R.drawable.bjy_base_vector_whiteness_off)).selected(AppCompatResources.getDrawable((Context)this.context, (int)R.drawable.bjy_base_vector_whiteness_on)).build();
        this.whitenessIcon.setImageDrawable((Drawable)whitenessDrawable);
        this.beautySeekbar = (AppCompatSeekBar)this.$beauty.id(R.id.bjy_base_setting_beauty_seekbar).view();
        this.beautySeekbar.setThumb(AppCompatResources.getDrawable((Context)this.context, (int)R.drawable.bjy_base_seekbar_thumb));
        this.beautySeekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                BaseSettingWindow.this.presenter.setBeautyLevel((float)seekBar.getProgress() * 1.0f / (float)seekBar.getMax());
                lastBeautyLevel = BaseSettingWindow.this.presenter.getBeautyLevel();
            }
        });
        this.whitenessSeekbar = (AppCompatSeekBar)this.$beauty.id(R.id.bjy_base_setting_whiteness_seekbar).view();
        this.whitenessSeekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                BaseSettingWindow.this.presenter.setWhitenessLevel((float)seekBar.getProgress() * 1.0f / (float)seekBar.getMax());
                lastWhitenessLevel = BaseSettingWindow.this.presenter.getWhitenessLevel();
            }
        });
        if (this.presenter.isVideoAttached()) {
            this.beautySwitch.setEnabled(true);
            if (this.presenter.enableBeauty()) {
                this.beautySwitch.setCheckedStatus(true);
                this.beautySeekbar.setProgress((int)(lastBeautyLevel * 100.0f));
                this.presenter.setBeautyLevel(lastBeautyLevel);
                this.whitenessSeekbar.setProgress((int)(lastWhitenessLevel * 100.0f));
                this.presenter.setWhitenessLevel(lastWhitenessLevel);
                this.updateBeautyStatus(true);
            } else {
                this.beautySwitch.setCheckedStatus(false);
                this.updateBeautyStatus(false);
            }
        } else {
            this.beautySwitch.setCheckedStatus(false);
            this.beautySwitch.setEnabled(false);
            this.updateBeautyStatus(false);
        }
        this.beautySwitch.setOnCheckedChangeListener((buttonView, checkedPosition) -> {
            if (checkedPosition == 0) {
                this.beautySeekbar.setProgress((int)(lastBeautyLevel * 100.0f));
                this.presenter.setBeautyLevel(lastBeautyLevel);
                this.whitenessSeekbar.setProgress((int)(lastWhitenessLevel * 100.0f));
                this.presenter.setWhitenessLevel(lastWhitenessLevel);
            } else {
                this.beautySeekbar.setProgress(0);
                this.whitenessSeekbar.setProgress(0);
                this.presenter.setBeautyLevel(0.0f);
                this.presenter.setWhitenessLevel(0.0f);
            }
            this.updateBeautyStatus(checkedPosition == 0);
            this.setEnableBeauty(checkedPosition == 0);
        });
    }

    private void updateBeautyStatus(boolean enable) {
        this.whitenessIcon.setSelected(enable);
        this.beautyIcon.setSelected(enable);
        this.beautySeekbar.setEnabled(enable);
        this.whitenessSeekbar.setEnabled(enable);
        if (enable) {
            this.beautySeekbar.setThumb(AppCompatResources.getDrawable((Context)this.context, (int)R.drawable.bjy_base_seekbar_thumb));
            this.whitenessSeekbar.setThumb(AppCompatResources.getDrawable((Context)this.context, (int)R.drawable.bjy_base_seekbar_thumb));
        } else {
            this.beautySeekbar.setThumb((Drawable)new ColorDrawable(0));
            this.whitenessSeekbar.setThumb((Drawable)new ColorDrawable(0));
        }
    }

    private void showOtherContainer(View v) {
        ((TextView)this.$navigation.id(R.id.bjy_base_setting_type_other).view()).setTextColor(-1);
        this.lastSelectedView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
        this.lastSelectedView.setSelected(false);
        this.$navigation.id(R.id.bjy_base_setting_type_other).view().setSelected(true);
        this.settingContainer.removeAllViews();
        this.$other = QueryPlus.with((View)LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_base_layout_setting_other, this.settingContainer));
        this.initOtherContainer();
    }

    protected void initOtherContainer() {
        this.$other.clearRefCache();
        if (this.presenter.getPartnerConfig().liveEnableUseHandWritingBoard) {
            this.setWritingBoardVisible(0);
            List<LPBleDevice> bleDeviceList = this.presenter.getRecentBleDevices();
            if (!bleDeviceList.isEmpty()) {
                this.$other.id(R.id.bjy_base_setting_connected_device_tv).text((CharSequence)bleDeviceList.get((int)0).name);
                if (this.presenter.getConnectedDevice() == null) {
                    this.$other.id(R.id.bjy_base_setting_connected_device_tv).textColor(R.color.base_live_bluetooth_gray);
                    this.$other.id(R.id.bjy_base_setting_connected_checkbox).visibility(8);
                } else {
                    this.$other.id(R.id.bjy_base_setting_connected_device_tv).setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_main_text_color));
                    this.$other.id(R.id.bjy_base_setting_connected_checkbox).visibility(0);
                }
            } else {
                this.$other.id(R.id.bjy_base_setting_connected_device_tv).visibility(8);
                this.$other.id(R.id.bjy_base_setting_connected_checkbox).visibility(8);
            }
            this.$other.id(R.id.bjy_base_setting_connect_tv).view().setSelected(true);
            this.$other.id(R.id.bjy_base_setting_connect_tv).enable(true);
            this.$other.id(R.id.bjy_base_setting_connect_tv).clicked(v -> this.presenter.showBleDialog());
        } else {
            this.setWritingBoardVisible(8);
        }
        this.$other.id(R.id.bjy_base_setting_music_mode_switch).enable(this.presenter.isClassStart());
        this.setMusicModeVisible(0);
        this.$other.id(R.id.bjy_base_setting_music_mode_debug_tv).visibility(8);
        ((SettingSwitch)this.$other.id(R.id.bjy_base_setting_music_mode_switch).view()).setCheckedStatus(this.presenter.isMusicModeOn());
        ((SettingSwitch)this.$other.id(R.id.bjy_base_setting_music_mode_switch).view()).setOnCheckedChangeListener((buttonView, checkedPosition) -> {
            if (this.presenter.isMusicModeOn() && checkedPosition == 0) {
                return;
            }
            if (!this.presenter.isMusicModeOn() && checkedPosition == 1) {
                return;
            }
            if (this.checkClickable(this.context.getString(R.string.bjy_base_frequent_music_mode))) {
                this.presenter.changeMusicMode(!this.presenter.isMusicModeOn());
                this.musicModeChangeListener.onMusicModeChange(this.presenter.isMusicModeOn());
            } else {
                ((SettingSwitch)this.$other.id(R.id.bjy_base_setting_music_mode_switch).view()).setCheckedStatus(this.presenter.isMusicModeOn(), false);
            }
        });
    }

    private void setWritingBoardVisible(int curVisible) {
        this.$other.id(R.id.bjy_base_setting_bluetooth_text).visibility(curVisible);
        this.$other.id(R.id.bjy_base_setting_connected_device_tv).visibility(curVisible);
        this.$other.id(R.id.bjy_base_setting_connected_checkbox).visibility(curVisible);
        this.$other.id(R.id.bjy_base_setting_connect_tv).visibility(curVisible);
    }

    private void setMusicModeVisible(int curVisible) {
        this.$other.id(R.id.bjy_base_setting_music_mode_text).visibility(curVisible);
        this.$other.id(R.id.bjy_base_setting_music_mode_debug_tv).visibility(curVisible);
        this.$other.id(R.id.bjy_base_setting_music_mode_switch).visibility(curVisible);
    }

    private void updateBeautyVisible() {
        boolean isSupportBeauty;
        boolean bl = isSupportBeauty = this.presenter.getWebrtcType() >= 3;
        if (isSupportBeauty) {
            this.$navigation.id(R.id.bjy_base_setting_type_beauty).visible();
        } else {
            this.$navigation.id(R.id.bjy_base_setting_type_beauty).gone();
        }
    }

    @Override
    public void setEnableBeauty(boolean isEnable) {
        this.presenter.getLiveRoom().getPartnerConfig().enableBeauty = isEnable;
    }

    @Override
    public void setWhichCameraEnable(boolean isEnable) {
        this.$camera.id(R.id.bjy_base_setting_camera_orientation_switch).enable(isEnable);
    }

    @Override
    public void onMirrorModeChange(LPMirrorModeModel mirrorModeModel, Set<String> horizontalSet, Set<String> verticalSet) {
        if (mirrorModeModel != null && mirrorModeModel.isToAll) {
            if (mirrorModeModel.horizonMirrorMode == 1) {
                this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_open).enable(false);
                this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_open).setSelected(true);
                this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_close).enable(true);
                this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_close).setSelected(false);
            } else {
                this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_close).enable(false);
                this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_close).setSelected(true);
                this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_open).enable(true);
                this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_open).setSelected(false);
            }
            if (mirrorModeModel.verticalMirrorMode == 1) {
                this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_open).enable(false);
                this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_open).setSelected(true);
                this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_close).enable(true);
                this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_close).setSelected(false);
            } else {
                this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_close).enable(false);
                this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_close).setSelected(true);
                this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_open).enable(true);
                this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_open).setSelected(false);
            }
        } else {
            if (mirrorModeModel == null) {
                this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_open).enable(true);
                this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_open).setSelected(false);
                this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_open).enable(true);
                this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_open).setSelected(false);
            } else {
                if (mirrorModeModel.horizonMirrorMode == this.lastMirrorModeModel.horizonMirrorMode) {
                    this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_open).enable(true);
                }
                if (mirrorModeModel.verticalMirrorMode == this.lastMirrorModeModel.verticalMirrorMode) {
                    this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_open).enable(true);
                }
            }
            this.$roomControl.id(R.id.bjy_base_setting_all_horizontal_mirror_close).enable(!horizontalSet.isEmpty());
            this.$roomControl.id(R.id.bjy_base_setting_all_vertical_mirror_close).enable(!verticalSet.isEmpty());
        }
        if (mirrorModeModel != null) {
            this.lastMirrorModeModel = mirrorModeModel;
        }
    }

    protected boolean checkClickable(String error) {
        AtomicBoolean clickable;
        if (!this.clickableWithKey.containsKey(error)) {
            this.clickableWithKey.put(error, new AtomicBoolean(true));
        }
        if ((clickable = this.clickableWithKey.get(error)) != null && clickable.get()) {
            clickable.set(false);
            this.disposableOfTimer = Observable.timer((long)2L, (TimeUnit)TimeUnit.SECONDS).subscribe(aLong -> {
                clickable.set(true);
                RxUtils.dispose((Disposable)this.disposableOfTimer);
            });
            return true;
        }
        this.showToastMessage(error);
        return false;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.disposableOfTimer);
        this.clickableWithKey.clear();
    }

    protected abstract BaseSettingPresenter initPresenter();

    protected abstract void initChildData();

    public static interface MusicModeChangeListener {
        public void onMusicModeChange(boolean var1);
    }
}

