/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.setting;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPLoginModel;
import com.baijiayun.livecore.models.launch.LPEnterRoomNative;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.utils.ToastUtil;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Unit;

public abstract class BaseSettingFragment
extends Fragment {
    protected View view;
    protected QueryPlus $;
    protected RouterViewModel routerViewModel;
    private final Map<String, AtomicBoolean> clickableWithKey = new ConcurrentHashMap<String, AtomicBoolean>();
    private Disposable disposableOfTimer;
    protected List<LPLoginModel.LPNetworkCDN> cdnList;
    protected boolean isPortrait;

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container2, Bundle savedInstanceState) {
        int res = this.getLayoutId();
        if (res != 0) {
            this.view = inflater.inflate(res, container2, false);
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            layoutParams.width = -1;
            layoutParams.height = -2;
            this.view.setLayoutParams(layoutParams);
        } else {
            this.view = this.getContentView();
        }
        this.$ = QueryPlus.with((View)this.view);
        this.init(savedInstanceState);
        return this.view;
    }

    public abstract int getLayoutId();

    protected abstract void dispose();

    protected void init(Bundle savedInstanceState) {
        this.isPortrait = DisplayUtils.isPortrait((Context)this.requireContext());
    }

    protected View getContentView() {
        return null;
    }

    public void setRouterViewModel(RouterViewModel routerViewModel2) {
        this.routerViewModel = routerViewModel2;
        this.cdnList = routerViewModel2.liveRoom.getPlayer().getCDNListOfMixStream();
    }

    public LPEnterRoomNative.LPPartnerConfig getPartnerConfig() {
        return this.routerViewModel.getLiveRoom().getPartnerConfig();
    }

    public boolean isStudentSpeakApply() {
        int status = this.routerViewModel.getSpeakApplyStatusValue();
        return status == 2;
    }

    public int getWebrtcType() {
        return this.routerViewModel.getLiveRoom().getRoomInfo().webRTCType;
    }

    protected boolean isClassStart() {
        return this.routerViewModel.getLiveRoom().isClassStarted();
    }

    protected boolean isReplaceCamera() {
        return this.routerViewModel.getLiveRoom().getSpeakQueueVM().isReplacedUser();
    }

    protected void showBleDialog() {
        this.routerViewModel.getActionShowBleDialog().setValue((Object)Unit.INSTANCE);
    }

    protected void setRemarksEnable(boolean isEnable) {
        this.routerViewModel.getRemarkEnable().setValue((Object)isEnable);
    }

    protected void switchForbidAllAudio(boolean isForbid) {
        this.routerViewModel.getLiveRoom().requestForbidAllAudio(isForbid);
    }

    protected boolean switchForbidStatus() {
        if (!this.canSwitchForbid()) {
            this.showSwitchForbid();
            return false;
        }
        this.routerViewModel.getLiveRoom().getChatVM().requestForbidAllChat(!this.routerViewModel.getLiveRoom().getChatVM().isChatForbidden());
        return true;
    }

    private boolean canSwitchForbid() {
        LiveRoom liveRoom2 = this.routerViewModel.getLiveRoom();
        return liveRoom2.getCurrentUser().getType() != LPConstants.LPUserType.Assistant || liveRoom2.getAdminAuth() == null || liveRoom2.getAdminAuth().forbidAndKick;
    }

    protected void showSwitchForbid() {
        this.showToastMessage(this.getString(R.string.bjy_base_room_forbid_and_kick_permission_forbid));
    }

    protected void switchForbidRaiseHand() {
        this.routerViewModel.getLiveRoom().requestForbidRaiseHand(!this.routerViewModel.getLiveRoom().getForbidRaiseHandStatus());
    }

    public void setBeautyLevel(float beautyLevel) {
        this.routerViewModel.getLiveRoom().getRecorder().setBeautyLevel(beautyLevel);
    }

    public float getBeautyLevel() {
        return this.routerViewModel.getLiveRoom().getRecorder().getBeautyLevel();
    }

    public void setWhitenessLevel(float whitenessLevel) {
        this.routerViewModel.getLiveRoom().getRecorder().setWhitenessLevel(whitenessLevel);
    }

    public float getWhitenessLevel() {
        return this.routerViewModel.getLiveRoom().getRecorder().getWhitenessLevel();
    }

    public boolean isVideoAttached() {
        return this.routerViewModel.getLiveRoom().getRecorder().isVideoAttached();
    }

    public boolean isTeacherOrAssistant() {
        return this.routerViewModel.getLiveRoom().isTeacherOrAssistant() || this.routerViewModel.getLiveRoom().isGroupTeacherOrAssistant();
    }

    public boolean isGroup() {
        return this.routerViewModel.getLiveRoom().getCurrentUser().getGroup() != 0;
    }

    public void switchChangePPTEnable(int checkedPosition) {
        if (this.routerViewModel.getLiveRoom().hasH5PPTAuth() && checkedPosition == 1) {
            this.onChangePPTForbidFailed();
            this.routerViewModel.getLiveRoom().requestH5PPTAuth(false);
        }
        this.routerViewModel.getLiveRoom().requestForbidStudentSwitchPPT(checkedPosition == 1);
    }

    public void onChangePPTForbidFailed() {
        this.showToastMessage(this.getString(R.string.bjy_base_cant_change_ppt_fail_tip));
    }

    public void switchAllHorizonMirrorMode(boolean isHorizonMirror) {
        this.routerViewModel.getLiveRoom().getSpeakQueueVM().requestMirrorModeAllSwitch(isHorizonMirror, this.routerViewModel.getLiveRoom().getSpeakQueueVM().getVerticalMirrorModeSet().contains(this.routerViewModel.getLiveRoom().getCurrentUser().getNumber()));
    }

    public void switchAllVerticalMirrorMode(boolean isVerticalMirror) {
        this.routerViewModel.getLiveRoom().getSpeakQueueVM().requestMirrorModeAllSwitch(this.routerViewModel.getLiveRoom().getSpeakQueueVM().getHorizontalMirrorModeSet().contains(this.routerViewModel.getLiveRoom().getCurrentUser().getNumber()), isVerticalMirror);
    }

    public boolean isAudioAttached() {
        return this.routerViewModel.getLiveRoom().getRecorder().isAudioAttached();
    }

    public int getSpeakApplyStatus() {
        return 0;
    }

    public boolean getForbidRaiseHandStatus() {
        return this.routerViewModel.getLiveRoom().getForbidRaiseHandStatus();
    }

    public boolean getForbidAllAudioStatus() {
        return this.routerViewModel.getLiveRoom().getForbidAllAudioStatus();
    }

    public boolean getForbidStatus() {
        return this.routerViewModel.getLiveRoom().getChatVM().isChatForbidden();
    }

    public boolean getStudentSwitchPPTState() {
        return this.routerViewModel.getLiveRoom().getStudentSwitchPPTState();
    }

    public Set<String> getHorizontalMirrorModeSet() {
        return this.routerViewModel.getLiveRoom().getSpeakQueueVM().getHorizontalMirrorModeSet();
    }

    public Set<String> getVerticalMirrorModeSet() {
        return this.routerViewModel.getLiveRoom().getSpeakQueueVM().getVerticalMirrorModeSet();
    }

    public LPConstants.LPResolutionType getVideoDefinition() {
        return this.routerViewModel.getLiveRoom().getRecorder().getVideoDefinition();
    }

    public LPError setCaptureVideoDefinition(LPConstants.LPResolutionType resolutionType) {
        return this.routerViewModel.getLiveRoom().getRecorder().setCaptureVideoDefinition(resolutionType);
    }

    public LPConstants.TemplateType getTemplateType() {
        return this.routerViewModel.getLiveRoom().getTemplateType();
    }

    public LPConstants.LPRoomType getRoomType() {
        return this.routerViewModel.getLiveRoom().getRoomInfo().roomType;
    }

    public boolean lastEnableBeauty() {
        return this.routerViewModel.getLiveRoom().getPartnerConfig().enableBeauty;
    }

    public void setEnableBeauty(boolean isEnableBeauty) {
        this.routerViewModel.getLiveRoom().getPartnerConfig().enableBeauty = isEnableBeauty;
    }

    public boolean isMusicModeOn() {
        return this.routerViewModel.getLiveRoom().getRecorder().isMusicModeOn();
    }

    public void changeMusicMode(boolean isOpen) {
        this.routerViewModel.getLiveRoom().getRecorder().changeMusicModeOn(isOpen);
    }

    protected boolean checkClickable(String error) {
        AtomicBoolean clickable;
        if (!this.clickableWithKey.containsKey(error)) {
            this.clickableWithKey.put(error, new AtomicBoolean(true));
        }
        if ((clickable = this.clickableWithKey.get(error)) != null && clickable.get()) {
            clickable.set(false);
            this.disposableOfTimer = Observable.timer((long)2L, (TimeUnit)TimeUnit.SECONDS).subscribe(aLong -> {
                clickable.set(true);
                RxUtils.dispose((Disposable)this.disposableOfTimer);
            });
            return true;
        }
        this.showToastMessage(error);
        return false;
    }

    protected void showToastMessage(String msg) {
        if (this.view != null && this.view.getContext() != null) {
            new ToastUtil(this.view.getContext()).setText(msg).show();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    protected void showToast(String msg) {
        if (this.getActivity() == null || this.getActivity().isDestroyed()) {
            return;
        }
        ToastCompat.showToastCenter((Context)this.getContext(), (CharSequence)msg, (int)0);
    }

    public void onDestroy() {
        super.onDestroy();
        RxUtils.dispose((Disposable)this.disposableOfTimer);
        this.clickableWithKey.clear();
        this.dispose();
        this.$ = null;
    }
}

