/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.popupwindow;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.utils.ShadowUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseAutoArrangePopupWindow
extends PopupWindow
implements LifecycleObserver {
    protected static final int COMMON_CUSTOM_ITEM_SIZE = 32;
    protected static final int COMMON_CUSTOM_COLORS_ITEM_SIZE = 24;
    protected static final int CENTER_ZERO = 0;
    public static final int LEFT_TOP = 1;
    public static final int RIGHT_TOP = 2;
    public static final int LEFT_BOTTOM = -1;
    public static final int RIGHT_BOTTOM = -2;
    protected static final int HORIZONTAL = 1;
    protected static final int VERTICAL = 2;
    protected static final int SINGLE = 1;
    protected static final int MULTIPLE = 2;
    protected static final int GROUP_SINGLE = 3;
    private int directionMode = 2;
    private int selectMode = 1;
    protected HashMap<Integer, GroupViewData> viewDataHashMap;
    private int marginToAnchor = 0;
    private int lastShowDirection = 0;
    private int[] contentPadding;
    private boolean showShadow = true;
    private int lineTopMargin = -1;
    private ResSet[] resSets;
    protected Context context;
    private View[] items;
    private Map<String, View> viewDots = new HashMap<String, View>();
    private int[] lastChecked;
    protected BaseAutoArrangePopupWindow mChild = null;
    protected BaseAutoArrangePopupWindow mParent = null;
    protected RelativeLayout shadowContainer = null;
    private Lifecycle lifecycle;
    private boolean isDefaultView = true;
    private boolean hasColors = false;
    public static final int[] colorIds = new int[]{R.color.base_toolbar_orange_1, R.color.base_toolbar_orange_2, R.color.base_toolbar_yellow, R.color.base_toolbar_red, R.color.base_toolbar_blue, R.color.base_toolbar_blue_2, R.color.base_toolbar_blue_3, R.color.base_toolbar_pink, R.color.base_toolbar_brown, R.color.base_toolbar_green_1, R.color.base_toolbar_green_2, R.color.base_toolbar_purple, R.color.base_toolbar_white, R.color.base_toolbar_gray_1, R.color.base_toolbar_gray_2, R.color.base_toolbar_black};
    private int autoMeasureDefaultDirection = 0;
    boolean isFirstShow = true;
    private int customOffsetX = 0;
    private int customOffsetY = 0;
    private int[] myOffset;
    private View rootAnchor;
    private WeakReference<View> limitView;
    private long lastDismissTime = -1L;

    public BaseAutoArrangePopupWindow(Context context2) {
        super(context2);
        this.context = context2;
        this.viewDataHashMap = new HashMap();
        this.viewDataHashMap.put(-1, new GroupViewData(context2, 166, 66, 50, 50, 3));
        this.contentPadding = new int[4];
        Arrays.fill(this.contentPadding, 0);
        if (context2 instanceof AppCompatActivity) {
            this.lifecycle = ((AppCompatActivity)context2).getLifecycle();
            this.lifecycle.addObserver((LifecycleObserver)this);
        }
    }

    public BaseAutoArrangePopupWindow(Context context2, @NonNull Lifecycle lifecycle) {
        super(context2);
        this.context = context2;
        this.viewDataHashMap = new HashMap();
        this.viewDataHashMap.put(-1, new GroupViewData(context2, 166, 66, 50, 50, 3));
        this.contentPadding = new int[4];
        Arrays.fill(this.contentPadding, 0);
        this.lifecycle = lifecycle;
        lifecycle.addObserver((LifecycleObserver)this);
    }

    protected void createView() {
        if (this.resSets == null || this.resSets.length == 0) {
            return;
        }
        if (this.selectMode == 1 || this.lastChecked == null) {
            this.lastChecked = new int[]{-1};
        }
        this.initViewDataHashMap();
        ScrollView scrollView = new ScrollView(this.context);
        LinearLayout contentView = new LinearLayout(this.context);
        int maxLineWidth = 0;
        for (GroupViewData viewData : this.viewDataHashMap.values()) {
            maxLineWidth = Math.max(viewData.lineWidth, maxLineWidth);
        }
        ConstraintLayout.LayoutParams contentParams = new ConstraintLayout.LayoutParams(maxLineWidth + this.contentPadding[0] + this.contentPadding[2], -2);
        contentView.setOrientation(1);
        contentView.setLayoutParams((ViewGroup.LayoutParams)contentParams);
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_brand_container_color));
        drawable2.setCornerRadius((float)this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
        contentView.setBackground((Drawable)drawable2);
        contentView.setPadding(this.contentPadding[0], this.contentPadding[1], this.contentPadding[2], this.contentPadding[3]);
        scrollView.addView((View)contentView);
        this.createView((View)scrollView, true);
    }

    protected void createView(View contentView, boolean isDefaultView) {
        if (this.showShadow) {
            ConstraintLayout rootView2 = new ConstraintLayout(this.context);
            ConstraintLayout.LayoutParams rootParams = new ConstraintLayout.LayoutParams(-2, -2);
            rootView2.setLayoutParams((ViewGroup.LayoutParams)rootParams);
            if (contentView.getId() == -1) {
                contentView.setId(View.generateViewId());
            }
            this.shadowContainer = new RelativeLayout(this.context);
            rootView2.setPadding(UtilsKt.getDp((int)8), UtilsKt.getDp((int)8), UtilsKt.getDp((int)8), UtilsKt.getDp((int)8));
            rootView2.addView(contentView);
            rootView2.addView((View)this.shadowContainer);
            ConstraintLayout.LayoutParams shadowParams = new ConstraintLayout.LayoutParams(0, 0);
            shadowParams.startToStart = contentView.getId();
            shadowParams.endToEnd = contentView.getId();
            shadowParams.topToTop = contentView.getId();
            shadowParams.bottomToBottom = contentView.getId();
            this.shadowContainer.setLayoutParams((ViewGroup.LayoutParams)shadowParams);
            ShadowUtil.setViewBoundShadow((View)this.shadowContainer);
            this.setContentView((View)rootView2);
        } else {
            this.setContentView(contentView);
        }
        this.setWidth(-2);
        this.setHeight(-2);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setFocusable(false);
        this.setOutsideTouchable(true);
        this.setTouchable(true);
        if (isDefaultView) {
            this.generateView((LinearLayout)((ViewGroup)contentView).getChildAt(0));
        }
        this.isDefaultView = isDefaultView;
        this.initTouchListener();
    }

    protected void generateView(LinearLayout contentView) {
        ConstraintLayout nowLine = null;
        int lastGroupId = this.resSets[0].checkValue;
        int nowLineMaxNum = this.getNowItemData((int)0).maxNumInPerLine;
        for (int i = 0; i < this.resSets.length; ++i) {
            TextView textView;
            View tmpGenView;
            if (!this.resSets[i].isEnable) continue;
            if (nowLine == null || nowLine.getChildCount() % nowLineMaxNum == 0 || lastGroupId != this.resSets[i].checkValue && nowLine.getChildCount() != 0) {
                this.generateHolders(nowLine, i - 1);
                if (nowLine != null) {
                    contentView.addView(nowLine);
                }
                if (lastGroupId != this.resSets[i].checkValue) {
                    View divideLine = new View(this.context);
                    LinearLayout.LayoutParams divideParams = new LinearLayout.LayoutParams(-1, UtilsKt.getDp((int)1));
                    divideParams.setMarginStart(UtilsKt.getDp((int)10));
                    divideParams.setMarginEnd(UtilsKt.getDp((int)10));
                    divideLine.setLayoutParams((ViewGroup.LayoutParams)divideParams);
                    divideLine.setBackgroundColor(this.getColor(R.color.base_divider_line_other));
                    contentView.addView(divideLine);
                    lastGroupId = this.resSets[i].checkValue;
                    nowLineMaxNum = this.getNowItemData((int)i).maxNumInPerLine;
                }
                nowLine = new ConstraintLayout(this.context);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.getNowItemData((int)i).lineWidth, this.getNowItemData((int)i).lineHeight);
                params.gravity = 1;
                if (this.lineTopMargin > 0) {
                    params.topMargin = this.lineTopMargin;
                }
                nowLine.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            if (!((tmpGenView = this.generateLineItem(nowLine, i, false)) instanceof ConstraintLayout)) continue;
            ConstraintLayout item = (ConstraintLayout)tmpGenView;
            int itemSize = this.getNowItemData((int)i).itemWidth;
            ConstraintLayout.LayoutParams layoutParams = new ConstraintLayout.LayoutParams(itemSize, itemSize);
            layoutParams.startToStart = 0;
            layoutParams.endToEnd = 0;
            layoutParams.topToTop = 0;
            if (this.resSets[i].displayMode == 1) {
                ImageView imageView = new ImageView(this.context);
                imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                imageView.setImageDrawable(this.resSets[i].drawableNormal);
                imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                item.addView((View)imageView);
                imageView.setId(View.generateViewId());
                this.items[i] = imageView;
            } else {
                textView = new TextView(this.context);
                textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                textView.setGravity(17);
                textView.setTextAlignment(4);
                textView.setTextSize(0, (float)(this.getNowItemData((int)i).itemWidth >> 1));
                textView.setTypeface(Typeface.DEFAULT_BOLD);
                textView.setText((CharSequence)this.resSets[i].descriptionText);
                textView.setTextColor(this.resSets[i].textColor);
                item.addView((View)textView);
                textView.setId(View.generateViewId());
                this.items[i] = textView;
            }
            if (this.resSets[i].drawableDot != null) {
                View view = new View(this.context);
                view.setBackground(this.resSets[i].drawableDot);
                int size = UtilsKt.getDp((int)8);
                ConstraintLayout.LayoutParams dotParams = new ConstraintLayout.LayoutParams(size, size);
                dotParams.circleConstraint = this.items[i].getId();
                dotParams.circleAngle = 45.0f;
                dotParams.circleRadius = itemSize / 2;
                item.addView(view, (ViewGroup.LayoutParams)dotParams);
                view.setVisibility(this.resSets[i].isShowDot ? 0 : 8);
                this.viewDots.put(this.resSets[i].descriptionText, view);
            }
            if (!TextUtils.isEmpty((CharSequence)this.resSets[i].descriptionText) && this.resSets[i].displayMode == 1) {
                textView = new TextView(this.context);
                ConstraintLayout.LayoutParams tvParams = new ConstraintLayout.LayoutParams(-2, -2);
                tvParams.startToStart = 0;
                tvParams.endToEnd = 0;
                tvParams.topToBottom = this.items[i].getId();
                tvParams.topMargin = UtilsKt.getDp((int)2);
                textView.setLayoutParams((ViewGroup.LayoutParams)tvParams);
                textView.setText((CharSequence)this.resSets[i].descriptionText);
                textView.setTextColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_bottom_menu_text_color));
                textView.setTextSize(12.0f);
                textView.setTextAlignment(4);
                textView.setSingleLine(true);
                textView.setEllipsize(TextUtils.TruncateAt.END);
                item.addView((View)textView);
            }
            int finalI = i;
            item.setOnClickListener(v -> this.updateUIOfIndex(finalI, v));
        }
        if (nowLine != null) {
            this.generateHolders(nowLine, this.resSets.length - 1);
            contentView.addView(nowLine);
        }
    }

    public void setDotsVisibility(String key, boolean visible) {
        View view = this.viewDots.get(key);
        if (view != null) {
            view.setVisibility(visible ? 0 : 8);
        }
    }

    private void generateHolders(ConstraintLayout nowLine, int nowResIndex) {
        if (this.checkIndexValueInvalid(nowResIndex) || nowLine == null) {
            return;
        }
        int maxNum = this.getNowItemData((int)nowResIndex).maxNumInPerLine;
        int i = nowLine.getChildCount();
        while (i < maxNum) {
            View holderView = this.generateLineItem(nowLine, nowResIndex, true);
            if (holderView == null) continue;
            holderView.setVisibility(4);
            i = nowLine.getChildCount();
        }
    }

    private View generateLineItem(ConstraintLayout nowLine, int nowResIndex, boolean generateHolder) {
        if (nowLine == null || this.context == null) {
            return null;
        }
        View nowLineLastView = nowLine.getChildAt(nowLine.getChildCount() - 1);
        ConstraintLayout.LayoutParams itemParams = new ConstraintLayout.LayoutParams(this.getNowItemData((int)nowResIndex).itemWidth, this.getNowItemData((int)nowResIndex).itemHeight);
        itemParams.topToTop = 0;
        itemParams.bottomToBottom = 0;
        if (nowLineLastView == null) {
            itemParams.startToStart = 0;
        } else {
            itemParams.startToEnd = nowLineLastView.getId();
        }
        itemParams.endToEnd = 0;
        Object view = generateHolder ? new View(this.context) : new ConstraintLayout(this.context);
        view.setLayoutParams((ViewGroup.LayoutParams)itemParams);
        view.setId(View.generateViewId());
        if (nowLineLastView != null) {
            ConstraintLayout.LayoutParams lastItemParams = (ConstraintLayout.LayoutParams)nowLineLastView.getLayoutParams();
            lastItemParams.endToEnd = -1;
            lastItemParams.endToStart = view.getId();
            nowLineLastView.setLayoutParams((ViewGroup.LayoutParams)lastItemParams);
        }
        nowLine.addView(view);
        return view;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void initTouchListener() {
        this.setTouchInterceptor((v, event) -> {
            if (event.getAction() == 4 && this.mParent == null) {
                this.dismiss();
            }
            return false;
        });
    }

    private GroupViewData getNowItemData(int index) {
        return this.viewDataHashMap.get(this.resSets[index].checkValue);
    }

    private void updateUIOfIndex(int index, View view) {
        this.updateUIOfIndex(index, view, true);
    }

    private void updateUIOfIndex(int index, View view, boolean callClick) {
        if (this.checkIndexValueInvalid(index)) {
            return;
        }
        if (this.resSets[index].displayMode == 1) {
            ImageView imageView = (ImageView)this.items[index];
            if (this.selectMode == 1) {
                if (this.lastChecked[0] > -1) {
                    ((ImageView)this.items[this.lastChecked[0]]).setImageDrawable(this.resSets[this.lastChecked[0]].drawableNormal);
                    this.items[this.lastChecked[0]].setSelected(false);
                }
                if (this.resSets[index].drawableChecked != null) {
                    imageView.setImageDrawable(this.resSets[index].drawableChecked);
                }
                imageView.setSelected(true);
                this.lastChecked[0] = index;
            } else if (this.selectMode == 2) {
                if (this.resSets[index].checkValue != 1) {
                    imageView.setImageDrawable(this.resSets[index].drawableChecked);
                    this.resSets[index].checkValue = 1;
                } else {
                    imageView.setImageDrawable(this.resSets[index].drawableNormal);
                    this.resSets[index].checkValue = 0;
                }
            } else if (this.selectMode == 3) {
                for (int groupInd = 0; groupInd < this.lastChecked.length; ++groupInd) {
                    int lastCheckedInd = this.lastChecked[groupInd];
                    if (lastCheckedInd == -1) {
                        this.lastChecked[groupInd] = index;
                        break;
                    }
                    if (this.resSets[lastCheckedInd].checkValue != this.resSets[index].checkValue) continue;
                    ((ImageView)this.items[lastCheckedInd]).setImageDrawable(this.resSets[lastCheckedInd].drawableNormal);
                    this.lastChecked[groupInd] = index;
                    break;
                }
                if (this.resSets[index].drawableChecked != null) {
                    imageView.setImageDrawable(this.resSets[index].drawableChecked);
                }
            }
        }
        if (callClick) {
            this.resSets[index].onClickListener.onClick(view);
        }
    }

    protected void setContentPadding(int left, int top, int right, int bottom) {
        if (this.contentPadding == null) {
            this.contentPadding = new int[4];
        }
        this.contentPadding[0] = left;
        this.contentPadding[1] = top;
        this.contentPadding[2] = right;
        this.contentPadding[3] = bottom;
    }

    protected void setLineTopMargin(int topMargin) {
        this.lineTopMargin = topMargin;
    }

    protected void setResSets(ResSet[] resSets) {
        if (resSets == null) {
            return;
        }
        this.items = new View[resSets.length];
        this.resSets = resSets;
        ArrayList<Integer> groupList = new ArrayList<Integer>();
        for (ResSet resSet : resSets) {
            if (groupList.contains(resSet.checkValue)) continue;
            groupList.add(resSet.checkValue);
        }
        this.lastChecked = new int[groupList.size()];
        Arrays.fill(this.lastChecked, -1);
    }

    public void setShowShadow(boolean showShadow) {
        this.showShadow = showShadow;
    }

    @CallSuper
    protected boolean initColorsSelect() {
        if (!this.hasColors) {
            return false;
        }
        try {
            this.handleColorAllChangeRst(colorIds[4]);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void handleColorAllChangeRst(Object newColor) {
        int defaultSelect = 4;
        int defaultColor = colorIds[defaultSelect];
        if (newColor instanceof String) {
            if (!TextUtils.isEmpty((CharSequence)((String)newColor))) {
                defaultColor = Color.parseColor((String)((String)newColor));
            }
        } else if (newColor instanceof Integer) {
            defaultColor = (Integer)newColor;
        } else {
            return;
        }
        for (int i = 0; i < colorIds.length; ++i) {
            if (defaultColor != this.getColor(colorIds[i])) continue;
            defaultSelect = i;
            break;
        }
        this.updateCheckedIndex(this.resSets.length - colorIds.length + defaultSelect);
    }

    protected void setResSetsMergeColors(List<ResSet> resSets, int colorsGroupId, IOnColorSelectListener onColorSelectListener) {
        this.hasColors = true;
        ResSet[] colors = this.getColorResSets(colorsGroupId, onColorSelectListener);
        ResSet[] lastResSets = new ResSet[(resSets == null ? 0 : resSets.size()) + colors.length];
        for (int i = 0; i < lastResSets.length; ++i) {
            lastResSets[i] = i < (resSets == null ? 0 : resSets.size()) ? resSets.get(i) : colors[i - (resSets == null ? 0 : resSets.size())];
        }
        this.setResSets(lastResSets);
    }

    private ResSet[] getColorResSets(int colorsGroupId, IOnColorSelectListener onColorSelectListener) {
        ResSet[] colors = new ResSet[colorIds.length];
        int strokeColor = -1;
        for (int i = 0; i < colors.length; ++i) {
            LayerDrawable drawable2 = this.getDrawable(this.getColor(colorIds[i]), this.getColor(colorIds[i]));
            LayerDrawable drawableChecked = this.getDrawable(this.getColor(colorIds[i]), strokeColor);
            int finalI = i;
            colors[i] = new ResSet((Drawable)drawable2, (Drawable)drawableChecked, colorsGroupId, "", v -> onColorSelectListener.onColorSelect(this.getColor(colorIds[finalI])));
        }
        return colors;
    }

    private LayerDrawable getDrawable(int color2, int strokeColor) {
        GradientDrawable drawable1 = new GradientDrawable();
        drawable1.setColor(color2);
        drawable1.setStroke(UtilsKt.getDp((int)2), 0);
        drawable1.setCornerRadius((float)this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius));
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setColor(0);
        drawable2.setStroke(UtilsKt.getDp((int)2), strokeColor);
        drawable2.setCornerRadius((float)(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius) >> 1));
        return new LayerDrawable(new Drawable[]{drawable1, drawable2});
    }

    protected abstract void initViewDataHashMap();

    protected void setSelectMode(int selectMode) {
        this.selectMode = selectMode;
    }

    protected void updateTextView(int index, String text, int textColor) {
        if (this.checkIndexValueInvalid(index)) {
            return;
        }
        if (!(this.items[index] instanceof TextView)) {
            return;
        }
        TextView textView = (TextView)this.items[index];
        if (text != null) {
            textView.setText((CharSequence)text);
        }
        if (textColor != 0) {
            textView.setTextColor(textColor);
        }
    }

    protected void updateCheckedIndex(int index) {
        if (this.checkIndexValueInvalid(index)) {
            return;
        }
        if (this.items[index].getParent() instanceof View) {
            this.updateUIOfIndex(index, (View)this.items[index].getParent(), false);
        }
    }

    public void checkedIndex(int index) {
        if (this.checkIndexValueInvalid(index)) {
            return;
        }
        if (this.items[index].getParent() instanceof View) {
            this.updateUIOfIndex(index, (View)this.items[index].getParent(), true);
        }
    }

    public void checkedColorIndex(int index) {
        if (this.checkIndexValueInvalid(index)) {
            return;
        }
        if (this.items[index].getParent() instanceof View) {
            this.updateUIOfIndex(index, (View)this.items[index].getParent(), true);
            this.isFirstShow = false;
        }
    }

    protected Drawable getDrawable(int drawableId) {
        return this.getDrawable(drawableId, false);
    }

    protected Drawable getDrawable(int drawableId, boolean mergeFloatLayerBg) {
        if (!mergeFloatLayerBg) {
            return AppCompatResources.getDrawable((Context)this.context, (int)drawableId);
        }
        return new LayerDrawable(new Drawable[]{AppCompatResources.getDrawable((Context)this.context, (int)R.drawable.base_tool_bar_second_check_layer_bg), AppCompatResources.getDrawable((Context)this.context, (int)drawableId)});
    }

    protected int getColor(int colorId) {
        int color2 = 0;
        try {
            color2 = ContextCompat.getColor((Context)this.context, (int)colorId);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
        return color2;
    }

    protected void setDirectionMode(int directionMode) {
        this.directionMode = directionMode;
    }

    protected void showAsAuto(View anchor) {
        if (this.autoMeasureDefaultDirection == 0) {
            int[] anchorDirection = this.getAnchor2limit(anchor);
            this.autoMeasureDefaultDirection = anchorDirection[0] + anchorDirection[1] < DisplayUtils.getScreenWidthPixels((Context)this.context) ? 1 : 2;
            if (anchorDirection[2] + anchorDirection[2] < DisplayUtils.getScreenHeightPixels((Context)((Activity)this.context))) {
                this.autoMeasureDefaultDirection *= -1;
            }
        }
        this.showWithViewOfDirection(anchor, this.autoMeasureDefaultDirection);
    }

    public abstract void show(View var1);

    public void setChild(BaseAutoArrangePopupWindow popupWindow) {
        if (popupWindow != null) {
            this.mChild = popupWindow;
            popupWindow.setParent(this);
        }
    }

    private void setParent(BaseAutoArrangePopupWindow popupWindow) {
        this.mParent = popupWindow;
    }

    protected void showWithViewOfDirection(View anchor, int direction) {
        if (System.currentTimeMillis() - this.lastDismissTime < 200L) {
            return;
        }
        if (this.isDefaultView && this.resSets.length == 0) {
            return;
        }
        if (this.isFirstShow) {
            this.initColorsSelect();
            this.isFirstShow = false;
        }
        if (this.mParent != null && this.mParent.getLastShowDirection() != 0) {
            direction = this.mParent.getLastShowDirection();
            this.rootAnchor = this.mParent.rootAnchor;
        } else if (direction == 0) {
            this.rootAnchor = anchor;
        } else {
            this.rootAnchor = anchor;
            int[] anchor2limit = this.getAnchor2limit(anchor);
            int[][] requestSize = this.getRequestSize(anchor);
            if (Math.abs(direction) == 1 && anchor2limit[0] < (this.directionMode == 2 ? requestSize[0][0] : requestSize[1][0])) {
                direction *= 2;
            }
            if (Math.abs(direction) == 2 && anchor2limit[1] < (this.directionMode == 2 ? requestSize[0][0] : requestSize[1][0])) {
                direction /= 2;
            }
            if (direction > 0 && anchor2limit[2] < (this.directionMode == 2 ? requestSize[0][1] : requestSize[1][1])) {
                direction *= -1;
            }
            if (direction < 0 && anchor2limit[3] < (this.directionMode == 2 ? requestSize[0][1] : requestSize[1][1])) {
                direction *= -1;
            }
        }
        switch (direction) {
            case 1: {
                this.setAnimationStyle(R.style.BJYPushInOutFromRightBottom);
                break;
            }
            case 2: {
                this.setAnimationStyle(R.style.BJYPushInOutFromLeftBottom);
                break;
            }
            case -1: {
                this.setAnimationStyle(R.style.BJYPushInOutFromRightTop);
                break;
            }
            case -2: {
                this.setAnimationStyle(R.style.BJYPushInOutFromLeftTop);
                break;
            }
            case 0: {
                this.setAnimationStyle(R.style.BJYPushInOutFromTop);
                break;
            }
            default: {
                this.setAnimationStyle(R.style.BJYPushInOutFromRightBottom);
            }
        }
        this.lastShowDirection = direction;
        this.initMyOffset(anchor);
        int[] offset2RootAnchor = this.getOffsetToRootAnchor();
        this.showAsDropDown(this.rootAnchor, offset2RootAnchor[0] + (offset2RootAnchor[0] >= 0 ? this.customOffsetX : -this.customOffsetX), offset2RootAnchor[1] + (offset2RootAnchor[1] >= 0 ? this.customOffsetY : -this.customOffsetY));
    }

    public void initCustomOffset(int customOffsetX, int customOffsetY) {
        this.customOffsetX = UtilsKt.getDp((int)customOffsetX);
        this.customOffsetY = UtilsKt.getDp((int)customOffsetY);
    }

    private int[][] getRequestSize(View anchor) {
        this.getContentView().measure(0, 0);
        int[][] requestSize = new int[2][2];
        int[][] childRequestSize = this.mChild == null ? new int[2][2] : this.mChild.getRequestSize(this.getContentView());
        requestSize[0][0] = this.getContentView().getMeasuredWidth() + this.marginToAnchor + childRequestSize[0][0];
        requestSize[0][1] = Math.max(0, this.getContentView().getMeasuredHeight() - anchor.getMeasuredHeight());
        requestSize[1][0] = Math.max(0, this.getContentView().getMeasuredWidth() - anchor.getMeasuredWidth());
        requestSize[1][1] = this.getContentView().getMeasuredHeight() + this.marginToAnchor + childRequestSize[1][1];
        return requestSize;
    }

    public void initLimitView(WeakReference<View> view) {
        this.limitView = view;
    }

    private int[] getAnchor2limit(View anchor) {
        int[] anchorDirection = new int[2];
        anchor.getLocationOnScreen(anchorDirection);
        int[] rst = new int[]{anchorDirection[0], DisplayUtils.getScreenWidthPixels((Context)this.context) - anchorDirection[0] - anchor.getMeasuredWidth(), anchorDirection[1], DisplayUtils.getScreenHeightPixels((Context)this.context) - anchorDirection[1] - anchor.getMeasuredHeight()};
        if (this.limitView != null && this.limitView.get() != null) {
            int[] limitDirection = new int[2];
            ((View)this.limitView.get()).getLocationOnScreen(limitDirection);
            rst[0] = rst[0] - limitDirection[0];
            rst[1] = rst[1] - (DisplayUtils.getScreenWidthPixels((Context)this.context) - limitDirection[0] - ((View)this.limitView.get()).getMeasuredWidth());
            rst[2] = rst[2] - Math.max(limitDirection[1], this.context instanceof Activity ? DisplayUtils.getStatusBarHeight((Activity)((Activity)this.context)) : 0);
            rst[3] = rst[3] - (this.context instanceof Activity ? Math.max(DisplayUtils.getScreenHeightPixels((Context)this.context) - limitDirection[1] - ((View)this.limitView.get()).getMeasuredHeight(), DisplayUtils.getNavigationBarHeight((Activity)((Activity)this.context))) : 0);
        }
        return rst;
    }

    private void initMyOffset(View anchor) {
        int[] anchor2limit = this.getAnchor2limit(anchor);
        int[][] requestSize = this.getRequestSize(anchor);
        this.myOffset = new int[2];
        int mWidth = this.getContentView().getMeasuredWidth();
        int mHeight = this.getContentView().getMeasuredHeight();
        int n = Math.abs(this.lastShowDirection) == 1 ? (this.directionMode == 2 ? -1 * (mWidth + this.marginToAnchor + this.getRealOffset(requestSize[0][0], anchor2limit[0])) : -1 * (mWidth - anchor.getMeasuredWidth()) + this.getRealOffset(requestSize[1][0], anchor2limit[0])) : (this.myOffset[0] = this.directionMode == 2 ? anchor.getMeasuredWidth() + this.marginToAnchor + this.getRealOffset(requestSize[0][1], anchor2limit[1]) : this.getRealOffset(requestSize[1][1], anchor2limit[1]));
        this.myOffset[1] = this.lastShowDirection > 0 ? (this.directionMode == 2 ? -1 * (mHeight + this.getRealOffset(requestSize[0][1], anchor2limit[2])) : -1 * (mHeight + anchor.getMeasuredHeight() + this.marginToAnchor + this.getRealOffset(requestSize[1][1], anchor2limit[2]))) : (this.directionMode == 2 ? -1 * anchor.getMeasuredHeight() + this.getRealOffset(requestSize[0][1], anchor2limit[3]) : this.marginToAnchor + this.getRealOffset(requestSize[1][1], anchor2limit[3]));
    }

    private int getRealOffset(int requestSpace, int remainSpace) {
        return Math.min(0, remainSpace - requestSpace);
    }

    private int[] getOffsetToRootAnchor() {
        int[] mOffset;
        if (this.lastShowDirection == 0) {
            mOffset = new int[2];
            this.rootAnchor.measure(0, 0);
            mOffset[1] = -this.rootAnchor.getMeasuredHeight();
        } else {
            mOffset = this.myOffset;
            if (this.mParent != null) {
                mOffset[0] = mOffset[0] + this.mParent.myOffset[0];
                mOffset[1] = mOffset[1] + (this.mParent.myOffset[1] + this.mParent.getContentView().getMeasuredHeight());
            }
        }
        return mOffset;
    }

    private int getLastShowDirection() {
        return this.lastShowDirection;
    }

    private boolean checkIndexValueInvalid(int index) {
        return this.items == null || index < 0 || index > this.items.length - 1;
    }

    public void dismiss() {
        this.lastDismissTime = System.currentTimeMillis();
        if (this.mChild != null) {
            this.mChild.dismiss();
        }
        super.dismiss();
    }

    public static interface IOnColorSelectListener {
        public void onColorSelect(int var1);
    }

    public static class ResSet {
        static final int DISPLAY_IMG_MODE = 1;
        static final int DISPLAY_TEXT_MODE = 2;
        public static final int DEFAULT_GROUP_ID = -1;
        Drawable drawableNormal;
        Drawable drawableChecked;
        Drawable drawableDot;
        String descriptionText;
        int textColor;
        View.OnClickListener onClickListener;
        int displayMode = 1;
        public boolean isEnable = true;
        public boolean isShowDot = false;
        int checkValue;

        public ResSet(Drawable drawable2, String descriptionText, View.OnClickListener onClickListener) {
            this(drawable2, null, null, -1, 1, descriptionText, 0, onClickListener);
        }

        public ResSet(Drawable drawable2, String descriptionText, Drawable drawableDot, View.OnClickListener onClickListener) {
            this(drawable2, null, drawableDot, -1, 1, descriptionText, 0, onClickListener);
        }

        public ResSet(Drawable drawable2, Drawable drawableChecked, int groupId, String descriptionText, View.OnClickListener onClickListener) {
            this(drawable2, drawableChecked, null, groupId, 1, descriptionText, 0, onClickListener);
        }

        public ResSet(String descriptionText, int textColor, View.OnClickListener onClickListener) {
            this(null, null, null, -1, 2, descriptionText, textColor, onClickListener);
        }

        private ResSet(Drawable drawable2, Drawable drawableChecked, Drawable drawableDot, int groupId, int displayMode, String descriptionText, int textColor, View.OnClickListener onClickListener) {
            this.drawableNormal = drawable2;
            this.drawableChecked = drawableChecked;
            this.drawableDot = drawableDot;
            this.displayMode = displayMode;
            this.checkValue = groupId;
            this.descriptionText = descriptionText;
            this.textColor = textColor;
            this.onClickListener = onClickListener;
        }
    }

    protected static class GroupViewData {
        int lineWidth;
        int lineHeight;
        int itemWidth;
        int itemHeight;
        int maxNumInPerLine;

        public GroupViewData(Context context2, int lineWidth, int lineHeight, int itemWidth, int itemHeight, int maxNumInPerLine) {
            this.lineWidth = UtilsKt.getDp((int)lineWidth);
            this.lineHeight = UtilsKt.getDp((int)lineHeight);
            this.itemWidth = UtilsKt.getDp((int)itemWidth);
            this.itemHeight = UtilsKt.getDp((int)itemHeight);
            this.maxNumInPerLine = maxNumInPerLine;
        }
    }
}

