/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.focus;

import android.content.Context;
import android.util.AttributeSet;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class FocusRecyclerView
extends RecyclerView {
    private OnItemFocusChangeListener onItemFocusChangeListener;

    public FocusRecyclerView(Context context2) {
        super(context2);
    }

    public FocusRecyclerView(Context context2, AttributeSet attrs) {
        super(context2, attrs);
    }

    public FocusRecyclerView(Context context2, AttributeSet attrs, int defStyle) {
        super(context2, attrs, defStyle);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return ev.getAction() == 2 || super.dispatchTouchEvent(ev);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            if (this.onItemFocusChangeListener != null) {
                this.onItemFocusChangeListener.onItemFocusChange(null, false, 0);
            }
            return super.dispatchKeyEvent(event);
        }
        int dy = firstChild.getHeight();
        View focusView = this.getFocusedChild();
        if (focusView != null) {
            switch (event.getKeyCode()) {
                case 20: {
                    View downView = FocusFinder.getInstance().findNextFocus((ViewGroup)this, focusView, 130);
                    if (event.getAction() == 1) {
                        if (this.onItemFocusChangeListener != null) {
                            this.onItemFocusChangeListener.onItemFocusChange(downView, true, this.getChildLayoutPosition(downView));
                        }
                        return true;
                    }
                    if (downView != null) {
                        downView.requestFocus();
                        if (this.onItemFocusChangeListener != null) {
                            this.onItemFocusChangeListener.onItemFocusChange(downView, true, this.getChildLayoutPosition(downView));
                        }
                        return true;
                    }
                    this.smoothScrollBy(0, dy);
                    int itemCount = 0;
                    if (this.getAdapter() != null) {
                        itemCount = this.getAdapter().getItemCount();
                    }
                    if (itemCount - 1 == this.getLastPosition()) {
                        if (this.onItemFocusChangeListener != null) {
                            this.onItemFocusChangeListener.onItemFocusChange(null, false, 0);
                        }
                        return super.dispatchKeyEvent(event);
                    }
                    if (this.onItemFocusChangeListener != null) {
                        this.onItemFocusChangeListener.onItemFocusChange(downView, true, this.getChildLayoutPosition(downView));
                    }
                    return true;
                }
                case 19: {
                    View upView = FocusFinder.getInstance().findNextFocus((ViewGroup)this, focusView, 33);
                    if (event.getAction() == 1) {
                        if (this.onItemFocusChangeListener != null) {
                            this.onItemFocusChangeListener.onItemFocusChange(upView, true, this.getChildLayoutPosition(upView));
                        }
                        return true;
                    }
                    if (upView != null) {
                        upView.requestFocus();
                        if (this.onItemFocusChangeListener != null) {
                            this.onItemFocusChangeListener.onItemFocusChange(upView, true, this.getChildLayoutPosition(upView));
                        }
                        return true;
                    }
                    this.smoothScrollBy(0, -dy);
                    if (this.getFirstPosition() == 0) {
                        if (this.onItemFocusChangeListener != null) {
                            this.onItemFocusChangeListener.onItemFocusChange(null, false, 0);
                        }
                        return super.dispatchKeyEvent(event);
                    }
                    if (this.onItemFocusChangeListener != null) {
                        this.onItemFocusChangeListener.onItemFocusChange(upView, true, this.getChildLayoutPosition(upView));
                    }
                    return true;
                }
                case 21: {
                    if (this.onItemFocusChangeListener == null) break;
                    this.onItemFocusChangeListener.onItemFocusLeft();
                    break;
                }
                case 22: {
                    if (this.onItemFocusChangeListener == null) break;
                    this.onItemFocusChangeListener.onItemFocusRight();
                    break;
                }
            }
        }
        if (this.onItemFocusChangeListener != null) {
            this.onItemFocusChangeListener.onItemFocusChange(null, false, 0);
        }
        return super.dispatchKeyEvent(event);
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        View focusView = this.getFocusedChild();
        if (focusView != null) {
            View destView = null;
            if (dy != 0) {
                destView = dy > 0 ? FocusFinder.getInstance().findNextFocus((ViewGroup)this, focusView, 130) : FocusFinder.getInstance().findNextFocus((ViewGroup)this, focusView, 33);
            }
            if (destView != null) {
                destView.requestFocus();
            }
        }
    }

    public int getFirstVisiblePosition() {
        if (this.getChildCount() == 0) {
            return 0;
        }
        return this.getChildAdapterPosition(this.getChildAt(0));
    }

    public boolean isFirstItemVisible() {
        return this.getFirstPosition() == 0;
    }

    public int getFirstPosition() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            int[] firstVisibleItems = null;
            firstVisibleItems = ((StaggeredGridLayoutManager)layoutManager).findFirstCompletelyVisibleItemPositions(null);
            return firstVisibleItems[0];
        }
        if (layoutManager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition();
        }
        return -1;
    }

    public boolean isLastItemVisible(int lineNum, int allItemNum) {
        int position = this.getLastPosition();
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            return position >= allItemNum - lineNum;
        }
        if (layoutManager instanceof LinearLayoutManager) {
            return allItemNum - 1 == position;
        }
        return false;
    }

    public int getLastPosition() {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof StaggeredGridLayoutManager) {
            int[] lastVisibleItems = ((StaggeredGridLayoutManager)layoutManager).findLastCompletelyVisibleItemPositions(null);
            return lastVisibleItems[0];
        }
        if (layoutManager instanceof LinearLayoutManager) {
            return ((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition();
        }
        return -1;
    }

    public void setOnItemFocusChangeListener(OnItemFocusChangeListener onItemFocusChangeListener) {
        this.onItemFocusChangeListener = onItemFocusChangeListener;
    }

    public static interface OnItemFocusChangeListener {
        public void onItemFocusChange(View var1, boolean var2, int var3);

        public void onItemFocusLeft();

        public void onItemFocusRight();
    }
}

