/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.liveuibase.R;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class SimpleTextDialog
extends Dialog {
    private TextView mTvDialogTitle;
    private TextView mTvDialogInfo;
    private Button mBtnDialogOk;
    private OnOkClickListener mOnOkClickListener;
    private LPError error;
    private Disposable mQuitDisposable;
    private final int TIME_JUMP_ENDLINK = 5;

    public SimpleTextDialog(@NonNull Context context2, LPError error) {
        super(context2, R.style.BJYDialogStyle);
        this.error = error;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.bjy_dialog_simple_text);
        this.initView();
        this.initListener();
    }

    private void initListener() {
        this.mBtnDialogOk.setOnClickListener(v -> this.jump());
    }

    private void jump() {
        RxUtils.dispose((Disposable)this.mQuitDisposable);
        this.mQuitDisposable = null;
        if (this.mOnOkClickListener == null) {
            return;
        }
        this.mOnOkClickListener.onJump(this.error.getAuditionEndLink());
    }

    private void initView() {
        this.mTvDialogTitle = (TextView)this.findViewById(R.id.tv_dialog_title);
        this.mTvDialogInfo = (TextView)this.findViewById(R.id.tv_dialog_info);
        this.mBtnDialogOk = (Button)this.findViewById(R.id.btn_dialog_ok);
        this.mTvDialogInfo.setText((CharSequence)this.error.getMessage());
        this.mQuitDisposable = Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (aLong >= 5L) {
                this.jump();
            } else {
                this.mBtnDialogOk.setText((CharSequence)(this.getContext().getResources().getString(R.string.live_quiz_dialog_confirm) + "(" + (5L - aLong) + ")"));
            }
        });
    }

    public void setOnOkClickListener(OnOkClickListener listener2) {
        this.mOnOkClickListener = listener2;
    }

    public static interface OnOkClickListener {
        public void onJump(String var1);
    }
}

