/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.courseware;

import android.annotation.SuppressLint;
import com.baijiayun.livecore.models.file.homework.LPHomeworkModel;
import com.baijiayun.livecore.utils.LPJsonUtils;
import com.baijiayun.liveuibase.base.BaseUIConstant;
import com.tencent.mmkv.MMKV;
import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;

public class HomeworkSaveUtil {
    private static final String TAG = HomeworkSaveUtil.class.getSimpleName();
    private final MMKV mmkv = MMKV.mmkvWithID((String)"BJY_HOMEWORK");

    @SuppressLint(value={"CheckResult"})
    public HomeworkSaveUtil() {
        Observable.empty().subscribeOn(Schedulers.io()).subscribe(o -> this.initMessageFile());
    }

    public void saveHomework(SaveMessageModel saveMessageModel) {
        String homeworkName = HomeworkSaveUtil.getHomeworkFileName(saveMessageModel.homeworkModel) + saveMessageModel.homeworkModel.getFext();
        String data = LPJsonUtils.toJsonObject((Object)saveMessageModel).toString();
        this.mmkv.encode(homeworkName, data);
    }

    public static String getHomeworkFileName(LPHomeworkModel homeworkModel) {
        if (homeworkModel.getName().length() < homeworkModel.getFext().length()) {
            return "\u6587\u4ef6\u540d\u9519\u8bef\uff1a\uff08" + homeworkModel.getHomeworkId() + "\uff09";
        }
        return homeworkModel.getName().substring(0, homeworkModel.getName().length() - homeworkModel.getFext().length()) + "\uff08" + homeworkModel.getHomeworkId() + "\uff09";
    }

    private void initMessageFile() {
        File dir = new File(BaseUIConstant.HOMEWORK_DIR_PATH);
        if (!this.checkDir(dir)) {
            return;
        }
        try {
            for (String allKey : this.mmkv.allKeys()) {
                File file = new File(BaseUIConstant.HOMEWORK_DIR_PATH + allKey);
                if (file.exists()) continue;
                this.mmkv.remove(allKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkDir(File dir) {
        boolean exist = dir.isDirectory();
        if (!exist) {
            try {
                exist = dir.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return exist;
    }

    public static class SaveMessageModel {
        String className;
        long roomId;
        LPHomeworkModel homeworkModel;

        public SaveMessageModel(String className, long roomId, LPHomeworkModel homeworkModel) {
            this.className = className;
            this.roomId = roomId;
            this.homeworkModel = homeworkModel;
        }
    }
}

