/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.courseware;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.FileUtils;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPDocModel;
import com.baijiayun.livecore.models.LPDocTranslateProgressModel;
import com.baijiayun.livecore.models.LPDocumentModel;
import com.baijiayun.livecore.models.LPResponseWithProgressMergedModel;
import com.baijiayun.livecore.models.LPUploadDocModel;
import com.baijiayun.livecore.models.LPUploadHomeworkUserModel;
import com.baijiayun.livecore.models.LPUploadingDocumentModel;
import com.baijiayun.livecore.models.courseware.LPMediaCoursewareModel;
import com.baijiayun.livecore.models.file.IFileModel;
import com.baijiayun.livecore.models.file.cloudfile.LPCloudFileModel;
import com.baijiayun.livecore.models.file.homework.LPHomeworkModel;
import com.baijiayun.livecore.models.file.homework.LPResHomeworkAllModel;
import com.baijiayun.livecore.models.file.homework.LPUploadHomeworkModel;
import com.baijiayun.livecore.models.roomresponse.LPAllowUploadHomeworkModel;
import com.baijiayun.liveuibase.widgets.courseware.BaseCourseWareContract;
import com.baijiayun.liveuibase.widgets.courseware.HomeworkSaveUtil;
import com.baijiayun.liveuibase.widgets.courseware.models.UploadDocModel;
import com.baijiayun.network.model.ProgressModel;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class CourseManagePresenter
implements BaseCourseWareContract.BaseCourseWarePresenter {
    private final String TAG = CourseManagePresenter.class.getSimpleName();
    private BaseCourseWareContract.BaseCourseWareView view;
    private HomeworkSaveUtil mHomeworkSaveHandler;
    private LiveRoom liveRoom;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private LinkedBlockingQueue<LPUploadingDocumentModel> uploadingDocumentQueue;
    private LinkedBlockingQueue<LPUploadingDocumentModel> uploadingImageQueue;
    private Map<String, Disposable> disposablesOfUploading;
    private Map<String, Disposable> disposablesOfRequestProgress;
    private Disposable disposableOfReqImg;
    private Disposable disposableOfDownloadHomework;

    public CourseManagePresenter(BaseCourseWareContract.BaseCourseWareView view) {
        this.view = view;
        this.mHomeworkSaveHandler = new HomeworkSaveUtil();
        this.uploadingDocumentQueue = new LinkedBlockingQueue();
        this.uploadingImageQueue = new LinkedBlockingQueue();
        this.disposablesOfUploading = new HashMap<String, Disposable>();
        this.disposablesOfRequestProgress = new HashMap<String, Disposable>();
    }

    @Override
    public LPConstants.LPRoomType getRoomType() {
        return this.liveRoom.getRoomInfo().roomType;
    }

    @Override
    public void sendHomeWork(String path, boolean isImg) {
        LPUploadingDocumentModel model = new LPUploadingDocumentModel(path);
        model.setImg(isImg);
        model.setHomework(true);
        this.uploadingDocumentQueue.offer(model);
        this.continueUploadQueue();
    }

    @Override
    public void deleteHomework(String homeworkId, LPUploadHomeworkUserModel userModel) {
        this.liveRoom.getDocListVM().deleteHomework(homeworkId, userModel);
    }

    @Override
    public void downloadHomework(LPHomeworkModel homeworkModel, File homeworkFile) {
        this.disposableOfDownloadHomework = this.liveRoom.getDocListVM().downloadHomework(homeworkModel.getHomeworkId(), homeworkFile).subscribe(progressModel -> {
            if (this.view == null) {
                return;
            }
            if (progressModel.isComplete()) {
                boolean rst = homeworkFile.renameTo(new File(homeworkFile.getPath() + homeworkModel.getFext()));
                if (rst) {
                    this.view.onDownloadSuccess(homeworkModel.getHomeworkId());
                    this.mHomeworkSaveHandler.saveHomework(new HomeworkSaveUtil.SaveMessageModel(this.liveRoom.getRoomInfo().title, this.liveRoom.getRoomInfo().roomId, homeworkModel));
                } else {
                    this.view.onDownloadFailed(homeworkModel.getHomeworkId(), "\u6587\u4ef6\u5f02\u5e38\uff0c\u4e0b\u8f7d\u5931\u8d25");
                }
            } else {
                this.view.onDownloadProgress(homeworkModel.getHomeworkId(), progressModel.getUploadRatio());
            }
        }, throwable -> {
            if (this.view != null) {
                this.view.onDownloadFailed(homeworkModel.getHomeworkId(), throwable.getMessage());
            }
        });
    }

    @Override
    public void requestSearchHomework(String keyword) {
        this.liveRoom.getDocListVM().requestHomeworkAllList(keyword);
    }

    private void uploadHomework(LPUploadingDocumentModel model) {
        IUserModel currentUser = this.liveRoom.getCurrentUser();
        this.liveRoom.getDocListVM().getObservableOfUploadHomeworkWithProgress(model.getFilePath(), new LPUploadHomeworkUserModel(currentUser.getNumber(), currentUser.getName(), currentUser.getType())).subscribe((Observer)new CourseUploadObserver<LPUploadHomeworkModel>(model){

            @Override
            public void onSubscribe(Disposable d) {
                super.onSubscribe(d);
                CourseManagePresenter.this.disposablesOfUploading.put(this.model.getFilePath(), d);
            }

            @Override
            void onNextResponse(LPUploadHomeworkModel uploadHomeworkModel) {
                uploadHomeworkModel.setUploadSource(0);
                if (!uploadHomeworkModel.isCanPreview() || this.model.isImg()) {
                    RxUtils.dispose((Disposable)((Disposable)CourseManagePresenter.this.disposablesOfUploading.remove(this.model.getFilePath())));
                    RxUtils.dispose((Disposable)((Disposable)CourseManagePresenter.this.disposablesOfRequestProgress.remove(this.model.getFilePath())));
                    CourseManagePresenter.this.view.removeUploadDocument(this.model.getFilePath());
                    CourseManagePresenter.this.liveRoom.getDocListVM().addHomework(LPHomeworkModel.copyValueFromUploadModel((LPUploadHomeworkModel)uploadHomeworkModel));
                    return;
                }
                this.model.setHomeworkId(uploadHomeworkModel.getHomeworkId());
                this.model.setFileId(uploadHomeworkModel.getFileId());
                CourseManagePresenter.this.view.startTranslate(this.model);
                Disposable disposableOfInterval = Observable.interval((long)2L, (TimeUnit)TimeUnit.SECONDS).subscribe(aLong -> CourseManagePresenter.this.checkTranslate(uploadHomeworkModel, this.model));
                CourseManagePresenter.this.disposablesOfUploading.put(this.model.getFilePath(), disposableOfInterval);
                CourseManagePresenter.this.continueUploadQueue();
            }
        });
    }

    private void checkTranslate(@NotNull LPUploadHomeworkModel uploadHomeworkModel, LPUploadingDocumentModel model) {
        if (!this.disposablesOfUploading.containsKey(model.getFilePath())) {
            return;
        }
        this.checkTransferProgress(model, () -> this.liveRoom.getDocListVM().addHomework(LPHomeworkModel.copyValueFromUploadModel((LPUploadHomeworkModel)uploadHomeworkModel)));
    }

    @Override
    public void requestHomeworkSupport() {
        this.liveRoom.getDocListVM().requestHomeworkSupport();
    }

    @Override
    public void cancelDownloadHomework(File file) {
        RxUtils.dispose((Disposable)this.disposableOfDownloadHomework);
        if (file.exists()) {
            boolean delete = file.delete();
            LPLogger.d((String)this.TAG, (String)("cancelDownloadHomework:" + delete));
        }
    }

    @Override
    public void sendPPTDocument(@NonNull String path, boolean isAnimPPT) {
        LPUploadingDocumentModel model = new LPUploadingDocumentModel(path);
        model.setAnimPPT(isAnimPPT);
        this.uploadingDocumentQueue.offer(model);
        this.continueUploadQueue();
    }

    private void uploadDoc(LPUploadingDocumentModel model) {
        this.liveRoom.getDocListVM().uploadPPTWithProgress(model.getFilePath(), model.isAnimPPT()).subscribe((Observer)new CourseUploadObserver<LPUploadDocModel>(model){

            @Override
            public void onSubscribe(Disposable d) {
                super.onSubscribe(d);
                CourseManagePresenter.this.disposablesOfUploading.put(this.model.getFilePath(), d);
            }

            @Override
            void onNextResponse(LPUploadDocModel lpUploadDocModel) {
                String fid = String.valueOf(lpUploadDocModel.fileId);
                this.model.setFileId(fid);
                LPLogger.d((String)"doc222", (String)"startTranslate");
                CourseManagePresenter.this.view.startTranslate(this.model);
                Disposable disposableOfInterval = Observable.interval((long)2L, (TimeUnit)TimeUnit.SECONDS).subscribe(aLong -> CourseManagePresenter.this.checkTransferProgress(this.model, () -> CourseManagePresenter.this.liveRoom.getDocListVM().addDocument(lpUploadDocModel)));
                CourseManagePresenter.this.disposablesOfUploading.put(this.model.getFilePath(), disposableOfInterval);
                CourseManagePresenter.this.continueUploadQueue();
            }
        });
    }

    private void continueUploadQueue() {
        LPUploadingDocumentModel model = this.uploadingDocumentQueue.poll();
        if (model == null || this.view == null) {
            return;
        }
        if (this.view.addUploadModel(model)) {
            if (model.isHomework()) {
                this.uploadHomework(model);
            } else if (model.isCloudFile()) {
                this.uploadCloudFile(model);
            } else {
                this.uploadDoc(model);
            }
        }
    }

    @Override
    public void cancelUpload(String path) {
        RxUtils.dispose((Disposable)this.disposablesOfUploading.remove(path));
        RxUtils.dispose((Disposable)this.disposablesOfRequestProgress.remove(path));
        this.view.removeUploadDocument(path);
    }

    @Override
    public void deleteTranslating(UploadDocModel model) {
        if (TextUtils.isEmpty((CharSequence)model.getFileId())) {
            this.view.removeUploadDocument(model.getFileId());
            return;
        }
        RxUtils.dispose((Disposable)this.disposablesOfUploading.remove(model.getPath()));
        RxUtils.dispose((Disposable)this.disposablesOfRequestProgress.remove(model.getPath()));
        if (model.isCloudFile()) {
            this.liveRoom.getCloudFileVM().deleteCloudFile(model.getFileId());
        } else if (model.isHomeWork()) {
            this.liveRoom.getDocListVM().deleteHomework(model.getHomeworkId(), LPUploadHomeworkUserModel.copyData((IUserModel)this.liveRoom.getCurrentUser()));
        } else {
            this.liveRoom.getDocListVM().deleteDocument(model.getFileId());
        }
        this.view.removeUploadDocument(model.getPath());
    }

    @Override
    public void sendPPTCloudFile(String path, boolean isAnimPPT, boolean isImg) {
        LPUploadingDocumentModel model = new LPUploadingDocumentModel(path, this.liveRoom.getCurrentUser());
        model.setCloudFile(true);
        model.setAnimPPT(isAnimPPT);
        model.setImg(isImg);
        this.uploadingDocumentQueue.offer(model);
        this.continueUploadQueue();
    }

    private void uploadCloudFile(LPUploadingDocumentModel model) {
        this.liveRoom.getCloudFileVM().getObservableOfUploadCloudFileWithProgress(model).subscribe((Observer)new CourseUploadObserver<LPCloudFileModel>(model){

            @Override
            public void onSubscribe(Disposable d) {
                super.onSubscribe(d);
                CourseManagePresenter.this.disposablesOfUploading.put(this.model.getFilePath(), d);
            }

            @Override
            void onNextResponse(LPCloudFileModel cloudFileModel) {
                this.model.setFileId(cloudFileModel.getFileId());
                CourseManagePresenter.this.view.startTranslate(this.model);
                Disposable disposableOfInterval = Observable.interval((long)2L, (TimeUnit)TimeUnit.SECONDS).subscribe(aLong -> CourseManagePresenter.this.checkTranslate(cloudFileModel, this.model));
                CourseManagePresenter.this.disposablesOfUploading.put(this.model.getFilePath(), disposableOfInterval);
                CourseManagePresenter.this.continueUploadQueue();
            }
        });
    }

    @Override
    public void requestCloudFileInDir(LPCloudFileModel dirFileModel) {
        if (dirFileModel == null || !dirFileModel.isDirectory()) {
            LPLogger.d((String)this.TAG, (String)"requestCloudFileInDir, dir is null or is not directory");
            return;
        }
        this.liveRoom.getCloudFileVM().requestCloudFileInDir(dirFileModel);
    }

    private void checkTranslate(@NotNull LPCloudFileModel cloudFileModel, LPUploadingDocumentModel model) {
        if (!this.disposablesOfUploading.containsKey(model.getFilePath())) {
            return;
        }
        if (model.isImg()) {
            this.view.removeUploadDocument(model.getFilePath());
            this.liveRoom.getCloudFileVM().addCloudFile(cloudFileModel);
            RxUtils.dispose((Disposable)this.disposablesOfUploading.remove(model.getFilePath()));
            return;
        }
        this.checkTransferProgress(model, () -> this.liveRoom.getCloudFileVM().addCloudFile(cloudFileModel));
    }

    private void checkTransferProgress(LPUploadingDocumentModel model, OnTransferComplete transferComplete) {
        Disposable disposableOfTransfer = this.liveRoom.getDocListVM().requestTransferProgress(model.getFileId()).observeOn(AndroidSchedulers.mainThread()).subscribe(progressModel -> {
            LPLogger.e((String)"doc222", (String)("upload percent " + progressModel.progress));
            if (progressModel.progress < 0) {
                this.view.translateFailure(model, (LPDocTranslateProgressModel)progressModel);
                RxUtils.dispose((Disposable)this.disposablesOfUploading.remove(model.getFilePath()));
                RxUtils.dispose((Disposable)this.disposablesOfRequestProgress.remove(model.getFilePath()));
                return;
            }
            if (progressModel.progress >= 100) {
                this.view.removeUploadDocument(model.getFilePath());
                RxUtils.dispose((Disposable)this.disposablesOfUploading.remove(model.getFilePath()));
                RxUtils.dispose((Disposable)this.disposablesOfRequestProgress.remove(model.getFilePath()));
                transferComplete.onComplete();
            }
        });
        this.disposablesOfRequestProgress.put(model.getFilePath(), disposableOfTransfer);
    }

    @Override
    public void requestFileTransfer(IFileModel fileModel, BaseCourseWareContract.IOnRequestTransferListener listener2) {
        if (listener2 == null || this.liveRoom == null) {
            return;
        }
        String fileId = fileModel.getFileId();
        String fExt = fileModel.getFExt();
        long size = fileModel.getSize();
        String userName = fileModel.getUserName();
        if (TextUtils.isEmpty((CharSequence)fileId)) {
            return;
        }
        List docModels = this.liveRoom.getDocListVM().getDocList();
        for (LPDocModel docModel : docModels) {
            if (!docModel.docId.equals(fileModel.getFileId())) continue;
            listener2.onSuccess(docModel);
            return;
        }
        listener2.onWaitForDocAdd();
        if (FileUtils.isImageFile((String)fExt)) {
            RxUtils.dispose((Disposable)this.disposableOfReqImg);
            this.disposableOfReqImg = this.liveRoom.getDocListVM().getObservableOfDocumentImages(fileId).observeOn(AndroidSchedulers.mainThread()).subscribe(imgModel -> {
                LPDocumentModel model;
                if (fileModel instanceof LPCloudFileModel) {
                    model = LPDocumentModel.getImgModelWithUserInfo((String)fileId, (String)fExt, (String)imgModel.name, (int)imgModel.width, (int)imgModel.height, (String)imgModel.url, (String)userName, null, null).buildCloudFile(true);
                } else if (fileModel instanceof LPUploadHomeworkModel) {
                    model = LPDocumentModel.getImgModelWithUserInfo((String)fileId, (String)fExt, (String)imgModel.name, (int)imgModel.width, (int)imgModel.height, (String)imgModel.url, (String)userName, null, null).buildHomework(true, ((LPUploadHomeworkModel)fileModel).getHomeworkId());
                } else {
                    return;
                }
                model.size = size;
                model.bindSource = 0;
                this.liveRoom.getDocListVM().addPictureDocument(model);
                RxUtils.dispose((Disposable)this.disposableOfReqImg);
            });
            return;
        }
        if (fileModel instanceof LPCloudFileModel) {
            this.liveRoom.getCloudFileVM().requestAddCloudFile((LPCloudFileModel)fileModel);
        } else if (fileModel instanceof LPUploadHomeworkModel) {
            this.liveRoom.getDocListVM().addDocument((LPUploadHomeworkModel)fileModel);
        }
    }

    @Override
    public void sendImageShape(String path, boolean isCloudFile) {
        LPUploadingDocumentModel model = new LPUploadingDocumentModel(path);
        model.setCloudFile(isCloudFile);
        this.uploadingImageQueue.offer(model);
        this.continueUploadImageQueue();
    }

    @Override
    public void sendChatImageShape(String path) {
        LPUploadingDocumentModel model = new LPUploadingDocumentModel(path);
        model.setFromChat(true);
        this.uploadingImageQueue.offer(model);
        this.continueUploadImageQueue();
    }

    private void continueUploadImageQueue() {
        LPUploadingDocumentModel model = this.uploadingImageQueue.poll();
        if (model == null || this.view == null) {
            return;
        }
        this.view.addUploadModel(model);
        this.liveRoom.getDocListVM().uploadImageWithProgress(model.getFilePath()).subscribe((Observer)new CourseUploadObserver<LPUploadDocModel>(model){

            @Override
            public void onError(Throwable e) {
                super.onError(e);
                if (this.model.isFromChat()) {
                    FileUtils.safeDeleteFile((File)new File(this.model.getFilePath()));
                }
            }

            @Override
            void onNextResponse(LPUploadDocModel lpUploadDocModel) {
                IUserModel currentUser = CourseManagePresenter.this.liveRoom.getCurrentUser();
                LPDocumentModel documentModel = LPDocumentModel.getImgModelWithUserInfo((String)String.valueOf(lpUploadDocModel.fileId), (String)lpUploadDocModel.fext, (String)lpUploadDocModel.name, (int)lpUploadDocModel.width, (int)lpUploadDocModel.height, (String)lpUploadDocModel.url, (String)currentUser.getName(), (String)currentUser.getNumber(), (LPConstants.LPUserType)currentUser.getType());
                documentModel.size = lpUploadDocModel.size;
                CourseManagePresenter.this.view.removeUploadDocument(this.model.getFilePath());
                if (CourseManagePresenter.this.liveRoom.getDocListVM().addPictureDocument(documentModel) == null && this.model.isFromChat()) {
                    FileUtils.safeDeleteFile((File)new File(this.model.getFilePath()));
                }
                CourseManagePresenter.this.continueUploadImageQueue();
            }
        });
    }

    @Override
    public void subscribe(LiveRoom liveRoom2) {
        this.liveRoom = liveRoom2;
        this.uploadingDocumentQueue.clear();
        this.uploadingImageQueue.clear();
        this.disposablesOfUploading.clear();
        this.disposablesOfRequestProgress.clear();
        if (liveRoom2 == null) {
            return;
        }
        this.compositeDisposable.add(liveRoom2.getDocListVM().getObservableOfDocListChanged().observeOn(AndroidSchedulers.mainThread()).subscribe(docModels -> {
            if (this.view != null) {
                this.view.updateAllDocList((List<LPDocModel>)docModels);
            }
        }));
        if (this.view != null) {
            this.view.updateMediaCoursewareList(liveRoom2.getDocListVM().getMediaCoursewareList());
        }
        this.compositeDisposable.add(liveRoom2.getDocListVM().getObservableOfMediaCoursewareList().observeOn(AndroidSchedulers.mainThread()).subscribe(mediaCoursewareModelList -> {
            if (this.view != null) {
                this.view.updateMediaCoursewareList((List<LPMediaCoursewareModel>)mediaCoursewareModelList);
            }
        }));
        this.compositeDisposable.add(liveRoom2.getDocListVM().getObservableOfHomeworkListChanged().observeOn(AndroidSchedulers.mainThread()).subscribe(homeworkAllModel -> {
            if (this.view != null) {
                this.view.updateAllHomework((LPResHomeworkAllModel)homeworkAllModel);
            }
        }));
        this.compositeDisposable.add(liveRoom2.getDocListVM().getObservableOfHomeworkSearchRstListChanged().observeOn(AndroidSchedulers.mainThread()).subscribe(homeworkAllModel -> {
            if (this.view != null) {
                this.view.updateHomeworkSearchRst((LPResHomeworkAllModel)homeworkAllModel);
            }
        }));
        this.compositeDisposable.add(liveRoom2.getCloudFileVM().getObservableOfCloudListChanged().observeOn(AndroidSchedulers.mainThread()).subscribe(lpCloudFileModels -> {
            if (this.view != null) {
                this.view.updateAllCloudFile((List<LPCloudFileModel>)lpCloudFileModels);
            }
        }));
        this.compositeDisposable.add(liveRoom2.getCloudFileVM().getObservableOfDirRecordChanged().observeOn(AndroidSchedulers.mainThread()).subscribe(dirRecordModels -> {
            if (this.view != null) {
                this.view.updateCloudDirRecord((List<LPCloudFileModel>)dirRecordModels);
            }
        }));
        this.compositeDisposable.add(liveRoom2.getDocListVM().getObservableOfHomeworkSupport().observeOn(AndroidSchedulers.mainThread()).subscribe(support -> {
            if (support != null && this.view != null) {
                this.view.updateHomeworkSupport((boolean)support);
            }
        }));
        liveRoom2.getDocListVM().requestHomeworkAllList("");
        liveRoom2.getCloudFileVM().requestCloudFileAll();
        liveRoom2.getDocListVM().requestHomeworkSupport();
        if (this.view != null) {
            this.view.updateAllDocList(liveRoom2.getDocListVM().getDocList());
            this.view.updateAllHomework(liveRoom2.getDocListVM().getHomeworkModelList());
            this.view.updateAllCloudFile(liveRoom2.getCloudFileVM().getCloudFileList());
            this.view.updateAllowUpdateHomework(liveRoom2.getDocListVM().getAllowUploadHomework().isAllow());
        }
        this.compositeDisposable.add(liveRoom2.getDocListVM().getObservableOfAllowUploadHomework().observeOn(AndroidSchedulers.mainThread()).map(LPAllowUploadHomeworkModel::isAllow).subscribe(isAllow -> {
            if (this.view != null) {
                this.view.updateAllowUpdateHomework((boolean)isAllow);
            }
        }));
    }

    @Override
    public boolean enableImageShowAsDoc() {
        if (this.liveRoom == null) {
            return false;
        }
        return this.liveRoom.getPartnerConfig().enableImageShowAsDoc;
    }

    @Override
    public void unSubscribe() {
        for (Map.Entry<String, Disposable> entry : this.disposablesOfRequestProgress.entrySet()) {
            RxUtils.dispose((Disposable)entry.getValue());
            if (this.view == null) continue;
            this.view.removeUploadDocument(entry.getKey());
        }
        this.disposablesOfRequestProgress.clear();
        for (Disposable disposable : this.disposablesOfUploading.values()) {
            RxUtils.dispose((Disposable)disposable);
        }
        this.disposablesOfUploading.clear();
        this.compositeDisposable.clear();
        RxUtils.dispose((Disposable)this.disposableOfReqImg);
        RxUtils.dispose((Disposable)this.disposableOfDownloadHomework);
    }

    @Override
    public void destroy() {
        this.view = null;
        this.unSubscribe();
    }

    static interface OnTransferComplete {
        public void onComplete();
    }

    abstract class CourseUploadObserver<T>
    implements Observer<LPResponseWithProgressMergedModel<ProgressModel, T>> {
        LPUploadingDocumentModel model;

        protected CourseUploadObserver(LPUploadingDocumentModel model) {
            this.model = model;
        }

        public void onSubscribe(Disposable d) {
            CourseManagePresenter.this.compositeDisposable.add(d);
        }

        public void onNext(LPResponseWithProgressMergedModel<ProgressModel, T> mergedModel) {
            if (mergedModel.isProgress()) {
                this.onNextProgress((ProgressModel)mergedModel.progress);
            } else {
                this.onNextResponse(mergedModel.response);
            }
        }

        public void onError(Throwable e) {
            this.model.setStatus(1);
            if (CourseManagePresenter.this.view == null) {
                return;
            }
            CourseManagePresenter.this.view.uploadFailure(this.model, "\u672a\u77e5\u9519\u8bef\uff1a" + e.getMessage());
        }

        public void onComplete() {
        }

        void onNextProgress(ProgressModel progress) {
            if (CourseManagePresenter.this.view != null) {
                CourseManagePresenter.this.view.uploadProgress(this.model.getFilePath(), (int)progress.getUploadRatio() * 100);
            }
        }

        abstract void onNextResponse(T var1);
    }
}

