/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.courseware;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.FileUtils;
import com.baijiayun.livecore.models.LPDocModel;
import com.baijiayun.livecore.models.LPDocTranslateProgressModel;
import com.baijiayun.livecore.models.LPUploadDocModel;
import com.baijiayun.livecore.models.LPUploadingDocumentModel;
import com.baijiayun.livecore.models.courseware.LPCoursewareModel;
import com.baijiayun.livecore.models.courseware.LPMediaCoursewareModel;
import com.baijiayun.livecore.models.file.IFileModel;
import com.baijiayun.livecore.models.file.cloudfile.LPCloudFileModel;
import com.baijiayun.livecore.models.file.homework.LPHomeworkModel;
import com.baijiayun.livecore.models.file.homework.LPResHomeworkAllModel;
import com.baijiayun.livecore.models.file.homework.LPUploadHomeworkModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseUIConstant;
import com.baijiayun.liveuibase.widgets.courseware.BaseCourseWareContract;
import com.baijiayun.liveuibase.widgets.courseware.BaseCourseWareFileViewHolder;
import com.baijiayun.liveuibase.widgets.courseware.ICourseWareViewListener;
import com.baijiayun.liveuibase.widgets.courseware.listeners.BaseCourseWareItemClickListener;
import com.baijiayun.liveuibase.widgets.courseware.models.DownloadHomeworkModel;
import com.baijiayun.liveuibase.widgets.courseware.models.TabState;
import com.baijiayun.liveuibase.widgets.courseware.models.UploadDocModel;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BaseCourseWareFileAdapter
extends RecyclerView.Adapter<BaseCourseWareFileViewHolder> {
    private TabState mTabState = TabState.DocFile;
    private List<LPCoursewareModel> mCoursewareList = new ArrayList<LPCoursewareModel>();
    private List<LPCoursewareModel> docCopy = new ArrayList<LPCoursewareModel>();
    private List<LPCoursewareModel> mediaCoursewareCopy = new ArrayList<LPCoursewareModel>();
    private List<LPHomeworkModel> mHomeworkModelList = new ArrayList<LPHomeworkModel>();
    private List<LPHomeworkModel> mHomeworkSearchRstList = new ArrayList<LPHomeworkModel>();
    private List<LPCloudFileModel> mCloudFileList = new ArrayList<LPCloudFileModel>();
    private List<String> mWaitAddToPlayList = new ArrayList<String>();
    private List<String> mWaitAddToPreviewList = new ArrayList<String>();
    private LinkedHashMap<String, UploadDocModel> mUploadDocQueue = new LinkedHashMap();
    private Map<String, DownloadHomeworkModel> downloadHomeworkQueue = new HashMap<String, DownloadHomeworkModel>();
    private boolean mIsOnSearching = false;
    private String docSearchKeyword = "";
    private ICourseWareViewListener courseWareViewListener;
    private BaseCourseWareContract.BaseCourseWarePresenter presenter;
    private boolean isTeacherOrAssistant;
    private Context context;

    public BaseCourseWareFileAdapter(ICourseWareViewListener courseWareViewListener, boolean isTeacherOrAssistant, Context context2) {
        this.courseWareViewListener = courseWareViewListener;
        this.isTeacherOrAssistant = isTeacherOrAssistant;
        this.context = context2;
    }

    public void setPresenter(BaseCourseWareContract.BaseCourseWarePresenter presenter2) {
        this.presenter = presenter2;
    }

    @NonNull
    public BaseCourseWareFileViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View view = LayoutInflater.from((Context)viewGroup.getContext()).inflate(R.layout.uibase_courseware_file_item_layout, viewGroup, false);
        return new BaseCourseWareFileViewHolder(view, this.isTeacherOrAssistant, this.presenter.getRoomType() == LPConstants.LPRoomType.NewSmallGroup);
    }

    public void onBindViewHolder(@NonNull BaseCourseWareFileViewHolder viewHolder, int position) {
        List<Object> showList = this.getShowList();
        viewHolder.resetView();
        if (position < showList.size()) {
            Object showItem = showList.get(position);
            if (showItem instanceof LPCoursewareModel) {
                viewHolder.initDocModel((LPCoursewareModel)showItem);
                viewHolder.setOnItemClickListener(new DocItemClickListener((LPCoursewareModel)showItem));
            } else if (showItem instanceof LPHomeworkModel) {
                LPHomeworkModel homeworkModel = (LPHomeworkModel)showItem;
                viewHolder.initDocModel(homeworkModel);
                viewHolder.setOnItemClickListener(new HomeworkItemClickListener(homeworkModel));
                this.checkAndInitDownloadQueue(homeworkModel, viewHolder);
            } else if (showItem instanceof LPCloudFileModel) {
                LPCloudFileModel cloudFileModel = (LPCloudFileModel)showItem;
                viewHolder.initDocModel(cloudFileModel);
                viewHolder.setOnItemClickListener(new CloudItemClickListener(cloudFileModel));
            }
        } else {
            LinkedHashMap<String, UploadDocModel> uploadQueue = this.getUploadQueue();
            UploadDocModel[] uploadDocModels = new UploadDocModel[uploadQueue.size()];
            uploadQueue.values().toArray(uploadDocModels);
            UploadDocModel uploadDocModel = uploadDocModels[position - showList.size()];
            viewHolder.initDocModel(uploadDocModel);
            viewHolder.setOnItemClickListener(new UploadItemClickListener(uploadDocModel));
        }
    }

    public void onViewDetachedFromWindow(@NonNull BaseCourseWareFileViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        RxUtils.dispose((Disposable)holder.disposableOfPermission);
    }

    public int getItemCount() {
        return this.mIsOnSearching ? this.getShowList().size() : this.getShowList().size() + this.getUploadQueue().size();
    }

    @NotNull
    private List<Object> getShowList() {
        ArrayList<Object> showList = new ArrayList<Object>();
        switch (this.mTabState) {
            case DocFile: {
                if (this.mIsOnSearching) {
                    for (LPCoursewareModel coursewareModel : this.mCoursewareList) {
                        if (!coursewareModel.name.contains(this.docSearchKeyword)) continue;
                        showList.add(coursewareModel);
                    }
                    break;
                }
                showList.addAll(this.mCoursewareList);
                break;
            }
            case HomeworkFile: {
                if (this.mIsOnSearching) {
                    showList.addAll(this.mHomeworkSearchRstList);
                    break;
                }
                showList.addAll(this.mHomeworkModelList);
                break;
            }
            case CloudFile: {
                showList.addAll(this.mCloudFileList);
                break;
            }
        }
        return showList;
    }

    private LinkedHashMap<String, UploadDocModel> getUploadQueue() {
        LinkedHashMap<String, UploadDocModel> showUploadMap = new LinkedHashMap<String, UploadDocModel>();
        for (Map.Entry<String, UploadDocModel> entry : this.mUploadDocQueue.entrySet()) {
            boolean isLocalFileUpload;
            boolean isHomeWorkUpload = this.mTabState == TabState.HomeworkFile && entry.getValue().isHomeWork();
            boolean isCloudFileUpload = this.mTabState == TabState.CloudFile && entry.getValue().isCloudFile();
            boolean bl = isLocalFileUpload = this.mTabState == TabState.DocFile && !entry.getValue().isHomeWork() && !entry.getValue().isCloudFile();
            if (isHomeWorkUpload || isLocalFileUpload || isCloudFileUpload) {
                showUploadMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            entry.getValue().setItemView(null);
        }
        return showUploadMap;
    }

    public void notifyDataWithTab(TabState reqTab) {
        if (reqTab == this.mTabState || reqTab == null) {
            this.notifyDataSetChanged();
        }
    }

    public void updateAllDocList(List<LPDocModel> allDocList) {
        ArrayList<LPDocModel> tmpList = new ArrayList<LPDocModel>(allDocList);
        this.docCopy.clear();
        for (LPDocModel docModel : tmpList) {
            if ("0".equals(docModel.docId) || this.docCopy.contains(docModel)) continue;
            this.docCopy.add((LPCoursewareModel)docModel);
            this.checkSyncList(docModel);
        }
        this.sortCourseware();
        this.notifyDataWithTab(null);
    }

    public void updateMediaCoursewareList(List<LPMediaCoursewareModel> mediaCoursewareModelList) {
        this.mediaCoursewareCopy.clear();
        this.mediaCoursewareCopy.addAll(mediaCoursewareModelList);
        this.sortCourseware();
        this.notifyDataWithTab(null);
    }

    private void sortCourseware() {
        this.mCoursewareList.clear();
        Collections.sort(this.mediaCoursewareCopy, (o1, o2) -> o1.lastModified - o2.lastModified);
        Collections.sort(this.docCopy, (o1, o2) -> o1.lastModified - o2.lastModified);
        for (LPCoursewareModel coursewareModel : this.mediaCoursewareCopy) {
            if (coursewareModel.bindSource != 1) continue;
            this.mCoursewareList.add(coursewareModel);
        }
        for (LPCoursewareModel coursewareModel : this.docCopy) {
            if (coursewareModel.bindSource != 1) continue;
            this.mCoursewareList.add(coursewareModel);
        }
        for (LPCoursewareModel coursewareModel : this.mediaCoursewareCopy) {
            if (coursewareModel.bindSource != 0) continue;
            this.mCoursewareList.add(coursewareModel);
        }
        for (LPCoursewareModel coursewareModel : this.docCopy) {
            if (coursewareModel.bindSource != 0) continue;
            this.mCoursewareList.add(coursewareModel);
        }
    }

    private void checkSyncList(LPDocModel docModel) {
        for (String fileId : this.mWaitAddToPlayList) {
            if (!fileId.equals(docModel.docId)) continue;
            this.playCourseware((LPCoursewareModel)docModel);
            this.mWaitAddToPlayList.remove(fileId);
            break;
        }
        if (!this.mWaitAddToPreviewList.isEmpty()) {
            for (String fileId : this.mWaitAddToPreviewList) {
                if (!fileId.equals(docModel.docId)) continue;
                this.presenter.previewDoc(docModel);
                this.mWaitAddToPreviewList.remove(fileId);
                break;
            }
        }
    }

    public void updateAllHomework(LPResHomeworkAllModel homeworkAll) {
        ArrayList<String> homeworkIds = new ArrayList<String>();
        this.mHomeworkModelList.clear();
        for (LPHomeworkModel model : homeworkAll.getHomeworkModelList()) {
            if (homeworkIds.contains(model.getHomeworkId())) continue;
            homeworkIds.add(model.getHomeworkId());
            this.mHomeworkModelList.add(model);
        }
        this.notifyDataWithTab(TabState.HomeworkFile);
    }

    public void updateDownloadState(String homeworkId, BaseUIConstant.HomeworkDownloadState downloadState, float progress) {
        DownloadHomeworkModel downloadHomeworkModel = this.downloadHomeworkQueue.get(homeworkId);
        if (downloadHomeworkModel != null) {
            downloadHomeworkModel.setProgress(progress);
            downloadHomeworkModel.setDownloadState(downloadState);
            if (downloadHomeworkModel.getItemView() != null) {
                downloadHomeworkModel.getItemView().updateDownloadProgress(progress);
                if (downloadState == BaseUIConstant.HomeworkDownloadState.HasDownload) {
                    downloadHomeworkModel.getItemView().checkHomeworkFile(downloadHomeworkModel.getHomeworkModel());
                } else if (downloadState == BaseUIConstant.HomeworkDownloadState.DownloadFailed) {
                    downloadHomeworkModel.getItemView().showDownLoadFailed();
                }
            }
        }
    }

    public void cancelDownload(String homeworkId) {
        DownloadHomeworkModel downloadHomeworkModel = this.downloadHomeworkQueue.get(homeworkId);
        if (downloadHomeworkModel != null) {
            downloadHomeworkModel.setProgress(0.0f);
            downloadHomeworkModel.setDownloadState(BaseUIConstant.HomeworkDownloadState.NotExit);
            if (downloadHomeworkModel.getItemView() != null) {
                downloadHomeworkModel.getItemView().updateDownloadProgress(0.0f);
            }
        }
    }

    private void checkAndInitDownloadQueue(LPHomeworkModel homeworkModel, BaseCourseWareFileViewHolder viewHolder) {
        DownloadHomeworkModel downloadHomeworkModel = this.downloadHomeworkQueue.get(homeworkModel.getHomeworkId());
        File file = viewHolder.checkHomeworkFile(homeworkModel);
        BaseUIConstant.HomeworkDownloadState downloadState = viewHolder.getHomeworkDownloadState();
        if (downloadHomeworkModel == null) {
            DownloadHomeworkModel model = new DownloadHomeworkModel(homeworkModel, viewHolder);
            model.setDownloadState(downloadState);
            if (downloadState == BaseUIConstant.HomeworkDownloadState.Downloading && file != null) {
                boolean deleteRst = file.delete();
                if (deleteRst) {
                    LPLogger.d((String)"lzdTest", (String)"\u5220\u9664\u4e86\u9057\u7559\u7684\u4e0b\u8f7d\u4efb\u52a1\u6587\u4ef6");
                    viewHolder.checkHomeworkFile(homeworkModel);
                }
                model.setDownloadState(BaseUIConstant.HomeworkDownloadState.DownloadFailed);
            }
            this.downloadHomeworkQueue.put(homeworkModel.getHomeworkId(), model);
        } else {
            if (downloadState == BaseUIConstant.HomeworkDownloadState.Downloading) {
                viewHolder.updateDownloadProgress(downloadHomeworkModel.getProgress());
            } else if (downloadState == BaseUIConstant.HomeworkDownloadState.DownloadFailed) {
                viewHolder.showDownLoadFailed();
            }
            downloadHomeworkModel.setItemView(viewHolder);
        }
        viewHolder.setDownloadHomeworkModel(downloadHomeworkModel);
    }

    public void setOnSearching(boolean onSearching) {
        if (this.mIsOnSearching != onSearching) {
            this.mIsOnSearching = onSearching;
            this.notifyDataWithTab(null);
        }
    }

    public void updateDocSearchKeyword(String keyword) {
        this.docSearchKeyword = keyword;
        this.notifyDataWithTab(null);
    }

    public void updateHomeworkSearchRst(LPResHomeworkAllModel searchRst) {
        ArrayList<String> homeworkIds = new ArrayList<String>();
        this.mHomeworkSearchRstList.clear();
        if (searchRst == null) {
            this.notifyDataWithTab(TabState.HomeworkFile);
            return;
        }
        for (LPHomeworkModel model : searchRst.getHomeworkModelList()) {
            if (homeworkIds.contains(model.getHomeworkId())) continue;
            homeworkIds.add(model.getHomeworkId());
            this.mHomeworkSearchRstList.add(model);
        }
        this.notifyDataWithTab(TabState.HomeworkFile);
    }

    public void updateAllCloudFile(List<LPCloudFileModel> allCloudFile) {
        this.mCloudFileList = new ArrayList<LPCloudFileModel>(allCloudFile);
        this.notifyDataWithTab(TabState.CloudFile);
    }

    public void updateUploadState(LPUploadingDocumentModel uploadingDocModel, BaseUIConstant.FileUploadState newState, LPDocTranslateProgressModel progressModel) {
        UploadDocModel model = this.mUploadDocQueue.get(uploadingDocModel.getFilePath());
        if (model != null) {
            if (newState == model.getNowState()) {
                return;
            }
            model.setFileId(uploadingDocModel.getFileId());
            model.setHomeworkId(uploadingDocModel.getHomeworkId());
            model.setNowState(newState);
            if (model.getItemView() != null) {
                model.getItemView().setFileState(model.getNowState());
            }
            if (progressModel != null) {
                model.setErrorModel(progressModel);
            }
            if (model.isHomeWork()) {
                this.notifyDataWithTab(TabState.HomeworkFile);
            } else if (model.isCloudFile()) {
                this.notifyDataWithTab(TabState.CloudFile);
            } else {
                this.notifyDataWithTab(TabState.DocFile);
            }
        }
    }

    public void addUploadModel(LPUploadingDocumentModel model) {
        if (model.isHomework()) {
            this.mUploadDocQueue.put(model.getFilePath(), new UploadDocModel(model.getFilePath(), true, false));
            this.notifyDataWithTab(TabState.HomeworkFile);
        } else if (model.isCloudFile()) {
            this.mUploadDocQueue.put(model.getFilePath(), new UploadDocModel(model.getFilePath(), false, model.isAnimPPT(), true));
            this.notifyDataWithTab(TabState.CloudFile);
        } else {
            this.mUploadDocQueue.put(model.getFilePath(), new UploadDocModel(model.getFilePath(), model.isAnimPPT()));
            this.notifyDataWithTab(TabState.DocFile);
        }
    }

    public void removeUpload(String path) {
        UploadDocModel docModel = (UploadDocModel)this.mUploadDocQueue.remove(path);
        if (docModel == null) {
            return;
        }
        if (docModel.isHomeWork()) {
            this.notifyDataWithTab(TabState.HomeworkFile);
        } else if (docModel.isCloudFile()) {
            this.notifyDataWithTab(TabState.CloudFile);
        } else {
            this.notifyDataWithTab(TabState.DocFile);
        }
    }

    public void updateTabState(TabState tabState) {
        if (this.mTabState != tabState) {
            this.mTabState = tabState;
            this.notifyDataSetChanged();
        }
    }

    public void onRoomLoseConnect() {
        for (UploadDocModel docModel : this.mUploadDocQueue.values()) {
            if (docModel.getNowState() != BaseUIConstant.FileUploadState.Uploading) continue;
            docModel.setNowState(BaseUIConstant.FileUploadState.UploadFailed);
            LPDocTranslateProgressModel errorModel2 = new LPDocTranslateProgressModel(-1, this.context.getString(R.string.base_course_manage_upload_fail_please_reupload));
            docModel.setErrorModel(errorModel2);
        }
    }

    private void playCourseware(LPCoursewareModel coursewareModel) {
        if (this.presenter == null) {
            return;
        }
        if (coursewareModel.ext != null && coursewareModel.ext.endsWith(".bds")) {
            LPDocModel docModel = (LPDocModel)coursewareModel;
            this.presenter.playBds(docModel);
            return;
        }
        if (coursewareModel.coursewareType == LPCoursewareModel.LPCoursewareType.DOC) {
            LPDocModel docModel = (LPDocModel)coursewareModel;
            if (FileUtils.isImageFile((String)docModel.ext) && !this.presenter.enableImageShowAsDoc()) {
                LPUploadDocModel lpUploadDocModel = new LPUploadDocModel();
                if (docModel.width != 0.0f) {
                    lpUploadDocModel.width = (int)docModel.width;
                    lpUploadDocModel.height = (int)docModel.height;
                } else {
                    int _100dp;
                    lpUploadDocModel.width = _100dp = UtilsKt.getDp((int)100);
                    lpUploadDocModel.height = _100dp;
                }
                lpUploadDocModel.url = docModel.url;
                try {
                    lpUploadDocModel.fileId = Long.parseLong(docModel.docId);
                }
                catch (NumberFormatException e) {
                    lpUploadDocModel.fileId = 0L;
                    e.printStackTrace();
                }
                if (this.courseWareViewListener != null) {
                    this.courseWareViewListener.onPlayImg(lpUploadDocModel);
                }
            } else if (!this.presenter.playDoc(docModel)) {
                return;
            }
            if (this.courseWareViewListener != null) {
                this.courseWareViewListener.onReminderMsg(this.context.getString(R.string.base_course_manage_has_open_doc));
            }
        } else {
            this.presenter.playMediaCourseware((LPMediaCoursewareModel)coursewareModel);
        }
    }

    public void destroy() {
        this.mCoursewareList.clear();
        this.mHomeworkModelList.clear();
        this.mHomeworkSearchRstList.clear();
        this.mUploadDocQueue.clear();
        this.downloadHomeworkQueue.clear();
        this.mIsOnSearching = false;
        this.docSearchKeyword = "";
        this.mWaitAddToPlayList.clear();
        this.mWaitAddToPreviewList.clear();
        this.presenter = null;
    }

    class HomeworkItemClickListener
    extends BaseCourseWareItemClickListener
    implements BaseCourseWareFileViewHolder.IOnHomeworkItemClickListener {
        private LPHomeworkModel homeworkModel;

        public HomeworkItemClickListener(LPHomeworkModel homeworkModel) {
            this.homeworkModel = homeworkModel;
        }

        @Override
        public void onPlay() {
            int checkCanPlayRst = this.checkCanPlay(this.homeworkModel.getFext());
            if (checkCanPlayRst != 0) {
                BaseCourseWareFileAdapter.this.courseWareViewListener.onReminderMsg(BaseCourseWareFileAdapter.this.context.getString(checkCanPlayRst));
                return;
            }
            if (!this.homeworkModel.isCanPreview() || BaseCourseWareFileAdapter.this.mWaitAddToPlayList.contains(this.homeworkModel.getFid()) || BaseCourseWareFileAdapter.this.presenter == null) {
                return;
            }
            BaseCourseWareFileAdapter.this.presenter.requestFileTransfer((IFileModel)LPUploadHomeworkModel.copyData((LPHomeworkModel)this.homeworkModel), new BaseCourseWareContract.IOnRequestTransferListener(){

                @Override
                public void onSuccess(LPDocModel docModel) {
                    BaseCourseWareFileAdapter.this.playCourseware((LPCoursewareModel)docModel);
                    BaseCourseWareFileAdapter.this.notifyDataWithTab(TabState.HomeworkFile);
                }

                @Override
                public void onWaitForDocAdd() {
                    BaseCourseWareFileAdapter.this.mWaitAddToPlayList.add(HomeworkItemClickListener.this.homeworkModel.getFid());
                }
            });
        }

        @Override
        public void onDelete(String homeworkId) {
            if (TextUtils.isEmpty((CharSequence)homeworkId)) {
                return;
            }
            BaseCourseWareFileAdapter.this.courseWareViewListener.onDeleteHomework(homeworkId);
        }

        @Override
        public void onPreview() {
            int checkCanPlayRst = this.checkCanPlay(this.homeworkModel.getFext());
            if (checkCanPlayRst != 0) {
                BaseCourseWareFileAdapter.this.courseWareViewListener.onReminderMsg(BaseCourseWareFileAdapter.this.context.getString(checkCanPlayRst));
                return;
            }
            if (!this.homeworkModel.isCanPreview() || BaseCourseWareFileAdapter.this.mWaitAddToPreviewList.contains(this.homeworkModel.getFid()) || BaseCourseWareFileAdapter.this.presenter == null) {
                return;
            }
            BaseCourseWareFileAdapter.this.presenter.requestFileTransfer((IFileModel)LPUploadHomeworkModel.copyData((LPHomeworkModel)this.homeworkModel), new BaseCourseWareContract.IOnRequestTransferListener(){

                @Override
                public void onSuccess(LPDocModel docModel) {
                    BaseCourseWareFileAdapter.this.presenter.previewDoc(docModel);
                    BaseCourseWareFileAdapter.this.notifyDataWithTab(TabState.HomeworkFile);
                }

                @Override
                public void onWaitForDocAdd() {
                    BaseCourseWareFileAdapter.this.mWaitAddToPreviewList.add(HomeworkItemClickListener.this.homeworkModel.getFid());
                }
            });
        }

        @Override
        public void onDownload(File file) {
            if (BaseCourseWareFileAdapter.this.presenter != null) {
                BaseCourseWareFileAdapter.this.presenter.downloadHomework(this.homeworkModel, file);
            }
        }

        @Override
        public void onCancelDownload(File file) {
            if (BaseCourseWareFileAdapter.this.presenter != null) {
                BaseCourseWareFileAdapter.this.presenter.cancelDownloadHomework(file);
            }
        }
    }

    class UploadItemClickListener
    implements BaseCourseWareFileViewHolder.IOnUploadItemClickListener {
        private UploadDocModel uploadDocModel;

        public UploadItemClickListener(UploadDocModel uploadDocModel) {
            this.uploadDocModel = uploadDocModel;
        }

        @Override
        public void onPlay() {
        }

        @Override
        public void onDelete(String fileId) {
            BaseCourseWareFileAdapter.this.removeUpload(this.uploadDocModel.getPath());
        }

        @Override
        public void onPreview() {
        }

        @Override
        public void onUploadByNormal() {
            if (BaseCourseWareFileAdapter.this.presenter != null) {
                BaseCourseWareFileAdapter.this.presenter.sendPPTDocument(this.uploadDocModel.getPath(), false);
            }
        }

        @Override
        public void onReUpload(String fileId) {
            if (BaseCourseWareFileAdapter.this.courseWareViewListener != null) {
                BaseCourseWareFileAdapter.this.courseWareViewListener.onDeleteDoc(fileId, true);
            }
            if (BaseCourseWareFileAdapter.this.presenter != null) {
                BaseCourseWareFileAdapter.this.presenter.sendPPTDocument(this.uploadDocModel.getPath(), this.uploadDocModel.isAnim());
            }
        }

        @Override
        public void onCancelUpload() {
            BaseCourseWareFileAdapter.this.removeUpload(this.uploadDocModel.getPath());
            BaseCourseWareFileAdapter.this.courseWareViewListener.onReminderMsg(BaseCourseWareFileAdapter.this.context.getString(R.string.base_course_manage_cancel_upload));
            BaseCourseWareFileAdapter.this.presenter.cancelUpload(this.uploadDocModel.getPath());
        }

        @Override
        public void onCancelTransfer() {
            BaseCourseWareFileAdapter.this.courseWareViewListener.onCancelTransfer(this.uploadDocModel);
        }
    }

    class CloudItemClickListener
    extends BaseCourseWareItemClickListener
    implements BaseCourseWareFileViewHolder.IOnCloudItemClickListener {
        LPCloudFileModel cloudFileModel;

        public CloudItemClickListener(LPCloudFileModel cloudFileModel) {
            this.cloudFileModel = cloudFileModel;
        }

        @Override
        public void onPlay() {
            if (this.cloudFileModel.isDirectory()) {
                return;
            }
            int checkCanPlayRst = this.checkCanPlay(this.cloudFileModel.getFExt());
            if (checkCanPlayRst != 0) {
                if (this.cloudFileModel.videoInfo != null) {
                    BaseCourseWareFileAdapter.this.presenter.playMediaCourseware(new LPMediaCoursewareModel(this.cloudFileModel));
                } else {
                    BaseCourseWareFileAdapter.this.courseWareViewListener.onReminderMsg(BaseCourseWareFileAdapter.this.context.getString(checkCanPlayRst));
                }
                return;
            }
            if (BaseCourseWareFileAdapter.this.mWaitAddToPlayList.contains(this.cloudFileModel.getFileId()) || BaseCourseWareFileAdapter.this.presenter == null) {
                return;
            }
            BaseCourseWareFileAdapter.this.presenter.requestFileTransfer((IFileModel)this.cloudFileModel, new BaseCourseWareContract.IOnRequestTransferListener(){

                @Override
                public void onSuccess(LPDocModel docModel) {
                    BaseCourseWareFileAdapter.this.playCourseware((LPCoursewareModel)docModel);
                    BaseCourseWareFileAdapter.this.notifyDataWithTab(TabState.CloudFile);
                }

                @Override
                public void onWaitForDocAdd() {
                    BaseCourseWareFileAdapter.this.mWaitAddToPlayList.add(CloudItemClickListener.this.cloudFileModel.getFileId());
                }
            });
        }

        @Override
        public void onDelete(String id2) {
            BaseCourseWareFileAdapter.this.courseWareViewListener.onDeleteCloudFile(this.cloudFileModel);
        }

        @Override
        public void onPreview() {
        }

        @Override
        public void onClickDirectory() {
            if (!this.cloudFileModel.isDirectory()) {
                return;
            }
            BaseCourseWareFileAdapter.this.presenter.requestCloudFileInDir(this.cloudFileModel);
        }
    }

    class DocItemClickListener
    extends BaseCourseWareItemClickListener
    implements BaseCourseWareFileViewHolder.IOnDocItemClickListener {
        LPCoursewareModel coursewareModel;

        public DocItemClickListener(LPCoursewareModel coursewareModel) {
            this.coursewareModel = coursewareModel;
        }

        @Override
        public void onPlay() {
            int checkCanPlayRst;
            if (this.coursewareModel.coursewareType == LPCoursewareModel.LPCoursewareType.DOC && (checkCanPlayRst = this.checkCanPlay(this.coursewareModel.ext)) != 0) {
                BaseCourseWareFileAdapter.this.courseWareViewListener.onReminderMsg(BaseCourseWareFileAdapter.this.context.getString(checkCanPlayRst));
                return;
            }
            BaseCourseWareFileAdapter.this.playCourseware(this.coursewareModel);
        }

        @Override
        public void onDelete(String fileId) {
            if (BaseCourseWareFileAdapter.this.courseWareViewListener != null) {
                if (this.coursewareModel.coursewareType == LPCoursewareModel.LPCoursewareType.DOC) {
                    BaseCourseWareFileAdapter.this.courseWareViewListener.onDeleteDoc(((LPDocModel)this.coursewareModel).docId, false);
                } else {
                    BaseCourseWareFileAdapter.this.courseWareViewListener.onDeleteMediaCourseware(this.coursewareModel.number);
                }
            }
        }

        @Override
        public void onPreview() {
            BaseCourseWareFileAdapter.this.presenter.previewDoc((LPDocModel)this.coursewareModel);
        }
    }
}

