/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.baijiayun.liveuibase.R;

public class EllipsizeTextView
extends AppCompatTextView {
    private Paint mPaint;
    private int saveLength = 1;

    public EllipsizeTextView(@NonNull Context context2) {
        this(context2, null);
    }

    public EllipsizeTextView(@NonNull Context context2, @Nullable AttributeSet attrs) {
        this(context2, attrs, 0);
    }

    public EllipsizeTextView(@NonNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init(context2, attrs);
    }

    private void init(Context context2, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context2.obtainStyledAttributes(attrs, R.styleable.BJYEllipsizeTextView);
            this.saveLength = typedArray.getInteger(R.styleable.BJYEllipsizeTextView_saveWordLength, 0);
            typedArray.recycle();
        }
        this.setSingleLine(true);
        this.setEllipsize(TextUtils.TruncateAt.END);
        this.mPaint = this.getPaint();
        this.mPaint.setAntiAlias(true);
    }

    public void setSaveLength(int saveLength) {
        this.saveLength = saveLength;
    }

    protected void onDraw(Canvas canvas) {
        if (!this.drawText(canvas)) {
            super.onDraw(canvas);
        }
    }

    private boolean drawText(Canvas canvas) {
        String text = this.getText().toString();
        int mViewWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        float textWidth = this.mPaint.measureText(text);
        if (textWidth > (float)mViewWidth && this.saveLength > 0) {
            String ellipsizeText = "..." + text.substring(Math.max(0, text.length() - this.saveLength));
            float ellipsisWidth = this.mPaint.measureText(ellipsizeText);
            float authenticTextWidth = (float)mViewWidth - ellipsisWidth;
            for (int i = 0; i < text.length() - this.saveLength; ++i) {
                if (!(this.mPaint.measureText(text.substring(0, i + 1)) > authenticTextWidth)) continue;
                text = text.substring(0, i) + ellipsizeText;
                break;
            }
            float lineY = (float)(this.getMeasuredHeight() - this.getPaddingBottom()) - 13.0f;
            float lineX = this.getPaddingLeft();
            canvas.drawText(text, lineX, lineY, this.mPaint);
            return true;
        }
        return false;
    }
}

