/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import com.baijiayun.liveuibase.R;

public class CheckImageView
extends AppCompatImageView {
    private Drawable checkedImg;
    private Drawable unCheckedImg;
    private boolean isChecked;
    private OnCheckedChangeListener listener;
    private static final int[] STATE_CHECKED = new int[]{R.attr.bjlive_state_checked_img};
    private boolean stateChecked;

    public CheckImageView(Context context2) {
        this(context2, null);
    }

    public CheckImageView(Context context2, AttributeSet attrs) {
        this(context2, attrs, 0);
    }

    public CheckImageView(Context context2, AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init(context2, attrs);
    }

    private void init(Context context2, AttributeSet attrs) {
        TypedArray typedArray = context2.obtainStyledAttributes(attrs, R.styleable.BJYCheckImageView);
        this.isChecked = typedArray.getBoolean(R.styleable.BJYCheckImageView_bjlive_is_checked, false);
        int checkedImgResId = typedArray.getResourceId(R.styleable.BJYCheckImageView_bjlive_check_img, 0);
        int unCheckedImgResId = typedArray.getResourceId(R.styleable.BJYCheckImageView_bjlive_uncheck_img, 0);
        if (checkedImgResId != 0) {
            this.checkedImg = AppCompatResources.getDrawable((Context)context2, (int)checkedImgResId);
        }
        if (unCheckedImgResId != 0) {
            this.unCheckedImg = AppCompatResources.getDrawable((Context)context2, (int)unCheckedImgResId);
        }
        typedArray.recycle();
        this.setCheckedDrawable();
    }

    public void setChecked(boolean isChecked) {
        this.isChecked = isChecked;
        this.setCheckedDrawable();
        if (this.listener != null) {
            this.listener.onCheckedChanged(isChecked);
        }
    }

    public void setCheckedDrawable(Drawable drawable2) {
        this.checkedImg = drawable2;
        this.setCheckedDrawable();
    }

    public void setUnCheckedDrawable(Drawable drawable2) {
        this.unCheckedImg = drawable2;
        this.setCheckedDrawable();
    }

    private void setCheckedDrawable() {
        if (this.isChecked) {
            this.setImageDrawable(this.checkedImg);
        } else {
            this.setImageDrawable(this.unCheckedImg);
        }
    }

    public Drawable getUnCheckedImg() {
        return this.unCheckedImg;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener2) {
        this.listener = listener2;
    }

    public void setStateChecked(boolean stateChecked) {
        if (this.stateChecked != stateChecked) {
            this.stateChecked = stateChecked;
            this.refreshDrawableState();
        }
    }

    public int[] onCreateDrawableState(int extraSpace) {
        if (this.stateChecked) {
            int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
            CheckImageView.mergeDrawableStates((int[])drawableState, (int[])STATE_CHECKED);
            return drawableState;
        }
        return super.onCreateDrawableState(extraSpace);
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(boolean var1);
    }
}

