/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.liveuibase.R;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0014J(\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0007H\u0014J\u0016\u0010,\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/baijiayun/liveuibase/widgets/PKView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "leftClipRectF", "Landroid/graphics/RectF;", "leftCountText", "", "leftRect", "leftShader", "Landroid/graphics/LinearGradient;", "leftVoteCount", "mHeight", "mWidth", "paint", "Landroid/graphics/Paint;", "radiusCorner", "", "rightClipRectF", "rightCountText", "rightRect", "rightShader", "rightVoteCount", "textMargin", "textPaint", "Landroid/text/TextPaint;", "textWidth", "init", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "oldw", "oldh", "setPKData", "liveuibase_release"})
public final class PKView
extends View {
    private int mWidth;
    private int mHeight;
    private int leftVoteCount;
    private int rightVoteCount;
    private Paint paint;
    private TextPaint textPaint;
    @NotNull
    private RectF leftRect;
    @NotNull
    private RectF rightRect;
    @NotNull
    private RectF leftClipRectF;
    @NotNull
    private RectF rightClipRectF;
    @Nullable
    private LinearGradient leftShader;
    @Nullable
    private LinearGradient rightShader;
    private final int textWidth;
    private final float textMargin;
    private final float radiusCorner;
    @NotNull
    private String leftCountText;
    @NotNull
    private String rightCountText;
    @NotNull
    public Map<Integer, View> _$_findViewCache;

    @JvmOverloads
    public PKView(@NotNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this._$_findViewCache = new LinkedHashMap();
        super(context2, attrs, defStyleAttr);
        this.leftVoteCount = -1;
        this.rightVoteCount = -1;
        this.leftRect = new RectF();
        this.rightRect = new RectF();
        this.leftClipRectF = new RectF();
        this.rightClipRectF = new RectF();
        this.textWidth = UtilsKt.getDp((int)45);
        this.textMargin = UtilsKt.getDp((float)8.0f);
        this.radiusCorner = UtilsKt.getDp((float)4.0f);
        this.leftCountText = "";
        this.rightCountText = "";
        this.init();
    }

    public /* synthetic */ PKView(Context context2, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context2, attributeSet, n);
    }

    public PKView(@NotNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this._$_findViewCache = new LinkedHashMap();
        super(context2, attrs, defStyleAttr, defStyleRes);
        this.leftVoteCount = -1;
        this.rightVoteCount = -1;
        this.leftRect = new RectF();
        this.rightRect = new RectF();
        this.leftClipRectF = new RectF();
        this.rightClipRectF = new RectF();
        this.textWidth = UtilsKt.getDp((int)45);
        this.textMargin = UtilsKt.getDp((float)8.0f);
        this.radiusCorner = UtilsKt.getDp((float)4.0f);
        this.leftCountText = "";
        this.rightCountText = "";
        this.init();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.leftRect.left = 0.0f;
        this.leftRect.top = 0.0f;
        this.leftRect.bottom = h;
        this.rightRect.top = 0.0f;
        this.rightRect.bottom = h;
        if (this.leftVoteCount <= 0 && this.rightVoteCount <= 0) {
            this.setPKData(this.leftVoteCount, this.rightVoteCount);
        }
    }

    private final void init() {
        this.paint = new Paint();
        Paint paint2 = this.paint;
        if (paint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
            paint2 = null;
        }
        paint2.setAntiAlias(true);
        this.textPaint = new TextPaint();
        TextPaint textPaint = this.textPaint;
        if (textPaint == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
            textPaint = null;
        }
        textPaint.setColor(-1);
        TextPaint textPaint2 = this.textPaint;
        if (textPaint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
            textPaint2 = null;
        }
        textPaint2.setTextSize(UtilsKt.getDp((float)14.0f));
    }

    protected void onDraw(@NotNull Canvas canvas) {
        float rightTextWidth;
        TextPaint textPaint;
        float leftTextWidth;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.mWidth <= 0 || this.mHeight <= 0) {
            return;
        }
        if (this.leftShader != null) {
            Paint paint2 = this.paint;
            if (paint2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
                paint2 = null;
            }
            paint2.setShader((Shader)this.leftShader);
            canvas.save();
            canvas.clipRect(this.leftClipRectF);
            Paint paint3 = this.paint;
            if (paint3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
                paint3 = null;
            }
            canvas.drawRoundRect(this.leftRect, this.radiusCorner, this.radiusCorner, paint3);
            canvas.restore();
        }
        if (this.rightShader != null) {
            Paint paint4 = this.paint;
            if (paint4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
                paint4 = null;
            }
            paint4.setShader((Shader)this.rightShader);
            canvas.save();
            canvas.clipRect(this.rightClipRectF);
            Paint paint5 = this.paint;
            if (paint5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"paint");
                paint5 = null;
            }
            canvas.drawRoundRect(this.rightRect, this.radiusCorner, this.radiusCorner, paint5);
            canvas.restore();
        }
        float f = this.leftRect.centerY();
        TextPaint textPaint2 = this.textPaint;
        if (textPaint2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
            textPaint2 = null;
        }
        float f2 = textPaint2.getFontMetrics().bottom;
        TextPaint textPaint3 = this.textPaint;
        if (textPaint3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
            textPaint3 = null;
        }
        float f3 = f - (f2 - textPaint3.getFontMetrics().top) / (float)2;
        TextPaint textPaint4 = this.textPaint;
        if (textPaint4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
            textPaint4 = null;
        }
        float textBottomY = f3 - textPaint4.getFontMetrics().top;
        TextPaint textPaint5 = this.textPaint;
        if (textPaint5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
            textPaint5 = null;
        }
        if ((leftTextWidth = textPaint5.measureText(this.leftCountText)) > (float)this.textWidth - this.textMargin) {
            CharSequence charSequence = this.leftCountText;
            TextPaint textPaint6 = this.textPaint;
            if (textPaint6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
                textPaint6 = null;
            }
            String s = ((Object)TextUtils.ellipsize((CharSequence)charSequence, (TextPaint)textPaint6, (float)leftTextWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END)).toString();
            TextPaint textPaint7 = this.textPaint;
            if (textPaint7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
                textPaint7 = null;
            }
            canvas.drawText(s, this.textMargin, textBottomY, (Paint)textPaint7);
        } else {
            TextPaint textPaint8 = this.textPaint;
            if (textPaint8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
                textPaint8 = null;
            }
            canvas.drawText(this.leftCountText, this.textMargin, textBottomY, (Paint)textPaint8);
        }
        if ((textPaint = this.textPaint) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
            textPaint = null;
        }
        if ((rightTextWidth = textPaint.measureText(this.rightCountText)) > (float)this.textWidth - this.textMargin) {
            CharSequence charSequence = this.rightCountText;
            TextPaint textPaint9 = this.textPaint;
            if (textPaint9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
                textPaint9 = null;
            }
            String s = ((Object)TextUtils.ellipsize((CharSequence)charSequence, (TextPaint)textPaint9, (float)leftTextWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END)).toString();
            float f4 = (float)this.mWidth - this.textMargin - rightTextWidth;
            TextPaint textPaint10 = this.textPaint;
            if (textPaint10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
                textPaint10 = null;
            }
            canvas.drawText(s, f4, textBottomY, (Paint)textPaint10);
        } else {
            float f5 = (float)this.mWidth - this.textMargin - rightTextWidth;
            TextPaint textPaint11 = this.textPaint;
            if (textPaint11 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"textPaint");
                textPaint11 = null;
            }
            canvas.drawText(this.rightCountText, f5, textBottomY, (Paint)textPaint11);
        }
    }

    public final void setPKData(int leftVoteCount, int rightVoteCount) {
        int width;
        Object[] objectArray = new Object[]{leftVoteCount};
        String string2 = this.getContext().getString(R.string.bjy_base_pk_vote_count, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026ote_count, leftVoteCount)");
        this.leftCountText = string2;
        objectArray = new Object[]{rightVoteCount};
        String string3 = this.getContext().getString(R.string.bjy_base_pk_vote_count, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026te_count, rightVoteCount)");
        this.rightCountText = string3;
        this.leftVoteCount = leftVoteCount;
        this.rightVoteCount = rightVoteCount;
        int leftWidth = leftVoteCount <= 0 && rightVoteCount <= 0 ? this.mWidth / 2 - this.textWidth : ((width = (int)(1.0f * (float)leftVoteCount / (float)(leftVoteCount + rightVoteCount) * (float)(this.mWidth - 2 * this.textWidth))) < this.textWidth ? this.textWidth : width);
        this.rightRect.left = this.leftRect.right = (float)(leftWidth + this.textWidth);
        this.rightRect.right = this.mWidth;
        this.leftShader = new LinearGradient(this.leftRect.left, this.leftRect.top, this.leftRect.right, this.leftRect.bottom, Color.parseColor((String)"#FFAE38F6"), Color.parseColor((String)"#FF1e5eff"), Shader.TileMode.CLAMP);
        this.rightShader = new LinearGradient(this.rightRect.left, this.rightRect.top, this.rightRect.right, this.rightRect.bottom, Color.parseColor((String)"#FFF7CA63"), Color.parseColor((String)"#FFEA4874"), Shader.TileMode.CLAMP);
        this.leftClipRectF.set(this.leftRect.left, this.leftRect.top, this.leftRect.right, this.leftRect.bottom);
        this.rightClipRectF.set(this.rightRect.left, this.rightRect.top, this.rightRect.right, this.rightRect.bottom);
        RectF rectF = this.leftRect;
        rectF.right += this.radiusCorner;
        rectF = this.rightRect;
        rectF.left -= this.radiusCorner;
        this.invalidate();
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2 = this.findViewById(id2);
            if (view2 != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    @JvmOverloads
    public PKView(@NotNull Context context2, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, attrs, 0, 4, null);
    }

    @JvmOverloads
    public PKView(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this(context2, null, 0, 6, null);
    }
}

