/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.RelativeLayout;
import com.baijiayun.bjyutils.kt.UtilsKt;

public class DragScaleRelativeLayout
extends RelativeLayout {
    private int threshold;
    private int dragThresholdY;
    private int dragThresholdXExcludeRight;
    private boolean canScaleOrDrag = true;
    private boolean forceNotConsume;

    public DragScaleRelativeLayout(Context context2) {
        this(context2, null);
    }

    public DragScaleRelativeLayout(Context context2, AttributeSet attrs) {
        this(context2, attrs, 0);
    }

    public DragScaleRelativeLayout(Context context2, AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init();
    }

    public DragScaleRelativeLayout(Context context2, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context2, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.threshold = UtilsKt.getDp((int)24);
        this.dragThresholdY = 0;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        boolean consume = this.canScaleOrDrag && this.isDownActionInScaleThreshold(event) || this.isDownActionInDragThreshold(event) || super.onInterceptTouchEvent(event);
        consume = !this.forceNotConsume && consume;
        return consume;
    }

    public void setCanScaleOrDrag(boolean canScaleOrDrag) {
        this.canScaleOrDrag = canScaleOrDrag;
    }

    public void setForceNotConsume(boolean forceNotConsume) {
        this.forceNotConsume = forceNotConsume;
    }

    private boolean isDownActionInDragThreshold(MotionEvent event) {
        return event.getAction() == 0 && event.getY() < (float)this.dragThresholdY && event.getX() < (float)(this.getWidth() - this.dragThresholdXExcludeRight);
    }

    public boolean isDownActionInScaleThreshold(MotionEvent event) {
        if (event.getAction() == 0) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            return this.getWidth() - x < this.threshold && this.getHeight() - y < this.threshold;
        }
        return false;
    }

    public void setDragThreshold(int dragThreshold) {
        this.setDragThreshold(0, dragThreshold);
    }

    public void setDragThreshold(int xThresholdExclude, int yThreshold) {
        this.dragThresholdY = yThreshold;
        this.dragThresholdXExcludeRight = xThresholdExclude;
    }
}

