/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.SoundPool;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.baijiayun.glide.Glide;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.utils.FrameAnimation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class AwardView
extends FrameLayout {
    private FrameAnimation frameAnimation;
    private AnimatorSet scaleInAnimatorSet;
    private AnimatorSet scaleOutAnimatorSet;
    private ObjectAnimator rotationAnimator;
    private ImageView starIv;
    private ImageView goldenShineIv;
    private ImageView medalIv;
    private TextView awardTextTv;
    private SoundPool soundPool;
    private int soundId;
    private float volumeCurrent = 1.0f;
    private int[] endPointLocation;
    private int[] startPointLocation = new int[2];
    public static final int TYPE_AWARD_USER = 1;
    public static final int TYPE_AWARD_GROUP = 2;
    public static final int TYPE_AWARD_ALL = 3;
    public static final int TYPE_AWARD_CUSTOM = 4;
    private boolean endAnimByMyself = false;
    ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
    ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{0.0f, 1.0f});
    private Runnable animRunnable = () -> {
        if (this.startPointLocation[0] == 0) {
            this.getLocationOnScreen(this.startPointLocation);
        }
        this.scaleOutAnimatorSet = new AnimatorSet();
        ObjectAnimator scaleOutX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{1.0f, 0.0f});
        ObjectAnimator scaleOutY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleY", (float[])new float[]{1.0f, 0.0f});
        this.scaleOutAnimatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        if (this.endPointLocation == null) {
            this.scaleOutAnimatorSet.play((Animator)scaleOutX).with((Animator)scaleOutY);
        } else {
            ObjectAnimator translateX = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{0.0f, this.endPointLocation[0] - this.startPointLocation[0] - this.getMeasuredWidth() / 2});
            ObjectAnimator translateY = ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationY", (float[])new float[]{0.0f, this.endPointLocation[1] - this.startPointLocation[1] - this.getMeasuredHeight() / 2});
            this.scaleOutAnimatorSet.setDuration(500L);
            this.scaleOutAnimatorSet.play((Animator)scaleOutX).with((Animator)scaleOutY).with((Animator)translateX).with((Animator)translateY);
        }
        this.scaleOutAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                AwardView.this.setX(AwardView.this.getLeft());
                AwardView.this.setY(AwardView.this.getTop());
                if (AwardView.this.endAnimByMyself) {
                    AwardView.this.endAnimByMyself = false;
                    return;
                }
                if (AwardView.this.frameAnimation != null) {
                    AwardView.this.frameAnimation.stop();
                    AwardView.this.frameAnimation = null;
                }
                if (AwardView.this.rotationAnimator != null) {
                    AwardView.this.rotationAnimator.cancel();
                    AwardView.this.rotationAnimator = null;
                }
                AwardView.this.releaseAudio();
                if (AwardView.this.scaleInAnimatorSet != null) {
                    AwardView.this.scaleInAnimatorSet.cancel();
                    AwardView.this.scaleInAnimatorSet.removeAllListeners();
                    AwardView.this.scaleInAnimatorSet = null;
                }
                AwardView.this.setVisibility(8);
            }
        });
        this.scaleOutAnimatorSet.start();
    };

    public AwardView(@NonNull Context context2) {
        this(context2, null);
    }

    public AwardView(@NonNull Context context2, @Nullable AttributeSet attrs) {
        this(context2, attrs, 0);
    }

    public AwardView(@NonNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        LayoutInflater.from((Context)context2).inflate(R.layout.uibase_layout_award, (ViewGroup)this);
        this.starIv = (ImageView)this.findViewById(R.id.award_start_iv);
        this.goldenShineIv = (ImageView)this.findViewById(R.id.golden_light_iv);
        this.medalIv = (ImageView)this.findViewById(R.id.award_medal_iv);
        this.awardTextTv = (TextView)this.findViewById(R.id.award_medal_text);
        this.setWillNotDraw(false);
        this.setOnClickListener(v -> this.cancelAnim());
    }

    public void setAwardText(String awardText) {
        this.awardTextTv.setText((CharSequence)awardText);
    }

    public void setAwardMedal(int awardType) {
        this.setAwardMedal(awardType, null);
    }

    public void setAwardMedal(int awardType, String pictureUrl) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.base_ic_award_user);
        switch (awardType) {
            case 1: {
                if (TextUtils.isEmpty((CharSequence)pictureUrl)) break;
                Glide.with((View)this.medalIv).load(pictureUrl).into(this.medalIv);
                break;
            }
            case 2: {
                drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.base_ic_awrad_group);
                break;
            }
            case 3: {
                drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.base_ic_awrad_all);
                break;
            }
        }
        if (TextUtils.isEmpty((CharSequence)pictureUrl)) {
            this.medalIv.setImageDrawable(drawable2);
        }
    }

    public void setEndPointLocation(int[] location) {
        this.endPointLocation = location;
    }

    public void startAnim() {
        if (this.frameAnimation != null) {
            this.frameAnimation.restartAnimation();
            this.rotationAnimator.setCurrentPlayTime(0L);
            this.rotationAnimator.start();
            this.scaleX.setCurrentPlayTime(0L);
            this.scaleY.setCurrentPlayTime(0L);
            this.scaleInAnimatorSet.start();
            if (this.scaleOutAnimatorSet != null && this.scaleOutAnimatorSet.isStarted()) {
                this.endAnimByMyself = true;
                this.scaleOutAnimatorSet.cancel();
                this.scaleOutAnimatorSet.removeAllListeners();
                this.scaleOutAnimatorSet = null;
            }
            this.removeCallbacks(this.animRunnable);
            this.postDelayed(this.animRunnable, 3000L);
        } else {
            this.initAnim();
        }
        this.playAudio();
    }

    public void initAnim() {
        this.frameAnimation = new FrameAnimation(this.starIv, this.getRes(), 33, true);
        this.frameAnimation.start();
        this.rotationAnimator = ObjectAnimator.ofFloat((Object)this.goldenShineIv, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
        this.rotationAnimator.setDuration(10000L);
        this.rotationAnimator.setRepeatCount(-1);
        this.rotationAnimator.setRepeatMode(2);
        this.rotationAnimator.start();
        this.scaleInAnimatorSet = new AnimatorSet();
        this.scaleInAnimatorSet.setDuration(500L);
        this.scaleInAnimatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.scaleInAnimatorSet.playTogether(new Animator[]{this.scaleX, this.scaleY});
        this.scaleInAnimatorSet.start();
        this.postDelayed(this.animRunnable, 3000L);
    }

    private int[] getRes() {
        TypedArray typedArray = this.getResources().obtainTypedArray(R.array.bjy_base_award_star);
        int len = typedArray.length();
        int[] resId = new int[len];
        for (int i = 0; i < len; ++i) {
            resId[i] = typedArray.getResourceId(i, -1);
        }
        typedArray.recycle();
        return resId;
    }

    private void playAudio() {
        this.releaseAudio();
        AudioManager am2 = (AudioManager)this.getContext().getSystemService("audio");
        if (am2 != null) {
            this.volumeCurrent = am2.getStreamVolume(3);
        }
        this.soundPool = new SoundPool(1, 3, 0);
        this.soundId = this.soundPool.load(this.getContext(), R.raw.award, 1);
        this.soundPool.setOnLoadCompleteListener((soundPool, sampleId, status) -> soundPool.play(this.soundId, this.volumeCurrent, this.volumeCurrent, 0, 0, 1.0f));
    }

    private void releaseAudio() {
        if (this.soundPool != null) {
            if (this.soundId != 0) {
                this.soundPool.unload(this.soundId);
            }
            this.soundPool.release();
            this.soundPool = null;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.animRunnable);
        this.cancelAnim();
    }

    private void cancelAnim() {
        this.releaseAudio();
        if (this.scaleOutAnimatorSet != null) {
            this.scaleOutAnimatorSet.cancel();
            this.scaleOutAnimatorSet.removeAllListeners();
            this.scaleOutAnimatorSet = null;
        }
        if (this.frameAnimation != null) {
            this.frameAnimation.stop();
            this.frameAnimation = null;
        }
        if (this.rotationAnimator != null) {
            this.rotationAnimator.cancel();
            this.rotationAnimator = null;
        }
        if (this.scaleInAnimatorSet != null) {
            this.scaleInAnimatorSet.cancel();
            this.scaleInAnimatorSet.removeAllListeners();
            this.scaleInAnimatorSet = null;
        }
        this.setVisibility(8);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AwardType {
    }
}

