/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.utils;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.RelativeLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.baijiayun.bjyutils.kt.UtilsKt;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class ShadowUtil {
    private WeakReference<View> needShadowView;
    private WeakReference<ViewGroup> shadowView;
    private int scaleUnitHor;
    private int scaleUnitVer;
    private int lastWidth;
    private int lastHeight;

    public static ShadowUtil Create() {
        return ShadowUtil.Create(0, 0);
    }

    public static ShadowUtil Create(int scaleUnitHor, int scaleUnitVer) {
        return new ShadowUtil(scaleUnitHor, scaleUnitVer);
    }

    private ShadowUtil(int scaleUnitHor, int scaleUnitVer) {
        this.scaleUnitHor = scaleUnitHor;
        this.scaleUnitVer = scaleUnitVer;
    }

    private void updateViewSize(WeakReference<View> view, WeakReference<ViewGroup> shadowView) {
        if (view != null && view.get() != null) {
            ((View)view.get()).post(() -> {
                if (shadowView == null || shadowView.get() == null) {
                    return;
                }
                this.setViewFamilyClipChildren((ViewGroup)shadowView.get());
                this.updateParentViewSize((ViewGroup)shadowView.get(), (View)view.get());
            });
        }
    }

    public View getShadowView() {
        return this.shadowView == null ? null : (View)this.shadowView.get();
    }

    public View getNeedShadowView() {
        return this.needShadowView == null ? null : (View)this.needShadowView.get();
    }

    private void updateParentViewSize(ViewGroup parentView, View view) {
        if (this.lastWidth != Math.max(view.getWidth() - this.scaleUnitHor, 0) || this.lastHeight != Math.max(view.getHeight() - this.scaleUnitVer, 0)) {
            this.lastWidth = Math.max(view.getWidth() - this.scaleUnitHor, 0);
            this.lastHeight = Math.max(view.getHeight() - this.scaleUnitVer, 0);
            if (view instanceof RelativeLayout) {
                parentView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.lastWidth, this.lastHeight));
            } else if (view instanceof ConstraintLayout) {
                parentView.setLayoutParams((ViewGroup.LayoutParams)new ConstraintLayout.LayoutParams(this.lastWidth, this.lastHeight));
            }
        }
    }

    private void setViewFamilyClipChildren(ViewGroup view) {
        if (view == null) {
            return;
        }
        view.setClipChildren(false);
        view.setClipToPadding(false);
        ViewParent rooter = view.getParent();
        while (rooter instanceof ViewGroup) {
            ((ViewGroup)rooter).setClipChildren(false);
            ((ViewGroup)rooter).setClipToPadding(false);
            rooter = rooter.getParent();
        }
    }

    public static ShadowGroup initShadowView(Context context2, View needShadow) {
        if (needShadow.getParent() != null) {
            return null;
        }
        ConstraintLayout contentView = new ConstraintLayout(context2);
        contentView.setLayoutParams((ViewGroup.LayoutParams)new ConstraintLayout.LayoutParams(-2, -2));
        ConstraintLayout.LayoutParams needShadowViewParams = needShadow.getLayoutParams() instanceof ConstraintLayout.LayoutParams ? (ConstraintLayout.LayoutParams)needShadow.getLayoutParams() : new ConstraintLayout.LayoutParams(-1, -2);
        needShadowViewParams.bottomToBottom = 0;
        needShadowViewParams.topToTop = 0;
        needShadowViewParams.startToStart = 0;
        needShadowViewParams.endToEnd = 0;
        needShadowViewParams.setMargins(UtilsKt.getDp((int)8), UtilsKt.getDp((int)8), UtilsKt.getDp((int)8), UtilsKt.getDp((int)8));
        needShadow.setLayoutParams((ViewGroup.LayoutParams)needShadowViewParams);
        if (needShadow.getId() == -1) {
            needShadow.setId(View.generateViewId());
        }
        contentView.addView(needShadow);
        RelativeLayout shadowContainer = new RelativeLayout(context2);
        ConstraintLayout.LayoutParams shadowParams = new ConstraintLayout.LayoutParams(0, 0);
        shadowParams.startToStart = needShadow.getId();
        shadowParams.endToEnd = needShadow.getId();
        shadowParams.topToTop = needShadow.getId();
        shadowParams.bottomToBottom = needShadow.getId();
        shadowContainer.setLayoutParams((ViewGroup.LayoutParams)shadowParams);
        contentView.addView((View)shadowContainer);
        return new ShadowGroup((View)contentView, (View)shadowContainer, needShadow);
    }

    public static ShadowUtil setViewBoundShadow(@NotNull View view) {
        return ShadowUtil.setViewBoundShadow(view, ShadowUtil.Create());
    }

    public static ShadowUtil setViewBoundShadow(@NotNull View view, @NotNull ShadowUtil shadowUtilValues) {
        if (shadowUtilValues.scaleUnitVer == 0) {
            shadowUtilValues.scaleUnitVer = UtilsKt.getDp((int)2);
        }
        if (shadowUtilValues.scaleUnitHor == 0) {
            shadowUtilValues.scaleUnitHor = UtilsKt.getDp((int)2);
        }
        int shadowSize = UtilsKt.getDp((int)8);
        int startColor = Color.parseColor((String)"#00000000");
        int endColor = Color.parseColor((String)"#050F0F0F");
        return ShadowUtil.setViewBoundShadow(view, shadowSize, startColor, endColor, shadowUtilValues);
    }

    public static ShadowUtil setViewBoundShadow(@NotNull View view, int shadowSize, int startColor, int endColor, @NotNull ShadowUtil shadowUtilValues) {
        if (shadowSize < 0) {
            return null;
        }
        if (shadowUtilValues.getShadowView() != null) {
            ((ViewGroup)shadowUtilValues.getShadowView().getParent()).removeView(shadowUtilValues.getShadowView());
            shadowUtilValues.shadowView = null;
            shadowUtilValues.needShadowView = null;
            shadowUtilValues.lastWidth = 0;
            shadowUtilValues.lastHeight = 0;
        }
        RelativeLayout parentView = new RelativeLayout(view.getContext());
        parentView.setId(View.generateViewId());
        if (view instanceof RelativeLayout || view instanceof ConstraintLayout) {
            ((ViewGroup)view).addView((View)parentView, new ViewGroup.LayoutParams(Math.max(view.getWidth() - shadowUtilValues.scaleUnitHor, 0), Math.max(view.getHeight() - shadowUtilValues.scaleUnitVer, 0)));
            if (view instanceof ConstraintLayout) {
                ConstraintLayout.LayoutParams params = new ConstraintLayout.LayoutParams(0, 0);
                params.startToStart = 0;
                params.topToTop = 0;
                parentView.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        } else if (!(view instanceof ViewGroup)) {
            parentView.addView(view);
        } else {
            return null;
        }
        class ChildValue {
            int width;
            int height;
            int horPos;
            int verPos;
            GradientDrawable.Orientation orientation;

            public ChildValue(int width, int height, int horPos, int verPos, GradientDrawable.Orientation orientation) {
                this.width = width;
                this.height = height;
                this.horPos = horPos;
                this.verPos = verPos;
                this.orientation = orientation;
            }
        }
        ChildValue[] childValues = new ChildValue[]{new ChildValue(shadowSize, shadowSize, 1, 1, null), new ChildValue(shadowSize, shadowSize, -1, 1, null), new ChildValue(shadowSize, shadowSize, -1, -1, null), new ChildValue(shadowSize, shadowSize, 1, -1, null), new ChildValue(shadowSize, 0, 1, 0, GradientDrawable.Orientation.RIGHT_LEFT), new ChildValue(shadowSize, 0, -1, 0, GradientDrawable.Orientation.LEFT_RIGHT), new ChildValue(0, shadowSize, 0, -1, GradientDrawable.Orientation.TOP_BOTTOM), new ChildValue(0, shadowSize, 0, 1, GradientDrawable.Orientation.BOTTOM_TOP)};
        int[] dirViewsId = new int[4];
        for (int i = 0; i < childValues.length; ++i) {
            RelativeLayout.LayoutParams childParams = new RelativeLayout.LayoutParams(childValues[i].width, childValues[i].height);
            View child = new View(view.getContext());
            if (childValues[i].horPos == 1) {
                childParams.addRule(21);
                childParams.rightMargin = -shadowSize - shadowUtilValues.scaleUnitHor;
            } else if (childValues[i].horPos == -1) {
                childParams.leftMargin = -shadowSize;
            }
            if (childValues[i].verPos == 1) {
                childParams.addRule(12);
                childParams.bottomMargin = -shadowSize - shadowUtilValues.scaleUnitVer;
            } else if (childValues[i].verPos == -1) {
                childParams.topMargin = -shadowSize;
            }
            if (i < dirViewsId.length) {
                child.setId(View.generateViewId());
                dirViewsId[i] = child.getId();
            } else if (childValues[i].horPos == 1 && childValues[i].verPos == 0) {
                childParams.addRule(2, dirViewsId[0]);
                childParams.addRule(3, dirViewsId[3]);
            } else if (childValues[i].horPos == -1 && childValues[i].verPos == 0) {
                childParams.addRule(2, dirViewsId[1]);
                childParams.addRule(3, dirViewsId[2]);
            } else if (childValues[i].horPos == 0 && childValues[i].verPos == -1) {
                childParams.addRule(0, dirViewsId[3]);
                childParams.addRule(1, dirViewsId[2]);
            } else if (childValues[i].horPos == 0 && childValues[i].verPos == 1) {
                childParams.addRule(0, dirViewsId[0]);
                childParams.addRule(1, dirViewsId[1]);
            }
            GradientDrawable childBg = new GradientDrawable();
            if (childValues[i].orientation != null) {
                childBg.setColors(new int[]{startColor, endColor});
                childBg.setOrientation(childValues[i].orientation);
            } else {
                childBg.setColors(new int[]{endColor, startColor});
                childBg.setGradientRadius((float)shadowSize);
                childBg.setGradientCenter((float)Math.max(0, -childValues[i].horPos), (float)Math.max(0, -childValues[i].verPos));
                childBg.setGradientType(1);
                childBg.setCornerRadii(new float[]{childValues[i].horPos + childValues[i].verPos == -2 ? (float)shadowSize : 0.0f, childValues[i].horPos + childValues[i].verPos == -2 ? (float)shadowSize : 0.0f, childValues[i].horPos == 1 && childValues[i].verPos == -1 ? (float)shadowSize : 0.0f, childValues[i].horPos == 1 && childValues[i].verPos == -1 ? (float)shadowSize : 0.0f, childValues[i].horPos + childValues[i].verPos == 2 ? (float)shadowSize : 0.0f, childValues[i].horPos + childValues[i].verPos == 2 ? (float)shadowSize : 0.0f, childValues[i].horPos == -1 && childValues[i].verPos == 1 ? (float)shadowSize : 0.0f, childValues[i].horPos == -1 && childValues[i].verPos == 1 ? (float)shadowSize : 0.0f});
            }
            child.setBackground((Drawable)childBg);
            child.setLayoutParams((ViewGroup.LayoutParams)childParams);
            parentView.addView(child);
        }
        shadowUtilValues.shadowView = new WeakReference<RelativeLayout>(parentView);
        shadowUtilValues.needShadowView = new WeakReference<View>(view);
        shadowUtilValues.updateViewSize(new WeakReference<View>(view), new WeakReference<RelativeLayout>(parentView));
        return shadowUtilValues;
    }

    public static void reInit(ShadowUtil shadowUtilValues) {
        if (shadowUtilValues.needShadowView == null || shadowUtilValues.needShadowView.get() == null || shadowUtilValues.shadowView == null || shadowUtilValues.shadowView.get() == null) {
            return;
        }
        shadowUtilValues.lastWidth = 0;
        shadowUtilValues.lastHeight = 0;
        shadowUtilValues.updateViewSize(new WeakReference<View>(shadowUtilValues.getNeedShadowView()), new WeakReference<ViewGroup>((ViewGroup)shadowUtilValues.getShadowView()));
        ((View)shadowUtilValues.needShadowView.get()).requestLayout();
    }

    public static class ShadowGroup {
        View contentView;
        View shadowContainer;
        View needShadow;

        private ShadowGroup(View contentView, View shadowContainer, View needShadow) {
            this.contentView = contentView;
            this.shadowContainer = shadowContainer;
            this.needShadow = needShadow;
        }

        public View getContentView() {
            return this.contentView;
        }

        public View getShadowContainer() {
            return this.shadowContainer;
        }

        public View getNeedShadow() {
            return this.needShadow;
        }
    }
}

