/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.baijiayun.liveuibase.utils.NetworkEnum;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NetworkUtils {
    public static String getIPAddress(Context context2) {
        NetworkInfo info = ((ConnectivityManager)context2.getApplicationContext().getSystemService("connectivity")).getActiveNetworkInfo();
        if (info != null && info.isConnected()) {
            if (info.getType() == 0) {
                try {
                    Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                    while (en.hasMoreElements()) {
                        NetworkInterface intf = en.nextElement();
                        Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                        while (enumIpAddr.hasMoreElements()) {
                            InetAddress inetAddress = enumIpAddr.nextElement();
                            if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                            return inetAddress.getHostAddress();
                        }
                    }
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            } else {
                if (info.getType() == 1) {
                    WifiManager wifiManager = (WifiManager)context2.getApplicationContext().getSystemService("wifi");
                    WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                    return NetworkUtils.intIP2StringIP(wifiInfo.getIpAddress());
                }
                if (info.getType() == 9) {
                    return NetworkUtils.getEtherNetIP();
                }
            }
        }
        return "";
    }

    public static String getEtherNetIP() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            Log.e((String)"WifiPreference", (String)ex.toString());
        }
        return "0.0.0.0";
    }

    public static String intIP2StringIP(int ip) {
        return (ip & 0xFF) + "." + (ip >> 8 & 0xFF) + "." + (ip >> 16 & 0xFF) + "." + (ip >> 24 & 0xFF);
    }

    @RequiresApi(api=24)
    public static NetworkEnum getNetworkState(Context context2) {
        NetworkInfo.State state;
        ConnectivityManager connManager = (ConnectivityManager)context2.getApplicationContext().getSystemService("connectivity");
        NetworkInfo activeNetInfo = connManager.getActiveNetworkInfo();
        if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
            return NetworkEnum.NETWORK_STATE_NONE;
        }
        NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
        if (null != wifiInfo && null != (state = wifiInfo.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return NetworkEnum.NETWORK_STATE_WIFI;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context2.getSystemService("phone");
        int networkType = telephonyManager.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return NetworkEnum.NETWORK_STATE_2G;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return NetworkEnum.NETWORK_STATE_3G;
            }
            case 13: {
                return NetworkEnum.NETWORK_STATE_4G;
            }
            case 20: {
                return NetworkEnum.NETWORK_STATE_5G;
            }
        }
        return NetworkEnum.NETWORK_STATE_MOBILE_UNKNOWN;
    }

    public static boolean isNetConnected(Context context2) {
        NetworkInfo info;
        ConnectivityManager connectivity = (ConnectivityManager)context2.getApplicationContext().getSystemService("connectivity");
        if (connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected()) {
            return info.getState() == NetworkInfo.State.CONNECTED;
        }
        return false;
    }

    public static synchronized boolean isWifiConnected(Context context2) {
        int networkInfoType;
        NetworkInfo networkInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context2.getSystemService("connectivity");
        if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && ((networkInfoType = networkInfo.getType()) == 1 || networkInfoType == 9)) {
            return networkInfo.isConnected();
        }
        return false;
    }
}

