/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.widget.ImageView;

public class FrameAnimation {
    private boolean mIsRepeat;
    private AnimationListener mAnimationListener;
    private ImageView mImageView;
    private int[] mFrameRes;
    private int[] mDurations;
    private int mDuration;
    private int mDelay;
    private int mLastFrame;
    private boolean mNext;
    private boolean mPause;
    private int mCurrentSelect;
    private int mCurrentFrame;
    private static final int SELECTED_A = 1;
    private static final int SELECTED_B = 2;
    private static final int SELECTED_C = 3;
    private static final int SELECTED_D = 4;
    private int imageViewWidth = 0;
    private int imageViewHeight = 0;

    public FrameAnimation(ImageView iv, int[] frameRes, int duration, boolean isRepeat) {
        this.mImageView = iv;
        this.mFrameRes = frameRes;
        this.mDuration = duration;
        this.mLastFrame = frameRes.length - 1;
        this.mIsRepeat = isRepeat;
    }

    public FrameAnimation(ImageView iv, int[] frameRess, int[] durations, boolean isRepeat) {
        this.mImageView = iv;
        this.mFrameRes = frameRess;
        this.mDurations = durations;
        this.mLastFrame = frameRess.length - 1;
        this.mIsRepeat = isRepeat;
    }

    public FrameAnimation(ImageView iv, int[] frameRess, int duration, int delay) {
        this.mImageView = iv;
        this.mFrameRes = frameRess;
        this.mDuration = duration;
        this.mDelay = delay;
        this.mLastFrame = frameRess.length - 1;
    }

    public FrameAnimation(ImageView iv, int[] frameRess, int[] durations, int delay) {
        this.mImageView = iv;
        this.mFrameRes = frameRess;
        this.mDurations = durations;
        this.mDelay = delay;
        this.mLastFrame = frameRess.length - 1;
    }

    private void playByDurationsAndDelay(int i) {
        this.mImageView.postDelayed(() -> {
            if (this.mPause) {
                this.mCurrentSelect = 1;
                this.mCurrentFrame = i;
                return;
            }
            if (0 == i && this.mAnimationListener != null) {
                this.mAnimationListener.onAnimationStart();
            }
            this.mImageView.setBackgroundResource(this.mFrameRes[i]);
            if (i == this.mLastFrame) {
                if (this.mAnimationListener != null) {
                    this.mAnimationListener.onAnimationRepeat();
                }
                this.mNext = true;
                this.playByDurationsAndDelay(0);
            } else {
                this.playByDurationsAndDelay(i + 1);
            }
        }, this.mNext && this.mDelay > 0 ? (long)this.mDelay : (long)this.mDurations[i]);
    }

    private void playAndDelay(int i) {
        this.mImageView.postDelayed(() -> {
            if (this.mPause) {
                if (this.mPause) {
                    this.mCurrentSelect = 2;
                    this.mCurrentFrame = i;
                    return;
                }
                return;
            }
            this.mNext = false;
            if (0 == i && this.mAnimationListener != null) {
                this.mAnimationListener.onAnimationStart();
            }
            this.mImageView.setBackgroundResource(this.mFrameRes[i]);
            if (i == this.mLastFrame) {
                if (this.mAnimationListener != null) {
                    this.mAnimationListener.onAnimationRepeat();
                }
                this.mNext = true;
                this.playAndDelay(0);
            } else {
                this.playAndDelay(i + 1);
            }
        }, this.mNext && this.mDelay > 0 ? (long)this.mDelay : (long)this.mDuration);
    }

    private void playByDurations(int i) {
        this.mImageView.postDelayed(() -> {
            if (this.mPause) {
                if (this.mPause) {
                    this.mCurrentSelect = 3;
                    this.mCurrentFrame = i;
                    return;
                }
                return;
            }
            if (0 == i && this.mAnimationListener != null) {
                this.mAnimationListener.onAnimationStart();
            }
            this.mImageView.setImageBitmap(this.decodeBitmap(this.mImageView.getContext(), this.mFrameRes[i]));
            if (i == this.mLastFrame) {
                if (this.mIsRepeat) {
                    if (this.mAnimationListener != null) {
                        this.mAnimationListener.onAnimationRepeat();
                    }
                    this.playByDurations(0);
                } else if (this.mAnimationListener != null) {
                    this.mAnimationListener.onAnimationEnd();
                }
            } else {
                this.playByDurations(i + 1);
            }
        }, (long)this.mDurations[i]);
    }

    private void play(int i) {
        this.mImageView.postDelayed(() -> {
            if (this.mPause) {
                this.mCurrentSelect = 4;
                this.mCurrentFrame = i;
                return;
            }
            if (0 == i && this.mAnimationListener != null) {
                this.mAnimationListener.onAnimationStart();
            }
            Bitmap bitmap = this.decodeBitmap(this.mImageView.getContext(), this.mFrameRes[i]);
            this.mImageView.setImageBitmap(bitmap);
            if (i == this.mLastFrame) {
                if (this.mIsRepeat) {
                    if (this.mAnimationListener != null) {
                        this.mAnimationListener.onAnimationRepeat();
                    }
                    this.play(0);
                } else if (this.mAnimationListener != null) {
                    this.mAnimationListener.onAnimationEnd();
                }
            } else {
                this.play(i + 1);
            }
        }, (long)this.mDuration);
    }

    public void start() {
        this.mPause = false;
        this.play(0);
        this.imageViewWidth = this.mImageView.getWidth();
        this.imageViewHeight = this.mImageView.getHeight();
    }

    public void stop() {
        this.pauseAnimation();
        this.mImageView.removeCallbacks(null);
    }

    public void setAnimationListener(AnimationListener listener2) {
        this.mAnimationListener = listener2;
    }

    public void pauseAnimation() {
        this.mPause = true;
    }

    public boolean isPause() {
        return this.mPause;
    }

    public void restartAnimation() {
        if (this.mPause) {
            this.mPause = false;
            switch (this.mCurrentSelect) {
                case 1: {
                    this.playByDurationsAndDelay(this.mCurrentFrame);
                    break;
                }
                case 2: {
                    this.playAndDelay(this.mCurrentFrame);
                    break;
                }
                case 3: {
                    this.playByDurations(this.mCurrentFrame);
                    break;
                }
                case 4: {
                    this.play(this.mCurrentFrame);
                    break;
                }
            }
        }
    }

    public Bitmap decodeBitmap(Context context2, int resId) {
        Bitmap result;
        Bitmap preBitmap = null;
        if (this.mImageView.getDrawable() != null) {
            preBitmap = ((BitmapDrawable)this.mImageView.getDrawable()).getBitmap();
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)context2.getResources(), (int)resId, (BitmapFactory.Options)options);
        if (preBitmap != null) {
            options.inSampleSize = this.calculateInSampleSize(options, this.mImageView.getWidth(), this.mImageView.getHeight());
            options.inBitmap = preBitmap;
        }
        options.inPreferredConfig = Bitmap.Config.ALPHA_8;
        options.inJustDecodeBounds = false;
        options.inMutable = true;
        try {
            result = BitmapFactory.decodeResource((Resources)context2.getResources(), (int)resId, (BitmapFactory.Options)options);
        }
        catch (IllegalStateException e) {
            if (options.inBitmap != null) {
                options.inBitmap = null;
            }
            result = BitmapFactory.decodeResource((Resources)context2.getResources(), (int)resId, (BitmapFactory.Options)options);
        }
        return result;
    }

    public int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (reqHeight == 0 || reqWidth == 0) {
            return inSampleSize;
        }
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
            float totalPixels = width * height;
            float totalReqPixelsCap = reqWidth * reqHeight * 2;
            while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
                ++inSampleSize;
            }
        }
        return inSampleSize;
    }

    public static interface AnimationListener {
        public void onAnimationStart();

        public void onAnimationEnd();

        public void onAnimationRepeat();
    }
}

