/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class ColorUtil {
    private static final int LIGHT_COLOR_COUNT = 5;
    private static final int DARK_COLOR_COUNT = 4;
    private static final float SATURATION_STEP1 = 0.16f;
    private static final float SATURATION_STEP2 = 0.05f;
    private static final float BRIGHTNESS_STEP1 = 0.05f;
    private static final float BRIGHTNESS_STEP2 = 0.15f;
    private static int hueStep = 2;
    private static int i;
    private static String[] colors;

    public static float[] getColor(String userNumber) {
        int integer2;
        float[] result = new float[3];
        if (userNumber == null || userNumber.equals("")) {
            return result;
        }
        if (userNumber.length() == 1) {
            userNumber = "0" + userNumber;
        }
        String last2Number = userNumber.substring(userNumber.length() - 2);
        try {
            integer2 = Integer.parseInt(last2Number);
        }
        catch (Exception e) {
            return result;
        }
        int index = integer2 / 10;
        if (integer2 % 10 >= 5) {
            index += 10;
        }
        String mainColor = colors[index];
        int light = integer2 % 5 + 3;
        boolean isLight = light <= 5;
        i = isLight ? 5 - light : light - 5;
        RGB rgb = ColorUtil.getRGBByString(mainColor);
        HSV hsv = rgb.RGB2HSV();
        HSV standardHSV = new HSV(hsv.H * 360.0f, hsv.S, hsv.V);
        HSV deriveHSV = standardHSV.standard2derive(i, isLight);
        result[0] = deriveHSV.H;
        result[1] = deriveHSV.S;
        result[2] = deriveHSV.V;
        return result;
    }

    private static RGB getRGBByString(String mainColor) {
        RGB rgb = new RGB();
        rgb.red = (float)Character.getNumericValue(mainColor.charAt(1)) * 16.0f + (float)Character.getNumericValue(mainColor.charAt(2));
        rgb.green = (float)Character.getNumericValue(mainColor.charAt(3)) * 16.0f + (float)Character.getNumericValue(mainColor.charAt(4));
        rgb.blue = (float)Character.getNumericValue(mainColor.charAt(5)) * 16.0f + (float)Character.getNumericValue(mainColor.charAt(6));
        return rgb;
    }

    static {
        colors = new String[]{"#f5222d", "#fa541c", "#fa8c16", "#faad14", "#fadb14", "#a0d911", "#52c41a", "#13c2c2", "#1890ff", "#2f54eb", "#722ed1", "#eb2f96", "#833d41", "#835a3d", "#77833d", "#3d8379", "#3d6183", "#3f3d83", "#7f3d83", "#607d8d"};
    }

    static class HSV {
        protected float H;
        protected float S;
        protected float V;

        public HSV(float h, float s, float v) {
            this.H = h;
            this.S = s;
            this.V = v;
        }

        public HSV() {
        }

        public HSV standard2derive(int i, boolean isLight) {
            HSV deriveHSV = new HSV();
            if (this.H >= 60.0f && this.H <= 240.0f) {
                deriveHSV.H = isLight ? this.H - (float)(hueStep * i) : this.H + (float)(hueStep * i);
            } else {
                float f = deriveHSV.H = isLight ? this.H + (float)(hueStep * i) : this.H - (float)(hueStep * i);
            }
            if (deriveHSV.H < 0.0f) {
                deriveHSV.H += 360.0f;
            } else if (deriveHSV.H >= 360.0f) {
                deriveHSV.H -= 360.0f;
            }
            deriveHSV.H = Math.round(deriveHSV.H);
            deriveHSV.S = isLight ? this.S - 0.16f * (float)i : (i == 4 ? this.S + 0.16f : this.S + 0.05f * (float)i);
            if (deriveHSV.S > 1.0f) {
                deriveHSV.S = 1.0f;
            }
            if (isLight && i == 5 && (double)deriveHSV.S > 0.1) {
                deriveHSV.S = 0.1f;
            }
            if ((double)deriveHSV.S < 0.06) {
                deriveHSV.S = 0.06f;
            }
            deriveHSV.S = BigDecimal.valueOf(deriveHSV.S).setScale(2, RoundingMode.HALF_UP).floatValue();
            deriveHSV.V = isLight ? this.V + 0.05f * (float)i : this.V - 0.15f * (float)i;
            if (deriveHSV.V > 1.0f) {
                deriveHSV.V = 1.0f;
            }
            deriveHSV.V = BigDecimal.valueOf(deriveHSV.V).setScale(2, RoundingMode.HALF_UP).floatValue();
            return deriveHSV;
        }
    }

    static class RGB {
        protected float red;
        protected float green;
        protected float blue;

        RGB() {
        }

        public HSV RGB2HSV() {
            this.red /= 255.0f;
            this.blue /= 255.0f;
            this.green /= 255.0f;
            float max = Math.max(this.red, Math.max(this.blue, this.green));
            float min = Math.min(this.red, Math.min(this.blue, this.green));
            float d = max - min;
            HSV hsv = new HSV();
            hsv.V = max;
            float f = hsv.S = max == 0.0f ? 0.0f : d / max;
            if (max == min) {
                hsv.H = 0.0f;
            } else {
                if (max == this.red) {
                    hsv.H = (this.green - this.blue) / d + (float)(this.green < this.blue ? 6 : 0);
                } else if (max == this.blue) {
                    hsv.H = (this.red - this.green) / d + 4.0f;
                } else if (max == this.green) {
                    hsv.H = (this.blue - this.red) / d + 2.0f;
                }
                hsv.H /= 6.0f;
            }
            return hsv;
        }
    }
}

