/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.redpacket;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livecore.models.RedPacketTopModel;
import com.baijiayun.liveuibase.R;

public class RedPacketTopAdapter
extends BaseAdapter {
    private LayoutInflater inflater;
    private RedPacketTopModel[] mList;
    private Context mContext;

    public RedPacketTopAdapter(Context context2) {
        this.inflater = LayoutInflater.from((Context)context2);
        this.mContext = context2;
    }

    public void setData(RedPacketTopModel[] list) {
        if (list == null) {
            return;
        }
        this.mList = list;
        this.notifyDataSetChanged();
    }

    public int getCount() {
        if (this.mList == null) {
            return 0;
        }
        return this.mList.length;
    }

    public Object getItem(int position) {
        if (position >= 0 && position < this.getCount()) {
            return this.mList[position];
        }
        return null;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        TopHolder topHolder;
        if (convertView == null) {
            convertView = this.inflater.inflate(R.layout.bjy_base_item_jingx_red_packet_top, parent, false);
            topHolder = new TopHolder();
            topHolder.mLlItemJingxiRedPacketTop = (LinearLayout)convertView.findViewById(R.id.ll_item_jingxi_red_packet_top);
            topHolder.mTvJingxiRpIcon = (TextView)convertView.findViewById(R.id.tv_jingxi_rp_icon);
            topHolder.mTvJingxiRpTopName = (TextView)convertView.findViewById(R.id.tv_jingxi_rp_top_name);
            topHolder.mTvJingxiRpTopCoin = (TextView)convertView.findViewById(R.id.tv_jingxi_rp_top_coin);
            convertView.setTag((Object)topHolder);
        } else {
            topHolder = (TopHolder)convertView.getTag();
        }
        RedPacketTopModel model = this.mList[position];
        topHolder.mTvJingxiRpIcon.setText((CharSequence)"");
        topHolder.mTvJingxiRpTopName.setTextColor(this.mContext.getResources().getColor(R.color.base_warning_color));
        if (model.rank_id == 1) {
            topHolder.mTvJingxiRpIcon.setBackground(this.mContext.getResources().getDrawable(R.drawable.bjy_base_iv_lp_ui_red_top_1));
        } else if (model.rank_id == 2) {
            topHolder.mTvJingxiRpIcon.setBackground(this.mContext.getResources().getDrawable(R.drawable.bjy_base_iv_lp_ui_red_top_2));
        } else if (model.rank_id == 3) {
            topHolder.mTvJingxiRpIcon.setBackground(this.mContext.getResources().getDrawable(R.drawable.bjy_base_iv_lp_ui_red_top_3));
        } else {
            topHolder.mTvJingxiRpIcon.setBackground(null);
            topHolder.mTvJingxiRpIcon.setText((CharSequence)String.valueOf(model.rank_id));
            topHolder.mTvJingxiRpTopName.setTextColor(this.mContext.getResources().getColor(R.color.base_black));
        }
        topHolder.mTvJingxiRpTopName.setText((CharSequence)UtilsKt.getEncodePhoneNumber((String)model.user_name));
        topHolder.mTvJingxiRpTopCoin.setText((CharSequence)String.valueOf(model.coin));
        return convertView;
    }

    static class TopHolder {
        private LinearLayout mLlItemJingxiRedPacketTop;
        private TextView mTvJingxiRpIcon;
        private TextView mTvJingxiRpTopName;
        private TextView mTvJingxiRpTopCoin;

        TopHolder() {
        }
    }
}

