/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.redpacket;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.context.LPException;
import com.baijiayun.livebase.network.alilog.AliYunLogHelper;
import com.baijiayun.livecore.models.LPRedPacketModel;
import com.baijiayun.livecore.models.RedPacketTopList;
import com.baijiayun.livecore.utils.LPJsonUtils;
import com.baijiayun.liveuibase.base.RouterListener;
import com.baijiayun.liveuibase.toolbox.redpacket.RedPacketContract;
import com.baijiayun.liveuibase.toolbox.redpacket.widget.MoveModel;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class RedPacketPresenter
implements RedPacketContract.Presenter {
    private final String TAG = RedPacketPresenter.class.getSimpleName();
    private final long TIME_RED_PACKET_START = 3L;
    private RouterListener mRouter;
    private RedPacketContract.View mView;
    private Disposable mTimeDisposable;
    private Disposable mRedPacketRain;
    private boolean isRobRedPacket = false;
    private LPRedPacketModel mLPRedPacketModel;
    private CompositeDisposable mCompositeDisposable = new CompositeDisposable();
    private volatile int mScoreAmount = 0;
    private RedPacketTopList mTopList;
    private boolean isStudent = true;
    private LPRedPacketModel model;
    private Disposable disposableOfRankListTimer;
    private Disposable disposableOfTimer;
    public static int ROB_COUNT;
    public static int ROB_SUCCESS_COUNT;
    public static int ROB_FAIL_COUNT;
    public static int ROB_FAIL_SENSITIVE_COUNT;
    public static float SENSITIVITY;
    private String nowPacketId = null;

    public RedPacketPresenter(RedPacketContract.View view, LPRedPacketModel model) {
        this.mView = view;
        this.model = model;
        ROB_FAIL_SENSITIVE_COUNT = 0;
        ROB_FAIL_COUNT = 0;
        ROB_SUCCESS_COUNT = 0;
        ROB_COUNT = 0;
        SENSITIVITY = model.sensitivity;
    }

    @Override
    public void setRouter(RouterListener routerListener2) {
        this.mRouter = routerListener2;
    }

    @SuppressLint(value={"CheckResult"})
    public void subscribe() {
    }

    @Override
    public void robRedPacket(MoveModel model) {
        if (this.mLPRedPacketModel == null) {
            return;
        }
        ++ROB_COUNT;
        model.isRob = true;
        this.mCompositeDisposable.add(this.mRouter.getLiveRoom().requestCloudRobRedPacket(Integer.parseInt(this.mLPRedPacketModel.id)).subscribe(robModel -> {
            if (robModel.status == 0) {
                LPLogger.d((String)this.TAG, (String)("requestCloudRobRedPacket mScoreAmount=" + this.mScoreAmount + ", \u8fd9\u6b21\u62a2\u5230\u4e86" + robModel.score_amount));
                this.mScoreAmount += robModel.score_amount;
                model.scoreAmount = robModel.score_amount;
                ++ROB_SUCCESS_COUNT;
            } else {
                LPLogger.d((String)this.TAG, (String)"requestCloudRobRedPacket status!=0 \u5931\u8d25");
                model.scoreAmount = 0;
                ++ROB_FAIL_COUNT;
            }
            model.isOpen = true;
        }, throwable -> {
            if (throwable instanceof LPException && ((LPException)throwable).getErrorCode() == -1046) {
                model.isOpen = true;
                model.scoreAmount = 0;
                model.openTime = -1L;
                ++ROB_FAIL_SENSITIVE_COUNT;
            } else {
                AliYunLogHelper.getInstance().addErrorLog("\u62a2\u7ea2\u5305\u62a5\u9519 : error " + throwable.getMessage());
            }
        }));
    }

    @Override
    public void startRedPacket() {
        RxUtils.dispose((Disposable)this.disposableOfTimer);
        this.isStudent = this.mRouter.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student && !this.mRouter.getLiveRoom().isAudition();
        this.mView.setRobEnable(this.isStudent);
        LPLogger.d((String)this.TAG, (String)("startRedPacket " + this.isRobRedPacket));
        if (this.isRobRedPacket) {
            return;
        }
        this.release();
        this.isRobRedPacket = true;
        this.mTopList = null;
        this.mLPRedPacketModel = this.model;
        this.mTimeDisposable = Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            LPLogger.d((String)this.TAG, (String)("startRedPacket : time : " + aLong));
            long timeStart = 3L - aLong;
            if (timeStart <= 0L) {
                RxUtils.dispose((Disposable)this.mTimeDisposable);
                this.startRedPacketRain(this.model);
            }
            this.mView.updateRedPacketTime(timeStart);
        });
        this.mCompositeDisposable.add(this.mRouter.getLiveRoom().getObservableOfRedPacketRankList().observeOn(AndroidSchedulers.mainThread()).subscribe(redPacketTopList -> {
            LPLogger.d((String)this.TAG, (String)"getObservableOfRedPacketRankList");
            this.mTopList = redPacketTopList;
        }));
        this.mCompositeDisposable.add(this.mRouter.getLiveRoom().getObservableOfRedPacketFinish().observeOn(AndroidSchedulers.mainThread()).subscribe(packetId -> {
            LPLogger.d((String)this.TAG, (String)"getObservableOfRedPacketFinish");
            this.robFinish((String)packetId);
        }));
    }

    private void startRedPacketRain(LPRedPacketModel lpRedPacketModel) {
        this.mScoreAmount = 0;
        this.mView.switchRedPacketStart(2);
        this.mRedPacketRain = Observable.interval((long)0L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            LPLogger.d((String)this.TAG, (String)("startRedPackRain time : " + aLong));
            if (aLong >= (long)lpRedPacketModel.duration) {
                this.robFinish(lpRedPacketModel.id);
            }
        });
    }

    private void robFinish(String packetId) {
        RxUtils.dispose((Disposable)this.disposableOfRankListTimer);
        RxUtils.dispose((Disposable)this.mRedPacketRain);
        this.isRobRedPacket = false;
        if (this.isStudent) {
            if (this.mScoreAmount <= 0) {
                this.mView.switchRedPacketStart(5);
            } else {
                this.mView.switchRedPacketStart(6);
            }
            this.disposableOfRankListTimer = Observable.timer((long)5L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
                if (this.mTopList != null) {
                    this.switchState(3);
                } else {
                    this.exit(false);
                }
            });
        } else {
            this.mView.switchRedPacketStart(7);
            this.nowPacketId = packetId;
            if (!TextUtils.isEmpty((CharSequence)this.nowPacketId) && this.mRouter.getLiveRoom().getToolBoxVM().enableUseBonusPoints()) {
                this.mCompositeDisposable.add(this.mRouter.getLiveRoom().requestCloudRedPacketRankList(Integer.parseInt(this.nowPacketId)).observeOn(AndroidSchedulers.mainThread()).subscribe(jsonObject -> {
                    jsonObject.addProperty("id", this.nowPacketId);
                    this.mRouter.getLiveRoom().sendRedPacketRankListBroadcast((JsonElement)jsonObject);
                }));
            }
        }
    }

    @Override
    public void showResultList() {
        if (TextUtils.isEmpty((CharSequence)this.nowPacketId)) {
            return;
        }
        this.mCompositeDisposable.add(this.mRouter.getLiveRoom().requestCloudRedPacketRankList(Integer.parseInt(this.nowPacketId)).subscribe(jsonObject -> {
            this.mTopList = (RedPacketTopList)LPJsonUtils.parseJsonObject((JsonObject)jsonObject, RedPacketTopList.class);
            this.switchState(3);
        }, throwable -> {
            LPLogger.e((String)this.TAG, (String)("requestCloudRedPacketRankList : " + throwable.getMessage()));
            this.switchState(3);
        }));
    }

    public void unSubscribe() {
    }

    @Override
    public void exit(boolean withRepublish) {
        if (withRepublish) {
            this.mRouter.onRepublishRedPacket();
        }
        this.mRouter.switchRedPacketUI(false, null);
    }

    @Override
    public void release() {
        RxUtils.dispose((Disposable)this.mTimeDisposable);
        RxUtils.dispose((Disposable)this.mRedPacketRain);
        RxUtils.dispose((Disposable)this.disposableOfRankListTimer);
        this.mCompositeDisposable.clear();
        this.mTimeDisposable = null;
        this.mRedPacketRain = null;
        this.isRobRedPacket = false;
        this.mLPRedPacketModel = null;
    }

    public void destroy() {
        this.release();
        this.mCompositeDisposable.dispose();
    }

    @Override
    public int getScoreAmount() {
        return this.mScoreAmount;
    }

    @Override
    public boolean isRobRedPacket() {
        return this.isRobRedPacket;
    }

    @Override
    public boolean isTeacher() {
        return this.mRouter != null && this.mRouter.getLiveRoom().isTeacher();
    }

    @Override
    public void switchState(int type) {
        if (type == 3) {
            this.mView.switchRedPacketRankingList(this.mTopList == null ? null : this.mTopList.list);
            if (this.mRouter.getLiveRoom() != null && BaseUtilsKt.hideFunctionXunlong(this.mRouter.getLiveRoom())) {
                this.disposableOfTimer = Observable.timer((long)5L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> this.exit(false));
            }
        } else {
            this.mView.switchRedPacketStart(type);
        }
    }
}

