/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.livetimer;

import android.content.Context;
import android.content.res.Resources;
import android.media.SoundPool;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BasePadFragment;
import com.baijiayun.liveuibase.databinding.BjyBaseFragmentTimerShowyBinding;
import com.baijiayun.liveuibase.toolbox.livetimer.TimerContract;

public class TimerShowyFragment
extends BasePadFragment
implements TimerContract.View {
    private TimerContract.Presenter presenter;
    private Context context;
    private SoundPool soundPool;
    private BjyBaseFragmentTimerShowyBinding binding;

    @Override
    public int getLayoutId() {
        return R.layout.bjy_base_fragment_timer_showy;
    }

    @Override
    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container2, @Nullable Bundle savedInstanceState) {
        this.binding = BjyBaseFragmentTimerShowyBinding.inflate(inflater, container2, false);
        return this.binding.getRoot();
    }

    @Override
    public void init(@NonNull View view) {
        super.init(view);
        this.presenter.subscribe();
        this.binding.dialogViewSpace.setVisibility(this.presenter.getUserType() == LPConstants.LPUserType.Teacher ? 8 : 0);
        this.binding.dialogCloseIv.setVisibility(this.presenter.getUserType() == LPConstants.LPUserType.Teacher ? 0 : 8);
        this.binding.dialogCloseIv.setOnClickListener(v -> this.presenter.closeTimer());
        this.binding.dialogTimerShowyTime.setOnClickListener(v -> this.presenter.showTimer());
        this.binding.dialogTimerShowyLogo.setOnClickListener(v -> this.presenter.showTimer());
    }

    public void setPresenter(TimerContract.Presenter presenter2) {
        this.presenter = presenter2;
    }

    @Override
    public void setTimer(long remainSeconds) {
        if (remainSeconds < 0L) {
            remainSeconds = 0L;
        }
        long min = remainSeconds / 60L;
        long second = remainSeconds % 60L;
        String sb = (min >= 10L ? Long.valueOf(min) : "0" + min) + ":" + (second >= 10L ? Long.valueOf(second) : "0" + second);
        this.binding.dialogTimerShowyTime.setText((CharSequence)sb);
    }

    @Override
    public void showViewWarning(boolean enable) {
        this.binding.dialogTimerShowyBg.setBackgroundDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)(enable ? R.drawable.shape_timer_showy_bg_end : R.drawable.shape_timer_showy_bg_nomal), null));
    }

    @Override
    public void showCountDown(boolean enable) {
    }

    @Override
    public void showTimerEnd() {
        this.binding.dialogTimerShowyBg.setBackgroundDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.shape_timer_showy_bg_end, null));
        if (this.soundPool != null) {
            this.soundPool.release();
        }
        this.soundPool = UtilsKt.playAudio((Context)this.getContext(), (int)R.raw.timer_end);
    }

    @Override
    public void showTimerPause(boolean isPause) {
    }

    @Override
    public void setButtonState(String state) {
        this.binding.dialogTimerShowyBg.setBackgroundDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)R.drawable.shape_timer_showy_bg_nomal, null));
    }

    @Override
    public void onAttach(Context context2) {
        super.onAttach(context2);
        this.context = context2;
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        this.presenter.requestTimerEnd();
        this.presenter.destroy();
        this.presenter.unSubscribe();
        this.presenter = null;
        if (this.soundPool != null) {
            this.soundPool.release();
        }
    }
}

