/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.toolbox.answerer.barchart;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.toolbox.answerer.barchart.AnswererBarEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AnswererBarChart
extends View {
    private Paint mBarPaint;
    private Paint mXAxisLabelPaint;
    private Paint mXAxisSelectedLabelPaint;
    private Paint mYAxisValuePaint;
    private Paint mXAxisPaint;
    private Rect mTextRect;
    private Rect mValueRect;
    private Rect mCountRect;
    private Rect mRateRect;
    private RectF mBarRectF;
    private RectF mClipRectF;
    private int mBarWidth;
    private int mGap;
    private int mRadius;
    private boolean canStop;
    private String mCountString = "";
    private String mRateString = "";
    private float mMax = 100.0f;
    private int mStep;
    private float mRatio = 0.7f;
    private float[] mDataList;
    private String[] mHorizontalAxis;
    private List<String> mSelectedAxis;
    private List<AnswererBarEntry> mBars = new ArrayList<AnswererBarEntry>();
    private int[] mColors = new int[]{-14786817, -14786817, -14786817, -14786817, -10241793, -1};
    public static final int DELAY = 10;
    public static final int BAR_GROWTH_STEP = 15;

    public AnswererBarChart(Context context2) {
        this(context2, null);
    }

    public AnswererBarChart(Context context2, @Nullable AttributeSet attrs) {
        this(context2, attrs, 0);
    }

    public AnswererBarChart(Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.initView(context2);
    }

    private void initView(Context context2) {
        this.mXAxisLabelPaint = new Paint();
        this.mXAxisLabelPaint.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_window_main_text_color));
        this.mXAxisLabelPaint.setAntiAlias(true);
        this.mXAxisLabelPaint.setTextSize((float)AnswererBarChart.dip2px(context2, 11.0f));
        this.mXAxisLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mXAxisSelectedLabelPaint = new Paint();
        this.mXAxisSelectedLabelPaint.setAntiAlias(true);
        this.mXAxisSelectedLabelPaint.setTextSize((float)AnswererBarChart.dip2px(context2, 11.0f));
        this.mXAxisSelectedLabelPaint.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_live_product_color));
        this.mXAxisSelectedLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mYAxisValuePaint = new Paint();
        this.mYAxisValuePaint.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_window_main_text_color));
        this.mYAxisValuePaint.setAntiAlias(true);
        this.mYAxisValuePaint.setTextSize((float)AnswererBarChart.dip2px(context2, 9.0f));
        this.mYAxisValuePaint.setTextAlign(Paint.Align.CENTER);
        this.mBarPaint = new Paint();
        this.mBarPaint.setColor(this.mColors[1]);
        this.mBarPaint.setAntiAlias(true);
        this.mBarWidth = AnswererBarChart.dip2px(context2, 10.0f);
        this.mXAxisPaint = new Paint();
        this.mXAxisPaint.setColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)context2, (int)R.attr.base_theme_window_main_text_color));
        this.mXAxisPaint.setAntiAlias(true);
        this.mXAxisPaint.setStrokeWidth(2.0f);
        this.mTextRect = new Rect();
        this.mValueRect = new Rect();
        this.mCountRect = new Rect();
        this.mRateRect = new Rect();
        this.mBarRectF = new RectF();
        this.mClipRectF = new RectF();
        this.mGap = AnswererBarChart.dip2px(context2, 4.0f);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mBars.clear();
        if (this.mHorizontalAxis == null || this.mHorizontalAxis.length == 0) {
            return;
        }
        this.mXAxisLabelPaint.getTextBounds(this.mHorizontalAxis[0], 0, this.mHorizontalAxis[0].length(), this.mTextRect);
        this.mYAxisValuePaint.getTextBounds(this.mHorizontalAxis[0], 0, this.mHorizontalAxis[0].length(), this.mValueRect);
        this.mXAxisLabelPaint.getTextBounds(this.mCountString, 0, this.mCountString.length(), this.mCountRect);
        this.mXAxisLabelPaint.getTextBounds(this.mRateString, 0, this.mRateString.length(), this.mRateRect);
        int width = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight() - (this.mCountRect.width() + this.mRateRect.width() + 2 * this.mGap);
        int height = this.getMeasuredHeight() - this.getPaddingBottom() - this.getPaddingTop();
        this.mStep = width / this.mDataList.length;
        this.mRadius = this.mBarWidth / 2;
        int barLeft = this.getPaddingLeft() + this.mStep / 2 - this.mRadius + this.mCountRect.width() + this.mGap;
        int maxBarHeight = height - this.mTextRect.height() * 2 - this.mGap * 2;
        float heightRatio = (float)maxBarHeight / this.mMax;
        for (float data : this.mDataList) {
            AnswererBarEntry bar = new AnswererBarEntry();
            bar.setValue(data);
            bar.setTransformedValue(bar.getValue() * heightRatio);
            bar.setLeft(barLeft);
            bar.setTop((int)((float)(this.getPaddingTop() + maxBarHeight) - bar.getTransformedValue() + (float)this.mTextRect.height() + (float)this.mGap));
            bar.setRight(bar.getLeft() + this.mBarWidth);
            bar.setBottom(this.getPaddingBottom() + maxBarHeight + this.mValueRect.height() + this.mGap);
            bar.setCurrentTop(bar.getBottom());
            this.mBars.add(bar);
            barLeft += this.mStep;
        }
    }

    private int getMaxDataTop(List<AnswererBarEntry> bars) {
        int maxTop = bars.get(0).getTop();
        for (AnswererBarEntry entry : bars) {
            if (maxTop <= entry.getTop()) continue;
            maxTop = entry.getTop();
        }
        return maxTop;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mBars == null || this.mBars.size() == 0) {
            return;
        }
        LPLogger.d((String)("canStop:" + this.canStop));
        this.canStop = false;
        AnswererBarEntry startBar = this.mBars.get(0);
        int startX = startBar.getLeft() + this.mRadius;
        int startY = startBar.getBottom();
        AnswererBarEntry endBar = this.mBars.get(this.mBars.size() - 1);
        int endX = endBar.getRight() - this.mRadius;
        int endY = endBar.getBottom();
        canvas.drawLine((float)startX - (float)this.mStep * 0.5f * this.mRatio, (float)startY, (float)endX + (float)this.mStep * 0.5f * this.mRatio, (float)endY, this.mXAxisPaint);
        Paint.FontMetrics fm = this.mXAxisLabelPaint.getFontMetrics();
        float textHeight = Math.abs(fm.ascent - fm.descent);
        float descLeftY = (float)startY + textHeight / 2.0f - Math.abs(fm.descent);
        float descLeftX = (float)(startX - this.mGap) - (float)this.mCountRect.width() * 0.5f - (float)this.mStep * 0.5f * this.mRatio;
        float descRightX = (float)(endX + this.mGap) + (float)this.mRateRect.width() * 0.5f + (float)this.mStep * 0.5f * this.mRatio;
        canvas.drawText(this.mCountString, descLeftX, descLeftY, this.mXAxisLabelPaint);
        canvas.drawText(this.mRateString, descRightX, descLeftY, this.mXAxisLabelPaint);
        int length = this.mDataList.length;
        for (int i = 0; i < length; ++i) {
            AnswererBarEntry bar = this.mBars.get(i);
            String axis = this.mHorizontalAxis[i];
            float textX = bar.getLeft() + this.mRadius;
            float textY = bar.getBottom() + this.mGap + this.mTextRect.height();
            if (this.mSelectedAxis != null && this.mSelectedAxis.size() != 0 && this.mSelectedAxis.contains(axis)) {
                canvas.drawText(axis, textX, textY, this.mXAxisSelectedLabelPaint);
            } else {
                canvas.drawText(axis, textX, textY, this.mXAxisLabelPaint);
            }
            bar.setCurrentTop(bar.getCurrentTop() - 15);
            if (bar.getCurrentTop() <= bar.getTop()) {
                bar.setCurrentTop(bar.getTop());
                if (bar.getCurrentTop() == this.getMaxDataTop(this.mBars)) {
                    this.canStop = true;
                }
            }
            this.mBarRectF.set((float)bar.getLeft(), (float)bar.getCurrentTop(), (float)bar.getRight(), (float)(bar.getBottom() + this.mRadius));
            this.mClipRectF.set((float)bar.getLeft(), (float)bar.getCurrentTop(), (float)bar.getRight(), (float)bar.getBottom());
            canvas.drawText(String.valueOf((int)bar.getValue()).concat("%"), textX, (float)(bar.getCurrentTop() - this.mGap), this.mYAxisValuePaint);
            LinearGradient linearGradient = new LinearGradient((float)bar.getLeft(), (float)bar.getBottom(), (float)bar.getRight(), (float)bar.getTop(), this.mColors, null, Shader.TileMode.CLAMP);
            this.mBarPaint.setShader((Shader)linearGradient);
            canvas.save();
            canvas.clipRect(this.mClipRectF);
            canvas.drawRoundRect(this.mBarRectF, (float)this.mRadius, (float)this.mRadius, this.mBarPaint);
            canvas.restore();
        }
        if (!this.canStop) {
            this.postInvalidateDelayed(10L);
        }
    }

    public void setHorizontalAxis(String[] horizontalAxis) {
        this.mHorizontalAxis = horizontalAxis;
    }

    public void setHorizontalAxis(List<String> horizontalAxis) {
        this.mHorizontalAxis = horizontalAxis.toArray(new String[horizontalAxis.size()]);
    }

    public void setMax(float max) {
        this.mMax = max;
    }

    public void setDataList(float[] dataList) {
        this.mDataList = dataList;
    }

    public void setSelectedAxis(String[] selectedAxis) {
        this.mSelectedAxis = Arrays.asList(selectedAxis);
    }

    public void setSelectedAxis(List<String> selectedAxis) {
        this.mSelectedAxis = selectedAxis;
    }

    public void setCountString(String mCountString) {
        this.mCountString = mCountString;
    }

    public void setRateString(String rateString) {
        this.mRateString = rateString;
    }

    public void setRatio(float ratio) {
        if (ratio > 1.0f) {
            this.mRatio = 1.0f;
        }
        this.mRatio = ratio;
    }

    private static int dip2px(Context context2, float dpValue) {
        float scale = context2.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

