/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.speaklist;

import android.annotation.SuppressLint;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.network.alilog.AliYunLogHelper;
import com.baijiayun.liveuibase.ppt.PadPPTView;
import com.baijiayun.liveuibase.speaklist.SpeakItemType;
import com.baijiayun.liveuibase.speaklist.Switchable;
import com.baijiayun.liveuibase.speaklist.SwitchableStatus;
import com.baijiayun.liveuibase.speaklist.SwitchableType;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import kotlin.Pair;

public abstract class BaseSwitchItem
implements Switchable {
    public static final String TAG = "LPSpeakQueueViewModel";
    protected SwitchableStatus status = SwitchableStatus.None;
    protected SpeakItemType itemType;
    private boolean isInFullScreen = false;
    protected RouterViewModel routerListener;

    public BaseSwitchItem(RouterViewModel listener2) {
        this.routerListener = listener2;
    }

    @Override
    public int getPositionInParent() {
        View view = this.getView();
        ViewParent viewParent = this.getView().getParent();
        if (viewParent == null) {
            return -1;
        }
        return ((ViewGroup)viewParent).indexOfChild(view);
    }

    @Override
    public SwitchableStatus getSwitchableStatus() {
        return this.status;
    }

    @Override
    public void setSwitchableStatus(SwitchableStatus status) {
        this.status = status;
    }

    @Override
    public void switchToMaxScreen() {
        this.removeSwitchableFromParent(this);
        this.routerListener.getSwitch2MaxScreen().setValue((Object)this);
        this.status = SwitchableStatus.MaxScreen;
        LPLogger.d((String)TAG, (String)("switchToMaxScreen: " + this.getIdentity()));
    }

    @Override
    public void switchToSpeakList() {
        this.removeSwitchableFromParent(this);
        this.routerListener.getSwitch2SpeakList().setValue((Object)this);
        this.status = SwitchableStatus.SpeakList;
        LPLogger.d((String)TAG, (String)("switchToSpeakList: " + this.getIdentity()));
    }

    @Override
    public void switchToFullScreen(boolean isFullScreen) {
        this.removeSwitchableFromParent(this);
        this.routerListener.getSwitch2FullScreen().setValue((Object)new Pair((Object)isFullScreen, (Object)this));
        this.isInFullScreen = isFullScreen;
    }

    @Override
    public void switchToMainScreen() {
        this.removeSwitchableFromParent(this);
        this.routerListener.getSwitch2MainVideo().setValue((Object)this);
        this.status = SwitchableStatus.MainVideo;
        LPLogger.d((String)TAG, (String)("switchToMainScreen: " + this.getIdentity()));
    }

    @Override
    public boolean isInFullScreen() {
        return this.isInFullScreen;
    }

    protected void removeSwitchableFromParent(Switchable switchable) {
        View view = switchable.getView();
        if (view == null) {
            return;
        }
        ViewParent viewParent = view.getParent();
        if (viewParent == null) {
            return;
        }
        ((ViewGroup)viewParent).removeView(view);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void registerClickEvent(View view) {
        GestureDetector gestureDetector2 = new GestureDetector(view.getContext(), (GestureDetector.OnGestureListener)new ClickGestureDetector(this));
        view.setOnTouchListener((v, event) -> {
            gestureDetector2.onTouchEvent(event);
            return true;
        });
    }

    public abstract void showOptionDialog();

    protected boolean canSwitchPPTAndMainVideo() {
        if (BaseUtilsKt.isInDiscussMode(this.routerListener)) {
            return false;
        }
        if (this.routerListener.getLiveRoom().getTemplateType() == LPConstants.TemplateType.LIVE_WALL) {
            return this.routerListener.getLiveRoom().getCurrentRoomLayout() != LPConstants.RoomLayoutMode.GALLERY;
        }
        return this.routerListener.getLiveRoom().getTemplateType() != LPConstants.TemplateType.VIDEO;
    }

    @Override
    public void switchPPTVideoSync() {
        this.switchPPTVideoWithoutSync();
    }

    @Override
    public void switchPPTVideoWithoutSync() {
        Switchable maxScreenItem = this.routerListener.getMaxScreenItem();
        if (maxScreenItem == null) {
            AliYunLogHelper.getInstance().addErrorLog("\u5207\u6362\u62a5\u9519\u51fa\u9519,ppt:" + this.routerListener.getPpt() + "---main:" + this.routerListener.getMainScreenItem());
            return;
        }
        PadPPTView pptView = this.routerListener.getPpt();
        switch (this.getSwitchableType()) {
            case MainItem: {
                this.handleMainItem2Max(pptView, maxScreenItem);
                break;
            }
            case SpeakItem: {
                this.handleSpeakItem2Max(pptView, maxScreenItem);
                break;
            }
            case PPT: {
                this.handlePPT2Max(maxScreenItem);
                break;
            }
        }
        if (this.isInFullScreen) {
            this.exitFullScreen(this);
        }
        this.switchToMaxScreen();
    }

    private void handlePPT2Max(Switchable maxScreenItem) {
        if (maxScreenItem.isInFullScreen()) {
            this.exitFullScreen(maxScreenItem);
        }
        this.resetSwitchableStatus(maxScreenItem);
    }

    private void handleSpeakItem2Max(Switchable ppt, Switchable maxScreenItem) {
        if (maxScreenItem.getSwitchableType() == SwitchableType.MainItem) {
            if (ppt.isInFullScreen()) {
                this.exitFullScreen(ppt);
            }
            ppt.switchToSpeakList();
            if (maxScreenItem.isInFullScreen()) {
                this.exitFullScreen(maxScreenItem);
            }
            maxScreenItem.switchToMainScreen();
        } else {
            if (maxScreenItem.isInFullScreen()) {
                this.exitFullScreen(maxScreenItem);
            }
            maxScreenItem.switchToSpeakList();
        }
    }

    private void handleMainItem2Max(Switchable ppt, Switchable maxScreenItem) {
        if (ppt.isInFullScreen()) {
            this.exitFullScreen(ppt);
        }
        ppt.switchToMainScreen();
        if (maxScreenItem.getSwitchableType() == SwitchableType.SpeakItem) {
            if (maxScreenItem.isInFullScreen()) {
                this.exitFullScreen(maxScreenItem);
            }
            maxScreenItem.switchToSpeakList();
        }
    }

    private void resetSwitchableStatus(Switchable switchable) {
        switch (switchable.getSwitchableType()) {
            case PPT: {
                switchable.switchToMaxScreen();
                break;
            }
            case MainItem: {
                switchable.switchToMainScreen();
                break;
            }
            case SpeakItem: {
                switchable.switchToSpeakList();
                break;
            }
        }
    }

    private void exitFullScreen(Switchable fullItem) {
        this.setSwitchableStatus(SwitchableStatus.None);
        fullItem.switchToFullScreen(false);
    }

    @Override
    public void syncPPTExtCamera(Switchable closeItem) {
        if (this.routerListener.isLiveEE()) {
            return;
        }
        if (closeItem.isInFullScreen()) {
            this.handleSwitchable(closeItem.getSwitchableStatus(), this);
            this.switchToFullScreen(true);
        } else {
            this.handleSwitchable(closeItem.getSwitchableStatus(), this);
        }
    }

    private void handleSwitchable(SwitchableStatus switchableStatus, Switchable switchable) {
        switch (switchableStatus) {
            case MainVideo: {
                switchable.switchToMainScreen();
                LPLogger.d((String)TAG, (String)("addMain,id:" + switchable.getIdentity()));
                break;
            }
            case MaxScreen: {
                switchable.switchToMaxScreen();
                LPLogger.d((String)TAG, (String)("addMax,id:" + switchable.getIdentity()));
                break;
            }
            case SpeakList: {
                switchable.switchToSpeakList();
                LPLogger.d((String)TAG, (String)("addSpeak,id:" + switchable.getIdentity()));
                break;
            }
        }
    }

    @Override
    public boolean isPlaceholderItem() {
        return false;
    }

    @Override
    public void replaceVideoSync(Switchable switchable) {
        if (switchable == null) {
            return;
        }
        LPLogger.d((String)TAG, (String)("this id:" + this.getIdentity() + ",type:" + (Object)((Object)this.getSwitchableType()) + ",status:" + (Object)((Object)this.getSwitchableStatus()) + "---id:" + switchable.getIdentity() + ",type:" + (Object)((Object)switchable.getSwitchableType()) + ",status:" + (Object)((Object)switchable.getSwitchableStatus())));
        if (switchable == this) {
            this.handleSwitchable(switchable.getSwitchableStatus(), this);
            return;
        }
        if (this.isPlaceholderItem() || switchable.isPlaceholderItem()) {
            this.handlePlaceholderItemSync(switchable);
            return;
        }
        SwitchableStatus currentStatus = this.status;
        this.handleSwitchable(switchable.getSwitchableStatus(), this);
        this.handleSwitchable(currentStatus, switchable);
        if (this.isInFullScreen()) {
            this.switchToFullScreen(false);
            switchable.switchToFullScreen(true);
        } else if (switchable.isInFullScreen()) {
            switchable.switchToFullScreen(false);
            this.switchToFullScreen(true);
        }
        if (this.getSwitchableType() == SwitchableType.MainItem && this.getSwitchableStatus() == SwitchableStatus.MaxScreen) {
            LPLogger.d((String)TAG, (String)"ppt switch to main");
            PadPPTView pptView = this.routerListener.getPpt();
            if (((Switchable)pptView).getSwitchableStatus() != SwitchableStatus.MainVideo) {
                ((Switchable)pptView).switchToMainScreen();
            }
        }
    }

    private void handlePlaceholderItemSync(Switchable switchable) {
        switch (switchable.getSwitchableStatus()) {
            case MainVideo: {
                LPLogger.d((String)TAG, (String)("id:" + this.getIdentity() + ",switch to main,type:" + (Object)((Object)this.getSwitchableType())));
                this.switchToMainScreen();
                break;
            }
            case MaxScreen: {
                LPLogger.d((String)TAG, (String)("id:" + this.getIdentity() + ",switch to max,type:" + (Object)((Object)this.getSwitchableType())));
                this.switchToMaxScreen();
                break;
            }
            case SpeakList: {
                LPLogger.d((String)TAG, (String)"presenter switch2SpeakList");
                break;
            }
        }
        if (this.isInFullScreen()) {
            this.switchToFullScreen(false);
            switchable.switchToFullScreen(true);
        } else if (switchable.isInFullScreen()) {
            switchable.switchToFullScreen(false);
            this.switchToFullScreen(true);
        }
        if (this.isPlaceholderItem() || !switchable.isPlaceholderItem()) {
            return;
        }
        if (!this.isInFullScreen() && !switchable.isInFullScreen()) {
            switchable.switchToMainScreen();
        }
        PadPPTView pptView = this.routerListener.getPpt();
        if (this.getSwitchableStatus() == SwitchableStatus.MaxScreen) {
            Switchable ppt = pptView;
            ppt.switchToMainScreen();
        }
    }

    private static class ClickGestureDetector
    extends GestureDetector.SimpleOnGestureListener {
        private WeakReference<BaseSwitchItem> baseSwitchItemWeakReference;
        Disposable subscriptionOfClickable;

        ClickGestureDetector(BaseSwitchItem switchItem) {
            this.baseSwitchItemWeakReference = new WeakReference<BaseSwitchItem>(switchItem);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            BaseSwitchItem switchable = (BaseSwitchItem)this.baseSwitchItemWeakReference.get();
            if (switchable == null) {
                RxUtils.dispose((Disposable)this.subscriptionOfClickable);
                return false;
            }
            if (this.clickableCheck()) {
                return false;
            }
            if (switchable.getSwitchableStatus() != SwitchableStatus.MaxScreen || switchable.isInFullScreen()) {
                switchable.showOptionDialog();
            }
            return true;
        }

        private boolean clickableCheck() {
            if (this.subscriptionOfClickable != null && !this.subscriptionOfClickable.isDisposed()) {
                return true;
            }
            this.subscriptionOfClickable = Observable.timer((long)1L, (TimeUnit)TimeUnit.SECONDS).subscribe(aLong -> RxUtils.dispose((Disposable)this.subscriptionOfClickable));
            return false;
        }
    }
}

