/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.ppt.quickswitchppt;

import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livecore.models.LPDocModel;
import com.baijiayun.liveuibase.ppt.quickswitchppt.SwitchPPTContract;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.List;
import kotlin.Pair;
import kotlin.Unit;

public class SwitchPPTFragmentPresenter
implements SwitchPPTContract.Presenter {
    private SwitchPPTContract.View view;
    private RouterViewModel routerViewModel;
    private Disposable subscriptionOfDocListChange;
    private Disposable subscriptionOfPageChange;
    private Disposable subscriptionOfStudentAuthChange;
    private boolean enableMultiWhiteboard;

    public SwitchPPTFragmentPresenter(SwitchPPTContract.View view, boolean enableMultiWhiteboard) {
        this.view = view;
        this.enableMultiWhiteboard = enableMultiWhiteboard;
    }

    public void subscribe() {
        this.subscriptionOfDocListChange = this.routerViewModel.getLiveRoom().getDocListVM().getObservableOfDocListChanged().observeOn(AndroidSchedulers.mainThread()).subscribe(docModels -> this.view.docListChanged((List<LPDocModel>)docModels));
        this.view.setType(!this.routerViewModel.getLiveRoom().isTeacherOrAssistant(), !this.enableMultiWhiteboard);
        this.view.docListChanged(this.routerViewModel.getLiveRoom().getDocListVM().getDocList());
        this.view.setIndex(-1);
        this.subscriptionOfPageChange = this.routerViewModel.getLiveRoom().getDocListVM().getObservableOfDocPageIndex().observeOn(AndroidSchedulers.mainThread()).subscribe(index -> {
            if (this.view != null) {
                this.view.setIndex((int)index);
            }
        });
        if (this.routerViewModel.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Student) {
            this.subscriptionOfStudentAuthChange = this.routerViewModel.getLiveRoom().getObservableOfForbidStudentSwitchPPT().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
                if (this.view != null && aBoolean.booleanValue()) {
                    this.view.close();
                }
            });
        }
    }

    public void unSubscribe() {
        RxUtils.dispose((Disposable)this.subscriptionOfDocListChange);
        RxUtils.dispose((Disposable)this.subscriptionOfPageChange);
        RxUtils.dispose((Disposable)this.subscriptionOfStudentAuthChange);
    }

    public void destroy() {
        this.routerViewModel = null;
        this.view = null;
    }

    @Override
    public void setSwitchPosition(int position) {
        this.routerViewModel.getNotifyPPTPageCurrent().setValue((Object)position);
    }

    @Override
    public void addPage() {
        this.routerViewModel.getAddPPTWhiteboardPage().setValue((Object)Unit.INSTANCE);
    }

    @Override
    public void delPage(int pageId) {
        this.routerViewModel.getDeletePPTWhiteboardPage().setValue((Object)pageId);
    }

    @Override
    public void changePage(int page) {
        this.routerViewModel.getChangePPTPage().setValue((Object)new Pair((Object)"0", (Object)page));
    }

    @Override
    public boolean canOperateDocumentControl() {
        IUserModel currentUser = this.routerViewModel.getLiveRoom().getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        if (currentUser.getType() == LPConstants.LPUserType.Teacher || currentUser.getType() == LPConstants.LPUserType.Assistant) {
            return true;
        }
        return !this.routerViewModel.getLiveRoom().getStudentSwitchPPTState();
    }

    @Override
    public boolean isBroadcasting() {
        return this.routerViewModel.getLiveRoom().isBroadcasting();
    }

    @Override
    public void changeDocList() {
        this.view.docListChanged(this.routerViewModel.getLiveRoom().getDocListVM().getDocList());
    }

    @Override
    public void setRouter(RouterViewModel routerViewModel2) {
        this.routerViewModel = routerViewModel2;
    }

    @Override
    public RouterViewModel getRouter() {
        return this.routerViewModel;
    }
}

