/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.loading;

import android.animation.ValueAnimator;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.baijiayun.livebase.base.BaseViewModelFactory;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.LiveRoomActivity;
import com.baijiayun.liveuibase.loading.ILoadingWindow;
import com.baijiayun.liveuibase.loading.LoadingWindow;
import com.baijiayun.liveuibase.utils.NetworkUtils;
import com.baijiayun.liveuibase.viewmodel.RouterViewModel;
import com.tencent.mmkv.MMKV;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0!H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0016J\u0012\u0010)\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0010\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/baijiayun/liveuibase/loading/LoadingWindow;", "Lcom/baijiayun/liveuibase/loading/ILoadingWindow;", "activity", "Landroidx/fragment/app/FragmentActivity;", "(Landroidx/fragment/app/FragmentActivity;)V", "deviceCheckResult", "", "", "loadingProgress", "", "mmkv", "Lcom/tencent/mmkv/MMKV;", "kotlin.jvm.PlatformType", "getMmkv", "()Lcom/tencent/mmkv/MMKV;", "mmkv$delegate", "Lkotlin/Lazy;", "rootView", "Landroid/view/View;", "getRootView", "()Landroid/view/View;", "rootView$delegate", "routerViewModel", "Lcom/baijiayun/liveuibase/viewmodel/RouterViewModel;", "getRouterViewModel", "()Lcom/baijiayun/liveuibase/viewmodel/RouterViewModel;", "routerViewModel$delegate", "valueAnimator", "Landroid/animation/ValueAnimator;", "cancelAnimator", "", "checkDevice", "enterRoom", "Lkotlin/Function0;", "getView", "onLaunchError", "error", "Lcom/baijiayun/livebase/context/LPError;", "onLaunchSteps", "step", "totalStep", "onLaunchSuccess", "liveRoom", "Lcom/baijiayun/livecore/context/LiveRoom;", "prepareWindowView", "liveuibase_release"})
public final class LoadingWindow
implements ILoadingWindow {
    @NotNull
    private final FragmentActivity activity;
    @Nullable
    private ValueAnimator valueAnimator;
    @NotNull
    private final List<Boolean> deviceCheckResult;
    private int loadingProgress;
    @NotNull
    private final Lazy routerViewModel$delegate;
    @NotNull
    private final Lazy mmkv$delegate;
    @NotNull
    private final Lazy rootView$delegate;

    public LoadingWindow(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activity = activity;
        this.deviceCheckResult = new ArrayList();
        this.routerViewModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RouterViewModel>(this){
            final /* synthetic */ LoadingWindow this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final RouterViewModel invoke() {
                void $this$getViewModel$iv;
                FragmentActivity fragmentActivity = LoadingWindow.access$getActivity$p(this.this$0);
                Function0 creator$iv = routerViewModel.1.INSTANCE;
                boolean $i$f$getViewModel = false;
                return (RouterViewModel)(creator$iv == null ? new ViewModelProvider((ViewModelStoreOwner)$this$getViewModel$iv).get(RouterViewModel.class) : new ViewModelProvider((ViewModelStoreOwner)$this$getViewModel$iv, (ViewModelProvider.Factory)new BaseViewModelFactory(creator$iv)).get(RouterViewModel.class));
            }
        }));
        this.mmkv$delegate = LazyKt.lazy((Function0)mmkv.2.INSTANCE);
        this.rootView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<View>(this){
            final /* synthetic */ LoadingWindow this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final View invoke() {
                return LayoutInflater.from((Context)((Context)LoadingWindow.access$getActivity$p(this.this$0))).inflate(R.layout.bjy_base_fragment_loading, null);
            }
        }));
    }

    private final RouterViewModel getRouterViewModel() {
        Lazy lazy = this.routerViewModel$delegate;
        return (RouterViewModel)((Object)lazy.getValue());
    }

    private final MMKV getMmkv() {
        Lazy lazy = this.mmkv$delegate;
        return (MMKV)lazy.getValue();
    }

    private final View getRootView() {
        Lazy lazy = this.rootView$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-rootView>(...)");
        return (View)object;
    }

    @Override
    @NotNull
    public View getView() {
        return this.getRootView();
    }

    @Override
    public void onLaunchSteps(int step, int totalStep) {
        block2: {
            int start2 = this.loadingProgress;
            int end = step * 100 / totalStep;
            this.cancelAnimator();
            int[] nArray = new int[]{start2, end};
            ValueAnimator valueAnimator = this.valueAnimator = ValueAnimator.ofInt((int[])nArray);
            if (valueAnimator != null) {
                valueAnimator.setDuration(300L);
            }
            ValueAnimator valueAnimator2 = this.valueAnimator;
            if (valueAnimator2 != null) {
                valueAnimator2.addUpdateListener(arg_0 -> LoadingWindow.onLaunchSteps$lambda$0(this, arg_0));
            }
            ValueAnimator valueAnimator3 = this.valueAnimator;
            if (valueAnimator3 == null) break block2;
            valueAnimator3.start();
        }
    }

    @Override
    public void onLaunchSuccess(@Nullable LiveRoom liveRoom2) {
        block1: {
            if (TextUtils.isEmpty((CharSequence)this.getMmkv().decodeString("ip"))) break block1;
            Map data = new LinkedHashMap();
            data.put("camera_status", this.getMmkv().decodeBool("camera_status", true) ? "1" : "0");
            data.put("mic_status", this.getMmkv().decodeBool("mic_status", true) ? "1" : "0");
            data.put("speaker_status", this.getMmkv().decodeBool("speaker_status", true) ? "1" : "0");
            Map map = data;
            String string2 = "os";
            String string3 = this.getMmkv().decodeString("os");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mmkv.decodeString(\"os\")");
            String string4 = string3;
            map.put(string2, string4);
            map = data;
            string2 = "client";
            String string5 = this.getMmkv().decodeString("client");
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"mmkv.decodeString(\"client\")");
            string4 = string5;
            map.put(string2, string4);
            map = data;
            string2 = "ip";
            String string6 = this.getMmkv().decodeString("ip");
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"mmkv.decodeString(\"ip\")");
            string4 = string6;
            map.put(string2, string4);
            LiveRoom liveRoom3 = liveRoom2;
            if (liveRoom3 != null) {
                liveRoom3.uploadDeviceInfo(data);
            }
        }
    }

    @Override
    public void onLaunchError(@NotNull LPError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
    }

    @Override
    public void checkDevice(@NotNull Function0<Unit> enterRoom2) {
        ImageView imageView;
        Intrinsics.checkNotNullParameter(enterRoom2, (String)"enterRoom");
        this.prepareWindowView();
        this.deviceCheckResult.clear();
        this.deviceCheckResult.add(!TextUtils.isEmpty((CharSequence)NetworkUtils.getIPAddress((Context)this.activity)));
        if (this.getRouterViewModel().isTvMode()) {
            this.deviceCheckResult.add(true);
            this.deviceCheckResult.add(true);
            this.deviceCheckResult.add(true);
        } else {
            this.deviceCheckResult.add(ActivityCompat.checkSelfPermission((Context)((Context)this.activity), (String)"android.permission.CAMERA") == 0);
            this.deviceCheckResult.add(true);
            this.deviceCheckResult.add(ActivityCompat.checkSelfPermission((Context)((Context)this.activity), (String)"android.permission.RECORD_AUDIO") == 0);
        }
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_net_check_iv)).setEnabled(this.deviceCheckResult.get(0).booleanValue());
        ImageView $this$checkDevice_u24lambda_u241 = imageView = (ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_net_check_result_iv);
        boolean bl = false;
        $this$checkDevice_u24lambda_u241.setVisibility(0);
        $this$checkDevice_u24lambda_u241.setEnabled(this.deviceCheckResult.get(0).booleanValue());
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_camera_check_iv)).setEnabled(this.deviceCheckResult.get(1).booleanValue());
        ImageView $this$checkDevice_u24lambda_u242 = imageView = (ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_camera_check_result_iv);
        boolean bl2 = false;
        $this$checkDevice_u24lambda_u242.setVisibility(0);
        $this$checkDevice_u24lambda_u242.setEnabled(this.deviceCheckResult.get(1).booleanValue());
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_speaker_check_iv)).setEnabled(this.deviceCheckResult.get(2).booleanValue());
        ImageView $this$checkDevice_u24lambda_u243 = imageView = (ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_speaker_check_result_iv);
        boolean bl3 = false;
        $this$checkDevice_u24lambda_u243.setVisibility(0);
        $this$checkDevice_u24lambda_u243.setEnabled(this.deviceCheckResult.get(2).booleanValue());
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_mic_check_iv)).setEnabled(this.deviceCheckResult.get(3).booleanValue());
        ImageView $this$checkDevice_u24lambda_u244 = imageView = (ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_mic_check_result_iv);
        boolean bl4 = false;
        $this$checkDevice_u24lambda_u244.setVisibility(0);
        $this$checkDevice_u24lambda_u244.setEnabled(this.deviceCheckResult.get(3).booleanValue());
        if (!this.deviceCheckResult.get(0).booleanValue()) {
            ImageView $this$checkDevice_u24lambda_u245 = imageView = (TextView)this.getRootView().findViewById(R.id.bjy_base_window_loading_device_check_result_tv);
            boolean bl5 = false;
            $this$checkDevice_u24lambda_u245.setText(this.deviceCheckResult.get(1) != false && this.deviceCheckResult.get(3) != false ? (CharSequence)this.activity.getString(R.string.bjy_base_window_loading_net_fail) : (CharSequence)this.activity.getString(R.string.bjy_base_window_loading_net_and_device_fail));
            $this$checkDevice_u24lambda_u245.setTextColor(ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.bjy_base_window_loading_device_check_failed_text_color));
            ((LinearLayout)this.getRootView().findViewById(R.id.bjy_base_window_loading_check_fail_button_container)).setVisibility(0);
            ImageView $this$checkDevice_u24lambda_u247 = imageView = (Button)this.getRootView().findViewById(R.id.bjy_base_window_loading_positive_button);
            boolean bl6 = false;
            $this$checkDevice_u24lambda_u247.setText((CharSequence)this.activity.getString(R.string.bjy_base_window_loading_retry));
            $this$checkDevice_u24lambda_u247.setOnClickListener(arg_0 -> LoadingWindow.checkDevice$lambda$7$lambda$6(this, enterRoom2, arg_0));
            ImageView $this$checkDevice_u24lambda_u249 = imageView = (Button)this.getRootView().findViewById(R.id.bjy_base_window_loading_negative_button);
            boolean bl7 = false;
            $this$checkDevice_u24lambda_u249.setText((CharSequence)this.activity.getString(R.string.bjy_base_window_loading_exit));
            $this$checkDevice_u24lambda_u249.setOnClickListener(arg_0 -> LoadingWindow.checkDevice$lambda$9$lambda$8(this, arg_0));
        } else if (!this.deviceCheckResult.get(1).booleanValue() || !this.deviceCheckResult.get(3).booleanValue()) {
            ImageView $this$checkDevice_u24lambda_u2410 = imageView = (TextView)this.getRootView().findViewById(R.id.bjy_base_window_loading_device_check_result_tv);
            boolean bl8 = false;
            $this$checkDevice_u24lambda_u2410.setText((CharSequence)this.activity.getString(R.string.bjy_base_window_loading_device_fail));
            $this$checkDevice_u24lambda_u2410.setTextColor(ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.bjy_base_window_loading_device_check_failed_text_color));
            ((LinearLayout)this.getRootView().findViewById(R.id.bjy_base_window_loading_check_fail_button_container)).setVisibility(0);
            ImageView $this$checkDevice_u24lambda_u2412 = imageView = (Button)this.getRootView().findViewById(R.id.bjy_base_window_loading_positive_button);
            boolean bl9 = false;
            $this$checkDevice_u24lambda_u2412.setText((CharSequence)this.activity.getString(R.string.base_live_leave_room));
            $this$checkDevice_u24lambda_u2412.setOnClickListener(arg_0 -> LoadingWindow.checkDevice$lambda$12$lambda$11(this, arg_0));
            ImageView $this$checkDevice_u24lambda_u2415 = imageView = (Button)this.getRootView().findViewById(R.id.bjy_base_window_loading_negative_button);
            boolean bl10 = false;
            $this$checkDevice_u24lambda_u2415.setText((CharSequence)this.activity.getString(R.string.bjy_base_window_loading_enter_room));
            $this$checkDevice_u24lambda_u2415.setOnClickListener(arg_0 -> LoadingWindow.checkDevice$lambda$15$lambda$14((Button)$this$checkDevice_u24lambda_u2415, enterRoom2, this, arg_0));
        } else {
            ImageView $this$checkDevice_u24lambda_u2416 = imageView = (TextView)this.getRootView().findViewById(R.id.bjy_base_window_loading_device_check_result_tv);
            boolean bl11 = false;
            $this$checkDevice_u24lambda_u2416.setText((CharSequence)this.activity.getString(R.string.bjy_base_window_loading_device_check_path));
            $this$checkDevice_u24lambda_u2416.setTextColor(ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.bjy_base_window_loading_device_checking_text_color));
            ImageView $this$checkDevice_u24lambda_u2417 = imageView = (TextView)this.getRootView().findViewById(R.id.bjy_base_window_loading_progress_tv);
            boolean bl12 = false;
            $this$checkDevice_u24lambda_u2417.setVisibility(0);
            Object[] objectArray = new Object[]{0};
            $this$checkDevice_u24lambda_u2417.setText((CharSequence)this.activity.getString(R.string.bjy_base_window_loading_progress, objectArray));
            enterRoom2.invoke();
        }
    }

    private final void prepareWindowView() {
        TextView textView;
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_net_check_iv)).setEnabled(false);
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_camera_check_iv)).setEnabled(false);
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_speaker_check_iv)).setEnabled(false);
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_mic_check_iv)).setEnabled(false);
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_net_check_result_iv)).setVisibility(4);
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_camera_check_result_iv)).setVisibility(4);
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_speaker_check_result_iv)).setVisibility(4);
        ((ImageView)this.getRootView().findViewById(R.id.bjy_base_window_loading_mic_check_result_iv)).setVisibility(4);
        TextView $this$prepareWindowView_u24lambda_u2418 = textView = (TextView)this.getRootView().findViewById(R.id.bjy_base_window_loading_device_check_result_tv);
        boolean bl = false;
        $this$prepareWindowView_u24lambda_u2418.setText((CharSequence)this.activity.getString(R.string.bjy_base_window_loading_device_checking));
        $this$prepareWindowView_u24lambda_u2418.setTextColor(ContextCompat.getColor((Context)((Context)this.activity), (int)R.color.bjy_base_window_loading_device_checking_text_color));
        ((LinearLayout)this.getRootView().findViewById(R.id.bjy_base_window_loading_check_fail_button_container)).setVisibility(4);
        ((TextView)this.getRootView().findViewById(R.id.bjy_base_window_loading_progress_tv)).setVisibility(4);
    }

    private final void cancelAnimator() {
        ValueAnimator valueAnimator = this.valueAnimator;
        boolean bl = valueAnimator != null ? valueAnimator.isRunning() : false;
        if (bl) {
            ValueAnimator valueAnimator2 = this.valueAnimator;
            if (valueAnimator2 != null) {
                valueAnimator2.cancel();
            }
            this.loadingProgress = 0;
        }
    }

    private static final void onLaunchSteps$lambda$0(LoadingWindow this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        this$0.loadingProgress = (Integer)object;
        Object[] objectArray = new Object[]{this$0.loadingProgress};
        ((TextView)this$0.getRootView().findViewById(R.id.bjy_base_window_loading_progress_tv)).setText((CharSequence)this$0.activity.getString(R.string.bjy_base_window_loading_progress, objectArray));
    }

    private static final void checkDevice$lambda$7$lambda$6(LoadingWindow this$0, Function0 $enterRoom, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$enterRoom, (String)"$enterRoom");
        this$0.prepareWindowView();
        this$0.checkDevice((Function0<Unit>)$enterRoom);
    }

    private static final void checkDevice$lambda$9$lambda$8(LoadingWindow this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.activity instanceof LiveRoomActivity) {
            ((LiveRoomActivity)this$0.activity).setExitError(LPError.getNewError((int)-1001, (String)"\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38"));
        }
        this$0.activity.finish();
    }

    private static final void checkDevice$lambda$12$lambda$11(LoadingWindow this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.activity instanceof LiveRoomActivity) {
            ((LiveRoomActivity)this$0.activity).setExitError(LPError.getNewError((int)-1014, (String)"\u65e0\u89c6\u9891\u6216\u97f3\u9891\u6743\u9650"));
        }
        this$0.activity.finish();
    }

    private static final void checkDevice$lambda$15$lambda$14(Button $this_apply, Function0 $enterRoom, LoadingWindow this$0, View it) {
        TextView textView;
        Intrinsics.checkNotNullParameter((Object)$enterRoom, (String)"$enterRoom");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ((TextView)$this_apply.getRootView().findViewById(R.id.bjy_base_window_loading_device_check_result_tv)).setText((CharSequence)"");
        ((LinearLayout)$this_apply.getRootView().findViewById(R.id.bjy_base_window_loading_check_fail_button_container)).setVisibility(4);
        TextView $this$checkDevice_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413 = textView = (TextView)$this_apply.getRootView().findViewById(R.id.bjy_base_window_loading_progress_tv);
        boolean bl = false;
        $this$checkDevice_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setVisibility(0);
        Object[] objectArray = new Object[]{0};
        $this$checkDevice_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.setText((CharSequence)this$0.activity.getString(R.string.bjy_base_window_loading_progress, objectArray));
        $enterRoom.invoke();
    }

    public static final /* synthetic */ FragmentActivity access$getActivity$p(LoadingWindow $this) {
        return $this.activity;
    }
}

