/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.devicetesting.fragment;

import android.content.Context;
import android.media.AudioRecord;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.devicetesting.DeviceTestingViewModel;
import com.baijiayun.liveuibase.devicetesting.fragment.DeviceTestingDialogFragment;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J&\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u0016H\u0016J\u001a\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/baijiayun/liveuibase/devicetesting/fragment/DeviceTestingMicFragment;", "Landroidx/fragment/app/Fragment;", "()V", "SAMPLE_RATE_IN_HZ", "", "audioRecord", "Landroid/media/AudioRecord;", "bufferSize", "disposableOfTime", "Lio/reactivex/disposables/Disposable;", "isRun", "", "mHandler", "Landroid/os/Handler;", "mLock", "Ljava/lang/Object;", "recordThread", "Ljava/lang/Thread;", "viewModel", "Lcom/baijiayun/liveuibase/devicetesting/DeviceTestingViewModel;", "volumeBlockNum", "initAction", "", "initMicVolumeView", "initView", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onPause", "onViewCreated", "view", "updateMicVolumeView", "enableNum", "liveuibase_release"})
public final class DeviceTestingMicFragment
extends Fragment {
    @Nullable
    private Disposable disposableOfTime;
    private DeviceTestingViewModel viewModel;
    private int volumeBlockNum;
    private final int SAMPLE_RATE_IN_HZ;
    private int bufferSize;
    @Nullable
    private AudioRecord audioRecord;
    private boolean isRun;
    @NotNull
    private final Object mLock;
    @NotNull
    private Handler mHandler;
    @Nullable
    private Thread recordThread;
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap();

    public DeviceTestingMicFragment() {
        this.SAMPLE_RATE_IN_HZ = 8000;
        this.mLock = new Object();
        this.mHandler = new Handler(arg_0 -> DeviceTestingMicFragment.mHandler$lambda$0(this, arg_0));
    }

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container2, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        return inflater.inflate(R.layout.bjy_base_fragment_device_testing_mic, container2, false);
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        this.viewModel = (DeviceTestingViewModel)new ViewModelProvider((ViewModelStoreOwner)fragmentActivity).get(DeviceTestingViewModel.class);
        this.initView();
        this.initAction();
    }

    private final void initView() {
        block0: {
            this.initMicVolumeView();
            ((TextView)this._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_description_tv)).setVisibility(4);
            ((Button)this._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_positive_btn)).setVisibility(4);
            ((Button)this._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_negative_btn)).setVisibility(4);
            ((Button)this._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_positive_btn)).setOnClickListener(arg_0 -> DeviceTestingMicFragment.initView$lambda$1(this, arg_0));
            ((Button)this._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_negative_btn)).setOnClickListener(arg_0 -> DeviceTestingMicFragment.initView$lambda$2(this, arg_0));
            RxUtils.Companion.dispose(this.disposableOfTime);
            this.disposableOfTime = Observable.timer((long)2L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(arg_0 -> DeviceTestingMicFragment.initView$lambda$3((Function1)new Function1<Long, Unit>(this){
                final /* synthetic */ DeviceTestingMicFragment this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(Long it) {
                    ((TextView)this.this$0._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_description_tv)).setVisibility(0);
                    ((Button)this.this$0._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_positive_btn)).setVisibility(0);
                    ((Button)this.this$0._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_negative_btn)).setVisibility(0);
                    DeviceTestingMicFragment.access$updateMicVolumeView(this.this$0, 10);
                }
            }, arg_0));
            Thread thread = this.recordThread = new Thread(() -> DeviceTestingMicFragment.initView$lambda$5(this));
            if (thread == null) break block0;
            thread.start();
        }
    }

    private final void initAction() {
        DeviceTestingViewModel deviceTestingViewModel = this.viewModel;
        if (deviceTestingViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            deviceTestingViewModel = null;
        }
        deviceTestingViewModel.getEarphoneState().observe((LifecycleOwner)this, arg_0 -> DeviceTestingMicFragment.initAction$lambda$6((Function1)new Function1<Boolean, Unit>(this){
            final /* synthetic */ DeviceTestingMicFragment this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Boolean it) {
                TextView textView = (TextView)this.this$0._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_name_tv);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                textView.setText(it != false ? (CharSequence)this.this$0.getString(R.string.bjy_base_device_testing_mic_other) : (CharSequence)this.this$0.getString(R.string.bjy_base_device_testing_mic_default));
            }
        }, arg_0));
    }

    private final void initMicVolumeView() {
        ((LinearLayout)this._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_volume_container)).post(() -> DeviceTestingMicFragment.initMicVolumeView$lambda$7(this));
    }

    private final void updateMicVolumeView(int enableNum) {
        if (this.volumeBlockNum == 0) {
            return;
        }
        int n = this.volumeBlockNum;
        for (int i = 0; i < n; ++i) {
            if (i < enableNum) {
                LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_volume_container);
                Object object = linearLayout != null ? linearLayout.getChildAt(i) : null;
                if (object == null) continue;
                Context context2 = this.getContext();
                Intrinsics.checkNotNull((Object)context2);
                object.setBackground(ContextCompat.getDrawable((Context)context2, (int)R.drawable.bjy_base_fragment_device_testing_bg_volume_enable));
                continue;
            }
            LinearLayout linearLayout = (LinearLayout)this._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_volume_container);
            Object object = linearLayout != null ? linearLayout.getChildAt(i) : null;
            if (object == null) continue;
            Context context3 = this.getContext();
            Intrinsics.checkNotNull((Object)context3);
            object.setBackground(ContextCompat.getDrawable((Context)context3, (int)R.drawable.bjy_base_fragment_device_testing_bg_volume_normal));
        }
    }

    public void onPause() {
        super.onPause();
        RxUtils.Companion.dispose(this.disposableOfTime);
        this.isRun = false;
    }

    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    @Nullable
    public View _$_findCachedViewById(int id2) {
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get(id2);
        if (view == null) {
            View view2;
            View view3 = this.getView();
            if (view3 != null && (view2 = view3.findViewById(id2)) != null) {
                map.put(id2, view2);
                view = view2;
            } else {
                view = null;
            }
        }
        return view;
    }

    private static final boolean mHandler$lambda$0(DeviceTestingMicFragment this$0, Message it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.what == 1) {
            Object object = it.obj;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            this$0.updateMicVolumeView((Integer)object);
            bl = true;
        } else {
            bl = true;
        }
        return bl;
    }

    private static final void initView$lambda$1(DeviceTestingMicFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        DeviceTestingViewModel deviceTestingViewModel = this$0.viewModel;
        if (deviceTestingViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            deviceTestingViewModel = null;
        }
        deviceTestingViewModel.setMicResult(true);
        DeviceTestingViewModel deviceTestingViewModel2 = this$0.viewModel;
        if (deviceTestingViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            deviceTestingViewModel2 = null;
        }
        deviceTestingViewModel2.setTestStep(DeviceTestingViewModel.TestStep.TestEnd);
    }

    private static final void initView$lambda$2(DeviceTestingMicFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        DeviceTestingDialogFragment dialogFragment = new DeviceTestingDialogFragment();
        String string2 = this$0.getString(R.string.bjy_base_device_testing_mic_confirm_question);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.bjy_b\u2026ing_mic_confirm_question)");
        dialogFragment.setTitle(string2);
        String string3 = this$0.getString(R.string.bjy_base_device_testing_mic_confirm_tip);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(R.string.bjy_b\u2026_testing_mic_confirm_tip)");
        dialogFragment.setContent(string3);
        String string4 = this$0.getString(R.string.bjy_base_device_testing_mic_no);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(R.string.bjy_base_device_testing_mic_no)");
        dialogFragment.setNegativeButtonText(string4);
        String string5 = this$0.getString(R.string.bjy_base_device_testing_mic_yes);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(R.string.bjy_b\u2026e_device_testing_mic_yes)");
        dialogFragment.setPositiveButtonText(string5);
        dialogFragment.setButtonClickedListener(new DeviceTestingDialogFragment.OnButtonClickedListener(this$0, dialogFragment){
            final /* synthetic */ DeviceTestingMicFragment this$0;
            final /* synthetic */ DeviceTestingDialogFragment $dialogFragment;
            {
                this.this$0 = $receiver;
                this.$dialogFragment = $dialogFragment;
            }

            public void onPositive() {
                DeviceTestingViewModel deviceTestingViewModel = DeviceTestingMicFragment.access$getViewModel$p(this.this$0);
                if (deviceTestingViewModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    deviceTestingViewModel = null;
                }
                deviceTestingViewModel.setMicResult(true);
                DeviceTestingViewModel deviceTestingViewModel2 = DeviceTestingMicFragment.access$getViewModel$p(this.this$0);
                if (deviceTestingViewModel2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    deviceTestingViewModel2 = null;
                }
                deviceTestingViewModel2.setTestStep(DeviceTestingViewModel.TestStep.TestEnd);
                this.$dialogFragment.dismissAllowingStateLoss();
            }

            public void onNegative() {
                DeviceTestingViewModel deviceTestingViewModel = DeviceTestingMicFragment.access$getViewModel$p(this.this$0);
                if (deviceTestingViewModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    deviceTestingViewModel = null;
                }
                deviceTestingViewModel.setMicResult(false);
                DeviceTestingViewModel deviceTestingViewModel2 = DeviceTestingMicFragment.access$getViewModel$p(this.this$0);
                if (deviceTestingViewModel2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    deviceTestingViewModel2 = null;
                }
                deviceTestingViewModel2.setTestStep(DeviceTestingViewModel.TestStep.TestEnd);
                this.$dialogFragment.dismissAllowingStateLoss();
            }
        });
        FragmentActivity fragmentActivity = this$0.getActivity();
        Intrinsics.checkNotNull((Object)fragmentActivity);
        dialogFragment.show(fragmentActivity.getSupportFragmentManager(), "mic");
    }

    private static final void initView$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void initView$lambda$5(DeviceTestingMicFragment this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.bufferSize = AudioRecord.getMinBufferSize((int)this$0.SAMPLE_RATE_IN_HZ, (int)2, (int)2);
        AudioRecord audioRecord = this$0.audioRecord = new AudioRecord(1, this$0.SAMPLE_RATE_IN_HZ, 2, 2, this$0.bufferSize);
        if (audioRecord != null) {
            audioRecord.startRecording();
        }
        this$0.isRun = true;
        short[] buffer = new short[this$0.bufferSize];
        while (this$0.isRun) {
            AudioRecord audioRecord2 = this$0.audioRecord;
            Integer r = audioRecord2 != null ? Integer.valueOf(audioRecord2.read(buffer, 0, this$0.bufferSize)) : null;
            long v = 0L;
            int n = buffer.length;
            for (int i = 0; i < n; ++i) {
                v += (long)(buffer[i] * buffer[i]);
            }
            Integer n2 = r;
            Intrinsics.checkNotNull((Object)n2);
            double mean = v / (long)n2.intValue();
            int volume = ((int)((double)10 * Math.log10(mean)) - 30) / 5;
            Message message = new Message();
            message.what = 1;
            message.obj = volume;
            this$0.mHandler.sendMessage(message);
            Object object = this$0.mLock;
            synchronized (object) {
                boolean bl = false;
                try {
                    this$0.mLock.wait(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        AudioRecord audioRecord3 = this$0.audioRecord;
        if (audioRecord3 != null) {
            audioRecord3.stop();
        }
        AudioRecord audioRecord4 = this$0.audioRecord;
        if (audioRecord4 != null) {
            audioRecord4.release();
        }
        this$0.audioRecord = null;
    }

    private static final void initAction$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void initMicVolumeView$lambda$7(DeviceTestingMicFragment this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        int containerWidth = ((LinearLayout)this$0._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_volume_container)).getWidth();
        this$0.volumeBlockNum = (int)((float)containerWidth / UtilsKt.getDp((float)12.0f));
        int n = this$0.volumeBlockNum;
        for (int i = 0; i < n; ++i) {
            View view = new View(this$0.getContext());
            Context context2 = this$0.getContext();
            Intrinsics.checkNotNull((Object)context2);
            view.setBackground(ContextCompat.getDrawable((Context)context2, (int)R.drawable.bjy_base_fragment_device_testing_bg_volume_normal));
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(UtilsKt.getDp((int)8), -1);
            layoutParams.setMarginEnd(UtilsKt.getDp((int)4));
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ((LinearLayout)this$0._$_findCachedViewById(R.id.bjy_base_fragment_device_testing_mic_volume_container)).addView(view, i);
        }
    }

    public static final /* synthetic */ void access$updateMicVolumeView(DeviceTestingMicFragment $this, int enableNum) {
        $this.updateMicVolumeView(enableNum);
    }

    public static final /* synthetic */ DeviceTestingViewModel access$getViewModel$p(DeviceTestingMicFragment $this) {
        return $this.viewModel;
    }

    public /* synthetic */ void onDestroyView() {
        super.onDestroyView();
        this._$_clearFindViewByIdCache();
    }
}

