/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.chat;

import android.content.Context;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.liveuibase.R;

public class LengthFilter
implements InputFilter {
    private final int mMax;
    private Context context;
    private String tip;

    public LengthFilter(Context context2, int max) {
        this.context = context2;
        this.mMax = max;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public CharSequence filter(CharSequence source, int start2, int end, Spanned dest, int dstart, int dend) {
        int keep = this.mMax - (dest.length() - (dend - dstart));
        if (keep <= 0) {
            if (TextUtils.isEmpty((CharSequence)this.tip)) {
                ToastCompat.showToast((Context)this.context, (CharSequence)this.context.getString(R.string.chat_input_text_beyond_tips, new Object[]{this.mMax}), (int)0);
            } else {
                ToastCompat.showToast((Context)this.context, (CharSequence)this.tip, (int)0);
            }
            return "";
        }
        if (keep >= end - start2) {
            return null;
        }
        if (Character.isHighSurrogate(source.charAt((keep += start2) - 1)) && --keep == start2) {
            return "";
        }
        return source.subSequence(start2, keep);
    }

    public int getMax() {
        return this.mMax;
    }
}

