/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.base;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.baijiayun.liveuibase.base.ILayer;
import com.baijiayun.liveuibase.base.IWindow;
import com.baijiayun.liveuibase.base.RouterListener;
import io.reactivex.disposables.CompositeDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseLayer
extends FrameLayout
implements ILayer,
LifecycleObserver {
    private Lifecycle lifecycle;
    protected CompositeDisposable compositeDisposable = new CompositeDisposable();

    public BaseLayer(@NonNull Context context2) {
        super(context2);
        this.init();
    }

    public BaseLayer(@NonNull Context context2, @Nullable AttributeSet attrs) {
        super(context2, attrs);
        this.init();
    }

    public BaseLayer(@NonNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public BaseLayer(@NonNull Context context2, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context2, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    @CallSuper
    protected void init() {
        Context context2 = this.getContext();
        if (context2 instanceof RouterListener) {
            RouterListener routerListener2 = (RouterListener)context2;
            this.lifecycle = routerListener2.getLifecycle();
            this.lifecycle.addObserver((LifecycleObserver)this);
        }
    }

    @Override
    public void addWindow(@Nullable IWindow window2) {
        if (window2 != null) {
            this.addView(window2.getView(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        }
    }

    @Override
    public void addWindow(@Nullable IWindow window2, @NotNull FrameLayout.LayoutParams layoutParams) {
        if (window2 != null) {
            this.addView(window2.getView(), (ViewGroup.LayoutParams)layoutParams);
        }
    }

    @Override
    public void addWindow(@Nullable IWindow window2, @NotNull ViewGroup.LayoutParams layoutParams) {
        if (window2 != null) {
            this.addView(window2.getView(), layoutParams);
        }
    }

    @Override
    public void removeWindow(@Nullable IWindow window2) {
        if (window2 != null) {
            this.removeView(window2.getView());
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    @CallSuper
    protected void onDestroy() {
        this.compositeDisposable.clear();
    }

    public void removeAndDestroy(@Nullable BaseLayer layer) {
        if (layer != null) {
            this.removeView((View)layer);
            layer.onDestroy();
        }
    }

    @Override
    @Nullable
    public ViewGroup getViewGroup() {
        return this;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.lifecycle != null) {
            this.onDestroy();
        }
    }
}

