/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.announcement;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.StringRes;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.baijiayun.livebase.base.BaseFragment;
import com.baijiayun.livebase.base.BasePresenter;
import com.baijiayun.livecore.models.imodels.IAnnouncementModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.announcement.AnnouncementContract;
import com.baijiayun.liveuibase.announcement.modelui.BlankTipsFragment;
import com.baijiayun.liveuibase.announcement.modelui.DoubleAnnContract;
import com.baijiayun.liveuibase.announcement.modelui.DoubleAnnFragment;
import com.baijiayun.liveuibase.announcement.modelui.DoubleAnnPresenter;
import com.baijiayun.liveuibase.announcement.modelui.EditAnnContract;
import com.baijiayun.liveuibase.announcement.modelui.EditAnnFragment;
import com.baijiayun.liveuibase.announcement.modelui.EditAnnPresenter;
import com.baijiayun.liveuibase.announcement.modelui.IAnnouncementUI;
import com.baijiayun.liveuibase.announcement.modelui.NoticeInfo;
import com.baijiayun.liveuibase.base.BaseWindow;

public class AnnouncementWindow
extends BaseWindow
implements AnnouncementContract.View {
    private AnnouncementContract.Presenter mPresenter;
    protected FragmentManager mFragmentManager;
    private BaseFragment mCurrFragment;
    private BasePresenter mCurrPresenter;
    private IAnnouncementModel mIAnnModel;
    private EditAnnContract.OnAnnEditListener mAnnEditListener = new EditAnnContract.OnAnnEditListener(){

        @Override
        public void cancel() {
            AnnouncementWindow.this.$.id(R.id.tv_announcement_edit_button).visible();
            AnnouncementWindow.this.$.id(R.id.tv_announcement_edit_layout).gone();
            AnnouncementWindow.this.mPresenter.switchUI();
        }

        @Override
        public void onError() {
        }

        @Override
        public void Success() {
        }
    };

    public AnnouncementWindow(Context context2, FragmentManager fragmentManager) {
        super(context2);
        this.mFragmentManager = fragmentManager;
        this.initView();
    }

    @Override
    protected View onCreateView(Context context2) {
        this.setNeedShowShadow(true);
        this.allowTouch = true;
        return View.inflate((Context)context2, (int)this.getLayoutId(), null);
    }

    protected int getLayoutId() {
        return R.layout.bjy_dialog_announcement;
    }

    protected void initView() {
        this.$.id(R.id.tv_announcement_edit_button).visible();
        this.$.id(R.id.tv_announcement_edit_layout).gone();
        this.$.id(R.id.tv_announcement_edit_button).clicked(v -> {
            if (!this.mPresenter.canOperateNotice()) {
                this.showToastMessage(this.getString(R.string.live_room_notice_permission_forbid));
                return;
            }
            if (this.mCurrFragment != null) {
                this.removeFragment((Fragment)this.mCurrFragment);
            }
            this.mCurrFragment = null;
            this.mCurrPresenter = null;
            this.mCurrFragment = new EditAnnFragment();
            this.mCurrPresenter = new EditAnnPresenter((EditAnnFragment)this.mCurrFragment, this.mIAnnModel);
            ((EditAnnFragment)this.mCurrFragment).setPresenter((EditAnnContract.Presenter)this.mCurrPresenter);
            this.showFragment((Fragment)this.mCurrFragment);
            if (this.mPresenter.getRouter().getLiveRoom().isTeacherOrAssistant()) {
                this.setTitle(1);
            } else {
                this.setTitle(2);
            }
            this.$.id(R.id.tv_announcement_edit_button).invisible();
            this.$.id(R.id.tv_announcement_edit_layout).visible();
        });
        this.$.id(R.id.tv_announcement_edit_cancel).clicked(v -> {
            if (this.mAnnEditListener == null) {
                return;
            }
            this.mAnnEditListener.cancel();
            this.setTitle(1);
        });
        this.$.id(R.id.tv_announcement_edit_send).clicked(v -> {
            NoticeInfo info = ((IAnnouncementUI)this.mCurrPresenter).getNotice();
            if (info == null) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)info.link) && TextUtils.isEmpty((CharSequence)info.content)) {
                return;
            }
            if (info.link == null) {
                info.link = "";
            }
            if (info.content == null) {
                info.content = "";
            }
            this.mPresenter.saveAnnouncement(info.content, info.link);
            this.mPresenter.switchUI();
            this.$.id(R.id.tv_announcement_edit_button).visible();
            this.$.id(R.id.tv_announcement_edit_layout).gone();
            this.setTitle(1);
        });
        this.$.id(R.id.announcement_exit).clicked(v -> this.routerListener.onDismissAnnouncement());
    }

    private void initDefaultUI() {
        this.mCurrFragment = new BlankTipsFragment();
        this.showFragment((Fragment)this.mCurrFragment);
    }

    public void setPresenter(AnnouncementContract.Presenter presenter2) {
        this.mPresenter = presenter2;
        this.initDefaultUI();
        this.mPresenter.subscribe();
    }

    private void showFragment(Fragment fragment) {
        FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
        transaction.add(R.id.fl_announcement, fragment).commit();
    }

    protected void removeFragment(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        FragmentTransaction transaction = this.mFragmentManager.beginTransaction();
        transaction.remove(fragment);
        transaction.commitAllowingStateLoss();
    }

    @Override
    public void editButtonEnable(boolean enable, @StringRes int stringRes) {
        if (enable) {
            this.$.id(R.id.tv_announcement_edit_button).visibility(0);
            this.$.id(R.id.tv_announcement_edit_button).text((CharSequence)this.context.getResources().getString(stringRes));
        } else {
            this.$.id(R.id.tv_announcement_edit_button).visibility(8);
        }
    }

    @Override
    public void showBlankTips() {
        this.removeCurrFragment();
        this.mIAnnModel = null;
        this.mCurrFragment = new BlankTipsFragment();
        this.showFragment((Fragment)this.mCurrFragment);
    }

    @Override
    public void setTitle(int titleType) {
        if (titleType == 1) {
            this.$.id(R.id.tv_announcement_title).text((CharSequence)this.context.getResources().getString(R.string.live_announcement));
        } else {
            this.$.id(R.id.tv_announcement_title).text((CharSequence)this.context.getResources().getString(R.string.string_notice_group_title));
        }
    }

    private void removeCurrFragment() {
        if (this.mCurrFragment != null) {
            this.removeFragment((Fragment)this.mCurrFragment);
        }
        this.mCurrFragment = null;
        this.mCurrPresenter = null;
    }

    @Override
    public void showCurrUI(int type, int groupId) {
        this.removeCurrFragment();
        this.mCurrFragment = new DoubleAnnFragment();
        this.mCurrPresenter = type == 1001 ? new DoubleAnnPresenter((DoubleAnnFragment)this.mCurrFragment, 1001, groupId) : (type == 1002 ? new DoubleAnnPresenter((DoubleAnnFragment)this.mCurrFragment, 1002, groupId) : new DoubleAnnPresenter((DoubleAnnFragment)this.mCurrFragment, 1003, groupId));
        ((DoubleAnnFragment)this.mCurrFragment).setPresenter((DoubleAnnContract.Presenter)this.mCurrPresenter);
        this.showFragment((Fragment)this.mCurrFragment);
    }

    @Override
    public void setNoticeInfo(IAnnouncementModel iAnnouncementModel) {
        if (!(this.mCurrFragment instanceof DoubleAnnFragment)) {
            this.mPresenter.switchUI();
        }
        if (this.mCurrPresenter == null) {
            return;
        }
        if (String.valueOf(this.mPresenter.getRouter().getLiveRoom().getCurrentUser().getGroup()).equals(iAnnouncementModel.getGroup())) {
            this.mIAnnModel = iAnnouncementModel;
        }
        ((IAnnouncementUI)this.mCurrPresenter).setNoticeInfo(iAnnouncementModel);
    }

    @Override
    public void onDestroy() {
        this.mPresenter.unSubscribe();
        super.onDestroy();
    }
}

