/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.zxing;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import com.baijiahulian.common.permission.AppPermissions;
import com.baijiahulian.common.permission.PermissionTipsView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.toast.ToastCompat;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.zxing.ScanActivity;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.integration.android.IntentIntegrator;
import com.google.zxing.qrcode.QRCodeWriter;
import java.util.HashMap;

public class ZxingUtils {
    public static void startScan(Activity activity) {
        PermissionTipsView.Builder builder = new PermissionTipsView.Builder((Context)activity);
        PermissionTipsView permissionTipsView = builder.setIcon(R.drawable.bjy_base_permission_camera).setTitle(activity.getResources().getString(R.string.bjy_base_setting_type_camera)).setMessage(activity.getResources().getString(R.string.bjy_base_zxing_camera_permission_tips)).setOrientation(!UtilsKt.isOrientationLandscape((Context)activity)).build();
        AppPermissions.newPermissions((Activity)activity).request(permissionTipsView, new String[]{"android.permission.CAMERA"}).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                new IntentIntegrator(activity).setCaptureActivity(ScanActivity.class).setBeepEnabled(false).initiateScan();
            } else {
                ToastCompat.showToast((Context)activity, (CharSequence)activity.getString(R.string.base_live_no_camera_permission), (int)1);
            }
        });
    }

    public static Bitmap generateQRCodeBitmap(String content, int width, int height) {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        try {
            BitMatrix encode = qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, width, height, hints);
            int[] pixels = new int[width * height];
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    pixels[i * width + j] = encode.get(j, i) ? 0 : 0xFFFFFF;
                }
            }
            return Bitmap.createBitmap((int[])pixels, (int)0, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        }
        catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
    }
}

