/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.webview;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.baijiayun.livebase.widgets.view.webview.BJWebViewImpl;
import com.baijiayun.liveuibase.R;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;

public class ControllerWebView
extends FrameLayout {
    private TextView tvComplete;
    private TextView tvUrl;
    private ImageView ivRefresh;
    private BJWebViewImpl mWebView;
    private ImageView ivBack;
    private ImageView ivForward;
    private IOnOptListener mOnOptListener;

    public ControllerWebView(Context context2, @Nullable AttributeSet attrs) {
        super(context2, attrs);
        this.initView(context2);
    }

    public ControllerWebView(Context context2, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.initView(context2);
    }

    private void initView(Context context2) {
        LayoutInflater.from((Context)context2).inflate(R.layout.uibase_controller_webview, (ViewGroup)this);
        this.tvComplete = (TextView)this.findViewById(R.id.uibase_controller_webview_complete);
        this.tvUrl = (TextView)this.findViewById(R.id.uibase_controller_webview_url);
        this.ivRefresh = (ImageView)this.findViewById(R.id.uibase_controller_webview_refresh);
        this.mWebView = (BJWebViewImpl)this.findViewById(R.id.uibase_controller_webview_main);
        this.ivBack = (ImageView)this.findViewById(R.id.uibase_controller_webview_opt_back);
        this.ivForward = (ImageView)this.findViewById(R.id.uibase_controller_webview_opt_forward);
        this.initWebView();
        this.tvComplete.setOnClickListener(v -> {
            this.mWebView.clearHistory();
            if (this.mOnOptListener != null) {
                this.mOnOptListener.onComplete();
            }
        });
        this.ivRefresh.setOnClickListener(v -> this.mWebView.reload());
        this.ivBack.setOnClickListener(v -> {
            if (this.mWebView.canGoBack()) {
                this.mWebView.goBack();
            }
        });
        this.ivForward.setOnClickListener(v -> {
            if (this.mWebView.canGoForward()) {
                this.mWebView.goForward();
            }
        });
    }

    private void initWebView() {
        this.mWebView.setWebViewClient((WebViewClient)new BJWebViewImpl.BJWebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (url.startsWith("http")) {
                    ControllerWebView.this.tvUrl.setText((CharSequence)url);
                    return false;
                }
                try {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)url));
                    ControllerWebView.this.getContext().startActivity(intent);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                ControllerWebView.this.ivBack.setEnabled(ControllerWebView.this.mWebView.canGoBack());
                ControllerWebView.this.ivForward.setEnabled(ControllerWebView.this.mWebView.canGoForward());
            }
        });
    }

    public void resetUrl(String url) {
        this.mWebView.clearHistory();
        this.mWebView.clearCache(true);
        this.mWebView.clearFormData();
        this.ivBack.setEnabled(false);
        this.ivForward.setEnabled(false);
        this.mWebView.loadUrl(url);
    }

    public void setOnOptListener(IOnOptListener mOnOptListener) {
        this.mOnOptListener = mOnOptListener;
    }

    public static interface IOnOptListener {
        public void onComplete();
    }
}

