/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.switchCompat;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.R;
import androidx.core.graphics.ColorUtils;
import com.baijiayun.liveuibase.widgets.switchCompat.TintTypedArray;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class ThemeUtils {
    private static final String TAG = "ThemeUtils";
    private static final ThreadLocal<TypedValue> TL_TYPED_VALUE = new ThreadLocal();
    static final int[] DISABLED_STATE_SET = new int[]{-16842910};
    static final int[] FOCUSED_STATE_SET = new int[]{16842908};
    static final int[] ACTIVATED_STATE_SET = new int[]{16843518};
    static final int[] PRESSED_STATE_SET = new int[]{16842919};
    static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    static final int[] SELECTED_STATE_SET = new int[]{0x10100A1};
    static final int[] NOT_PRESSED_OR_FOCUSED_STATE_SET = new int[]{-16842919, -16842908};
    static final int[] EMPTY_STATE_SET = new int[0];
    private static final int[] TEMP_ARRAY = new int[1];

    @NonNull
    public static ColorStateList createDisabledStateList(int textColor, int disabledTextColor) {
        int[][] states = new int[2][];
        int[] colors = new int[2];
        int i = 0;
        states[i] = DISABLED_STATE_SET;
        colors[i] = disabledTextColor;
        states[++i] = EMPTY_STATE_SET;
        colors[i] = textColor;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getThemeAttrColor(@NonNull Context context2, int attr2) {
        ThemeUtils.TEMP_ARRAY[0] = attr2;
        TintTypedArray a = TintTypedArray.obtainStyledAttributes(context2, null, TEMP_ARRAY);
        try {
            int n = a.getColor(0, 0);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ColorStateList getThemeAttrColorStateList(@NonNull Context context2, int attr2) {
        ThemeUtils.TEMP_ARRAY[0] = attr2;
        TintTypedArray a = TintTypedArray.obtainStyledAttributes(context2, null, TEMP_ARRAY);
        try {
            ColorStateList colorStateList = a.getColorStateList(0);
            return colorStateList;
        }
        finally {
            a.recycle();
        }
    }

    public static int getDisabledThemeAttrColor(@NonNull Context context2, int attr2) {
        ColorStateList csl = ThemeUtils.getThemeAttrColorStateList(context2, attr2);
        if (csl != null && csl.isStateful()) {
            return csl.getColorForState(DISABLED_STATE_SET, csl.getDefaultColor());
        }
        TypedValue tv = ThemeUtils.getTypedValue();
        context2.getTheme().resolveAttribute(0x1010033, tv, true);
        float disabledAlpha = tv.getFloat();
        return ThemeUtils.getThemeAttrColor(context2, attr2, disabledAlpha);
    }

    private static TypedValue getTypedValue() {
        TypedValue typedValue = TL_TYPED_VALUE.get();
        if (typedValue == null) {
            typedValue = new TypedValue();
            TL_TYPED_VALUE.set(typedValue);
        }
        return typedValue;
    }

    static int getThemeAttrColor(@NonNull Context context2, int attr2, float alpha) {
        int color2 = ThemeUtils.getThemeAttrColor(context2, attr2);
        int originalAlpha = Color.alpha((int)color2);
        return ColorUtils.setAlphaComponent((int)color2, (int)Math.round((float)originalAlpha * alpha));
    }

    public static void checkAppCompatTheme(@NonNull View view, @NonNull Context context2) {
        TypedArray a = context2.obtainStyledAttributes(R.styleable.AppCompatTheme);
        try {
            if (!a.hasValue(R.styleable.AppCompatTheme_windowActionBar)) {
                Log.e((String)TAG, (String)("View " + view.getClass() + " is an AppCompat widget that can only be used with a Theme.AppCompat theme (or descendant)."));
            }
        }
        finally {
            a.recycle();
        }
    }

    private ThemeUtils() {
    }
}

