/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.focus;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.baijiayun.liveuibase.utils.AnimationUtil;

public class FocusConstraintLayout
extends ConstraintLayout {
    public FocusConstraintLayout(Context context2) {
        super(context2);
        this.init();
    }

    public FocusConstraintLayout(Context context2, AttributeSet attrs) {
        super(context2, attrs);
        this.init();
    }

    public FocusConstraintLayout(Context context2, AttributeSet attrs, int defStyleAttr) {
        super(context2, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(false);
        this.setOnKeyListener((v, keyCode, event) -> {
            if (66 == keyCode || 23 == keyCode) {
                int action = event.getAction();
                if (0 == action) {
                    AnimationUtil.zoomOut((View)this);
                } else if (1 == action) {
                    AnimationUtil.zoomIn((View)this);
                }
            }
            return false;
        });
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        this.setHovered(gainFocus);
    }

    public void onHoverChanged(boolean hovered) {
        super.onHoverChanged(hovered);
        if (hovered) {
            this.requestFocusFromTouch();
            this.requestFocus();
        }
        this.changeSelectedState(hovered);
    }

    private void changeSelectedState(boolean selected) {
        if (selected) {
            AnimationUtil.zoomIn((View)this);
        } else {
            AnimationUtil.zoomOut((View)this);
        }
    }
}

