/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.dialog;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.widgets.dialog.BaseTitleDialog;
import org.jetbrains.annotations.NotNull;

public class SimpleTipsDialog
extends BaseTitleDialog {
    private ChoiceMode choiceMode = ChoiceMode.Double;
    private String positiveText;
    private String negativeText;
    private String contentTitle;
    private String contentText;
    private View.OnClickListener onPositiveClickListener;
    private View.OnClickListener onNegativeClickListener;

    public SimpleTipsDialog(@NonNull @NotNull Context context2) {
        super(context2);
    }

    public SimpleTipsDialog setTips(String title, String content) {
        this.contentTitle = title;
        this.contentText = content;
        return this;
    }

    public SimpleTipsDialog setDisplayMode(ChoiceMode choiceMode) {
        this.choiceMode = choiceMode;
        return this;
    }

    public SimpleTipsDialog setPositive(String positiveText, View.OnClickListener onPositiveClickListener) {
        this.positiveText = positiveText;
        this.onPositiveClickListener = onPositiveClickListener;
        return this;
    }

    public SimpleTipsDialog setNegative(String negativeText, View.OnClickListener onNegativeClickListener) {
        this.negativeText = negativeText;
        this.onNegativeClickListener = onNegativeClickListener;
        return this;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window dialogWindow = this.getWindow();
        if (dialogWindow != null) {
            WindowManager.LayoutParams params = dialogWindow.getAttributes();
            params.width = (int)this.getContext().getResources().getDimension(R.dimen.bjy_base_live_tips_dialog_width);
            params.height = (int)this.getContext().getResources().getDimension(R.dimen.bjy_base_live_tips_dialog_height);
            dialogWindow.setAttributes(params);
        }
        switch (this.choiceMode) {
            case None: {
                this.$.id(R.id.simple_tips_dialog_negative).visibility(8);
                this.$.id(R.id.simple_tips_dialog_positive).visibility(8);
                break;
            }
            case Single_Negative: {
                this.$.id(R.id.simple_tips_dialog_positive).visibility(8).id(R.id.simple_tips_dialog_negative).text((CharSequence)this.negativeText).visibility(0).view().setOnClickListener(this.onNegativeClickListener);
                break;
            }
            case Single_Positive: {
                this.$.id(R.id.simple_tips_dialog_negative).visibility(8).id(R.id.simple_tips_dialog_positive).text((CharSequence)this.positiveText).visibility(0).view().setOnClickListener(this.onPositiveClickListener);
                break;
            }
            case Double: {
                this.$.id(R.id.simple_tips_dialog_positive).text((CharSequence)this.positiveText).view().setOnClickListener(this.onPositiveClickListener);
                this.$.id(R.id.simple_tips_dialog_negative).text((CharSequence)this.negativeText).view().setOnClickListener(this.onNegativeClickListener);
                break;
            }
        }
        this.$.id(R.id.simple_tips_title).text((CharSequence)this.contentTitle).visibility(TextUtils.isEmpty((CharSequence)this.contentTitle) ? 8 : 0);
        this.$.id(R.id.simple_tips_content).text((CharSequence)this.contentText).visibility(TextUtils.isEmpty((CharSequence)this.contentText) ? 8 : 0);
    }

    @Override
    protected int getContentLayout() {
        return R.layout.uibase_simple_tips_dialog;
    }

    public static enum ChoiceMode {
        None(0),
        Single_Positive(1),
        Single_Negative(2),
        Double(3);

        int mode;

        private ChoiceMode(int mode) {
            this.mode = mode;
        }
    }
}

