/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.dialog;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiahulian.common.utils.DisplayUtils;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livecore.utils.LPRecyclerItemClickSupport;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.listeners.share.LPShareModel;
import java.util.ArrayList;

public class LPShareDialog
extends BaseDialogFragment {
    private static final String SHARE_CHANNELS = "SHARE_CHANNELS";
    private LPShareClickListener listener;
    private ArrayList<LPShareModel> shareChannels;
    private RecyclerView recyclerView;

    public static LPShareDialog newInstance(ArrayList<? extends LPShareModel> shareChannels) {
        LPShareDialog f = new LPShareDialog();
        Bundle args = new Bundle();
        args.putSerializable(SHARE_CHANNELS, shareChannels);
        f.setArguments(args);
        return f;
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        this.getDialog().getWindow().setBackgroundDrawableResource(R.drawable.shape_share_bg);
        windowParams.gravity = 8388661;
        windowParams.height = (int)this.getResources().getDimension(R.dimen.live_share_window_height);
        windowParams.width = (int)this.getResources().getDimension(R.dimen.live_share_window_width);
        windowParams.x = DisplayUtils.dip2px((Context)this.getContext(), (float)72.0f);
        windowParams.y = DisplayUtils.dip2px((Context)this.getContext(), (float)32.0f);
        windowParams.windowAnimations = R.style.BJYShareDialogAnim;
    }

    protected int getLayoutId() {
        return R.layout.bjy_dialog_share_room;
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        super.hideTitleBar();
        this.shareChannels = (ArrayList)arguments.getSerializable(SHARE_CHANNELS);
        this.recyclerView = (RecyclerView)this.contentView.findViewById(R.id.lp_dialog_share_recycler);
        int GRID_SPAN_COUNT = 3;
        GridLayoutManager gridLayoutManager = new GridLayoutManager((Context)this.getActivity(), GRID_SPAN_COUNT);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.recyclerView.setAdapter((RecyclerView.Adapter)new LPShareAdapter());
        LPRecyclerItemClickSupport.addTo((RecyclerView)this.recyclerView).setOnItemClickListener((recyclerView, position, v) -> {
            if (this.listener != null) {
                this.listener.onShareClick(this.shareChannels.get(position).getShareType());
            }
            this.dismissAllowingStateLoss();
        });
    }

    public void setListener(LPShareClickListener listener2) {
        this.listener = listener2;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.recyclerView != null) {
            LPRecyclerItemClickSupport.removeFrom((RecyclerView)this.recyclerView);
        }
    }

    public static interface LPShareClickListener {
        public void onShareClick(LPConstants.LPShareType var1);
    }

    private static class LPShareViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivShareIcon;
        private TextView tvShareTitle;
        private TextView tvShareCorner;

        public LPShareViewHolder(View itemView) {
            super(itemView);
            this.ivShareIcon = (ImageView)itemView.findViewById(R.id.lp_item_share_icon);
            this.tvShareTitle = (TextView)itemView.findViewById(R.id.lp_item_share_title);
            this.tvShareCorner = (TextView)itemView.findViewById(R.id.lp_item_share_corner);
        }
    }

    private class LPShareAdapter
    extends RecyclerView.Adapter<LPShareViewHolder> {
        private LPShareAdapter() {
        }

        public LPShareViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.bjy_item_share, parent, false);
            return new LPShareViewHolder(view);
        }

        public void onBindViewHolder(LPShareViewHolder holder, int position) {
            holder.ivShareIcon.setImageResource(((LPShareModel)LPShareDialog.this.shareChannels.get(position)).getShareIconRes());
            holder.tvShareTitle.setText((CharSequence)((LPShareModel)LPShareDialog.this.shareChannels.get(position)).getShareIconText());
            if (((LPShareModel)LPShareDialog.this.shareChannels.get(position)).hasCorner()) {
                holder.tvShareCorner.setVisibility(0);
                holder.tvShareCorner.setText((CharSequence)((LPShareModel)LPShareDialog.this.shareChannels.get(position)).getCornerText());
            } else {
                holder.tvShareCorner.setVisibility(8);
            }
        }

        public int getItemCount() {
            return LPShareDialog.this.shareChannels.size();
        }
    }
}

