/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.dialog;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.TextView;
import android_serialport_api.ZXYBDeviceInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPBleDevice;
import com.baijiayun.liveuibase.R;
import com.zxyb.zxybbaselib.ble.entity.BleDevice;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class BluetoothDeviceDialog
extends BaseDialogFragment {
    private static final String TAG = "zxyb-ble";
    private static final int BLUETOOTH_SCAN_TIMEOUT = 10;
    private static final int BLUETOOTH_SCAN_CHECK_TIME = 5;
    private static final String BLUETOOTH_DIV_TAG = "tag";
    private final BluetoothAdapter bluetoothAdapter = new BluetoothAdapter();
    private final List<LPBleDevice> bleDeviceList = new ArrayList<LPBleDevice>();
    private final List<LPBleDevice> bleDeviceWhitelist = new ArrayList<LPBleDevice>();
    private final List<LPBleDevice> scanningBleDeviceList = new ArrayList<LPBleDevice>();
    private final PriorityQueue<LPBleDevice> otherDeviceQueue = new PriorityQueue(11, (o1, o2) -> 0);
    private Disposable timerDisposable;
    private CompositeDisposable disposables;
    private boolean isScanning = false;
    private Context context;
    private final LiveRoom liveRoom;

    public BluetoothDeviceDialog(LiveRoom liveRoom2) {
        this.liveRoom = liveRoom2;
    }

    public void onAttach(@NonNull Context context2) {
        super.onAttach(context2);
        this.context = context2;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.title(this.context.getString(R.string.base_live_bluetooth));
        this.showCross();
        RecyclerView recyclerView = (RecyclerView)this.$.id(R.id.base_bluetooth_recyclerView).view();
        recyclerView.setAdapter((RecyclerView.Adapter)this.bluetoothAdapter);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        this.disposables = new CompositeDisposable();
        this.intZXYBListener();
        this.startScan();
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog != null) {
            dialog.setCanceledOnTouchOutside(false);
            dialog.setCancelable(false);
            dialog.getWindow().setBackgroundDrawable(new DrawableBuilder().rectangle().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_bg_color)).cornerRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
            this.setTitleBackground(new DrawableBuilder().rectangle().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_bg_color)).topLeftRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).topRightRadius(this.context.getResources().getDimensionPixelSize(R.dimen.bjy_base_common_bg_radius)).build());
        }
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.width = UtilsKt.getDp((int)460);
        windowParams.height = UtilsKt.getDp((int)285);
        windowParams.gravity = 17;
    }

    private void startScan() {
        LPLogger.d((String)TAG, (String)"startScan");
        this.liveRoom.getZXYBVM().startScan();
        this.isScanning = true;
        RxUtils.dispose((Disposable)this.timerDisposable);
        this.timerDisposable = Observable.interval((long)1L, (long)1L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(aLong -> {
            if (aLong == 9L) {
                LPLogger.d((String)TAG, (String)"10s stopScan");
                this.liveRoom.getZXYBVM().stopScan();
                RxUtils.dispose((Disposable)this.timerDisposable);
            }
            if (this.isScanning) {
                this.checkBleDeviceAvailable();
            }
        });
    }

    public void refresh() {
        this.startScan();
    }

    private void checkBleDeviceAvailable() {
        Iterator<LPBleDevice> deviceIterator = this.bleDeviceList.iterator();
        boolean isChange = false;
        while (deviceIterator.hasNext()) {
            LPBleDevice bleDevice = deviceIterator.next();
            long currentTimeMillis = System.currentTimeMillis();
            if (BLUETOOTH_DIV_TAG.equals(bleDevice.address) || currentTimeMillis - bleDevice.getScanTimestamp() <= 5000L || bleDevice.status == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_SUCCESS) continue;
            deviceIterator.remove();
            this.otherDeviceQueue.remove(bleDevice);
            int index = this.bleDeviceWhitelist.indexOf(bleDevice);
            if (index != -1) {
                this.bleDeviceWhitelist.get((int)index).isActive = false;
            }
            isChange = true;
        }
        if (isChange) {
            this.bluetoothAdapter.notifyDataSetChanged();
        }
    }

    public BluetoothDeviceDialog setData(List<LPBleDevice> recentConnectDevices) {
        this.bleDeviceList.clear();
        this.otherDeviceQueue.clear();
        this.bleDeviceWhitelist.clear();
        long currentTimeMillis = System.currentTimeMillis();
        for (LPBleDevice lpBleDevice : recentConnectDevices) {
            lpBleDevice.setScanTimestamp(currentTimeMillis);
        }
        this.bleDeviceWhitelist.addAll(recentConnectDevices);
        this.bleDeviceList.addAll(recentConnectDevices);
        this.bleDeviceList.add(new LPBleDevice(BLUETOOTH_DIV_TAG, BLUETOOTH_DIV_TAG));
        this.bluetoothAdapter.notifyDataSetChanged();
        return this;
    }

    private void intZXYBListener() {
        this.disposables.add(this.liveRoom.getZXYBVM().getObservableOfScanStatus().observeOn(AndroidSchedulers.mainThread()).subscribe(aBoolean -> {
            LPLogger.d((String)TAG, (String)("scan:" + aBoolean));
            if (aBoolean.booleanValue()) {
                this.isScanning = true;
            } else {
                RxUtils.dispose((Disposable)this.timerDisposable);
                this.isScanning = false;
            }
            this.bluetoothAdapter.notifyDataSetChanged();
        }));
        this.disposables.add(this.liveRoom.getZXYBVM().getObservableOfScanDevice().observeOn(AndroidSchedulers.mainThread()).subscribe(this::onScanDevice));
        this.disposables.add(this.liveRoom.getZXYBVM().getObservableOfConnectStatus().observeOn(AndroidSchedulers.mainThread()).subscribe(zxybConnectStatus -> {
            if (zxybConnectStatus == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_SUCCESS) {
                ZXYBDeviceInfo deviceInfo = this.liveRoom.getZXYBVM().getConnectedDevice();
                if (deviceInfo == null) {
                    return;
                }
                for (LPBleDevice lpBleDevice : this.bleDeviceList) {
                    lpBleDevice.status = lpBleDevice.address.equals(deviceInfo.bleAdress) ? LPConstants.ZXYBConnectStatus.CONNECT_STATUS_SUCCESS : LPConstants.ZXYBConnectStatus.CONNECT_STATUS_UNIT;
                }
                this.bluetoothAdapter.notifyDataSetChanged();
            } else if (zxybConnectStatus == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_FAIL || zxybConnectStatus == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_DISCONNECT) {
                for (LPBleDevice lpBleDevice : this.bleDeviceList) {
                    lpBleDevice.status = LPConstants.ZXYBConnectStatus.CONNECT_STATUS_UNIT;
                }
                this.bluetoothAdapter.notifyDataSetChanged();
            }
        }));
    }

    private void onScanDevice(BleDevice bleDevice) {
        int index;
        LPLogger.d((String)TAG, (String)("scan:" + bleDevice.name + "----" + bleDevice.address));
        LPBleDevice lpBleDevice = new LPBleDevice(bleDevice);
        long currentTimeMillis = System.currentTimeMillis();
        lpBleDevice.setScanTimestamp(currentTimeMillis);
        if (!this.bleDeviceList.contains(lpBleDevice)) {
            if (!this.otherDeviceQueue.contains(lpBleDevice) && !this.bleDeviceWhitelist.contains(lpBleDevice)) {
                this.otherDeviceQueue.add(lpBleDevice);
            }
            if (this.bleDeviceWhitelist.contains(lpBleDevice)) {
                index = this.bleDeviceWhitelist.indexOf(lpBleDevice);
                LPBleDevice whitelistDevice = this.bleDeviceWhitelist.get(index);
                whitelistDevice.isActive = true;
            }
            this.bleDeviceList.add(lpBleDevice);
            this.bluetoothAdapter.notifyDataSetChanged();
        } else {
            int i;
            index = this.bleDeviceList.indexOf(lpBleDevice);
            if (index != -1) {
                this.bleDeviceList.get(index).setScanTimestamp(currentTimeMillis);
            }
            if (this.otherDeviceQueue.remove(lpBleDevice)) {
                this.otherDeviceQueue.add(lpBleDevice);
            } else if (this.bleDeviceWhitelist.contains(lpBleDevice) && (i = this.bleDeviceWhitelist.indexOf(lpBleDevice)) != -1) {
                LPBleDevice whitelistDevice = this.bleDeviceWhitelist.get(i);
                whitelistDevice.setScanTimestamp(currentTimeMillis);
                whitelistDevice.isActive = true;
            }
        }
        boolean isConnect = false;
        int index2 = this.bleDeviceWhitelist.indexOf(lpBleDevice);
        if (index2 == 0) {
            this.connectDevice(lpBleDevice);
            this.liveRoom.getZXYBVM().stopScan();
            isConnect = true;
        }
        if (!this.scanningBleDeviceList.contains(lpBleDevice)) {
            this.scanningBleDeviceList.add(lpBleDevice);
        } else {
            if (isConnect) {
                return;
            }
            if (!this.bleDeviceWhitelist.isEmpty()) {
                LPBleDevice autoConnectDevice = null;
                for (LPBleDevice device : this.bleDeviceWhitelist) {
                    if (!device.isActive) continue;
                    autoConnectDevice = device;
                    break;
                }
                if (autoConnectDevice != null) {
                    this.connectDevice(lpBleDevice);
                    this.liveRoom.getZXYBVM().stopScan();
                }
            }
        }
    }

    private void insertConnectedDevice(LPBleDevice bleDevice) {
        bleDevice.updateConnectTime();
        this.otherDeviceQueue.remove(bleDevice);
        this.bleDeviceList.remove(bleDevice);
        this.bleDeviceWhitelist.add(0, bleDevice);
        this.bleDeviceList.add(0, bleDevice);
        this.bluetoothAdapter.notifyDataSetChanged();
    }

    private void connectDevice(LPBleDevice bleDevice) {
        bleDevice.status = LPConstants.ZXYBConnectStatus.CONNECT_STATUS_CONNECTING;
        for (LPBleDevice lpBleDevice : this.bleDeviceList) {
            if (bleDevice.equals((Object)lpBleDevice)) continue;
            lpBleDevice.status = LPConstants.ZXYBConnectStatus.CONNECT_STATUS_UNIT;
        }
        this.insertConnectedDevice(bleDevice);
        this.liveRoom.getZXYBVM().connectZXYB(bleDevice.address);
    }

    public void dismiss() {
        super.dismiss();
        this.onDestroyView();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.liveRoom.getZXYBVM().stopScan();
        RxUtils.dispose((Disposable)this.timerDisposable);
        RxUtils.dispose((Disposable)this.disposables);
    }

    protected int getLayoutId() {
        return R.layout.uibase_bluetooth_list_dialog;
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
    }

    public class BluetoothAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private static final int DIVIDER_TYPE = 0;
        private static final int BLUETOOTH_TYPE = 1;

        @NonNull
        @NotNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull @NotNull ViewGroup parent, int viewType) {
            if (viewType == 0) {
                View itemView = LayoutInflater.from((Context)BluetoothDeviceDialog.this.getContext()).inflate(R.layout.uibase_bluetooth_divider, parent, false);
                return new DividerViewHolder(itemView);
            }
            View itemView = LayoutInflater.from((Context)BluetoothDeviceDialog.this.getContext()).inflate(R.layout.uibase_bluetooth_item, parent, false);
            return new ViewHolder(itemView);
        }

        public void onBindViewHolder(@NonNull @NotNull RecyclerView.ViewHolder holder, int position) {
            if (this.getItemViewType(position) == 1) {
                ViewHolder viewHolder = (ViewHolder)holder;
                LPBleDevice bleDevice = (LPBleDevice)BluetoothDeviceDialog.this.bleDeviceList.get(position);
                viewHolder.deviceNameTv.setText((CharSequence)bleDevice.name);
                if (bleDevice.status == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_SUCCESS) {
                    viewHolder.showConnected();
                } else if (bleDevice.status == LPConstants.ZXYBConnectStatus.CONNECT_STATUS_CONNECTING) {
                    viewHolder.showLoading();
                } else {
                    viewHolder.showInitStatus(bleDevice);
                }
                viewHolder.itemView.setOnClickListener(v -> BluetoothDeviceDialog.this.connectDevice(bleDevice));
            } else {
                DividerViewHolder viewHolder = (DividerViewHolder)holder;
                if (BluetoothDeviceDialog.this.isScanning) {
                    viewHolder.imageView.setVisibility(0);
                    viewHolder.animator.start();
                } else {
                    viewHolder.imageView.setVisibility(8);
                    viewHolder.animator.cancel();
                }
            }
        }

        public int getItemCount() {
            return BluetoothDeviceDialog.this.bleDeviceList.size();
        }

        public int getItemViewType(int position) {
            return BluetoothDeviceDialog.BLUETOOTH_DIV_TAG.equals(((LPBleDevice)((BluetoothDeviceDialog)BluetoothDeviceDialog.this).bleDeviceList.get((int)position)).address) ? 0 : 1;
        }

        class DividerViewHolder
        extends RecyclerView.ViewHolder {
            ImageView imageView;
            ObjectAnimator animator;

            public DividerViewHolder(View itemView) {
                super(itemView);
                this.imageView = (ImageView)itemView.findViewById(R.id.window_course_ware_loading);
                this.animator = ObjectAnimator.ofFloat((Object)this.imageView, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
                this.animator.setRepeatCount(-1);
                this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.animator.setDuration(1500L);
            }
        }

        class ViewHolder
        extends RecyclerView.ViewHolder {
            TextView deviceNameTv;
            TextView connectStatusTv;
            AppCompatImageView connectStatusIv;
            RotateAnimation animator;

            public ViewHolder(View itemView) {
                super(itemView);
                this.deviceNameTv = (TextView)itemView.findViewById(R.id.ui_base_ble_device_name);
                this.connectStatusTv = (TextView)itemView.findViewById(R.id.ui_base_ble_device_status_tv);
                this.connectStatusIv = (AppCompatImageView)itemView.findViewById(R.id.ui_base_ble_device_status_iv);
                this.animator = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
                this.animator.setDuration(1500L);
                this.animator.setInterpolator((Interpolator)new LinearInterpolator());
                this.animator.setRepeatCount(-1);
            }

            public void showLoading() {
                this.connectStatusIv.setVisibility(0);
                this.connectStatusIv.setImageResource(R.drawable.base_course_ware_loading);
                this.connectStatusTv.setVisibility(8);
                this.connectStatusIv.setAnimation((Animation)this.animator);
                this.animator.start();
            }

            public void showConnected() {
                this.connectStatusIv.setVisibility(0);
                this.connectStatusIv.setImageResource(R.drawable.base_live_connected_checkbox);
                this.connectStatusTv.setVisibility(8);
                this.animator.cancel();
                this.connectStatusIv.clearAnimation();
            }

            public void showInitStatus(LPBleDevice bleDevice) {
                this.connectStatusIv.setVisibility(8);
                this.connectStatusTv.setText((CharSequence)BluetoothDeviceDialog.this.context.getString(R.string.base_live_not_connected));
                this.connectStatusTv.setVisibility(bleDevice.isWhitelistDevice() ? 0 : 8);
                this.animator.cancel();
                this.connectStatusIv.clearAnimation();
            }
        }
    }
}

