/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.liveuibase.widgets.courseware;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.view.inputmethod.InputMethodManager;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiahulian.common.cropperv2.BJCommonImageCropHelper;
import com.baijiahulian.common.cropperv2.ThemeConfig;
import com.baijiahulian.common.cropperv2.model.PhotoInfo;
import com.baijiahulian.common.permission.AppPermissions;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.drawable.StateListDrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.widgets.SimpleTextWatcher;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.utils.FileUtils;
import com.baijiayun.livebase.utils.ThemeDataUtil;
import com.baijiayun.livecore.context.LiveRoom;
import com.baijiayun.livecore.models.LPDocModel;
import com.baijiayun.livecore.models.LPDocTranslateProgressModel;
import com.baijiayun.livecore.models.LPUploadingDocumentModel;
import com.baijiayun.livecore.models.courseware.LPMediaCoursewareModel;
import com.baijiayun.livecore.models.file.cloudfile.LPCloudFileModel;
import com.baijiayun.livecore.models.file.homework.LPResHomeworkAllModel;
import com.baijiayun.liveuibase.R;
import com.baijiayun.liveuibase.base.BaseUIConstant;
import com.baijiayun.liveuibase.utils.BaseUtilsKt;
import com.baijiayun.liveuibase.utils.ExtensionKt;
import com.baijiayun.liveuibase.utils.PermissionTipBuilderFactory;
import com.baijiayun.liveuibase.utils.ToastUtil;
import com.baijiayun.liveuibase.widgets.common.DirRecordTextView;
import com.baijiayun.liveuibase.widgets.courseware.BaseCourseWareContract;
import com.baijiayun.liveuibase.widgets.courseware.BaseCourseWareFileAdapter;
import com.baijiayun.liveuibase.widgets.courseware.BaseCourseWareUploadDialog;
import com.baijiayun.liveuibase.widgets.courseware.ICourseWareViewListener;
import com.baijiayun.liveuibase.widgets.courseware.models.TabState;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.ScrollBoundaryDecider;
import com.scwang.smartrefresh.layout.footer.ClassicsFooter;
import com.uber.autodispose.AutoDispose;
import com.uber.autodispose.ObservableSubscribeProxy;
import com.uber.autodispose.ScopeProvider;
import com.uber.autodispose.android.lifecycle.AndroidLifecycleScopeProvider;
import io.reactivex.ObservableConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class BaseCourseWareFragment
extends Fragment
implements BaseCourseWareContract.BaseCourseWareView,
View.OnTouchListener {
    protected BaseCourseWareContract.BaseCourseWarePresenter presenter;
    protected ICourseWareViewListener courseWareViewListener;
    public TabState tabState = TabState.DocFile;
    protected Context context;
    protected View contentView;
    protected BaseCourseWareFileAdapter courseWareAdapter;
    protected BaseCourseWareUploadDialog uploadDialog;
    protected boolean allIsSupportHomework = true;
    protected List<LPCloudFileModel> dirRecordList = new ArrayList<LPCloudFileModel>();
    public static final int REQUEST_CODE_PERMISSION_WRITE = 12345;
    protected int defaultPickImageOrientation = 0;
    protected HomeworkRemindStatus homeworkRemindStatus = HomeworkRemindStatus.HAS_SHOW_RST;
    View tabDocTab;
    View tabCloudTab;
    View tabHomeWork;
    DirRecordTextView tvDirRecordMore;
    protected CheckBox cbEnableStudentUpload;
    protected EditText etSearcher;
    protected boolean isOnSearching;
    protected RecyclerView rlCourseware;
    protected SmartRefreshLayout smartRefreshLayout;
    protected ScopeProvider scopeProvider;
    Runnable homeworkSearchRunnable = () -> this.presenter.requestSearchHomework(this.etSearcher.getText().toString());
    Runnable cloudSearchRunnable = () -> {
        if (this.getLiveRoom() != null) {
            this.getLiveRoom().getCloudFileVM().requestSearchFile(this.etSearcher.getText().toString(), true);
        }
    };
    Runnable docSearchRunnable = () -> {
        this.courseWareAdapter.updateDocSearchKeyword(this.etSearcher.getText().toString());
        this.showContent(this.getNowAdapterState());
    };

    protected void initViewId() {
        this.initTabsAndDirTextView();
        this.cbEnableStudentUpload = (CheckBox)this.contentView.findViewById(R.id.window_course_ware_enable_student_upload_check_box);
        this.rlCourseware = (RecyclerView)this.contentView.findViewById(R.id.window_course_ware_file_list_rl);
        this.smartRefreshLayout = (SmartRefreshLayout)this.contentView.findViewById(R.id.window_course_ware_file_refresh_layout);
        this.etSearcher = (EditText)this.contentView.findViewById(R.id.window_course_ware_searcher);
        this.etSearcher.addTextChangedListener((TextWatcher)new SimpleTextWatcher(){
            boolean hasChange;

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
                this.hasChange = count + after > 0;
            }

            public void afterTextChanged(Editable s) {
                BaseCourseWareFragment.this.isOnSearching = !TextUtils.isEmpty((CharSequence)s);
                BaseCourseWareFragment.this.courseWareAdapter.setOnSearching(BaseCourseWareFragment.this.isOnSearching);
                BaseCourseWareFragment.this.etSearcher.removeCallbacks(BaseCourseWareFragment.this.homeworkSearchRunnable);
                BaseCourseWareFragment.this.etSearcher.removeCallbacks(BaseCourseWareFragment.this.cloudSearchRunnable);
                BaseCourseWareFragment.this.etSearcher.removeCallbacks(BaseCourseWareFragment.this.docSearchRunnable);
                if (BaseCourseWareFragment.this.isOnSearching) {
                    BaseCourseWareFragment.this.showContent(BaseUIConstant.ListState.Requesting);
                } else {
                    BaseCourseWareFragment.this.showContent(BaseCourseWareFragment.this.getNowAdapterState());
                }
                if (BaseCourseWareFragment.this.tabState == TabState.HomeworkFile) {
                    BaseCourseWareFragment.this.courseWareAdapter.updateHomeworkSearchRst(null);
                    if (BaseCourseWareFragment.this.isOnSearching) {
                        BaseCourseWareFragment.this.etSearcher.postDelayed(BaseCourseWareFragment.this.homeworkSearchRunnable, 500L);
                    }
                } else if (BaseCourseWareFragment.this.tabState == TabState.CloudFile) {
                    if (this.hasChange) {
                        if (BaseCourseWareFragment.this.isOnSearching) {
                            BaseCourseWareFragment.this.etSearcher.postDelayed(BaseCourseWareFragment.this.cloudSearchRunnable, 500L);
                        } else {
                            BaseCourseWareFragment.this.getLiveRoom().getCloudFileVM().requestSearchFile(BaseCourseWareFragment.this.etSearcher.getText().toString(), true);
                        }
                    }
                } else if (BaseCourseWareFragment.this.isOnSearching) {
                    BaseCourseWareFragment.this.etSearcher.postDelayed(BaseCourseWareFragment.this.docSearchRunnable, 500L);
                }
                BaseCourseWareFragment.this.setVisibility(R.id.window_course_ware_search_clear, BaseCourseWareFragment.this.isOnSearching);
            }
        });
    }

    protected void initTabsAndDirTextView() {
        this.tabHomeWork = this.contentView.findViewById(R.id.window_course_ware_homework_tab);
        this.tabDocTab = this.contentView.findViewById(R.id.window_course_ware_class_files_tab);
        this.tabCloudTab = this.contentView.findViewById(R.id.window_course_ware_cloud_files_tab);
        this.tvDirRecordMore = (DirRecordTextView)this.contentView.findViewById(R.id.window_course_ware_record_dir_more);
        this.tvDirRecordMore.setOnItemClickListener(this::changeDirPosition);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container2, @Nullable Bundle savedInstanceState) {
        this.context = this.getContext();
        this.contentView = LayoutInflater.from((Context)this.context).inflate(R.layout.uibase_courseware_manage_layout, container2, false);
        this.presenter = this.initPresenter();
        this.initChildData();
        this.initViewId();
        this.scopeProvider = AndroidLifecycleScopeProvider.from((LifecycleOwner)this);
        this.courseWareViewListener = this.initCourseWareViewListener();
        this.contentView.setOnTouchListener((View.OnTouchListener)this);
        this.contentView.findViewById(R.id.base_courseware_container).setBackground(ThemeDataUtil.getCommonWindowBg((Context)this.context));
        this.contentView.findViewById(R.id.window_course_ware_close).setOnClickListener(v -> {
            if (this.courseWareViewListener != null) {
                this.courseWareViewListener.onClose();
            }
        });
        this.initTabView(this.tabDocTab, TabState.DocFile);
        this.initTabView(this.tabCloudTab, TabState.CloudFile);
        this.initCoursewareContainer();
        if (this.isEnableHomework()) {
            this.initTabView(this.tabHomeWork, TabState.HomeworkFile);
        } else {
            this.tabHomeWork.setVisibility(8);
        }
        this.updateAllowUpdateHomework(true);
        this.contentView.findViewById(R.id.window_course_ware_enable_student_upload_tv).setOnClickListener(v -> this.cbEnableStudentUpload.performClick());
        this.cbEnableStudentUpload.setOnClickListener(v -> this.courseWareViewListener.onUpdateAllowUploadHomework(this.cbEnableStudentUpload.isChecked()));
        this.tabDocTab.setSelected(true);
        this.etSearcher.setOnEditorActionListener((v, actionId, event) -> {
            this.clearEditFocus((View)this.etSearcher);
            return true;
        });
        this.contentView.findViewById(R.id.window_course_ware_search_clear).setOnClickListener(v -> {
            this.clearEditFocus((View)this.etSearcher);
            this.etSearcher.setText((CharSequence)"");
        });
        this.contentView.findViewById(R.id.window_course_ware_upload).setOnClickListener(v -> {
            if (this.getLiveRoom().getCurrentUser().getType() == LPConstants.LPUserType.Assistant && !this.getLiveRoom().getAdminAuth().documentUpload) {
                this.showToast(this.getString(R.string.base_ui_forbid_upload_ppt));
                return;
            }
            if (this.tabState == TabState.HomeworkFile) {
                ExtensionKt.openSystemFileManager(this, BaseUIConstant.UploadType.HomeWork.getValue(), false);
            } else {
                this.showUploadDialog();
            }
        });
        this.contentView.findViewById(R.id.window_course_ware_upload_image).setOnClickListener(v -> this.doUploadImage());
        this.contentView.findViewById(R.id.window_course_ware_refresh).setOnClickListener(v -> this.onRefreshDocList());
        this.contentView.findViewById(R.id.window_course_ware_record_dir_root).setOnClickListener(v -> {
            this.getLiveRoom().getCloudFileVM().requestCloudFileAll();
            this.showContent(BaseUIConstant.ListState.Requesting);
            this.clearEditFocus((View)this.etSearcher);
            this.etSearcher.setText((CharSequence)"");
        });
        this.showAsUserType();
        return this.contentView;
    }

    protected void doUploadImage() {
        if (Build.VERSION.SDK_INT >= 33) {
            this.selectImage();
        } else {
            ((ObservableSubscribeProxy)AppPermissions.newPermissions((Activity)this.getActivity()).request(PermissionTipBuilderFactory.createPermissionTipsView(this.context, "android.permission.READ_EXTERNAL_STORAGE"), new String[]{"android.permission.READ_EXTERNAL_STORAGE"}).as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)AndroidLifecycleScopeProvider.from((LifecycleOwner)this, (Lifecycle.Event)Lifecycle.Event.ON_DESTROY)))).subscribe(grant -> {
                if (grant.booleanValue()) {
                    this.selectImage();
                } else {
                    BaseUtilsKt.showSystemSettingDialog((Activity)this.getActivity(), 12345);
                }
            });
        }
    }

    private void showAsUserType() {
        if (!this.isTeacherOrAssistant()) {
            this.updateTabView(TabState.HomeworkFile);
            this.setVisibility(R.id.window_course_ware_tab_container, false);
            TextView tvTitle = (TextView)this.contentView.findViewById(R.id.base_course_ware_title);
            tvTitle.setText(R.string.base_course_manage_homework_tab);
            this.cbEnableStudentUpload.setVisibility(8);
            this.setVisibility(R.id.window_course_ware_enable_student_upload_tv, false);
            this.setVisibility(R.id.window_course_ware_search_container, false);
        } else if (!this.isOrganizationUser()) {
            this.tabCloudTab.setVisibility(8);
        }
    }

    public void onRefreshDocList() {
        if (this.getLiveRoom() == null) {
            return;
        }
        this.showContent(BaseUIConstant.ListState.Requesting);
        switch (this.tabState) {
            case DocFile: {
                this.getLiveRoom().getDocListVM().requestDocAllReq();
                break;
            }
            case CloudFile: {
                this.getLiveRoom().getCloudFileVM().onRefresh();
                break;
            }
            case HomeworkFile: {
                if (this.getLiveRoom().isTeacherOrAssistant()) {
                    ((ObservableSubscribeProxy)this.getLiveRoom().getDocListVM().getObservableOfRefreshDocList().as((ObservableConverter)AutoDispose.autoDisposable((ScopeProvider)this.scopeProvider))).subscribe(jsonObjectLPShortResult -> this.contentView.post(() -> this.showContent(this.getNowAdapterState())));
                    break;
                }
                this.getLiveRoom().getDocListVM().requestHomeworkAllList("");
                break;
            }
        }
    }

    protected void showUploadDialog() {
        if (this.uploadDialog == null) {
            this.uploadDialog = new BaseCourseWareUploadDialog(this.context, new BaseCourseWareUploadDialog.IOnChooseUploadTypeListener(){

                @Override
                public void onChooseStatic() {
                    ExtensionKt.openSystemFileManager(BaseCourseWareFragment.this, BaseCourseWareFragment.this.tabState == TabState.CloudFile ? BaseUIConstant.UploadType.StaticCloudFile.getValue() : BaseUIConstant.UploadType.StaticDoc.getValue(), false);
                }

                @Override
                public void onChooseAnim() {
                    ExtensionKt.openSystemFileManager(BaseCourseWareFragment.this, BaseCourseWareFragment.this.tabState == TabState.CloudFile ? BaseUIConstant.UploadType.AnimCloudFile.getValue() : BaseUIConstant.UploadType.AnimDoc.getValue(), false);
                }
            });
        }
        if (!this.uploadDialog.isShowing()) {
            this.uploadDialog.show();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    protected void initCoursewareContainer() {
        this.rlCourseware.addOnItemTouchListener(new RecyclerView.OnItemTouchListener(){

            public boolean onInterceptTouchEvent(@NonNull RecyclerView recyclerView, @NonNull MotionEvent motionEvent2) {
                if (motionEvent2.getAction() == 0) {
                    BaseCourseWareFragment.this.clearEditFocus((View)BaseCourseWareFragment.this.etSearcher);
                }
                return false;
            }

            public void onTouchEvent(@NonNull RecyclerView recyclerView, @NonNull MotionEvent motionEvent2) {
            }

            public void onRequestDisallowInterceptTouchEvent(boolean b) {
            }
        });
        this.rlCourseware.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        this.courseWareAdapter = new BaseCourseWareFileAdapter(this.courseWareViewListener, this.isTeacherOrAssistant(), this.context);
        this.courseWareAdapter.setPresenter(this.presenter);
        this.rlCourseware.setAdapter((RecyclerView.Adapter)this.courseWareAdapter);
        this.smartRefreshLayout.setEnableRefresh(false);
        ((ClassicsFooter)this.contentView.findViewById(R.id.window_course_ware_file_refresh_footer)).setAccentColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_window_assistant_text_color));
        this.smartRefreshLayout.setOnLoadMoreListener(refreshLayout -> {
            String keyword;
            if (this.tabState == TabState.DocFile) {
                this.smartRefreshLayout.finishLoadMore();
                return;
            }
            String string2 = keyword = this.isOnSearching ? this.etSearcher.getText().toString() : "";
            if (this.tabState == TabState.HomeworkFile) {
                this.courseWareViewListener.requestLoadNextPage(keyword);
            } else {
                this.getLiveRoom().getCloudFileVM().loadNextPage(keyword);
            }
            this.smartRefreshLayout.finishLoadMore(2000);
        });
        this.smartRefreshLayout.setScrollBoundaryDecider(new ScrollBoundaryDecider(){

            public boolean canRefresh(View content) {
                return true;
            }

            public boolean canLoadMore(View content) {
                if (BaseCourseWareFragment.this.rlCourseware == null) {
                    return false;
                }
                BaseCourseWareFragment.this.rlCourseware.getHeight();
                int scrollRange = BaseCourseWareFragment.this.rlCourseware.computeVerticalScrollRange();
                int scrollOffset = BaseCourseWareFragment.this.rlCourseware.computeVerticalScrollOffset();
                int scrollExtent = BaseCourseWareFragment.this.rlCourseware.computeVerticalScrollExtent();
                int height = BaseCourseWareFragment.this.rlCourseware.getHeight();
                if (height > scrollRange) {
                    return false;
                }
                return scrollRange <= scrollOffset + scrollExtent;
            }
        });
    }

    private void initTabView(View tabView, TabState tabState) {
        Drawable selectedDrawable = new DrawableBuilder().solidColor(ThemeDataUtil.getColorFromThemeConfigByAttrId((Context)this.context, (int)R.attr.base_theme_live_product_color)).cornerRadii(UtilsKt.getDp((int)2), UtilsKt.getDp((int)2), 0, 0).build();
        Drawable normalDrawable = new DrawableBuilder().strokeWidth((int)UtilsKt.getDp((float)0.5f)).strokeColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_bg_stroke)).cornerRadii(UtilsKt.getDp((int)2), UtilsKt.getDp((int)2), 0, 0).build();
        tabView.setOnClickListener(v -> this.updateTabView(tabState));
        tabView.setBackground((Drawable)new StateListDrawableBuilder().normal(normalDrawable).selected(selectedDrawable).build());
    }

    protected void updateTabView(TabState tabState) {
        if (this.tabState != tabState) {
            if (tabState == TabState.HomeworkFile && this.isTeacherOrAssistant()) {
                if (this.allIsSupportHomework && this.homeworkRemindStatus != HomeworkRemindStatus.DO_NOT_REMIND) {
                    this.homeworkRemindStatus = HomeworkRemindStatus.WAITING_FOR_RST;
                    this.presenter.requestHomeworkSupport();
                } else if (this.homeworkRemindStatus == HomeworkRemindStatus.HAS_SHOW_RST) {
                    this.courseWareViewListener.onRemindHomeworkSupport();
                }
            }
            if (tabState == TabState.CloudFile) {
                this.getLiveRoom().getCloudFileVM().onRefresh();
                this.showContent(BaseUIConstant.ListState.Requesting);
            }
        }
        this.tabState = tabState;
        this.courseWareAdapter.updateTabState(tabState);
        this.updateTabSelected();
        this.etSearcher.setText((CharSequence)"");
        this.etSearcher.setHint(tabState == TabState.HomeworkFile ? R.string.base_course_manage_homework_search_hint : R.string.base_course_manage_search_hint);
        this.updateUploadText();
        this.clearEditFocus((View)this.etSearcher);
        this.updateHomeworkHintVisibility();
        this.updateFinderRecordView();
        this.showContent(this.getNowAdapterState());
    }

    protected void updateUploadText() {
        ((TextView)this.contentView.findViewById(R.id.window_course_ware_upload_name)).setText(this.tabState == TabState.HomeworkFile ? R.string.base_course_manage_upload_homework_file : R.string.base_course_manage_upload_file);
    }

    protected void updateTabSelected() {
        this.tabDocTab.setSelected(this.tabState == TabState.DocFile);
        this.tabCloudTab.setSelected(this.tabState == TabState.CloudFile);
        this.tabHomeWork.setSelected(this.tabState == TabState.HomeworkFile);
    }

    protected void updateHomeworkHintVisibility() {
        this.setVisibility(R.id.window_course_ware_tab_hint, this.tabState == TabState.HomeworkFile);
        this.setVisibility(R.id.window_course_ware_tab_hint_icon, this.tabState == TabState.HomeworkFile);
        this.setVisibility(R.id.window_course_ware_enable_student_upload_check_box, this.tabState == TabState.HomeworkFile);
        this.setVisibility(R.id.window_course_ware_enable_student_upload_tv, this.tabState == TabState.HomeworkFile);
    }

    private void showContent(BaseUIConstant.ListState listState) {
        switch (listState) {
            case Empty: {
                this.setVisibility(R.id.window_course_ware_empty_file_container, true);
                this.setVisibility(R.id.window_course_ware_loading, false);
                String emptyFileDes = this.isOnSearching ? this.context.getString(this.tabState == TabState.HomeworkFile ? R.string.base_course_manage_no_search_homework_file : R.string.base_course_manage_no_search_file) : this.context.getString(this.tabState == TabState.HomeworkFile ? R.string.base_course_manage_no_homework_file : R.string.base_course_manage_no_file);
                ((TextView)this.contentView.findViewById(R.id.window_course_ware_empty_file_des)).setText((CharSequence)emptyFileDes);
                this.setVisibility(R.id.window_course_ware_file_refresh_layout, false);
                this.stopLoadingAnim();
                break;
            }
            case NotEmpty: {
                this.setVisibility(R.id.window_course_ware_empty_file_container, false);
                this.setVisibility(R.id.window_course_ware_loading, false);
                this.setVisibility(R.id.window_course_ware_file_refresh_layout, true);
                this.stopLoadingAnim();
                break;
            }
            case Requesting: {
                this.setVisibility(R.id.window_course_ware_empty_file_container, false);
                this.setVisibility(R.id.window_course_ware_loading, true);
                this.setVisibility(R.id.window_course_ware_file_refresh_layout, false);
                this.startLoadingAnim();
                break;
            }
        }
    }

    private void startLoadingAnim() {
        if (this.contentView.findViewById(R.id.window_course_ware_loading).getAnimation() != null) {
            return;
        }
        RotateAnimation rotate = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        LinearInterpolator lin = new LinearInterpolator();
        rotate.setInterpolator((Interpolator)lin);
        rotate.setDuration(2000L);
        rotate.setRepeatCount(-1);
        rotate.setFillAfter(true);
        this.contentView.findViewById(R.id.window_course_ware_loading).setAnimation((Animation)rotate);
        rotate.start();
    }

    private void stopLoadingAnim() {
        this.contentView.findViewById(R.id.window_course_ware_loading).clearAnimation();
    }

    protected void updateFinderRecordView() {
        boolean hideFinderRecordView = this.tabState != TabState.CloudFile || this.dirRecordList.size() == 0;
        this.setVisibility(R.id.window_course_ware_upload, hideFinderRecordView);
        this.setVisibility(R.id.window_course_ware_upload_image, hideFinderRecordView);
        this.setVisibility(R.id.window_course_ware_record_dir_root, !hideFinderRecordView);
        this.setVisibility(R.id.window_course_ware_record_dir_more, !hideFinderRecordView);
    }

    protected abstract void initChildData();

    protected abstract ICourseWareViewListener initCourseWareViewListener();

    protected abstract BaseCourseWareContract.BaseCourseWarePresenter initPresenter();

    protected abstract LiveRoom getLiveRoom();

    @Override
    public void updateAllowUpdateHomework(boolean isAllow) {
        this.cbEnableStudentUpload.setChecked(isAllow);
        if (!this.isTeacherOrAssistant()) {
            int visibility = isAllow ? 0 : 8;
            this.contentView.findViewById(R.id.window_course_ware_upload).setVisibility(visibility);
            this.contentView.findViewById(R.id.window_course_ware_upload_image).setVisibility(visibility);
        }
    }

    @Override
    public void updateAllDocList(@NotNull List<LPDocModel> allDocList) {
        this.courseWareAdapter.updateAllDocList(allDocList);
        this.showContent(this.getNowAdapterState());
    }

    @Override
    public void updateMediaCoursewareList(List<LPMediaCoursewareModel> mediaCoursewareModelList) {
        this.courseWareAdapter.updateMediaCoursewareList(mediaCoursewareModelList);
        this.showContent(this.getNowAdapterState());
    }

    @Override
    public void updateAllHomework(@NotNull LPResHomeworkAllModel homeworkAll) {
        this.courseWareAdapter.updateAllHomework(homeworkAll);
        this.showContent(this.getNowAdapterState());
        this.smartRefreshLayout.finishLoadMore();
    }

    @Override
    public void updateHomeworkSearchRst(LPResHomeworkAllModel searchRst) {
        this.courseWareAdapter.updateHomeworkSearchRst(searchRst);
        this.showContent(this.getNowAdapterState());
        this.smartRefreshLayout.finishLoadMore();
    }

    @Override
    public void updateAllCloudFile(List<LPCloudFileModel> allCloudFile) {
        this.courseWareAdapter.updateAllCloudFile(allCloudFile);
        this.showContent(this.getNowAdapterState());
        this.smartRefreshLayout.finishLoadMore();
    }

    @Override
    public void updateCloudDirRecord(List<LPCloudFileModel> dirRecordModels) {
        this.dirRecordList = dirRecordModels;
        this.updateFinderRecordView();
        if (dirRecordModels.size() == 0) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (LPCloudFileModel fileModel : dirRecordModels) {
            if (!TextUtils.isEmpty((CharSequence)fileModel.getSearchKey())) {
                names.add(fileModel.getSearchKey());
                break;
            }
            names.add(fileModel.getName());
        }
        this.tvDirRecordMore.updateItems(names);
    }

    @Override
    public void updateHomeworkSupport(boolean support) {
        this.allIsSupportHomework = support;
        if (this.homeworkRemindStatus == HomeworkRemindStatus.WAITING_FOR_RST && !support) {
            this.courseWareViewListener.onRemindHomeworkSupport();
            this.homeworkRemindStatus = HomeworkRemindStatus.HAS_SHOW_RST;
        }
    }

    public void onUpload(@NotNull Map<BaseUIConstant.UploadType, String> uploadPath) {
        for (BaseUIConstant.UploadType key : uploadPath.keySet()) {
            if (!(key instanceof BaseUIConstant.UploadType)) {
                return;
            }
            BaseUIConstant.UploadType uploadType = key;
            String path = uploadPath.get((Object)key);
            if (path.endsWith(".bds")) {
                this.showToast(this.context.getString(R.string.base_tip_file_type_is_not_support));
                return;
            }
            switch (uploadType) {
                case AnimCloudFile: {
                    if (FileUtils.checkAnimFilePathValid((String)path)) {
                        this.presenter.sendPPTCloudFile(path, true, false);
                        break;
                    }
                    this.showToast(this.context.getString(R.string.base_tip_please_upload_ppt_or_pptx));
                    break;
                }
                case StaticCloudFile: {
                    if (FileUtils.checkStaticFilePathValid((String)path)) {
                        this.presenter.sendPPTCloudFile(path, false, FileUtils.isImageFile((String)path));
                        break;
                    }
                    this.showToast(this.context.getString(R.string.base_tip_file_type_is_not_support));
                    break;
                }
                case AnimDoc: {
                    if (FileUtils.checkAnimFilePathValid((String)path)) {
                        this.presenter.sendPPTDocument(path, true);
                        break;
                    }
                    this.showToast(this.context.getString(R.string.base_tip_please_upload_ppt_or_pptx));
                    break;
                }
                case StaticDoc: {
                    if (FileUtils.checkStaticFilePathValid((String)path)) {
                        if (FileUtils.isImageFile((String)path)) {
                            this.presenter.sendImageShape(path, false);
                            break;
                        }
                        this.presenter.sendPPTDocument(path, false);
                        break;
                    }
                    this.showToast(this.context.getString(R.string.base_tip_file_type_is_not_support));
                    break;
                }
                case HomeWork: {
                    if (FileUtils.checkStaticFilePathValid((String)path)) {
                        this.presenter.sendHomeWork(path, FileUtils.isImageFile((String)path));
                        break;
                    }
                    this.showToast(this.context.getString(R.string.base_tip_file_type_is_not_support));
                    break;
                }
                case TransferFromChatImg: {
                    if (FileUtils.checkStaticFilePathValid((String)path)) {
                        this.presenter.sendChatImageShape(path);
                        break;
                    }
                    this.showToast(this.context.getString(R.string.base_tip_file_type_is_not_support));
                    break;
                }
            }
        }
    }

    protected boolean isTeacherOrAssistant() {
        if (this.getLiveRoom() == null) {
            return false;
        }
        if (this.getLiveRoom().getRoomInfo().roomType == LPConstants.LPRoomType.NewSmallGroup) {
            return this.getLiveRoom().isTeacherOrAssistant() || this.getLiveRoom().isGroupTeacherOrAssistant();
        }
        return this.getLiveRoom().isTeacherOrAssistant();
    }

    private int getDocumentMaxSize() {
        if (this.getLiveRoom() == null) {
            return 0;
        }
        return this.getLiveRoom().getPartnerConfig().documentMaxSize;
    }

    private boolean isEnableHomework() {
        if (this.getLiveRoom() == null) {
            return false;
        }
        return this.getLiveRoom().getPartnerConfig().enableUseHomeWork == 1;
    }

    private boolean isOrganizationUser() {
        if (this.getLiveRoom() == null) {
            return false;
        }
        return this.getLiveRoom().isOrganizationUser();
    }

    protected void setVisibility(int id2, boolean visible) {
        View view = this.contentView.findViewById(id2);
        if (view != null) {
            view.setVisibility(visible ? 0 : 8);
        }
    }

    protected void clearEditFocus(View v) {
        v.clearFocus();
        if (v instanceof EditText) {
            InputMethodManager manager = (InputMethodManager)this.contentView.getContext().getSystemService("input_method");
            manager.hideSoftInputFromWindow(v.getWindowToken(), 2);
        }
    }

    protected void showToast(String message) {
        new ToastUtil(this.context).setText(message).show();
    }

    private boolean checkUploadFileSize(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file.length() / 1024L / 1024L <= (long)this.getDocumentMaxSize();
        }
        return false;
    }

    private void changeDirPosition(int ind) {
        if (ind < 0 || ind >= this.dirRecordList.size() - 1) {
            return;
        }
        this.getLiveRoom().getCloudFileVM().requestBackDirRecord(ind);
    }

    private BaseUIConstant.ListState getNowAdapterState() {
        return this.courseWareAdapter.getItemCount() == 0 ? BaseUIConstant.ListState.Empty : BaseUIConstant.ListState.NotEmpty;
    }

    public void onDestroy() {
        super.onDestroy();
        this.presenter.destroy();
        this.courseWareAdapter.destroy();
        this.stopLoadingAnim();
        this.courseWareViewListener = null;
    }

    public boolean onTouch(View v, @NotNull MotionEvent event) {
        if (event.getAction() == 0 && v.getId() != R.id.window_course_ware_searcher) {
            this.clearEditFocus((View)this.etSearcher);
        }
        return true;
    }

    @Override
    public boolean addUploadModel(LPUploadingDocumentModel model) {
        this.courseWareAdapter.addUploadModel(model);
        this.showContent(this.getNowAdapterState());
        if (!this.checkUploadFileSize(model.getFilePath())) {
            String errorMsg = String.format(this.context.getResources().getString(R.string.base_tip_upload_file_over_size), this.getDocumentMaxSize());
            this.courseWareAdapter.updateUploadState(model, BaseUIConstant.FileUploadState.UploadFailed, new LPDocTranslateProgressModel(-1, errorMsg));
            return false;
        }
        return true;
    }

    @Override
    public void removeUploadDocument(String path) {
        this.contentView.post(() -> this.courseWareAdapter.removeUpload(path));
    }

    @Override
    public void uploadProgress(String filePath, int progress) {
    }

    @Override
    public void startTranslate(LPUploadingDocumentModel model) {
        this.contentView.post(() -> this.courseWareAdapter.updateUploadState(model, BaseUIConstant.FileUploadState.Translating, null));
    }

    @Override
    public void translateProgress(String filePath, int progress) {
    }

    @Override
    public void uploadFailure(LPUploadingDocumentModel model, String msg) {
        this.contentView.post(() -> {
            LPDocTranslateProgressModel errorModel2 = new LPDocTranslateProgressModel(-1, msg);
            this.courseWareAdapter.updateUploadState(model, BaseUIConstant.FileUploadState.UploadFailed, errorModel2);
        });
    }

    @Override
    public void translateFailure(LPUploadingDocumentModel model, LPDocTranslateProgressModel progressModel) {
        this.contentView.post(() -> this.courseWareAdapter.updateUploadState(model, BaseUIConstant.FileUploadState.TranslateFailed, progressModel));
    }

    @Override
    public void onDownloadFailed(String homeworkId, String msg) {
        this.contentView.post(() -> {
            if (msg != null && msg.toLowerCase().contains("cancel")) {
                this.showToast(this.context.getResources().getString(R.string.base_course_manage_cancel_download));
                this.courseWareAdapter.cancelDownload(homeworkId);
            } else if (msg != null) {
                this.showToast(msg);
                this.courseWareAdapter.updateDownloadState(homeworkId, BaseUIConstant.HomeworkDownloadState.DownloadFailed, 0.0f);
            } else {
                this.showToast(this.context.getResources().getString(R.string.base_course_manage_download_failed));
            }
        });
    }

    @Override
    public void onDownloadSuccess(String homeworkId) {
        this.contentView.post(() -> this.courseWareAdapter.updateDownloadState(homeworkId, BaseUIConstant.HomeworkDownloadState.HasDownload, 1.0f));
    }

    @Override
    public void onDownloadProgress(String homeworkId, float progress) {
        this.contentView.post(() -> this.courseWareAdapter.updateDownloadState(homeworkId, BaseUIConstant.HomeworkDownloadState.Downloading, progress));
    }

    private void selectImage() {
        ThemeConfig.Builder builder = new ThemeConfig.Builder();
        builder.setScreenOrientation(this.defaultPickImageOrientation).setMainElementsColor(ContextCompat.getColor((Context)this.context, (int)R.color.base_product_color_50_press));
        BJCommonImageCropHelper.openImageMulti((Context)this.context, (int)20, (ThemeConfig)builder.build(), (BJCommonImageCropHelper.OnHandlerResultCallback)new BJCommonImageCropHelper.OnHandlerResultCallback(){

            public void onHandlerSuccess(List<PhotoInfo> list) {
                switch (BaseCourseWareFragment.this.tabState) {
                    case DocFile: {
                        for (PhotoInfo photoInfo : list) {
                            BaseCourseWareFragment.this.presenter.sendImageShape(photoInfo.getPhotoPath(), false);
                        }
                        break;
                    }
                    case CloudFile: {
                        for (PhotoInfo photoInfo : list) {
                            BaseCourseWareFragment.this.presenter.sendPPTCloudFile(photoInfo.getPhotoPath(), false, true);
                        }
                        break;
                    }
                    case HomeworkFile: {
                        for (PhotoInfo photoInfo : list) {
                            BaseCourseWareFragment.this.presenter.sendHomeWork(photoInfo.getPhotoPath(), true);
                        }
                        break;
                    }
                }
            }

            public void onHandlerFailure(String s) {
                BaseCourseWareFragment.this.showToast(s);
            }
        });
    }

    public static enum HomeworkRemindStatus {
        DO_NOT_REMIND,
        WAITING_FOR_RST,
        HAS_SHOW_RST;

    }
}

